/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.proxy;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.zerono.mods.extremereactors.api.reactor.ModeratorsRegistry;
import it.zerono.mods.extremereactors.api.reactor.ReactantMappingsRegistry;
import it.zerono.mods.extremereactors.api.turbine.CoilMaterialRegistry;
import it.zerono.mods.extremereactors.config.Config;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.compat.patchouli.PatchouliCompat;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.CachedSprites;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.GuiTheme;
import it.zerono.mods.extremereactors.gamecontent.multiblock.energizer.client.model.EnergizerModelBuilder;
import it.zerono.mods.extremereactors.gamecontent.multiblock.energizer.client.screen.EnergizerChargingPortScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.energizer.client.screen.EnergizerControllerScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.energizer.client.screen.EnergizerPowerPortScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.FluidizerTankData;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.client.model.FluidizerClientTankData;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.client.model.FluidizerGlassModelBuilder;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.client.model.FluidizerIOModelBuilder;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.client.model.FluidizerModelBuilder;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.client.render.FluidizerControllerEntityRenderer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.client.screen.FluidizerControllerScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.client.screen.FluidizerSolidInjectorScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.part.FluidizerControllerEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.FuelRodsLayout;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.ClientFuelRodsLayout;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.model.ReactorFuelRodBlockColor;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.model.ReactorFuelRodModelBuilder;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.model.ReactorGlassModelBuilder;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.model.ReactorModelBuilder;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.screen.ReactorChargingPortScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.screen.ReactorControlRodScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.screen.ReactorControllerScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.screen.ReactorFluidAccessPortScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.screen.ReactorFluidPortScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.screen.ReactorRedstonePortScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.screen.ReactorSolidAccessPortScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.client.model.ReprocessorGlassModelBuilder;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.client.model.ReprocessorIOModelBuilder;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.client.model.ReprocessorModelBuilder;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.client.render.ReprocessorCollectorRender;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.client.screen.ReprocessorAccessPortScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.client.screen.ReprocessorControllerScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.model.TurbineGlassModelBuilder;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.model.TurbineModelBuilder;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.model.TurbineRotorModelBuilder;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.render.rotor.RotorBearingEntityRenderer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.screen.TurbineChargingPortScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.screen.TurbineControllerScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.screen.TurbineFluidPortScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.screen.TurbineRedstonePortScreen;
import it.zerono.mods.extremereactors.proxy.IForgeProxy;
import it.zerono.mods.zerocore.lib.client.model.BlockVariantsModelBuilder;
import it.zerono.mods.zerocore.lib.client.model.ICustomModelBuilder;
import it.zerono.mods.zerocore.lib.client.model.ModBakedModelSupplier;
import it.zerono.mods.zerocore.lib.item.TintedBucketItem;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

public class ClientProxy
implements IForgeProxy,
ResourceManagerReloadListener {
    private static ModBakedModelSupplier s_bakedModelSupplier;
    private Supplier<List<ICustomModelBuilder>> _modelBuilders;
    private Map<Item, Set<Component>> _apiTooltipCache;

    public static Supplier<BakedModel> getModelSupplier(ModelResourceLocation modelId) {
        return s_bakedModelSupplier.getOrCreate(modelId);
    }

    @Override
    public void initialize(IEventBus modEventBus) {
        s_bakedModelSupplier = new ModBakedModelSupplier(modEventBus);
        this._modelBuilders = Suppliers.memoize(ClientProxy::initModels);
        modEventBus.addListener(ClientProxy::onClientInit);
        modEventBus.addListener(this::onRegisterModels);
        modEventBus.addListener(this::onModelBake);
        modEventBus.addListener(ClientProxy::onRegisterBlockColorHandlers);
        modEventBus.addListener(ClientProxy::onRegisterItemColorHandlers);
        modEventBus.addListener(ClientProxy::onRegisterMenuScreensEvent);
        NeoForge.EVENT_BUS.addListener(this::onAddReloadListener);
        NeoForge.EVENT_BUS.addListener(this::onItemTooltip);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::onVanillaTagsUpdated);
    }

    @Override
    public FuelRodsLayout createFuelRodsLayout(Direction direction, int length) {
        return new ClientFuelRodsLayout(direction, length);
    }

    @Override
    public FluidizerTankData createFluidizerTankData(FluidizerControllerEntity controllerEntity) {
        return new FluidizerClientTankData(controllerEntity);
    }

    public void onResourceManagerReload(ResourceManager resourceManager) {
        this.invalidateApiTooltipCache();
    }

    private static List<ICustomModelBuilder> initModels() {
        return (List)Streams.concat((Stream[])new Stream[]{Stream.of(new ICustomModelBuilder[]{new ReactorModelBuilder.Basic(), new ReactorGlassModelBuilder.Basic(), ReactorFuelRodModelBuilder.basic(), new ReactorModelBuilder.Reinforced(), new ReactorGlassModelBuilder.Reinforced(), ReactorFuelRodModelBuilder.reinforced()}), Stream.of(new BlockVariantsModelBuilder[]{new TurbineModelBuilder.Basic(), new TurbineGlassModelBuilder.Basic(), new TurbineRotorModelBuilder.Basic(), new TurbineModelBuilder.Reinforced(), new TurbineGlassModelBuilder.Reinforced(), new TurbineRotorModelBuilder.Reinforced()}), Stream.of(new BlockVariantsModelBuilder[]{new ReprocessorModelBuilder(), new ReprocessorIOModelBuilder(), new ReprocessorGlassModelBuilder(), new FluidizerModelBuilder(), new FluidizerIOModelBuilder(), new FluidizerGlassModelBuilder(), new EnergizerModelBuilder()})}).collect(ImmutableList.toImmutableList());
    }

    private static void registerRenderTypes() {
        ClientProxy.registerRenderType(RenderType.translucent(), Content.Blocks.REACTOR_GLASS_BASIC, Content.Blocks.REACTOR_GLASS_REINFORCED, Content.Blocks.TURBINE_GLASS_BASIC, Content.Blocks.TURBINE_GLASS_REINFORCED, Content.Blocks.REPROCESSOR_GLASS, Content.Blocks.FLUIDIZER_GLASS);
        ClientProxy.registerRenderType(RenderType.cutout(), Content.Blocks.TURBINE_ROTORBLADE_BASIC, Content.Blocks.TURBINE_ROTORBLADE_REINFORCED, Content.Blocks.TURBINE_ROTORSHAFT_BASIC, Content.Blocks.TURBINE_ROTORSHAFT_REINFORCED);
    }

    private static void registerTileRenderers() {
        BlockEntityRenderers.register(Content.TileEntityTypes.TURBINE_ROTORBEARING.get(), RotorBearingEntityRenderer::new);
        BlockEntityRenderers.register(Content.TileEntityTypes.REPROCESSOR_COLLECTOR.get(), ReprocessorCollectorRender::new);
        BlockEntityRenderers.register(Content.TileEntityTypes.FLUIDIZER_CONTROLLER.get(), FluidizerControllerEntityRenderer::new);
    }

    @SafeVarargs
    private static void registerRenderType(RenderType type, Supplier<? extends Block> ... blocks) {
        for (Supplier<? extends Block> block : blocks) {
            ItemBlockRenderTypes.setRenderLayer((Block)block.get(), (RenderType)type);
        }
    }

    private void onVanillaTagsUpdated(TagsUpdatedEvent event) {
        this.invalidateApiTooltipCache();
    }

    private Map<Item, Set<Component>> getApiTooltipCache() {
        if (null == this._apiTooltipCache) {
            this._apiTooltipCache = ClientProxy.buildApiTooltipCache();
        }
        return this._apiTooltipCache;
    }

    private void invalidateApiTooltipCache() {
        this._apiTooltipCache = null;
    }

    private static Map<Item, Set<Component>> buildApiTooltipCache() {
        HashMap wipCache = Maps.newHashMap();
        ReactantMappingsRegistry.fillReactantsTooltips(wipCache, Sets::newHashSet);
        ModeratorsRegistry.fillModeratorsTooltips(wipCache, Sets::newHashSet);
        CoilMaterialRegistry.fillCoilsTooltips(wipCache, Sets::newHashSet);
        return new Object2ObjectArrayMap((Map)wipCache);
    }

    private static void onClientInit(FMLClientSetupEvent event) {
        CachedSprites.initialize();
        event.enqueueWork(() -> {
            ClientProxy.registerRenderTypes();
            ClientProxy.registerTileRenderers();
            PatchouliCompat.initialize();
        });
    }

    private static void onRegisterMenuScreensEvent(RegisterMenuScreensEvent event) {
        event.register(Content.ContainerTypes.REACTOR_CONTROLLER.get(), ReactorControllerScreen::new);
        event.register(Content.ContainerTypes.REACTOR_SOLID_ACCESSPORT.get(), ReactorSolidAccessPortScreen::new);
        event.register(Content.ContainerTypes.REACTOR_FLUID_ACCESSPORT.get(), ReactorFluidAccessPortScreen::new);
        event.register(Content.ContainerTypes.REACTOR_REDSTONEPORT.get(), ReactorRedstonePortScreen::new);
        event.register(Content.ContainerTypes.REACTOR_CONTROLROD.get(), ReactorControlRodScreen::new);
        event.register(Content.ContainerTypes.REACTOR_CHARGINGPORT.get(), ReactorChargingPortScreen::new);
        event.register(Content.ContainerTypes.REACTOR_FLUIDPORT.get(), ReactorFluidPortScreen::new);
        event.register(Content.ContainerTypes.TURBINE_CONTROLLER.get(), TurbineControllerScreen::new);
        event.register(Content.ContainerTypes.TURBINE_CHARGINGPORT.get(), TurbineChargingPortScreen::new);
        event.register(Content.ContainerTypes.TURBINE_FLUIDPORT.get(), TurbineFluidPortScreen::new);
        event.register(Content.ContainerTypes.TURBINE_REDSTONEPORT.get(), TurbineRedstonePortScreen::new);
        event.register(Content.ContainerTypes.REPROCESSOR_CONTROLLER.get(), ReprocessorControllerScreen::new);
        event.register(Content.ContainerTypes.REPROCESSOR_ACCESSPORT.get(), ReprocessorAccessPortScreen::new);
        event.register(Content.ContainerTypes.FLUIDIZER_SOLID_INJECTOR.get(), FluidizerSolidInjectorScreen::new);
        event.register(Content.ContainerTypes.FLUIDIZER_CONTROLLER.get(), FluidizerControllerScreen::new);
        event.register(Content.ContainerTypes.ENERGIZER_CONTROLLER.get(), EnergizerControllerScreen::new);
        event.register(Content.ContainerTypes.ENERGIZER_POWERPORT.get(), EnergizerPowerPortScreen::new);
        event.register(Content.ContainerTypes.ENERGIZER_CHARGINGPORT.get(), EnergizerChargingPortScreen::new);
    }

    private void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)this);
        event.addListener((PreparableReloadListener)GuiTheme.ER);
    }

    private void onRegisterModels(ModelEvent.RegisterAdditional event) {
        this._modelBuilders.get().forEach(b -> b.onRegisterModels(event));
    }

    private void onModelBake(ModelEvent.ModifyBakingResult event) {
        this._modelBuilders.get().forEach(builder -> builder.onBakeModels(event));
    }

    private void onItemTooltip(ItemTooltipEvent event) {
        if (!((Boolean)Config.CLIENT.disableApiTooltips.get()).booleanValue() && event.getFlags().isAdvanced()) {
            event.getToolTip().addAll(this.getApiTooltipCache().getOrDefault(event.getItemStack().getItem(), Collections.emptySet()));
        }
    }

    private static void onRegisterBlockColorHandlers(RegisterColorHandlersEvent.Block event) {
        event.register((BlockColor)new ReactorFuelRodBlockColor(), new Block[]{(Block)Content.Blocks.REACTOR_FUELROD_BASIC.get(), (Block)Content.Blocks.REACTOR_FUELROD_REINFORCED.get()});
    }

    private static void onRegisterItemColorHandlers(RegisterColorHandlersEvent.Item event) {
        event.register(TintedBucketItem::getTintColour, new ItemLike[]{(ItemLike)Content.Items.YELLORIUM_BUCKET.get(), (ItemLike)Content.Items.CYANITE_BUCKET.get(), (ItemLike)Content.Items.BLUTONIUM_BUCKET.get(), (ItemLike)Content.Items.MAGENTITE_BUCKET.get(), (ItemLike)Content.Items.VERDERIUM_BUCKET.get(), (ItemLike)Content.Items.ROSSINITE_BUCKET.get(), (ItemLike)Content.Items.STEAM_BUCKET.get(), (ItemLike)Content.Items.CRYOMISI_BUCKET.get(), (ItemLike)Content.Items.TANGERIUM_BUCKET.get(), (ItemLike)Content.Items.REDFRIGIUM_BUCKET.get()});
    }
}

