/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.model;

import it.zerono.mods.extremereactors.ExtremeReactors;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.ITurbinePartType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.TurbineRotorComponentBlock;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.rotor.RotorBladeState;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.rotor.RotorShaftState;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.variant.TurbineVariant;
import it.zerono.mods.extremereactors.proxy.ClientProxy;
import it.zerono.mods.zerocore.base.multiblock.client.model.AbstractMultiblockModelBuilder;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;

public abstract class TurbineRotorModelBuilder
extends AbstractMultiblockModelBuilder {
    public static final Supplier<BakedModel> BASIC_SHAFT;
    public static final Supplier<BakedModel> REINFORCED_SHAFT;
    public static final Supplier<BakedModel> BASIC_BLADE;
    public static final Supplier<BakedModel> REINFORCED_BLADE;

    protected TurbineRotorModelBuilder(TurbineVariant variant) {
        super(ExtremeReactors.ROOT_LOCATION.appendPath(new String[]{"block", "turbine", variant.getName()}));
    }

    protected void addBlade(TurbineRotorComponentBlock block) {
        this.addRotorComponent(block, RotorBladeState.values(), RotorBladeState.getDefault());
    }

    protected void addShaft(TurbineRotorComponentBlock block) {
        this.addRotorComponent(block, RotorShaftState.values(), RotorShaftState.getDefault());
    }

    private <E extends Enum<E>> void addRotorComponent(TurbineRotorComponentBlock component, E[] properties, E defaultProperty) {
        ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)component);
        ModelResourceLocation originalModel = TurbineRotorModelBuilder.componentModelResourceLocation(blockId, (StringRepresentable)defaultProperty);
        ModelResourceLocation[] additionalModels = new ModelResourceLocation[properties.length - 1 + 1];
        Arrays.setAll(additionalModels, idx -> TurbineRotorModelBuilder.componentModelResourceLocation(blockId, (StringRepresentable)properties[idx]));
        this.addBlock(((ITurbinePartType)component.getPartType()).getByteHashCode(), originalModel, true, additionalModels);
    }

    private static ModelResourceLocation componentModelResourceLocation(ResourceLocation blockId, StringRepresentable property) {
        return new ModelResourceLocation(blockId, "state=" + property.getSerializedName());
    }

    static {
        BASIC_BLADE = ClientProxy.getModelSupplier(new ModelResourceLocation(ExtremeReactors.ROOT_LOCATION.buildWithSuffix("basic_turbinerotorblade"), "state=z_x_pos"));
        REINFORCED_BLADE = ClientProxy.getModelSupplier(new ModelResourceLocation(ExtremeReactors.ROOT_LOCATION.buildWithSuffix("reinforced_turbinerotorblade"), "state=z_x_pos"));
        BASIC_SHAFT = ClientProxy.getModelSupplier(new ModelResourceLocation(ExtremeReactors.ROOT_LOCATION.buildWithSuffix("basic_turbinerotorshaft"), "state=y_noblades"));
        REINFORCED_SHAFT = ClientProxy.getModelSupplier(new ModelResourceLocation(ExtremeReactors.ROOT_LOCATION.buildWithSuffix("reinforced_turbinerotorshaft"), "state=y_noblades"));
    }

    public static class Reinforced
    extends TurbineRotorModelBuilder {
        public Reinforced() {
            super(TurbineVariant.Reinforced);
        }

        public void build() {
            this.addBlade(Content.Blocks.TURBINE_ROTORBLADE_REINFORCED.get());
            this.addShaft(Content.Blocks.TURBINE_ROTORSHAFT_REINFORCED.get());
        }
    }

    public static class Basic
    extends TurbineRotorModelBuilder {
        public Basic() {
            super(TurbineVariant.Basic);
        }

        public void build() {
            this.addBlade(Content.Blocks.TURBINE_ROTORBLADE_BASIC.get());
            this.addShaft(Content.Blocks.TURBINE_ROTORSHAFT_BASIC.get());
        }
    }
}

