/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor;

import it.zerono.mods.extremereactors.Log;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.part.ReprocessorAccessPortEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.part.ReprocessorCollectorEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.part.ReprocessorControllerEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.part.ReprocessorFluidPortEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.part.ReprocessorGlassEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.part.ReprocessorPowerPortEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.recipe.ReprocessorHeldRecipe;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.recipe.ReprocessorRecipe;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.IActivableMachine;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.IDebuggable;
import it.zerono.mods.zerocore.lib.TickerListener;
import it.zerono.mods.zerocore.lib.block.ModBlock;
import it.zerono.mods.zerocore.lib.data.IoDirection;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.data.stack.IStackHolder;
import it.zerono.mods.zerocore.lib.data.stack.OperationMode;
import it.zerono.mods.zerocore.lib.energy.EnergyBuffer;
import it.zerono.mods.zerocore.lib.energy.EnergyHelper;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import it.zerono.mods.zerocore.lib.energy.IWideEnergyStorage;
import it.zerono.mods.zerocore.lib.energy.handler.WideEnergyStoragePolicyWrapper;
import it.zerono.mods.zerocore.lib.fluid.FluidTank;
import it.zerono.mods.zerocore.lib.fluid.handler.FluidHandlerPolicyWrapper;
import it.zerono.mods.zerocore.lib.item.inventory.ItemStackHolder;
import it.zerono.mods.zerocore.lib.item.inventory.handler.ItemHandlerPolicyWrapper;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockMachine;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockPart;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.AbstractCuboidMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.validation.IMultiblockValidator;
import it.zerono.mods.zerocore.lib.recipe.holder.IHeldRecipe;
import it.zerono.mods.zerocore.lib.recipe.holder.IRecipeHolder;
import it.zerono.mods.zerocore.lib.recipe.holder.RecipeHolder;
import it.zerono.mods.zerocore.lib.recipe.ingredient.FluidStackRecipeIngredient;
import it.zerono.mods.zerocore.lib.recipe.ingredient.IRecipeIngredientSource;
import it.zerono.mods.zerocore.lib.recipe.ingredient.ItemStackRecipeIngredient;
import it.zerono.mods.zerocore.lib.recipe.ingredient.RecipeIngredientSourceWrapper;
import it.zerono.mods.zerocore.lib.recipe.result.IRecipeResult;
import it.zerono.mods.zerocore.lib.recipe.result.IRecipeResultTarget;
import it.zerono.mods.zerocore.lib.recipe.result.ItemStackRecipeResult;
import it.zerono.mods.zerocore.lib.recipe.result.RecipeResultTargetWrapper;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class MultiblockReprocessor
extends AbstractCuboidMultiblockController<MultiblockReprocessor>
implements IMultiblockMachine,
IActivableMachine,
ISyncableEntity,
IDebuggable {
    public static final int TICKS = 40;
    public static final int TICK_ENERGY_COST = 25;
    public static final int INTERNAL_HEIGHT = 5;
    public static final int FLUID_CAPACITY = 5000;
    public static final int ENERGY_CAPACITY = 5000;
    private final ItemStackHandler _outputInventory = new ItemStackHandler(1);
    private final ItemStackHolder _wasteInventory = (ItemStackHolder)((ItemStackHolder)new ItemStackHolder(1).setOnLoadListener(this::setIngredientsChanged)).setOnContentsChangedListener(this::onInventoryChanged);
    private final FluidTank _fluidTank = (FluidTank)((FluidTank)new FluidTank(5000).setOnLoadListener(this::setIngredientsChanged)).setOnContentsChangedListener(this::onInventoryChanged);
    private final EnergyBuffer _energyBuffer = new EnergyBuffer(EnergySystem.ForgeEnergy, 5000.0, 1000.0);
    private final IRecipeIngredientSource<ItemStack> _wasteIngredientSource;
    private final IRecipeIngredientSource<FluidStack> _fluidIngredientSource;
    private final IRecipeResultTarget<ItemStackRecipeResult> _outputTarget;
    private final RecipeHolder<ReprocessorRecipe> _recipeHolder;
    private boolean _ingredientsChanged = false;
    private ReprocessorCollectorEntity _collector;
    private final IItemHandlerModifiable _outputItemHandler = ItemHandlerPolicyWrapper.outputOnly((IItemHandlerModifiable)this._outputInventory);
    private final IItemHandlerModifiable _inputItemHandler = ItemHandlerPolicyWrapper.twoWay((IItemHandlerModifiable)this._wasteInventory, (slot, stack) -> this.isValidIngredient((ItemStack)stack));
    private final IFluidHandler _inputFluidHandler = FluidHandlerPolicyWrapper.inputOnly((IFluidHandler)this._fluidTank, this::isValidIngredient);
    private final IWideEnergyStorage _energyInputHandler = WideEnergyStoragePolicyWrapper.inputOnly((IWideEnergyStorage)this._energyBuffer);
    private final TickerListener _ticker;
    private boolean _active;
    private boolean _interiorInvisible = false;

    public MultiblockReprocessor(Level world) {
        super(world);
        this._outputTarget = RecipeResultTargetWrapper.wrap((IItemHandler)this._outputInventory, (int)0);
        this._wasteIngredientSource = RecipeIngredientSourceWrapper.wrap((IItemHandler)this._wasteInventory, (int)0);
        this._fluidIngredientSource = RecipeIngredientSourceWrapper.wrap((IFluidHandler)this._fluidTank, (int)0);
        this._recipeHolder = RecipeHolder.builder(this::heldRecipeFactory, recipe -> 40).onCanProcess(this::canProcess).onHasIngredientsChanged(this::hasIngredientsChanged).onRecipeTickProcessed(tick -> this._energyBuffer.extractEnergy(EnergySystem.ForgeEnergy, 25.0, false)).onRecipeChanged(this::onRecipeChanged).build();
        this._ticker = TickerListener.singleListener((int)5, () -> ((MultiblockReprocessor)this).sendUpdates());
    }

    public boolean isValidIngredient(ItemStack stack) {
        return Content.Recipes.REPROCESSOR_RECIPE_TYPE.get().findFirst(recipe -> recipe.matchIgnoreAmount(stack)).isPresent();
    }

    public boolean isValidIngredient(FluidStack stack) {
        return Content.Recipes.REPROCESSOR_RECIPE_TYPE.get().findFirst(recipe -> recipe.matchIgnoreAmount(stack)).isPresent();
    }

    public IItemHandlerModifiable getItemHandler(IoDirection direction) {
        return direction.isInput() ? this._inputItemHandler : this._outputItemHandler;
    }

    public IFluidHandler getFluidHandler() {
        return this._inputFluidHandler;
    }

    public IWideEnergyStorage getEnergyStorage() {
        return this._energyInputHandler;
    }

    public double getEnergyStored() {
        return this._energyBuffer.getEnergyStored();
    }

    public double getEnergyStoredPercentage() {
        return this._energyBuffer.getEnergyStoredPercentage();
    }

    public int getFluidStored() {
        return this._fluidTank.getFluidAmount();
    }

    public void voidFluid() {
        this._fluidTank.setContent(FluidStack.EMPTY);
    }

    public double getFluidStoredPercentage() {
        return this._fluidTank.getFluidAmountPercentage();
    }

    public double getRecipeProgress() {
        return this._recipeHolder.getHeldRecipe().map(IHeldRecipe::getProgress).orElse(0.0);
    }

    public boolean isInteriorInvisible() {
        return this._interiorInvisible;
    }

    public boolean isInteriorVisible() {
        return !this._interiorInvisible;
    }

    protected void setInteriorInvisible(boolean visible) {
        this._interiorInvisible = visible;
    }

    public boolean isMachineActive() {
        return this._active;
    }

    public void setMachineActive(boolean active) {
        if (this.isMachineActive() == active) {
            return;
        }
        this._active = active;
        if (active) {
            this.getConnectedParts().forEach(IMultiblockPart::onMachineActivated);
        } else {
            this.getConnectedParts().forEach(IMultiblockPart::onMachineDeactivated);
        }
        this.callOnLogicalServer(() -> this.markReferenceCoordForUpdate());
    }

    public void syncDataFrom(CompoundTag data, HolderLookup.Provider registries, ISyncableEntity.SyncReason syncReason) {
        super.syncDataFrom(data, registries, syncReason);
        this.syncBooleanElementFrom("active", data, registries, b -> {
            this._active = b;
        });
        this.syncDataElementFrom("out", data, registries, this._outputInventory);
        this.syncDataElementFrom("waste", data, registries, this._wasteInventory);
        this.syncChildDataEntityFrom((ISyncableEntity)this._fluidTank, "fluid", data, registries, syncReason);
        this.syncChildDataEntityFrom((ISyncableEntity)this._energyBuffer, "energy", data, registries, syncReason);
        this._recipeHolder.refresh();
        this.syncChildDataEntityFrom((ISyncableEntity)this._recipeHolder, "recipe", data, registries, syncReason);
    }

    public CompoundTag syncDataTo(CompoundTag data, HolderLookup.Provider registries, ISyncableEntity.SyncReason syncReason) {
        super.syncDataTo(data, registries, syncReason);
        this.syncBooleanElementTo("active", data, registries, this.isMachineActive());
        this.syncDataElementTo("out", data, registries, this._outputInventory);
        this.syncDataElementTo("waste", data, registries, this._wasteInventory);
        this.syncChildDataEntityTo((ISyncableEntity)this._fluidTank, "fluid", data, registries, syncReason);
        this.syncChildDataEntityTo((ISyncableEntity)this._energyBuffer, "energy", data, registries, syncReason);
        this.syncChildDataEntityTo((ISyncableEntity)this._recipeHolder, "recipe", data, registries, syncReason);
        return data;
    }

    public void getDebugMessages(LogicalSide side, IDebugMessages messages) {
        if (!this.isAssembled()) {
            return;
        }
        messages.addUnlocalized("Input waste: %s", new Object[]{this._wasteInventory.getStackInSlot(0).toString()});
        messages.add(side, (IDebuggable)this._fluidTank, "Input Fluid:");
        messages.addUnlocalized("Output: %s", new Object[]{this._outputInventory.getStackInSlot(0)});
        messages.add(side, (IDebuggable)this._energyBuffer, "Energy buffer:");
        messages.addUnlocalized("Current tick %d", new Object[]{this._recipeHolder.getHeldRecipe().map(IHeldRecipe::getCurrentTick).orElse(-1)});
    }

    protected boolean updateServer() {
        ProfilerFiller profiler = this.getWorld().getProfiler();
        boolean updated = false;
        profiler.push("Extreme Reactors|Reprocessor update");
        profiler.push("Process");
        if (this.isMachineActive()) {
            updated = this._recipeHolder.getCurrentRecipe().map(IHeldRecipe::processRecipe).orElse(false);
        }
        profiler.popPush("Updates");
        this._ticker.tick();
        profiler.pop();
        profiler.pop();
        return updated;
    }

    protected void updateClient() {
        if (null != this._collector) {
            this._collector.onClientTick();
        }
    }

    protected boolean isMachineWhole(IMultiblockValidator validatorCallback) {
        if (!super.isMachineWhole(validatorCallback)) {
            return false;
        }
        if (1 != this.getPartsCount(p -> p instanceof ReprocessorControllerEntity)) {
            validatorCallback.setLastError("multiblock.validation.reprocessor.missing_controller", new Object[0]);
            return false;
        }
        if (1 != this.getPartsCount(p -> p instanceof ReprocessorFluidPortEntity)) {
            validatorCallback.setLastError("multiblock.validation.reprocessor.missing_fluidinjector", new Object[0]);
            return false;
        }
        if (1 != this.getPartsCount(p -> p instanceof ReprocessorAccessPortEntity && ((ReprocessorAccessPortEntity)((Object)p)).getDirection().isInput())) {
            validatorCallback.setLastError("multiblock.validation.reprocessor.missing_wasteinjector", new Object[0]);
            return false;
        }
        if (1 != this.getPartsCount(p -> p instanceof ReprocessorAccessPortEntity && ((ReprocessorAccessPortEntity)((Object)p)).getDirection().isOutput())) {
            validatorCallback.setLastError("multiblock.validation.reprocessor.missing_outputport", new Object[0]);
            return false;
        }
        if (1 != this.getPartsCount(p -> p instanceof ReprocessorPowerPortEntity)) {
            validatorCallback.setLastError("multiblock.validation.reprocessor.missing_powerport", new Object[0]);
            return false;
        }
        List collectors = this.getConnectedParts(p -> p instanceof ReprocessorCollectorEntity).collect(Collectors.toList());
        if (1 != collectors.size()) {
            validatorCallback.setLastError("multiblock.validation.reprocessor.missing_collector", new Object[0]);
            return false;
        }
        return true;
    }

    protected void onPartAdded(IMultiblockPart<MultiblockReprocessor> newPart) {
    }

    protected void onPartRemoved(IMultiblockPart<MultiblockReprocessor> oldPart) {
    }

    protected void onMachineAssembled() {
        this._collector = this.getConnectedParts(p -> p instanceof ReprocessorCollectorEntity).map(p -> (ReprocessorCollectorEntity)((Object)p)).findAny().orElse(null);
        this.setInteriorInvisible(!this.isAnyPartConnected(part -> part instanceof ReprocessorGlassEntity));
        this.callOnLogicalSide(() -> this.markReferenceCoordForUpdate(), () -> this.markMultiblockForRenderUpdate());
        super.onMachineAssembled();
    }

    protected void onMachineRestored() {
        this.onMachineAssembled();
    }

    protected void onMachinePaused() {
        this._collector = null;
    }

    protected void onMachineDisassembled() {
        this._active = false;
        this._collector = null;
        this.markMultiblockForRenderUpdate();
    }

    protected int getMinimumNumberOfPartsForAssembledMachine() {
        return 58;
    }

    protected int getMaximumXSize() {
        return 3;
    }

    protected int getMinimumXSize() {
        return this.getMaximumXSize();
    }

    protected int getMaximumZSize() {
        return 3;
    }

    protected int getMinimumZSize() {
        return this.getMaximumZSize();
    }

    protected int getMaximumYSize() {
        return 7;
    }

    protected int getMinimumYSize() {
        return this.getMaximumYSize();
    }

    protected void onAssimilate(IMultiblockController<MultiblockReprocessor> assimilated) {
        if (!(assimilated instanceof MultiblockReprocessor)) {
            Log.LOGGER.warn(Log.REPROCESSOR, "[{}] Reprocessor @ {} is attempting to assimilate a non-Reprocessor machine! That machine's data will be lost!", (Object)CodeHelper.getWorldSideName((Level)this.getWorld()), (Object)this.getReferenceCoord());
            return;
        }
        MultiblockReprocessor otherReprocessor = (MultiblockReprocessor)assimilated;
        ItemHandlerHelper.insertItem((IItemHandler)this._outputInventory, (ItemStack)otherReprocessor._outputInventory.getStackInSlot(0), (boolean)false);
        ItemHandlerHelper.insertItem((IItemHandler)this._wasteInventory, (ItemStack)otherReprocessor._wasteInventory.getStackInSlot(0), (boolean)false);
        FluidUtil.tryFluidTransfer((IFluidHandler)this._fluidTank, (IFluidHandler)otherReprocessor._fluidTank, (int)Integer.MAX_VALUE, (boolean)true);
        EnergyHelper.transferEnergy((IWideEnergyStorage)this._energyBuffer, (IWideEnergyStorage)otherReprocessor._energyBuffer, (double)Double.MAX_VALUE, (OperationMode)OperationMode.Execute);
    }

    protected void onAssimilated(IMultiblockController<MultiblockReprocessor> assimilator) {
    }

    protected boolean isBlockGoodForFrame(Level world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        return MultiblockReprocessor.notifyInvalidBlock(world, x, y, z, validatorCallback);
    }

    protected boolean isBlockGoodForTop(Level world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        return MultiblockReprocessor.notifyInvalidBlock(world, x, y, z, validatorCallback);
    }

    protected boolean isBlockGoodForBottom(Level world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        return MultiblockReprocessor.notifyInvalidBlock(world, x, y, z, validatorCallback);
    }

    protected boolean isBlockGoodForSides(Level world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        return MultiblockReprocessor.notifyInvalidBlock(world, x, y, z, validatorCallback);
    }

    protected boolean isBlockGoodForInterior(Level world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        if (world.getBlockState(new BlockPos(x, y, z)).isAir()) {
            return true;
        }
        MultiblockReprocessor.notifyInvalidBlock(world, x, y, z, validatorCallback);
        return false;
    }

    @Nullable
    private ReprocessorHeldRecipe heldRecipeFactory(IRecipeHolder<ReprocessorRecipe> holder) {
        this._ingredientsChanged = false;
        return Content.Recipes.REPROCESSOR_RECIPE_TYPE.get().findFirst(recipe -> recipe.test(this._wasteInventory.getStackInSlot(0), this._fluidTank.getFluidInTank(0))).map(recipe -> new ReprocessorHeldRecipe((ReprocessorRecipe)((Object)recipe), holder, this._wasteIngredientSource, this._fluidIngredientSource, this._outputTarget)).orElse(null);
    }

    private boolean canProcess(ReprocessorRecipe recipe) {
        return this.isMachineActive() && this.areRecipeIngredientsAvailable() && this._energyBuffer.getEnergyStored() >= 25.0 && this._outputTarget.countStorableResults((IRecipeResult)((ItemStackRecipeResult)recipe.getResult())) > 0L;
    }

    private boolean hasIngredientsChanged() {
        boolean v = this._ingredientsChanged;
        this._ingredientsChanged = false;
        return v;
    }

    private void setIngredientsChanged() {
        if (this.calledByLogicalServer()) {
            this._ingredientsChanged = true;
        }
    }

    private void onInventoryChanged(IStackHolder.ChangeType changeType, int slot) {
        if (changeType.fullChange()) {
            this.setIngredientsChanged();
        }
    }

    private static boolean notifyInvalidBlock(Level world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        BlockPos position = new BlockPos(x, y, z);
        validatorCallback.setLastError(position, "multiblock.validation.reprocessor.invalid_block", new Object[]{ModBlock.getNameForTranslation((Block)world.getBlockState(position).getBlock())});
        return false;
    }

    private void onRecipeChanged(ReprocessorRecipe heldRecipe) {
        if (null != this._collector) {
            this._collector.onRecipeChanged(heldRecipe);
        }
    }

    private boolean areRecipeIngredientsAvailable() {
        return this._recipeHolder.getHeldRecipe().map(IHeldRecipe::getRecipe).map(this::areRecipeIngredientsAvailable).orElse(false);
    }

    private boolean areRecipeIngredientsAvailable(ReprocessorRecipe recipe) {
        return ((ItemStackRecipeIngredient)recipe.getIngredient1()).test(this._wasteInventory.getStackInSlot(0)) && ((FluidStackRecipeIngredient)recipe.getIngredient2()).test(this._fluidTank.getFluid());
    }
}

