/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.screen;

import it.zerono.mods.extremereactors.CommonLocations;
import it.zerono.mods.extremereactors.gamecontent.CommonConstants;
import it.zerono.mods.extremereactors.gamecontent.compat.patchouli.PatchouliCompat;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.CommonIcons;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.CommonMultiblockScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.MultiblockReactor;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.container.ReactorFluidAccessPortContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.ReactorFluidAccessPortEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.variant.ReactorVariant;
import it.zerono.mods.zerocore.base.client.screen.BaseScreenToolTipsBuilder;
import it.zerono.mods.zerocore.base.client.screen.ClientBaseHelper;
import it.zerono.mods.zerocore.base.client.screen.control.BarsPanel;
import it.zerono.mods.zerocore.base.client.screen.control.FluidBar;
import it.zerono.mods.zerocore.base.client.screen.control.MachineStatusIndicator;
import it.zerono.mods.zerocore.lib.client.gui.ButtonState;
import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.ToolTipsBuilder;
import it.zerono.mods.zerocore.lib.client.gui.control.AbstractButtonControl;
import it.zerono.mods.zerocore.lib.client.gui.control.Button;
import it.zerono.mods.zerocore.lib.client.gui.control.Panel;
import it.zerono.mods.zerocore.lib.client.gui.control.SwitchPictureButton;
import it.zerono.mods.zerocore.lib.client.gui.layout.AnchoredLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.FlowLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.ILayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.client.render.ModRenderHelper;
import it.zerono.mods.zerocore.lib.data.geometry.Point;
import it.zerono.mods.zerocore.lib.item.inventory.PlayerInventoryUsage;
import it.zerono.mods.zerocore.lib.multiblock.variant.IMultiblockVariant;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class ReactorFluidAccessPortScreen
extends CommonMultiblockScreen<MultiblockReactor, ReactorFluidAccessPortEntity, ReactorFluidAccessPortContainer> {
    private final IControl _buttonsPanel;
    private final IControl _barsPanel;

    public ReactorFluidAccessPortScreen(ReactorFluidAccessPortContainer container, Inventory inventory, Component title) {
        super(container, inventory, PlayerInventoryUsage.None, title, ReactorFluidAccessPortScreen.mainTextureFromVariant((IMultiblockVariant)((ReactorFluidAccessPortEntity)container.getTileEntity()).getMultiblockVariant().orElse(ReactorVariant.Basic)));
        this.addPatchouliHelpButton(PatchouliCompat.HANDBOOK_ID, CommonLocations.REACTOR.buildWithSuffix("part-fluidaccessport"), 1);
        SwitchPictureButton inputDirection = new SwitchPictureButton((ModContainerScreen)this, "directionInput", false, "direction");
        ClientBaseHelper.setButtonSpritesAndOverlayForState((AbstractButtonControl)inputDirection, (ButtonState)ButtonState.Default, (Supplier)CommonIcons.ButtonInputDirection);
        ClientBaseHelper.setButtonSpritesAndOverlayForState((AbstractButtonControl)inputDirection, (ButtonState)ButtonState.Active, (Supplier)CommonIcons.ButtonInputDirectionActive);
        inputDirection.setDesiredDimension(16, 16);
        inputDirection.Activated.subscribe(this::onInputActivated);
        inputDirection.setTooltips((ToolTipsBuilder)new BaseScreenToolTipsBuilder().addTranslatableAsTitle("gui.bigreactors.reactor.fluidaccessport.directioninput.tooltip.title").addEmptyLine().addTranslatable("gui.bigreactors.reactor.fluidaccessport.directioninput.tooltip.body"));
        SwitchPictureButton outputDirection = new SwitchPictureButton((ModContainerScreen)this, "directionOutput", false, "direction");
        ClientBaseHelper.setButtonSpritesAndOverlayForState((AbstractButtonControl)outputDirection, (ButtonState)ButtonState.Default, (Supplier)CommonIcons.ButtonOutputDirection);
        ClientBaseHelper.setButtonSpritesAndOverlayForState((AbstractButtonControl)outputDirection, (ButtonState)ButtonState.Active, (Supplier)CommonIcons.ButtonOutputDirectionActive);
        outputDirection.setDesiredDimension(16, 16);
        outputDirection.Activated.subscribe(this::onOutputActivated);
        outputDirection.setTooltips((ToolTipsBuilder)new BaseScreenToolTipsBuilder().addTranslatableAsTitle("gui.bigreactors.reactor.fluidaccessport.directionoutput.tooltip.title").addEmptyLine().addTranslatable("gui.bigreactors.reactor.fluidaccessport.directionoutput.tooltip.body"));
        container.DIRECTION.bind(direction -> {
            inputDirection.setActive(direction.isInput());
            outputDirection.setActive(direction.isOutput());
        });
        Button dumpFuel = new Button((ModContainerScreen)this, "dumpFuel", "");
        dumpFuel.setPadding(0);
        dumpFuel.setIconForState(CommonIcons.ButtonDumpFuel.get(), ButtonState.Default);
        dumpFuel.setIconForState(CommonIcons.ButtonDumpFuelActive.get(), ButtonState.Active, ButtonState.ActiveHighlighted, new ButtonState[]{ButtonState.DefaultHighlighted});
        dumpFuel.setDesiredDimension(16, 16);
        dumpFuel.Clicked.subscribe(this::onDumpFuel);
        dumpFuel.setTooltips((ToolTipsBuilder)new BaseScreenToolTipsBuilder().addTranslatableAsTitle("gui.bigreactors.reactor.fluidaccessport.dumpfuel.tooltip.title").addEmptyLine().addTranslatable("gui.bigreactors.reactor.fluidaccessport.dumpfuel.tooltip.body"));
        Button dumpWaste = new Button((ModContainerScreen)this, "dumpWaste", "");
        dumpWaste.setPadding(0);
        dumpWaste.setIconForState(CommonIcons.ButtonDumpWaste.get(), ButtonState.Default);
        dumpWaste.setIconForState(CommonIcons.ButtonDumpWasteActive.get(), ButtonState.Active, ButtonState.ActiveHighlighted, new ButtonState[]{ButtonState.DefaultHighlighted});
        dumpWaste.setDesiredDimension(16, 16);
        dumpWaste.Clicked.subscribe(this::onDumpWaste);
        dumpWaste.setTooltips((ToolTipsBuilder)new BaseScreenToolTipsBuilder().addTranslatableAsTitle("gui.bigreactors.reactor.fluidaccessport.dumpwaste.tooltip.title").addEmptyLine().addTranslatable("gui.bigreactors.reactor.fluidaccessport.dumpwaste.tooltip.body"));
        this._buttonsPanel = this.buttonsPanel((IControl)inputDirection, (IControl)outputDirection, (IControl)dumpFuel, (IControl)dumpWaste);
        FluidBar fuelTank = new FluidBar((ModContainerScreen)this, "fuelTank", ReactorFluidAccessPortEntity.TANK_CAPACITY, container.FUEL_STACK, (Supplier)CommonIcons.FuelReactantIcon, "gui.bigreactors.reactor.fluidaccessport.fueltank.tooltip.title", "gui.bigreactors.reactor.fluidaccessport.fueltank.tooltip.body");
        FluidBar wasteTank = new FluidBar((ModContainerScreen)this, "wasteTank", ReactorFluidAccessPortEntity.TANK_CAPACITY, container.WASTE_STACK, (Supplier)CommonIcons.WasteReactantIcon, "gui.bigreactors.reactor.fluidaccessport.wastetank.tooltip.title", "gui.bigreactors.reactor.fluidaccessport.wastetank.tooltip.body");
        this._barsPanel = new BarsPanel((ModContainerScreen)this, "bars").add((IControl)fuelTank).addVerticalSeparator().add((IControl)wasteTank);
        this._barsPanel.setLayoutEngineHint((ILayoutEngine.ILayoutEngineHint)AnchoredLayoutEngine.Anchor.TopRight);
        this.setContentLayoutEngine((ILayoutEngine)((AnchoredLayoutEngine)new AnchoredLayoutEngine().setHorizontalMargin(36)).setVerticalMargin(13));
    }

    @Override
    protected MachineStatusIndicator createStatusIndicator(ReactorFluidAccessPortContainer container) {
        return this.createReactorStatusIndicator(container.ACTIVE);
    }

    protected void onScreenCreate() {
        super.onScreenCreate();
        this.addControl(this._buttonsPanel);
        this.addControl(this._barsPanel);
    }

    private void onInputActivated(SwitchPictureButton button) {
        this.sendCommandToServer(CommonConstants.COMMAND_SET_INPUT);
    }

    private void onOutputActivated(SwitchPictureButton button) {
        this.sendCommandToServer(CommonConstants.COMMAND_SET_OUTPUT);
    }

    private void onDumpFuel(Button button, Integer mouseButton) {
        CompoundTag options = new CompoundTag();
        options.putBoolean("void", Screen.hasShiftDown());
        this.sendCommandToServer(CommonConstants.COMMAND_DUMP_FUEL, options);
    }

    private void onDumpWaste(Button button, Integer integer) {
        CompoundTag options = new CompoundTag();
        options.putBoolean("void", Screen.hasShiftDown());
        this.sendCommandToServer(CommonConstants.COMMAND_DUMP_WASTE, options);
    }

    private Panel buttonsPanel(IControl setInput, IControl setOutput, IControl dumpFuel, IControl dumpWaste) {
        Panel p = new Panel((ModContainerScreen)this);
        p.setDesiredDimension(38, 74);
        p.setLayoutEngineHint((ILayoutEngine.ILayoutEngineHint)AnchoredLayoutEngine.Anchor.TopLeft);
        p.setCustomBackgroundPainter((panel, matrix) -> {
            Point xy = panel.controlToScreen(0, 18);
            ISprite border = CommonIcons.ImageButtonBorder.get();
            int z = (int)panel.getGui().getZLevel();
            ModRenderHelper.paintSprite((GuiGraphics)matrix, (ISprite)border, (int)xy.X, (int)xy.Y, (int)z, (int)18, (int)18);
            ModRenderHelper.paintSprite((GuiGraphics)matrix, (ISprite)border, (int)(xy.X + 2 + 18), (int)xy.Y, (int)z, (int)18, (int)18);
            ModRenderHelper.paintSprite((GuiGraphics)matrix, (ISprite)border, (int)xy.X, (int)(xy.Y + 2 + 18), (int)z, (int)18, (int)18);
            ModRenderHelper.paintSprite((GuiGraphics)matrix, (ISprite)border, (int)(xy.X + 2 + 18), (int)(xy.Y + 2 + 18), (int)z, (int)18, (int)18);
        });
        p.setLayoutEngine((ILayoutEngine)((FlowLayoutEngine)((FlowLayoutEngine)((FlowLayoutEngine)new FlowLayoutEngine().setZeroMargins()).setVerticalMargin(19)).setHorizontalMargin(1)).setControlsSpacing(4));
        p.addControl(new IControl[]{setInput, setOutput, dumpFuel, dumpWaste});
        return p;
    }
}

