/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor;

import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.IFuelContainer;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;

public class Stats
implements ISyncableEntity {
    private final IFuelContainer _fuelContainer;
    private double _amountGeneratedLastTick;
    private float _fuelConsumedLastTick;

    public Stats(IFuelContainer fc) {
        this._fuelContainer = fc;
        this._amountGeneratedLastTick = 0.0;
        this._fuelConsumedLastTick = 0.0f;
    }

    public float getFuelConsumedLastTick() {
        return this._fuelConsumedLastTick;
    }

    public double getAmountGeneratedLastTick() {
        return this._amountGeneratedLastTick;
    }

    public float getFuelRichness() {
        int wasteAmount;
        int fuelAmount = this._fuelContainer.getFuelAmount();
        if ((float)(fuelAmount + (wasteAmount = this._fuelContainer.getWasteAmount())) <= 0.0f) {
            return 0.0f;
        }
        return (float)fuelAmount / (float)(fuelAmount + wasteAmount);
    }

    void setFuelConsumedLastTick(float value) {
        this._fuelConsumedLastTick = value;
    }

    void changeFuelConsumedLastTick(float delta) {
        this._fuelConsumedLastTick += delta;
    }

    void setAmountGeneratedLastTick(double value) {
        this._amountGeneratedLastTick = value;
    }

    void changeAmountGeneratedLastTick(double delta) {
        this._amountGeneratedLastTick += delta;
    }

    public void syncDataFrom(CompoundTag data, HolderLookup.Provider registries, ISyncableEntity.SyncReason syncReason) {
        if (data.contains("stuff")) {
            this.setAmountGeneratedLastTick(data.getDouble("stuff"));
        }
        if (data.contains("fuel")) {
            this.setFuelConsumedLastTick(data.getFloat("fuel"));
        }
    }

    public CompoundTag syncDataTo(CompoundTag data, HolderLookup.Provider registries, ISyncableEntity.SyncReason syncReason) {
        data.putDouble("stuff", this.getAmountGeneratedLastTick());
        data.putFloat("fuel", this.getFuelConsumedLastTick());
        return data;
    }

    public String toString() {
        return "Generated: " + this._amountGeneratedLastTick + ", Consumed: " + this._fuelConsumedLastTick;
    }
}

