/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.IIrradiationSource;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.ReactorFuelRodEntity;
import it.zerono.mods.zerocore.base.multiblock.part.AbstractMultiblockEntity;
import it.zerono.mods.zerocore.lib.data.UnmodifiableChildrenIterator;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class FuelRodsMap
implements Iterable<ReactorFuelRodEntity> {
    private final Int2ObjectMap<List<ReactorFuelRodEntity>> _verticalSlices = new Int2ObjectArrayMap(32);
    private int _elementCount = 0;
    private int _keyZero;
    private Iterator<ReactorFuelRodEntity> _nextSource;

    FuelRodsMap() {
        this.onMapChanged();
    }

    public void add(ReactorFuelRodEntity rod) {
        ((List)this._verticalSlices.computeIfAbsent(rod.getWorldPosition().getY(), $ -> new LinkedList())).add(rod);
        ++this._elementCount;
        this.onMapChanged();
    }

    public void remove(ReactorFuelRodEntity rod) {
        int y = rod.getWorldPosition().getY();
        List list = (List)this._verticalSlices.get(y);
        if (null != list && list.remove(rod)) {
            if (list.isEmpty()) {
                this._verticalSlices.remove(y);
            }
            --this._elementCount;
            this.onMapChanged();
        }
    }

    public void clear() {
        this._verticalSlices.clear();
        this._elementCount = 0;
        this.onMapChanged();
    }

    public int size() {
        return this._elementCount;
    }

    public float getHeatTransferRate() {
        double rate = 0.0;
        for (ReactorFuelRodEntity rod : this) {
            rate += rod.getHeatTransferRate();
        }
        return (float)rate;
    }

    public IIrradiationSource getNextIrradiationSource() {
        if (null == this._nextSource || !this._nextSource.hasNext()) {
            this._nextSource = this.iterator();
        }
        return this._nextSource.next();
    }

    public void markFuelRodsForRenderUpdate() {
        this.forEach(AbstractMultiblockEntity::markForRenderUpdate);
    }

    public void markFuelRodsForRenderUpdate(IntSet indices) {
        indices.forEach(index -> this.getSlice(index).forEach(AbstractMultiblockEntity::markForRenderUpdate));
    }

    public void reset() {
        this._nextSource = null;
    }

    @Override
    public Iterator<ReactorFuelRodEntity> iterator() {
        return new UnmodifiableChildrenIterator((Iterator)this._verticalSlices.values().iterator(), List::iterator);
    }

    private List<ReactorFuelRodEntity> getSlice(int index) {
        if (Integer.MIN_VALUE == this._keyZero) {
            this._keyZero = this._verticalSlices.keySet().stream().mapToInt($ -> $).min().orElse(Integer.MIN_VALUE);
        }
        return (List)this._verticalSlices.getOrDefault(this._keyZero + index, Collections.emptyList());
    }

    private void onMapChanged() {
        this._keyZero = Integer.MIN_VALUE;
        this._nextSource = null;
    }
}

