/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.container;

import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.MultiblockFluidizer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.part.AbstractFluidizerEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.part.FluidizerControllerEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.part.FluidizerFluidInjectorEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.part.FluidizerSolidInjectorEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe.IFluidizerRecipe;
import it.zerono.mods.zerocore.lib.block.AbstractModBlockEntity;
import it.zerono.mods.zerocore.lib.data.WideAmount;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import it.zerono.mods.zerocore.lib.item.inventory.container.ContainerFactory;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModTileContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.BooleanData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.DoubleData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.EnumData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.FluidStackData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.ItemStackData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.WideAmountData;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;

public class FluidizerControllerContainer
extends ModTileContainer<FluidizerControllerEntity> {
    public final BooleanData ACTIVE;
    public final EnumData<IFluidizerRecipe.Type> RECIPE_TYPE;
    public final DoubleData RECIPE_PROGRESS;
    public final FluidStackData FLUID_OUTPUT_STACK;
    public final WideAmountData ENERGY_STORED;
    private final ItemStackData[] _solidInputBindings;
    private final FluidStackData[] _fluidInputBindings;
    private final int _outputCapacity;

    private FluidizerControllerContainer(boolean isClientSide, int windowId, Inventory playerInventory, FluidizerControllerEntity controller) {
        super(isClientSide, 5, ContainerFactory.EMPTY, Content.ContainerTypes.FLUIDIZER_CONTROLLER.get(), windowId, playerInventory, (AbstractModBlockEntity)controller);
        MultiblockFluidizer fluidizer = (MultiblockFluidizer)controller.getMultiblockController().orElseThrow(IllegalStateException::new);
        this._outputCapacity = fluidizer.getFluidHandler().getTankCapacity(0);
        List<FluidizerSolidInjectorEntity> solidInjectors = fluidizer.getSolidInjectors();
        List<FluidizerFluidInjectorEntity> fluidInjectors = fluidizer.getFluidInjectors();
        this.ACTIVE = BooleanData.of((ModContainer)this, fluidizer::isMachineActive);
        this.RECIPE_TYPE = EnumData.of((ModContainer)this, IFluidizerRecipe.Type.class, fluidizer::getRecipeType);
        this.RECIPE_PROGRESS = DoubleData.of((ModContainer)this, fluidizer::getRecipeProgress);
        this.FLUID_OUTPUT_STACK = FluidStackData.sampled((int)3, (ModContainer)this, () -> fluidizer.getFluidHandler().getFluidInTank(0));
        this.ENERGY_STORED = WideAmountData.sampled((int)3, (ModContainer)this, () -> fluidizer.getEnergyStored(EnergySystem.ForgeEnergy));
        this._solidInputBindings = new ItemStackData[2];
        this._fluidInputBindings = new FluidStackData[2];
        for (int i = 0; i < 2; ++i) {
            FluidStackData fluidData;
            ItemStackData itemData;
            AbstractFluidizerEntity entity;
            if (i < solidInjectors.size()) {
                entity = solidInjectors.get(i);
                itemData = ItemStackData.of((ModContainer)this, ((FluidizerSolidInjectorEntity)entity)::getStack);
            } else {
                itemData = ItemStackData.empty((ModContainer)this);
            }
            if (i < fluidInjectors.size()) {
                entity = fluidInjectors.get(i);
                fluidData = FluidStackData.of((ModContainer)this, ((FluidizerFluidInjectorEntity)entity)::getStack);
            } else {
                fluidData = FluidStackData.empty((ModContainer)this);
            }
            this._solidInputBindings[i] = itemData;
            this._fluidInputBindings[i] = fluidData;
        }
    }

    public FluidizerControllerContainer(int windowId, Inventory playerInventory, FluidizerControllerEntity controller) {
        this(false, windowId, playerInventory, controller);
    }

    public FluidizerControllerContainer(int windowId, Inventory playerInventory, FriendlyByteBuf networkData) {
        this(true, windowId, playerInventory, (FluidizerControllerEntity)AbstractModBlockEntity.getGuiClientBlockEntity((FriendlyByteBuf)networkData));
    }

    public ItemStackData getSolidInput(int index) {
        return this._solidInputBindings[index];
    }

    public FluidStackData getFluidInput(int index) {
        return this._fluidInputBindings[index];
    }

    public int getOutputCapacity() {
        return this._outputCapacity;
    }

    public WideAmount getEnergyCapacity() {
        return MultiblockFluidizer.ENERGY_CAPACITY;
    }
}

