/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.energizer.part;

import it.zerono.mods.extremereactors.gamecontent.multiblock.energizer.part.AbstractEnergizerEntity;
import it.zerono.mods.zerocore.base.multiblock.part.io.power.IPowerPort;
import it.zerono.mods.zerocore.base.multiblock.part.io.power.IPowerPortHandler;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.data.IoDirection;
import it.zerono.mods.zerocore.lib.data.WideAmount;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.LogicalSide;

abstract class AbstractEnergizerPowerPortEntity
extends AbstractEnergizerEntity
implements IPowerPort {
    private IPowerPortHandler _handler;
    private WideAmount _transferRate = WideAmount.MAX_VALUE;
    private IoDirection _ioDirection;

    protected AbstractEnergizerPowerPortEntity(BlockEntityType<?> type, BlockPos position, BlockState blockState) {
        super(type, position, blockState);
        this.setIoDirection(IoDirection.Input);
    }

    public IPowerPortHandler getPowerPortHandler() {
        return this._handler;
    }

    public WideAmount getMaxTransferRate() {
        return this._transferRate;
    }

    public IoDirection getIoDirection() {
        return this._ioDirection;
    }

    public void setIoDirection(IoDirection direction) {
        if (this.getIoDirection() == direction) {
            return;
        }
        this._ioDirection = direction;
        this.notifyBlockUpdate();
        this.callOnLogicalSide(() -> {
            this.notifyOutwardNeighborsOfStateChange();
            this.setChanged();
        }, () -> ((AbstractEnergizerPowerPortEntity)this).markForRenderUpdate());
    }

    public void syncDataFrom(CompoundTag data, HolderLookup.Provider registries, ISyncableEntity.SyncReason syncReason) {
        super.syncDataFrom(data, registries, syncReason);
        this._transferRate = WideAmount.deserializeFromNBT((Tag)data.getCompound("rate"));
    }

    public CompoundTag syncDataTo(CompoundTag data, HolderLookup.Provider registries, ISyncableEntity.SyncReason syncReason) {
        super.syncDataTo(data, registries, syncReason);
        data.put("rate", this._transferRate.serializeToNBT());
        return data;
    }

    @Override
    public void getDebugMessages(LogicalSide side, IDebugMessages messages) {
        super.getDebugMessages(side, messages);
        messages.add("Max transfer rate: %1$s", new Object[]{CodeHelper.formatAsHumanReadableNumber((WideAmount)this.getMaxTransferRate(), (String)"/t")});
        messages.add("Direction: %1$s", new Object[]{this._ioDirection});
    }

    protected final void setHandler(IPowerPortHandler handler) {
        this._handler = handler;
    }
}

