/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.config;

import net.neoforged.neoforge.common.ModConfigSpec;

public class Reactor {
    public final ModConfigSpec.IntValue maxReactorHeight;
    public final ModConfigSpec.IntValue maxReactorSize;
    public final ModConfigSpec.DoubleValue reactorPowerProductionMultiplier;

    Reactor(ModConfigSpec.Builder builder) {
        builder.comment("Define how Reactors works").push("reactor");
        this.maxReactorHeight = builder.comment(new String[]{"The maximum valid size of a Reactor in the Y dimension, in blocks.", "Lower this if your server's players are building ginormous Reactors.", "Bigger Y sizes have far less performance impact than X/Z sizes."}).translation("config.bigreactors.reactor.maxreactorheight").worldRestart().defineInRange("maxReactorHeight", 48, 3, 256);
        this.maxReactorSize = builder.comment(new String[]{"The maximum valid size of a Reactor in the X/Z plane, in blocks.", "Lower this if your server's players are building ginormous Reactors."}).translation("config.bigreactors.reactor.maxreactorsize").worldRestart().defineInRange("maxReactorSize", 32, 3, 256);
        this.reactorPowerProductionMultiplier = builder.comment("A multiplier for balancing Reactor power production. Stacks with powerProductionMultiplier.").translation("config.bigreactors.reactor.reactorpowerproductionmultiplier").worldRestart().defineInRange("reactorPowerProductionMultiplier", 1.0, 0.5, 100.0);
        builder.pop();
    }
}

