/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui.config;

import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import snownee.jade.gui.config.OptionsList;

public class OptionButton
extends OptionsList.Entry {
    protected final Component title;

    public OptionButton(String titleKey, Button button) {
        this((Component)OptionButton.makeTitle(titleKey), button);
    }

    public OptionButton(Component title, Button button) {
        this.title = title;
        this.addMessage(title.getString());
        if (button != null) {
            if (button.getMessage().getString().isEmpty()) {
                button.setMessage(title);
            } else {
                this.addMessage(button.getMessage().getString());
            }
            this.addWidget((AbstractWidget)button, 0);
        }
    }

    public OptionButton(Component title, Button.Builder builder) {
        this(title, builder.createNarration($ -> CommonComponents.joinForNarration((Component[])new Component[]{title, (Component)$.get()})).build());
    }

    @Override
    public void render(GuiGraphics guiGraphics, int index, int rowTop, int rowLeft, int width, int height, int mouseX, int mouseY, boolean hovered, float deltaTime) {
        Font font = this.client.font;
        int n = rowTop + height / 2;
        Objects.requireNonNull(this.client.font);
        guiGraphics.drawString(font, this.title, rowLeft + 10, n - 9 / 2, 0xFFFFFF);
        super.render(guiGraphics, index, rowTop, rowLeft, width, height, mouseX, mouseY, hovered, deltaTime);
    }
}

