/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.JukeboxPlayable;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IDisplayHelper;

public enum JukeboxProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;

    private static final MapCodec<ItemStack> RECORD_CODEC;

    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        BlockState state = accessor.getBlockState();
        ItemStack stack = ItemStack.EMPTY;
        if (((Boolean)state.getValue((Property)JukeboxBlock.HAS_RECORD)).booleanValue()) {
            stack = accessor.readData(RECORD_CODEC).orElse(ItemStack.EMPTY);
        }
        if (!stack.isEmpty()) {
            JukeboxPlayable playable = (JukeboxPlayable)stack.get(DataComponents.JUKEBOX_PLAYABLE);
            Component name = playable != null ? playable.song().unwrap((HolderLookup.Provider)accessor.getLevel().registryAccess()).map($ -> ((JukeboxSong)$.value()).description()).orElse(stack.getHoverName()) : stack.getHoverName();
            tooltip.add((Component)Component.translatable((String)"record.nowPlaying", (Object[])new Object[]{IDisplayHelper.get().stripColor(name)}));
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.jade.empty"));
        }
    }

    @Override
    public void appendServerData(CompoundTag data, BlockAccessor accessor) {
        JukeboxBlockEntity jukebox;
        ItemStack stack;
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof JukeboxBlockEntity && !(stack = (jukebox = (JukeboxBlockEntity)blockEntity).getTheItem()).isEmpty()) {
            accessor.writeData(RECORD_CODEC, stack);
        }
    }

    @Override
    public ResourceLocation getUid() {
        return JadeIds.MC_JUKEBOX;
    }

    static {
        RECORD_CODEC = ItemStack.CODEC.fieldOf("record");
    }
}

