/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;

public enum BeehiveProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        BlockState state = accessor.getBlockState();
        int level = (Integer)state.getValue((Property)BeehiveBlock.HONEY_LEVEL);
        IThemeHelper t = IThemeHelper.get();
        MutableComponent value = Component.translatable((String)"jade.fraction", (Object[])new Object[]{level, 5});
        tooltip.add((Component)Component.translatable((String)"jade.beehive.honey", (Object[])new Object[]{level == 5 ? t.success(value) : t.info(value)}));
        if (accessor.getServerData().contains("Full")) {
            boolean full = accessor.getServerData().getBoolean("Full");
            byte bees = accessor.getServerData().getByte("Bees");
            tooltip.add((Component)Component.translatable((String)"jade.beehive.bees", (Object[])new Object[]{full ? t.success(bees) : t.info(bees)}));
        }
    }

    @Override
    public void appendServerData(CompoundTag tag, BlockAccessor accessor) {
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof BeehiveBlockEntity) {
            BeehiveBlockEntity beehive = (BeehiveBlockEntity)blockEntity;
            tag.putByte("Bees", (byte)beehive.getOccupantCount());
            tag.putBoolean("Full", beehive.isFull());
        }
    }

    @Override
    public ResourceLocation getUid() {
        return JadeIds.MC_BEEHIVE;
    }
}

