/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.universal;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.LockCode;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.EnderChestBlockEntity;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;
import snownee.jade.addon.universal.ItemCollector;
import snownee.jade.addon.universal.ItemIterator;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.ui.ScreenDirection;
import snownee.jade.api.view.ClientViewGroup;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ItemView;
import snownee.jade.api.view.ViewGroup;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.impl.ui.HorizontalLineElement;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.WailaExceptionHandler;

public abstract class ItemStorageProvider<T extends Accessor<?>>
implements IComponentProvider<T>,
IServerDataProvider<T> {
    public static final Cache<Object, ItemCollector<?>> targetCache = CacheBuilder.newBuilder().weakKeys().expireAfterAccess(60L, TimeUnit.SECONDS).build();
    public static final Cache<Object, ItemCollector<?>> containerCache = CacheBuilder.newBuilder().weakKeys().expireAfterAccess(120L, TimeUnit.SECONDS).build();

    public static ForBlock getBlock() {
        return ForBlock.INSTANCE;
    }

    public static ForEntity getEntity() {
        return ForEntity.INSTANCE;
    }

    public static void append(ITooltip tooltip, Accessor<?> accessor, IPluginConfig config) {
        List groups;
        if (!accessor.getServerData().contains("JadeItemStorage")) {
            if (accessor.getServerData().getBoolean("Loot")) {
                tooltip.add((Component)Component.translatable((String)"jade.loot_not_generated"));
            } else if (accessor.getServerData().getBoolean("Locked")) {
                tooltip.add((Component)Component.translatable((String)"jade.locked"));
            }
            return;
        }
        IClientExtensionProvider provider = Optional.ofNullable(ResourceLocation.tryParse((String)accessor.getServerData().getString("JadeItemStorageUid"))).map(WailaClientRegistration.instance().itemStorageProviders::get).orElse(null);
        if (provider == null) {
            return;
        }
        try {
            groups = provider.getClientGroups(accessor, ViewGroup.readList(accessor.getServerData(), "JadeItemStorage", itemTag -> {
                ItemStack item = ItemStack.parseOptional((HolderLookup.Provider)accessor.getLevel().registryAccess(), (CompoundTag)itemTag);
                if (!item.isEmpty() && itemTag.contains("NewCount")) {
                    item.setCount(itemTag.getInt("NewCount"));
                }
                return item;
            }));
        }
        catch (Exception e) {
            WailaExceptionHandler.handleErr(e, provider, tooltip, provider.getUid().getNamespace());
            return;
        }
        if (groups.isEmpty()) {
            return;
        }
        MutableBoolean showName = new MutableBoolean(true);
        int totalSize = 0;
        for (ClientViewGroup clientViewGroup : groups) {
            for (ItemView view : clientViewGroup.views) {
                if (view.amountText != null) {
                    showName.setFalse();
                }
                if (view.item.isEmpty()) continue;
                ++totalSize;
            }
        }
        if (showName.isTrue()) {
            showName.setValue(totalSize < PluginConfig.INSTANCE.getInt(JadeIds.UNIVERSAL_ITEM_STORAGE_SHOW_NAME_AMOUNT));
        }
        IElementHelper helper = IElementHelper.get();
        boolean renderGroup = groups.size() > 1 || groups.getFirst().shouldRenderGroup();
        ClientViewGroup.tooltip(tooltip, groups, renderGroup, (theTooltip, group) -> {
            float progress;
            CompoundTag data;
            if (renderGroup) {
                theTooltip.add(new HorizontalLineElement());
                if (group.title != null) {
                    theTooltip.append(helper.text(group.title).scale(0.5f));
                    theTooltip.append(new HorizontalLineElement());
                }
            }
            if (group.views.isEmpty() && (data = group.extraData) != null && data.contains("Collecting", 99) && (progress = data.getFloat("Collecting")) < 1.0f) {
                MutableComponent component = Component.translatable((String)"jade.collectingItems");
                if (progress > 0.0f) {
                    component.append(" %s%%".formatted((int)(progress * 100.0f)));
                }
                theTooltip.add((Component)component);
            }
            int drawnCount = 0;
            int realSize = PluginConfig.INSTANCE.getInt(accessor.showDetails() ? JadeIds.UNIVERSAL_ITEM_STORAGE_DETAILED_AMOUNT : JadeIds.UNIVERSAL_ITEM_STORAGE_NORMAL_AMOUNT);
            realSize = Math.min(group.views.size(), realSize);
            ArrayList elements = Lists.newArrayList();
            for (int i = 0; i < realSize; ++i) {
                ItemView itemView = (ItemView)group.views.get(i);
                ItemStack stack = itemView.item;
                if (stack.isEmpty()) continue;
                if (i > 0 && (showName.isTrue() || drawnCount >= PluginConfig.INSTANCE.getInt(JadeIds.UNIVERSAL_ITEM_STORAGE_ITEMS_PER_LINE))) {
                    theTooltip.add(elements);
                    theTooltip.setLineMargin(-1, ScreenDirection.DOWN, -1);
                    elements.clear();
                    drawnCount = 0;
                }
                if (showName.isTrue()) {
                    if (itemView.description != null) {
                        elements.add(helper.smallItem(stack));
                        elements.addAll(itemView.description);
                    } else {
                        elements.add(helper.smallItem(stack).clearCachedMessage());
                        elements.add(helper.text((Component)Component.literal((String)IDisplayHelper.get().humanReadableNumber(stack.getCount(), "", false, null)).append("\u00d7 ").append((Component)IDisplayHelper.get().stripColor(stack.getHoverName()))).message(null));
                    }
                } else if (itemView.amountText != null) {
                    elements.add(helper.item(stack, 1.0f, itemView.amountText));
                } else {
                    elements.add(helper.item(stack));
                }
                ++drawnCount;
            }
            if (!elements.isEmpty()) {
                theTooltip.add(elements);
            }
        });
    }

    public static void putData(Accessor<?> accessor) {
        CompoundTag tag = accessor.getServerData();
        Object target = accessor.getTarget();
        Player player = accessor.getPlayer();
        for (IServerExtensionProvider<ItemStack> provider : WailaCommonRegistration.instance().itemStorageProviders.get(accessor)) {
            RandomizableContainer containerEntity;
            List groups;
            try {
                groups = provider.getGroups(accessor);
            }
            catch (Exception e) {
                WailaExceptionHandler.handleErr(e, provider, null, provider.getUid().getNamespace());
                continue;
            }
            if (groups == null) continue;
            if (ViewGroup.saveList(tag, "JadeItemStorage", groups, item -> {
                int count = item.getCount();
                if (count > item.getMaxStackSize()) {
                    item.setCount(1);
                }
                CompoundTag itemTag = (CompoundTag)item.save((HolderLookup.Provider)accessor.getLevel().registryAccess());
                if (count > item.getMaxStackSize()) {
                    itemTag.putInt("NewCount", count);
                    item.setCount(count);
                }
                return itemTag;
            })) {
                tag.putString("JadeItemStorageUid", provider.getUid().toString());
                break;
            }
            if (target instanceof RandomizableContainer && (containerEntity = (RandomizableContainer)target).getLootTable() != null) {
                tag.putBoolean("Loot", true);
                break;
            }
            if (player.isCreative() || player.isSpectator() || !(target instanceof BaseContainerBlockEntity)) break;
            BaseContainerBlockEntity te = (BaseContainerBlockEntity)target;
            if (te.lockKey == LockCode.NO_LOCK) break;
            tag.putBoolean("Locked", true);
            break;
        }
    }

    @Override
    public void appendTooltip(ITooltip tooltip, T accessor, IPluginConfig config) {
        if (accessor.getTarget() instanceof AbstractFurnaceBlockEntity) {
            return;
        }
        ItemStorageProvider.append(tooltip, accessor, config);
    }

    @Override
    public void appendServerData(CompoundTag tag, T accessor) {
        if (accessor.getTarget() instanceof AbstractFurnaceBlockEntity) {
            return;
        }
        ItemStorageProvider.putData(accessor);
    }

    @Override
    public boolean shouldRequestData(T accessor) {
        if (accessor.getTarget() instanceof AbstractFurnaceBlockEntity) {
            return false;
        }
        int amount = accessor.showDetails() ? IWailaConfig.get().getPlugin().getInt(JadeIds.UNIVERSAL_ITEM_STORAGE_DETAILED_AMOUNT) : IWailaConfig.get().getPlugin().getInt(JadeIds.UNIVERSAL_ITEM_STORAGE_NORMAL_AMOUNT);
        if (amount == 0) {
            return false;
        }
        for (IServerExtensionProvider<ItemStack> provider : WailaCommonRegistration.instance().itemStorageProviders.get((Accessor<?>)accessor)) {
            if (!provider.shouldRequestData((Accessor<?>)accessor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ResourceLocation getUid() {
        return JadeIds.UNIVERSAL_ITEM_STORAGE;
    }

    @Override
    public int getDefaultPriority() {
        return 1000;
    }

    public static class ForBlock
    extends ItemStorageProvider<BlockAccessor> {
        private static final ForBlock INSTANCE = new ForBlock();
    }

    public static class ForEntity
    extends ItemStorageProvider<EntityAccessor> {
        private static final ForEntity INSTANCE = new ForEntity();
    }

    public static enum Extension implements IServerExtensionProvider<ItemStack>,
    IClientExtensionProvider<ItemStack, ItemView>
    {
        INSTANCE;


        @Override
        public ResourceLocation getUid() {
            return JadeIds.UNIVERSAL_ITEM_STORAGE_DEFAULT;
        }

        @Override
        @Nullable
        public List<ViewGroup<ItemStack>> getGroups(Accessor<?> accessor) {
            ItemCollector itemCollector;
            ContainerEntity containerEntity;
            RandomizableContainer te;
            BlockAccessor blockAccessor;
            Block block;
            Object target = accessor.getTarget();
            if (target == null && accessor instanceof BlockAccessor && (block = (blockAccessor = (BlockAccessor)accessor).getBlock()) instanceof WorldlyContainerHolder) {
                WorldlyContainerHolder holder = (WorldlyContainerHolder)block;
                WorldlyContainer container = holder.getContainer(blockAccessor.getBlockState(), (LevelAccessor)accessor.getLevel(), blockAccessor.getPosition());
                return CommonProxy.containerGroup((Container)container, accessor);
            }
            if (target == null) {
                return List.of();
            }
            if (target instanceof RandomizableContainer && (te = (RandomizableContainer)target).getLootTable() != null) {
                return List.of();
            }
            if (target instanceof ContainerEntity && (containerEntity = (ContainerEntity)target).getLootTable() != null) {
                return List.of();
            }
            Player player = accessor.getPlayer();
            if (!player.isCreative() && !player.isSpectator() && target instanceof BaseContainerBlockEntity) {
                BaseContainerBlockEntity te2 = (BaseContainerBlockEntity)target;
                if (te2.lockKey != LockCode.NO_LOCK) {
                    return List.of();
                }
            }
            if (target instanceof EnderChestBlockEntity) {
                PlayerEnderChestContainer inventory = player.getEnderChestInventory();
                return new ItemCollector<Container>(new ItemIterator.ContainerItemIterator(0)).update(inventory, accessor.getLevel().getGameTime());
            }
            try {
                itemCollector = (ItemCollector)targetCache.get(target, () -> CommonProxy.createItemCollector(target, containerCache));
            }
            catch (ExecutionException e) {
                WailaExceptionHandler.handleErr(e, null, null, null);
                return null;
            }
            if (itemCollector == ItemCollector.EMPTY) {
                return null;
            }
            return itemCollector.update(target, accessor.getLevel().getGameTime());
        }

        @Override
        public List<ClientViewGroup<ItemView>> getClientGroups(Accessor<?> accessor, List<ViewGroup<ItemStack>> groups) {
            return ClientViewGroup.map(groups, ItemView::new, null);
        }

        @Override
        public boolean shouldRequestData(Accessor<?> accessor) {
            return CommonProxy.hasDefaultItemStorage(accessor);
        }

        @Override
        public int getDefaultPriority() {
            return 9999;
        }
    }
}

