/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.util;

import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.common.capability.FamiliarSettingsData;
import com.klikli_dev.occultism.common.entity.familiar.IFamiliar;
import com.klikli_dev.occultism.registry.OccultismDataStorage;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;

public class FamiliarUtil {
    public static List<LivingEntity> getOwnerEnemies(LivingEntity owner, LivingEntity familiar, float range) {
        if (null == owner) {
            return new ArrayList<LivingEntity>();
        }
        LivingEntity revenge = owner.getLastHurtByMob();
        LivingEntity target = owner.getLastHurtMob();
        ArrayList<LivingEntity> enemies = new ArrayList<LivingEntity>();
        if (FamiliarUtil.isClose(revenge, familiar, range)) {
            enemies.add(revenge);
        }
        if (FamiliarUtil.isClose(target, familiar, range)) {
            enemies.add(target);
        }
        return enemies;
    }

    private static boolean isClose(LivingEntity e, LivingEntity familiar, float range) {
        return e != null && e != familiar && e.distanceToSqr((Entity)familiar) < (double)range;
    }

    public static boolean isFamiliarEnabled(LivingEntity owner, EntityType<? extends IFamiliar> familiar) {
        return ((FamiliarSettingsData)owner.getData(OccultismDataStorage.FAMILIAR_SETTINGS)).isFamiliarEnabled(familiar);
    }

    public static <T extends Entity> boolean hasFamiliar(LivingEntity owner, EntityType<T> type) {
        return FamiliarUtil.hasFamiliar(owner, type, f -> true);
    }

    public static <T extends Entity> boolean hasFamiliar(LivingEntity owner, EntityType<T> type, Predicate<T> pred) {
        return FamiliarUtil.getFamiliar(owner, type, pred) != null;
    }

    public static <T extends Entity> List<T> getAllFamiliars(LivingEntity owner, EntityType<T> type) {
        return FamiliarUtil.getAllFamiliars(owner, type, f -> true);
    }

    public static <T extends Entity> List<T> getAllFamiliars(LivingEntity owner, EntityType<T> type, Predicate<T> pred) {
        List<T> nearby = FamiliarUtil.getAllNearbyFamiliars(owner, type, pred);
        List<T> equipped = FamiliarUtil.getAllEquippedFamiliars(owner, type, pred);
        nearby.addAll(equipped);
        return nearby;
    }

    public static <T extends Entity> T getFamiliar(LivingEntity owner, EntityType<T> type) {
        return (T)FamiliarUtil.getFamiliar(owner, type, f -> true);
    }

    public static <T extends Entity> T getFamiliar(LivingEntity owner, EntityType<T> type, Predicate<T> pred) {
        T familiar = FamiliarUtil.getEquippedFamiliar(owner, type, pred);
        if (familiar == null) {
            familiar = FamiliarUtil.getNearbyFamiliar(owner, type, pred);
        }
        return familiar;
    }

    public static <T extends Entity> List<T> getAllNearbyFamiliars(LivingEntity owner, EntityType<T> type, Predicate<T> pred) {
        return owner.level().getEntities(type, owner.getBoundingBox().inflate(10.0), e -> pred.test(e) && ((IFamiliar)e).getFamiliarOwner() == owner && e.isAlive());
    }

    public static <T extends Entity> T getNearbyFamiliar(LivingEntity owner, EntityType<T> type, Predicate<T> pred) {
        List<T> nearby = FamiliarUtil.getAllNearbyFamiliars(owner, type, pred);
        return (T)(nearby.isEmpty() ? null : (Entity)nearby.get(0));
    }

    public static <T extends Entity> List<T> getAllEquippedFamiliars(LivingEntity owner, EntityType<T> type, Predicate<T> pred) {
        ArrayList familiars = new ArrayList();
        return familiars;
    }

    public static <T extends Entity> T getEquippedFamiliar(LivingEntity owner, EntityType<T> type, Predicate<T> pred) {
        List<T> familiars = FamiliarUtil.getAllEquippedFamiliars(owner, type, pred);
        return (T)(familiars.isEmpty() ? null : (Entity)familiars.get(0));
    }

    public static float toRads(float deg) {
        return (float)Math.toRadians(deg);
    }

    public static boolean isChristmas() {
        if (((Boolean)Occultism.CLIENT_CONFIG.visuals.disableHolidayTheming.get()).booleanValue()) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) == 11 && calendar.get(5) >= 15 || calendar.get(2) == 0 && calendar.get(5) <= 15;
    }
}

