/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.registry;

import com.klikli_dev.occultism.common.level.cave.SphericalCaveSubFeature;
import com.klikli_dev.occultism.common.level.cave.UndergroundGroveDecorator;
import com.klikli_dev.occultism.common.level.multichunk.MultiChunkFeature;
import com.klikli_dev.occultism.common.level.multichunk.MultiChunkFeatureConfig;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.neoforged.neoforge.registries.DeferredRegister;

public class OccultismFeatures {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((Registry)BuiltInRegistries.FEATURE, (String)"occultism");
    public static final Supplier<MultiChunkFeature> UNDERGROUND_GROVE_FEATURE = FEATURES.register("underground_grove", () -> new MultiChunkFeature(MultiChunkFeatureConfig.CODEC, new SphericalCaveSubFeature(new UndergroundGroveDecorator(), 25, 25)));

    private static List<PlacementModifier> orePlacement(PlacementModifier modifier1, PlacementModifier modifier2) {
        return List.of(modifier1, InSquarePlacement.spread(), modifier2, BiomeFilter.biome());
    }

    public static List<PlacementModifier> commonOrePlacement(int count, PlacementModifier modifier) {
        return OccultismFeatures.orePlacement((PlacementModifier)CountPlacement.of((int)count), modifier);
    }

    private static List<PlacementModifier> rareOrePlacement(int rarity, PlacementModifier modifier) {
        return OccultismFeatures.orePlacement((PlacementModifier)RarityFilter.onAverageOnceEvery((int)rarity), modifier);
    }
}

