/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.registry;

import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.common.block.CandleBlock;
import com.klikli_dev.occultism.common.block.ChalkGlyphBlock;
import com.klikli_dev.occultism.common.block.DimensionalMineshaftBlock;
import com.klikli_dev.occultism.common.block.GoldenSacrificialBowlBlock;
import com.klikli_dev.occultism.common.block.NonPathfindableBlock;
import com.klikli_dev.occultism.common.block.SacrificialBowlBlock;
import com.klikli_dev.occultism.common.block.SpiritAttunedCrystalBlock;
import com.klikli_dev.occultism.common.block.SpiritFireBlock;
import com.klikli_dev.occultism.common.block.SpiritTorchBlock;
import com.klikli_dev.occultism.common.block.SpiritWallTorchBlock;
import com.klikli_dev.occultism.common.block.crops.ReplantableCropsBlock;
import com.klikli_dev.occultism.common.block.otherworld.IesniumOreNaturalBlock;
import com.klikli_dev.occultism.common.block.otherworld.OtherstoneNaturalBlock;
import com.klikli_dev.occultism.common.block.otherworld.OtherworldLeavesNaturalBlock;
import com.klikli_dev.occultism.common.block.otherworld.OtherworldLogNaturalBlock;
import com.klikli_dev.occultism.common.block.otherworld.OtherworldSaplingBlock;
import com.klikli_dev.occultism.common.block.otherworld.OtherworldSaplingNaturalBlock;
import com.klikli_dev.occultism.common.block.storage.StableWormholeBlock;
import com.klikli_dev.occultism.common.block.storage.StorageControllerBlock;
import com.klikli_dev.occultism.common.block.storage.StorageStabilizerBlock;
import com.klikli_dev.occultism.common.entity.familiar.CthulhuFamiliarEntity;
import com.klikli_dev.occultism.common.entity.familiar.FamiliarEntity;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.klikli_dev.occultism.registry.OccultismParticles;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class OccultismBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"occultism");
    public static final Map<ResourceLocation, BlockDataGenSettings> BLOCK_DATA_GEN_SETTINGS = new HashMap<ResourceLocation, BlockDataGenSettings>();
    public static final DeferredBlock<SpiritFireBlock> SPIRIT_FIRE = OccultismBlocks.register("spirit_fire", () -> new SpiritFireBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).noCollission().instabreak().lightLevel(state -> 12).sound(SoundType.WOOL).noLootTable()), false, LootTableType.EMPTY);
    public static final DeferredBlock<Block> LIGHTED_AIR = OccultismBlocks.register("lighted_air", () -> new AirBlock(BlockBehaviour.Properties.of().noCollission().air().noLootTable().lightLevel(s -> 15).randomTicks()){

        public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
            if (pLevel.getEntitiesOfClass(CthulhuFamiliarEntity.class, new AABB(pPos), FamiliarEntity::hasBlacksmithUpgrade).isEmpty()) {
                pLevel.setBlockAndUpdate(pPos, Blocks.AIR.defaultBlockState());
            }
        }
    }, false, LootTableType.EMPTY);
    public static final BlockBehaviour.Properties GLYPH_PROPERTIES = BlockBehaviour.Properties.of().sound(SoundType.WOOL).pushReaction(PushReaction.DESTROY).replaceable().noCollission().noLootTable().strength(5.0f, 30.0f);
    public static final DeferredBlock<ChalkGlyphBlock> CHALK_GLYPH_WHITE = OccultismBlocks.register("chalk_glyph_white", () -> new ChalkGlyphBlock(GLYPH_PROPERTIES, (Supplier<Integer>)Occultism.CLIENT_CONFIG.visuals.whiteChalkGlyphColor, () -> (Item)OccultismItems.CHALK_WHITE.get()), false, LootTableType.EMPTY);
    public static final DeferredBlock<ChalkGlyphBlock> CHALK_GLYPH_GOLD = OccultismBlocks.register("chalk_glyph_gold", () -> new ChalkGlyphBlock(GLYPH_PROPERTIES, (Supplier<Integer>)Occultism.CLIENT_CONFIG.visuals.goldenChalkGlyphColor, () -> (Item)OccultismItems.CHALK_GOLD.get()), false, LootTableType.EMPTY);
    public static final DeferredBlock<ChalkGlyphBlock> CHALK_GLYPH_PURPLE = OccultismBlocks.register("chalk_glyph_purple", () -> new ChalkGlyphBlock(GLYPH_PROPERTIES, (Supplier<Integer>)Occultism.CLIENT_CONFIG.visuals.purpleChalkGlyphColor, () -> (Item)OccultismItems.CHALK_PURPLE.get()), false, LootTableType.EMPTY);
    public static final DeferredBlock<ChalkGlyphBlock> CHALK_GLYPH_RED = OccultismBlocks.register("chalk_glyph_red", () -> new ChalkGlyphBlock(GLYPH_PROPERTIES, (Supplier<Integer>)Occultism.CLIENT_CONFIG.visuals.redChalkGlyphColor, () -> (Item)OccultismItems.CHALK_RED.get()), false, LootTableType.EMPTY);
    public static final DeferredBlock<Block> OTHERSTONE = OccultismBlocks.register("otherstone", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).sound(SoundType.STONE).strength(1.5f, 30.0f)));
    public static final DeferredBlock<SlabBlock> OTHERSTONE_SLAB = OccultismBlocks.register("otherstone_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)((BlockBehaviour)OTHERSTONE.get()))));
    public static final DeferredBlock<Block> OTHERSTONE_PEDESTAL = OccultismBlocks.register("otherstone_pedestal", () -> new Block(BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)((BlockBehaviour)OTHERSTONE.get()))));
    public static final DeferredBlock<Block> STORAGE_CONTROLLER_BASE = OccultismBlocks.register("storage_controller_base", () -> new NonPathfindableBlock(BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)((BlockBehaviour)OTHERSTONE.get())).noOcclusion()));
    public static final DeferredBlock<OtherstoneNaturalBlock> OTHERSTONE_NATURAL = OccultismBlocks.register("otherstone_natural", () -> new OtherstoneNaturalBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).sound(SoundType.STONE).strength(1.5f, 30.0f)), true, LootTableType.OTHERWORLD_BLOCK);
    public static final DeferredBlock<Block> OTHERWORLD_LOG = OccultismBlocks.register("otherworld_log", () -> new RotatedPillarBlock(BlockBehaviour.Properties.of().mapColor(state -> state.getValue((Property)RotatedPillarBlock.AXIS) == Direction.Axis.Y ? MapColor.WOOD : MapColor.COLOR_PURPLE).strength(2.0f).sound(SoundType.WOOD).strength(2.0f)));
    public static final DeferredBlock<Block> OTHERWORLD_LOG_NATURAL = OccultismBlocks.register("otherworld_log_natural", () -> new OtherworldLogNaturalBlock(BlockBehaviour.Properties.of().mapColor(state -> state.getValue((Property)RotatedPillarBlock.AXIS) == Direction.Axis.Y ? MapColor.WOOD : MapColor.COLOR_PURPLE).strength(2.0f)), true, LootTableType.OTHERWORLD_BLOCK);
    public static final DeferredBlock<LeavesBlock> OTHERWORLD_LEAVES = OccultismBlocks.register("otherworld_leaves", () -> new LeavesBlock(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).sound(SoundType.GRASS).strength(0.2f).randomTicks().noOcclusion()), true, LootTableType.CUSTOM);
    public static final DeferredBlock<OtherworldLeavesNaturalBlock> OTHERWORLD_LEAVES_NATURAL = OccultismBlocks.register("otherworld_leaves_natural", () -> new OtherworldLeavesNaturalBlock(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).sound(SoundType.GRASS).strength(0.2f).randomTicks().noOcclusion()), true, LootTableType.CUSTOM);
    public static final DeferredBlock<OtherworldSaplingBlock> OTHERWORLD_SAPLING = OccultismBlocks.register("otherworld_sapling", () -> new OtherworldSaplingBlock(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).sound(SoundType.GRASS).strength(0.0f).randomTicks().noCollission()));
    public static final DeferredBlock<OtherworldSaplingNaturalBlock> OTHERWORLD_SAPLING_NATURAL = OccultismBlocks.register("otherworld_sapling_natural", () -> new OtherworldSaplingNaturalBlock(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).sound(SoundType.GRASS).strength(0.0f).randomTicks().noCollission()), false, LootTableType.OTHERWORLD_BLOCK);
    public static final DeferredBlock<Block> SILVER_ORE = OccultismBlocks.register("silver_ore", () -> new Block(BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.IRON_ORE)), true, LootTableType.CUSTOM);
    public static final DeferredBlock<Block> SILVER_ORE_DEEPSLATE = OccultismBlocks.register("silver_ore_deepslate", () -> new Block(BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.IRON_ORE)), true, LootTableType.CUSTOM);
    public static final DeferredBlock<Block> IESNIUM_ORE = OccultismBlocks.register("iesnium_ore", () -> new Block(BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.IRON_ORE)), true, LootTableType.CUSTOM);
    public static final DeferredBlock<IesniumOreNaturalBlock> IESNIUM_ORE_NATURAL = OccultismBlocks.register("iesnium_ore_natural", () -> new IesniumOreNaturalBlock(BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.IRON_ORE)), true, LootTableType.OTHERWORLD_BLOCK);
    public static final DeferredBlock<Block> SILVER_BLOCK = OccultismBlocks.register("silver_block", () -> new Block(BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.IRON_BLOCK)));
    public static final DeferredBlock<Block> RAW_SILVER_BLOCK = OccultismBlocks.register("raw_silver_block", () -> new Block(BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.RAW_IRON_BLOCK)));
    public static final DeferredBlock<Block> IESNIUM_BLOCK = OccultismBlocks.register("iesnium_block", () -> new Block(BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.IRON_BLOCK)));
    public static final DeferredBlock<Block> RAW_IESNIUM_BLOCK = OccultismBlocks.register("raw_iesnium_block", () -> new Block(BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.RAW_IRON_BLOCK)));
    public static final DeferredBlock<CandleBlock> CANDLE_WHITE = OccultismBlocks.register("candle_white", () -> new CandleBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WOOL).sound(SoundType.WOOL).noCollission().strength(0.1f, 0.0f).lightLevel(state -> 12)));
    public static final DeferredBlock<SpiritAttunedCrystalBlock> SPIRIT_ATTUNED_CRYSTAL = OccultismBlocks.register("spirit_attuned_crystal", () -> new SpiritAttunedCrystalBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).sound(SoundType.STONE).noOcclusion().strength(1.5f, 30.0f).lightLevel(state -> 8)));
    public static final DeferredBlock<SacrificialBowlBlock> SACRIFICIAL_BOWL = OccultismBlocks.register("sacrificial_bowl", () -> new SacrificialBowlBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).sound(SoundType.STONE).strength(1.5f, 30.0f).noOcclusion()));
    public static final DeferredBlock<GoldenSacrificialBowlBlock> GOLDEN_SACRIFICIAL_BOWL = OccultismBlocks.register("golden_sacrificial_bowl", () -> new GoldenSacrificialBowlBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).sound(SoundType.STONE).strength(1.5f, 30.0f).noOcclusion()));
    public static final DeferredBlock<StorageControllerBlock> STORAGE_CONTROLLER = OccultismBlocks.register("storage_controller", () -> new StorageControllerBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).sound(SoundType.STONE).strength(5.0f, 100.0f).noOcclusion()), false, LootTableType.CUSTOM);
    public static final DeferredBlock<StorageStabilizerBlock> STORAGE_STABILIZER_TIER1 = OccultismBlocks.register("storage_stabilizer_tier1", () -> new StorageStabilizerBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).sound(SoundType.STONE).strength(1.5f, 30.0f).noOcclusion()));
    public static final DeferredBlock<StorageStabilizerBlock> STORAGE_STABILIZER_TIER2 = OccultismBlocks.register("storage_stabilizer_tier2", () -> new StorageStabilizerBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).sound(SoundType.STONE).strength(1.5f, 30.0f).noOcclusion()));
    public static final DeferredBlock<StorageStabilizerBlock> STORAGE_STABILIZER_TIER3 = OccultismBlocks.register("storage_stabilizer_tier3", () -> new StorageStabilizerBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).sound(SoundType.STONE).strength(1.5f, 30.0f).noOcclusion()));
    public static final DeferredBlock<StorageStabilizerBlock> STORAGE_STABILIZER_TIER4 = OccultismBlocks.register("storage_stabilizer_tier4", () -> new StorageStabilizerBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).sound(SoundType.STONE).strength(1.5f, 30.0f).noOcclusion()));
    public static final DeferredBlock<StableWormholeBlock> STABLE_WORMHOLE = OccultismBlocks.register("stable_wormhole", () -> new StableWormholeBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).sound(SoundType.STONE).noCollission().strength(2.0f, 2.0f).noOcclusion()), false, LootTableType.CUSTOM);
    public static final DeferredBlock<DimensionalMineshaftBlock> DIMENSIONAL_MINESHAFT = OccultismBlocks.register("dimensional_mineshaft", () -> new DimensionalMineshaftBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).strength(1.5f, 30.0f).noOcclusion()));
    public static final DeferredBlock<ReplantableCropsBlock> DATURA = OccultismBlocks.register("datura", () -> new ReplantableCropsBlock(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).sound(SoundType.CROP).noCollission().randomTicks().strength(0.0f, 0.0f), () -> (Item)OccultismItems.DATURA_SEEDS.get(), () -> (Item)OccultismItems.DATURA.get()), false, LootTableType.REPLANTABLE_CROP);
    public static final DeferredBlock<Block> SKELETON_SKULL_DUMMY = OccultismBlocks.register("skeleton_skull_dummy", () -> new Block(BlockBehaviour.Properties.of().strength(1.0f)), false);
    public static final DeferredBlock<Block> WITHER_SKELETON_SKULL_DUMMY = OccultismBlocks.register("wither_skeleton_skull_dummy", () -> new Block(BlockBehaviour.Properties.of().strength(1.0f)), false);
    public static final DeferredBlock<Block> SPIRIT_LANTERN = OccultismBlocks.register("spirit_lantern", () -> new LanternBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).requiresCorrectToolForDrops().strength(3.5f).sound(SoundType.LANTERN).lightLevel(state -> 10).noOcclusion()));
    public static final DeferredBlock<Block> SPIRIT_CAMPFIRE = OccultismBlocks.register("spirit_campfire", () -> new CampfireBlock(false, 0, BlockBehaviour.Properties.of().mapColor(MapColor.PODZOL).strength(2.0f).sound(SoundType.WOOD).lightLevel(OccultismBlocks.litBlockEmission(10)).noOcclusion()));
    public static final DeferredBlock<Block> SPIRIT_TORCH = OccultismBlocks.register("spirit_torch", () -> new SpiritTorchBlock(() -> OccultismParticles.SPIRIT_FIRE_FLAME.get(), BlockBehaviour.Properties.of().noCollission().instabreak().lightLevel(state -> 10).sound(SoundType.WOOD)), false);
    public static final DeferredBlock<Block> SPIRIT_WALL_TORCH = OccultismBlocks.register("spirit_wall_torch", () -> new SpiritWallTorchBlock(() -> OccultismParticles.SPIRIT_FIRE_FLAME.get(), BlockBehaviour.Properties.of().noCollission().instabreak().lightLevel(state -> 10).sound(SoundType.WOOD).lootFrom(SPIRIT_TORCH)), false);

    public static <I extends Block> DeferredBlock<I> register(String name, Supplier<? extends I> sup) {
        return OccultismBlocks.register(name, sup, true);
    }

    public static <I extends Block> DeferredBlock<I> register(String name, Supplier<? extends I> sup, boolean generateDefaultBlockItem) {
        return OccultismBlocks.register(name, sup, generateDefaultBlockItem, LootTableType.DROP_SELF);
    }

    public static <I extends Block> DeferredBlock<I> register(String name, Supplier<? extends I> sup, boolean generateDefaultBlockItem, LootTableType lootTableType) {
        DeferredBlock object = BLOCKS.register(name, sup);
        BLOCK_DATA_GEN_SETTINGS.put(object.getId(), new BlockDataGenSettings(generateDefaultBlockItem, lootTableType));
        if (generateDefaultBlockItem) {
            OccultismItems.ITEMS.register(name, () -> new BlockItem((Block)object.get(), new Item.Properties()));
        }
        return object;
    }

    private static ToIntFunction<BlockState> litBlockEmission(int pLightValue) {
        return p_50763_ -> (Boolean)p_50763_.getValue((Property)BlockStateProperties.LIT) != false ? pLightValue : 0;
    }

    public static enum LootTableType {
        EMPTY,
        DROP_SELF,
        REPLANTABLE_CROP,
        OTHERWORLD_BLOCK,
        CUSTOM;

    }

    public static class BlockDataGenSettings {
        public boolean generateDefaultBlockItem;
        public LootTableType lootTableType;

        public BlockDataGenSettings(boolean generateDefaultBlockItem, LootTableType lootTableType) {
            this.generateDefaultBlockItem = generateDefaultBlockItem;
            this.lootTableType = lootTableType;
        }
    }
}

