/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.network.messages;

import com.google.common.base.Preconditions;
import com.klikli_dev.occultism.api.common.blockentity.IStorageController;
import com.klikli_dev.occultism.api.common.container.IStorageControllerContainer;
import com.klikli_dev.occultism.network.IMessage;
import com.klikli_dev.occultism.network.Networking;
import com.klikli_dev.occultism.util.StorageUtil;
import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.neoforge.common.crafting.IShapedRecipe;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.PlayerMainInvWrapper;

public class MessageSetRecipeByID
implements IMessage {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"set_recipe_by_id");
    public static final CustomPacketPayload.Type<MessageSetRecipeByID> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageSetRecipeByID> STREAM_CODEC = CustomPacketPayload.codec(MessageSetRecipeByID::encode, MessageSetRecipeByID::new);
    private ResourceLocation id;

    public MessageSetRecipeByID(RegistryFriendlyByteBuf buf) {
        this.decode(buf);
    }

    public MessageSetRecipeByID(ResourceLocation id) {
        this.id = id;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (!(abstractContainerMenu instanceof IStorageControllerContainer)) {
            return;
        }
        IStorageControllerContainer container = (IStorageControllerContainer)abstractContainerMenu;
        IStorageController storageController = container.getStorageController();
        if (storageController == null) {
            return;
        }
        RecipeHolder recipe = player.level().getRecipeManager().byKey(this.id).orElse(null);
        Preconditions.checkArgument((recipe != null ? 1 : 0) != 0);
        StorageUtil.clearOpenCraftingMatrix(player, false);
        CraftingContainer craftMatrix = container.getCraftMatrix();
        NonNullList<Ingredient> ingredients = this.getIngredientsForRecipe(recipe.value());
        for (int slot = 0; slot < 9; ++slot) {
            Ingredient ingredient = (Ingredient)ingredients.get(slot);
            ItemStack extractedStack = StorageUtil.extractItem((IItemHandler)new PlayerMainInvWrapper(player.getInventory()), (Predicate<ItemStack>)ingredient, 1, true);
            if (extractedStack != null && !extractedStack.isEmpty() && craftMatrix.getItem(slot).isEmpty()) {
                StorageUtil.extractItem((IItemHandler)new PlayerMainInvWrapper(player.getInventory()), (Predicate<ItemStack>)ingredient, 1, false);
                craftMatrix.setItem(slot, extractedStack);
                continue;
            }
            extractedStack = storageController.getOneOfMostCommonItem((Predicate<ItemStack>)ingredient, false);
            if (extractedStack.isEmpty() || !craftMatrix.getItem(slot).isEmpty()) continue;
            craftMatrix.setItem(slot, extractedStack);
        }
        container.updateCraftingSlots(true);
        Networking.sendTo(player, storageController.getMessageUpdateStacks());
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buf) {
        buf.writeResourceLocation(this.id);
    }

    @Override
    public void decode(RegistryFriendlyByteBuf buf) {
        this.id = buf.readResourceLocation();
    }

    private NonNullList<Ingredient> getIngredientsForRecipe(Recipe<?> recipe) {
        NonNullList ingredients = recipe.getIngredients();
        NonNullList ingredientsMatrixGrid = NonNullList.withSize((int)9, (Object)Ingredient.EMPTY);
        Preconditions.checkArgument((ingredients.size() <= 9 ? 1 : 0) != 0);
        if (recipe instanceof IShapedRecipe) {
            IShapedRecipe shapedRecipe = (IShapedRecipe)recipe;
            int width = shapedRecipe.getWidth();
            int height = shapedRecipe.getHeight();
            Preconditions.checkArgument((width <= 3 && height <= 3 ? 1 : 0) != 0);
            for (int h = 0; h < height; ++h) {
                for (int w = 0; w < width; ++w) {
                    int source = w + h * width;
                    int target = w + h * 3;
                    Ingredient i = (Ingredient)ingredients.get(source);
                    ingredientsMatrixGrid.set(target, (Object)i);
                }
            }
        } else {
            for (int i = 0; i < ingredients.size(); ++i) {
                ingredientsMatrixGrid.set(i, (Object)((Ingredient)ingredients.get(i)));
            }
        }
        return ingredientsMatrixGrid;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

