/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.network.messages;

import com.klikli_dev.occultism.api.common.blockentity.IStorageController;
import com.klikli_dev.occultism.api.common.container.IStorageControllerContainer;
import com.klikli_dev.occultism.network.IMessage;
import com.klikli_dev.occultism.network.Networking;
import com.klikli_dev.occultism.network.messages.MessageUpdateMouseHeldItem;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class MessageInsertMouseHeldItem
implements IMessage {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"insert_mouse_held_item");
    public static final CustomPacketPayload.Type<MessageInsertMouseHeldItem> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageInsertMouseHeldItem> STREAM_CODEC = CustomPacketPayload.codec(MessageInsertMouseHeldItem::encode, MessageInsertMouseHeldItem::new);
    private int mouseButton;

    public MessageInsertMouseHeldItem(RegistryFriendlyByteBuf buf) {
        this.decode(buf);
    }

    public MessageInsertMouseHeldItem(int mouseButton) {
        this.mouseButton = mouseButton;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        if (player.containerMenu instanceof IStorageControllerContainer) {
            IStorageController storageController = ((IStorageControllerContainer)player.containerMenu).getStorageController();
            ItemStack result = ItemStack.EMPTY;
            ItemStack carriedByMouse = player.containerMenu.getCarried();
            if (this.mouseButton == 0) {
                int remainder = storageController.insertStack(carriedByMouse, false);
                if (remainder != 0) {
                    result = carriedByMouse.copyWithCount(remainder);
                }
            } else if (this.mouseButton == 1) {
                ItemStack toInsert = carriedByMouse.copy();
                toInsert.setCount(1);
                carriedByMouse.shrink(1);
                int remainder = storageController.insertStack(toInsert, false) + carriedByMouse.getCount();
                if (remainder != 0) {
                    result = carriedByMouse.copyWithCount(remainder);
                }
            }
            player.containerMenu.setCarried(result);
            Networking.sendTo(player, new MessageUpdateMouseHeldItem(result));
            Networking.sendTo(player, storageController.getMessageUpdateStacks());
            player.containerMenu.broadcastChanges();
        }
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.mouseButton);
    }

    @Override
    public void decode(RegistryFriendlyByteBuf buf) {
        this.mouseButton = buf.readInt();
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

