/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.integration.theurgy;

import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.theurgy.content.entity.FollowProjectile;
import com.klikli_dev.theurgy.util.EntityUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.ModList;

public class TheurgyIntegration {
    public static boolean isLoaded() {
        return ModList.get().isLoaded("theurgy");
    }

    public static void spawnDivinationResultParticle(BlockPos result, Level level, LivingEntity entity) {
        if (TheurgyIntegration.isLoaded()) {
            TheurgyHelper.spawnDivinationResultParticle(result, level, entity);
        } else {
            Occultism.LOGGER.warn("Attempted to spawn Theurgy Divination Result Particle without Theurgy installed");
        }
    }

    public static class TheurgyHelper {
        protected static void spawnDivinationResultParticle(BlockPos result, Level level, LivingEntity entity) {
            Vec3 to;
            float visualizationRange = 10.0f;
            Vec3 from = new Vec3(entity.getX(), entity.getEyeY() - (double)0.1f, entity.getZ());
            Vec3 resultVec = Vec3.atCenterOf((Vec3i)result);
            Vec3 dist = resultVec.subtract(from);
            Vec3 dir = dist.normalize();
            Vec3 vec3 = to = dist.length() <= 10.0 ? resultVec : from.add(dir.scale(10.0));
            if (level.isLoaded(BlockPos.containing((Position)to)) && level.isLoaded(BlockPos.containing((Position)from)) && level.isClientSide) {
                FollowProjectile aoeProjectile = new FollowProjectile(level, from, to, 255, 25, 180, 0.25f);
                EntityUtil.spawnEntityClientSide((Level)level, (Entity)aoeProjectile);
            }
        }
    }
}

