/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.integration.emi.recipes;

import com.klikli_dev.modonomicon.api.ModonomiconAPI;
import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.occultism.crafting.recipe.RitualRecipe;
import com.klikli_dev.occultism.integration.emi.OccultismEmiPlugin;
import com.klikli_dev.occultism.integration.emi.render.ItemWidget;
import com.klikli_dev.occultism.registry.OccultismBlocks;
import com.klikli_dev.occultism.registry.OccultismItems;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class RitualRecipeCategory
implements EmiRecipe {
    private final RitualRecipe recipe;
    private final ResourceLocation id;

    public RitualRecipeCategory(RecipeHolder<RitualRecipe> recipe) {
        this.recipe = (RitualRecipe)recipe.value();
        this.id = recipe.id();
    }

    public EmiRecipeCategory getCategory() {
        return OccultismEmiPlugin.RITUAL_CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        List inputs = this.recipe.getIngredients().stream().map(EmiIngredient::of).collect(Collectors.toCollection(ArrayList::new));
        inputs.add(EmiIngredient.of((Ingredient)this.recipe.getActivationItem()));
        return inputs;
    }

    public List<EmiStack> getOutputs() {
        ArrayList<EmiStack> outputs = new ArrayList<EmiStack>();
        outputs.add(EmiStack.of((ItemStack)this.recipe.getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess())));
        if (this.recipe.getEntityToSummon() != null) {
            for (SpawnEggItem egg : SpawnEggItem.eggs()) {
                if (!egg.getType(new ItemStack((ItemLike)egg)).equals(this.recipe.getEntityToSummon())) continue;
                outputs.add(EmiStack.of((ItemLike)egg));
            }
        }
        outputs.add(EmiStack.of((ItemStack)this.recipe.getRitualDummy()));
        return outputs;
    }

    public int getDisplayWidth() {
        return 134;
    }

    public int getDisplayHeight() {
        return 90;
    }

    public void addWidgets(WidgetHolder widgetHolder) {
        int sacrificialCircleRadius = 30;
        int sacricialBowlPaddingVertical = 20;
        int sacricialBowlPaddingHorizontal = 15;
        int ritualCenterX = this.getDisplayWidth() / 2 - 9 - 30;
        int ritualCenterY = this.getDisplayHeight() / 2 - 9 + 10;
        List sacrificialBowlPosition = Stream.of(new Vec3i(ritualCenterX, ritualCenterY - sacrificialCircleRadius, 0), new Vec3i(ritualCenterX + sacrificialCircleRadius, ritualCenterY, 0), new Vec3i(ritualCenterX, ritualCenterY + sacrificialCircleRadius, 0), new Vec3i(ritualCenterX - sacrificialCircleRadius, ritualCenterY, 0), new Vec3i(ritualCenterX + sacricialBowlPaddingHorizontal, ritualCenterY - sacrificialCircleRadius, 0), new Vec3i(ritualCenterX + sacrificialCircleRadius, ritualCenterY - sacricialBowlPaddingVertical, 0), new Vec3i(ritualCenterX - sacricialBowlPaddingHorizontal, ritualCenterY + sacrificialCircleRadius, 0), new Vec3i(ritualCenterX - sacrificialCircleRadius, ritualCenterY + sacricialBowlPaddingVertical, 0), new Vec3i(ritualCenterX - sacricialBowlPaddingHorizontal, ritualCenterY - sacrificialCircleRadius, 0), new Vec3i(ritualCenterX + sacrificialCircleRadius, ritualCenterY + sacricialBowlPaddingVertical, 0), new Vec3i(ritualCenterX + sacricialBowlPaddingHorizontal, ritualCenterY + sacrificialCircleRadius, 0), new Vec3i(ritualCenterX - sacrificialCircleRadius, ritualCenterY - sacricialBowlPaddingVertical, 0)).collect(Collectors.toList());
        for (int i = 0; i < this.recipe.getIngredients().size(); ++i) {
            Vec3i pos = (Vec3i)sacrificialBowlPosition.get(i);
            SlotWidget slotWidget = new SlotWidget(EmiIngredient.of((Ingredient)((Ingredient)this.recipe.getIngredients().get(i))), pos.getX(), pos.getY() - 5);
            slotWidget.drawBack(false);
            widgetHolder.add((Widget)slotWidget);
            ItemWidget bowlWidget = new ItemWidget(EmiStack.of((ItemLike)((ItemLike)OccultismBlocks.SACRIFICIAL_BOWL.get())), pos.getX(), pos.getY());
            widgetHolder.add((Widget)bowlWidget);
        }
        SlotWidget activationItemSlot = new SlotWidget(EmiIngredient.of((Ingredient)this.recipe.getActivationItem()), ritualCenterX, ritualCenterY - 5);
        activationItemSlot.drawBack(false);
        widgetHolder.add((Widget)activationItemSlot);
        ItemWidget bowlWidget = new ItemWidget(EmiStack.of((ItemLike)((ItemLike)OccultismBlocks.GOLDEN_SACRIFICIAL_BOWL.get())), ritualCenterX, ritualCenterY);
        widgetHolder.add((Widget)bowlWidget);
        widgetHolder.addTexture(EmiTexture.EMPTY_ARROW, 80, 70);
        if (this.getOutputs().get(0).getItemStack().getItem() != OccultismItems.JEI_DUMMY_NONE.get()) {
            widgetHolder.addSlot((EmiIngredient)this.getOutputs().get(0), 110, 70).recipeContext((EmiRecipe)this);
        } else {
            widgetHolder.addSlot(EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{this.recipe.getRitualDummy()})), 110, 70);
        }
        widgetHolder.addSlot(EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{this.recipe.getRitualDummy()})), 82, 53).drawBack(false);
        int infotextY = 0;
        int infoTextX = 90;
        int lineHeight = 17;
        Multiblock pentacle = ModonomiconAPI.get().getMultiblock(this.recipe.getPentacleId());
        if (pentacle != null) {
            List pentacleName = Minecraft.getInstance().font.split((FormattedText)Component.translatable((String)Util.makeDescriptionId((String)"multiblock", (ResourceLocation)pentacle.getId())), 150);
            for (FormattedCharSequence line : pentacleName) {
                widgetHolder.addText(line, this.getDisplayWidth() / 2, infotextY, -1, true).horizontalAlign(TextWidget.Alignment.CENTER);
                Objects.requireNonNull(Minecraft.getInstance().font);
                infotextY += 9;
            }
        } else {
            widgetHolder.addText((Component)Component.translatable((String)"jei.occultism.error.pentacle_not_loaded"), this.getDisplayWidth() / 2, 0, -1, true).horizontalAlign(TextWidget.Alignment.CENTER);
        }
        if (this.recipe.requiresSacrifice()) {
            ItemWidget knife = new ItemWidget(EmiStack.of((ItemLike)((ItemLike)OccultismItems.BUTCHER_KNIFE.get())), infoTextX, infotextY);
            knife.tooltip((mouseX, mouseY) -> {
                ArrayList<ClientTextTooltip> tooltip = new ArrayList<ClientTextTooltip>();
                tooltip.add(new ClientTextTooltip(Component.translatable((String)"jei.occultism.sacrifice", (Object[])new Object[]{Component.translatable((String)this.recipe.getEntityToSacrificeDisplayName())}).getVisualOrderText()));
                return tooltip;
            });
            widgetHolder.add((Widget)knife);
            infotextY += lineHeight;
        }
        if (this.recipe.requiresItemUse()) {
            int textX = Minecraft.getInstance().font.width((FormattedText)Component.translatable((String)"jei.occultism.item_to_use")) + infoTextX + 1;
            ItemWidget itemToUse = new ItemWidget(EmiStack.of((ItemStack)this.recipe.getItemToUse().getItems()[0]), infoTextX, infotextY);
            itemToUse.tooltip((mouseX, mouseY) -> {
                ArrayList<ClientTextTooltip> tooltip = new ArrayList<ClientTextTooltip>();
                tooltip.add(new ClientTextTooltip(Component.translatable((String)"emi.occultism.item_to_use", (Object[])new Object[]{Component.translatable((String)this.recipe.getItemToUse().getItems()[0].getDescriptionId())}).getVisualOrderText()));
                return tooltip;
            });
            widgetHolder.add((Widget)itemToUse);
            infotextY += lineHeight;
        }
        if (this.recipe.getEntityToSummon() != null) {
            widgetHolder.addTexture(new EmiTexture(OccultismEmiPlugin.EMI_WIDGETS, 16, 16, 16, 16), infoTextX, infotextY).tooltip((mouseX, mouseY) -> {
                ArrayList<ClientTextTooltip> tooltip = new ArrayList<ClientTextTooltip>();
                tooltip.add(new ClientTextTooltip(Component.translatable((String)"jei.occultism.summon", (Object[])new Object[]{Component.translatable((String)this.recipe.getEntityToSummon().getDescriptionId())}).getVisualOrderText()));
                if (this.recipe.getSpiritJobType() != null) {
                    tooltip.add(new ClientTextTooltip(Component.translatable((String)"jei.occultism.job", (Object[])new Object[]{Component.translatable((String)("job." + this.recipe.getSpiritJobType().toString().replace(":", ".")))}).getVisualOrderText()));
                }
                return tooltip;
            });
            infotextY += lineHeight;
        }
    }
}

