/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.handlers;

import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.registry.OccultismEffects;
import com.klikli_dev.occultism.registry.OccultismEntities;
import com.klikli_dev.occultism.util.FamiliarUtil;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.living.LivingExperienceDropEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;

@EventBusSubscriber(modid="occultism", bus=EventBusSubscriber.Bus.GAME)
public class LootEventHandler {
    @SubscribeEvent
    public static void onExpDrop(LivingExperienceDropEvent event) {
        if (event.getDroppedExperience() == 0) {
            return;
        }
        Player attackingPlayer = event.getAttackingPlayer();
        if (attackingPlayer != null) {
            MobEffectInstance greed = attackingPlayer.getEffect(OccultismEffects.DRAGON_GREED);
            if (greed == null) {
                return;
            }
            event.setDroppedExperience(event.getDroppedExperience() + greed.getAmplifier() + 1);
        }
    }

    @SubscribeEvent
    public static void giveStoneToBlacksmith(ItemEntityPickupEvent.Pre event) {
        ItemEntity entity = event.getItemEntity();
        ItemStack stack = entity.getItem();
        if (!stack.is(Tags.Items.COBBLESTONES) && !stack.is(Tags.Items.STONES)) {
            return;
        }
        Player player = event.getPlayer();
        if (!FamiliarUtil.isFamiliarEnabled((LivingEntity)player, OccultismEntities.BLACKSMITH_FAMILIAR.get()) || !FamiliarUtil.hasFamiliar((LivingEntity)player, OccultismEntities.BLACKSMITH_FAMILIAR.get())) {
            return;
        }
        if (player.getRandom().nextDouble() < (Double)Occultism.SERVER_CONFIG.spiritJobs.blacksmithFamiliarRepairChance.get() * (double)stack.getCount()) {
            LootEventHandler.repairEquipment(player);
        }
        event.setCanPickup(TriState.FALSE);
        entity.remove(Entity.RemovalReason.DISCARDED);
    }

    private static void repairEquipment(Player player) {
        for (ItemStack stack : player.getAllSlots()) {
            if (!stack.isDamaged()) continue;
            stack.setDamageValue(stack.getDamageValue() - 2);
            return;
        }
    }
}

