/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.datagen.recipe.builders;

import com.klikli_dev.occultism.crafting.recipe.MinerRecipe;
import com.klikli_dev.occultism.crafting.recipe.result.ItemRecipeResult;
import com.klikli_dev.occultism.crafting.recipe.result.RecipeResult;
import com.klikli_dev.occultism.crafting.recipe.result.TagRecipeResult;
import com.klikli_dev.occultism.crafting.recipe.result.WeightedItemRecipeResult;
import com.klikli_dev.occultism.crafting.recipe.result.WeightedRecipeResult;
import com.klikli_dev.occultism.crafting.recipe.result.WeightedTagRecipeResult;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ItemExistsCondition;
import net.neoforged.neoforge.common.conditions.NotCondition;
import net.neoforged.neoforge.common.conditions.TagEmptyCondition;
import org.jetbrains.annotations.Nullable;

public class MinerRecipeBuilder
implements RecipeBuilder {
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();
    private final Ingredient ingredient;
    @Nullable
    private String group;
    private WeightedRecipeResult result;
    private boolean allowEmpty;
    private boolean addResultItemExistsCondition;

    public MinerRecipeBuilder(Ingredient ingredient, WeightedRecipeResult result) {
        this.ingredient = ingredient;
        this.result = result;
        this.allowEmpty = false;
        this.addResultItemExistsCondition = false;
    }

    public static MinerRecipeBuilder minerRecipe(Ingredient ingredient, ItemLike output, int weight) {
        return new MinerRecipeBuilder(ingredient, WeightedItemRecipeResult.of(new ItemStack(output), weight));
    }

    public static MinerRecipeBuilder minerRecipe(ItemLike ingredient, ItemLike output, int weight) {
        return MinerRecipeBuilder.minerRecipe(Ingredient.of((ItemLike[])new ItemLike[]{ingredient}), output, weight);
    }

    public static MinerRecipeBuilder minerRecipe(TagKey<Item> ingredient, ItemLike output, int weight) {
        return MinerRecipeBuilder.minerRecipe(Ingredient.of(ingredient), output, weight);
    }

    public static MinerRecipeBuilder minerRecipe(Ingredient ingredient, TagKey<Item> output, int weight) {
        return new MinerRecipeBuilder(ingredient, WeightedTagRecipeResult.of(output, 1, weight));
    }

    public static MinerRecipeBuilder minerRecipe(TagKey<Item> ingredient, TagKey<Item> output, int weight) {
        return MinerRecipeBuilder.minerRecipe(Ingredient.of(ingredient), output, weight);
    }

    public MinerRecipeBuilder unlockedBy(String s, Criterion<?> criterionTriggerInstance) {
        this.criteria.put(s, criterionTriggerInstance);
        return this;
    }

    public RecipeBuilder group(@Nullable String s) {
        this.group = s;
        return this;
    }

    public Item getResult() {
        return null;
    }

    public MinerRecipeBuilder allowEmpty() {
        this.allowEmpty = true;
        return this;
    }

    public MinerRecipeBuilder addResultItemExistsCondition() {
        this.addResultItemExistsCondition = true;
        return this;
    }

    public void save(RecipeOutput pRecipeOutput, ResourceLocation pId) {
        this.ensureValid(pId);
        Advancement.Builder advancement$builder = pRecipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)pId)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)pId)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement$builder).addCriterion(arg_0, arg_1));
        ICondition[] conditions = this.getConditions(this.allowEmpty, this.addResultItemExistsCondition, this.ingredient, this.result);
        MinerRecipe recipe = new MinerRecipe(this.ingredient, this.result);
        pRecipeOutput.accept(pId, (Recipe)recipe, advancement$builder.build(pId.withPrefix("recipes/miner/")), conditions);
    }

    public void save(RecipeOutput p_176499_) {
        throw new IllegalStateException("Recipe must be saved with a unique ID");
    }

    public void save(RecipeOutput p_176501_, String p_176502_) {
        throw new IllegalStateException("Recipe must be saved with a unique ID");
    }

    protected ICondition[] getConditions(boolean allowEmpty, boolean addItemExistsCondition, Ingredient ingredient, RecipeResult result) {
        ICondition notCondition;
        ArrayList<ICondition> conditions = new ArrayList<ICondition>();
        if (!allowEmpty) {
            notCondition = this.getNoTagCondition(ingredient);
            if (notCondition != null) {
                conditions.add(notCondition);
            }
            if ((notCondition = this.getNoTagCondition(result)) != null) {
                conditions.add(notCondition);
            }
        }
        if (addItemExistsCondition && (notCondition = this.getItemExistsCondition(result)) != null) {
            conditions.add(notCondition);
        }
        return conditions.toArray(new ICondition[0]);
    }

    protected ICondition getNoTagCondition(Ingredient ingredient) {
        Ingredient.Value value;
        if (ingredient.getValues().length == 1 && (value = ingredient.getValues()[0]) instanceof Ingredient.TagValue) {
            Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
            return new NotCondition((ICondition)new TagEmptyCondition(tagValue.tag()));
        }
        return null;
    }

    protected ICondition getItemExistsCondition(RecipeResult ingredient) {
        if (ingredient instanceof ItemRecipeResult) {
            ItemRecipeResult itemResult = (ItemRecipeResult)ingredient;
            return new ItemExistsCondition(BuiltInRegistries.ITEM.getKey((Object)itemResult.getStack().getItem()));
        }
        if (ingredient instanceof WeightedItemRecipeResult) {
            WeightedItemRecipeResult itemResult = (WeightedItemRecipeResult)ingredient;
            return new ItemExistsCondition(BuiltInRegistries.ITEM.getKey((Object)itemResult.getStack().getItem()));
        }
        return null;
    }

    protected ICondition getNoTagCondition(RecipeResult result) {
        if (result instanceof TagRecipeResult) {
            TagRecipeResult tagResult = (TagRecipeResult)result;
            return new NotCondition((ICondition)new TagEmptyCondition(tagResult.tag()));
        }
        if (result instanceof WeightedTagRecipeResult) {
            WeightedTagRecipeResult tagResult = (WeightedTagRecipeResult)result;
            return new NotCondition((ICondition)new TagEmptyCondition(tagResult.tag()));
        }
        return null;
    }

    private void ensureValid(ResourceLocation pId) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(pId));
        }
    }
}

