/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.datagen.recipe;

import com.klikli_dev.occultism.datagen.recipe.builders.RitualRecipeBuilder;
import com.klikli_dev.occultism.registry.OccultismBlocks;
import com.klikli_dev.occultism.registry.OccultismEntities;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.klikli_dev.occultism.registry.OccultismTags;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;

public abstract class RitualRecipes
extends RecipeProvider {
    private static final ResourceLocation RITUAL_SUMMON = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"summon");
    private static final ResourceLocation RITUAL_SUMMON_JOB = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"summon_spirit_with_job");
    private static final ResourceLocation RITUAL_RESURRECT_FAMILIAR = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"resurrect_familiar");
    private static final ResourceLocation PENTACLE_SUMMON_FOLIOT = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"summon_foliot");
    private static final ResourceLocation PENTACLE_SUMMON_AFRIT = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"summon_afrit");
    private static final ResourceLocation PENTACLE_SUMMON_WILD_AFRIT = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"summon_wild_afrit");
    private static final ResourceLocation PENTACLE_SUMMON_WILD_GREATER_SPIRIT = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"summon_wild_greater_spirit");
    private static final ResourceLocation RITUAL_FAMILIAR = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"familiar");
    private static final ResourceLocation RITUAL_CRAFT_WITH_SPIRIT_NAME = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"craft_with_spirit_name");
    private static final ResourceLocation RITUAL_CRAFT = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"craft");
    private static final ResourceLocation RITUAL_CRAFT_MINER_SPIRIT = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"craft_miner_spirit");
    private static final ResourceLocation PENTACLE_POSSESS_DJINNI = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"possess_djinni");
    private static final ResourceLocation PENTACLE_POSSESS_FOLIOT = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"possess_foliot");
    private static final ResourceLocation PENTACLE_POSSESS_AFRIT = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"possess_afrit");
    private static final ResourceLocation PENTACLE_CRAFT_DJINNI = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"craft_djinni");
    private static final ResourceLocation PENTACLE_CRAFT_FOLIOT = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"craft_foliot");
    private static final ResourceLocation PENTACLE_CRAFT_AFRIT = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"craft_afrit");
    private static final ResourceLocation PENTACLE_CRAFT_MARID = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"craft_marid");

    public RitualRecipes(PackOutput p_248933_, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(p_248933_, lookupProvider);
    }

    private static ItemStack makeLoreSpawnEgg(Item item, String key) {
        ItemStack output = new ItemStack((ItemLike)item);
        output.set(DataComponents.LORE, (Object)new ItemLore(List.of(Component.translatable((String)(key + ".tooltip")))));
        output.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)key));
        return output;
    }

    private static ItemStack makeRitualDummy(ResourceLocation location) {
        return new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(location));
    }

    private static ItemStack makeJeiDummy(ResourceLocation location) {
        return new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(location));
    }

    private static ItemStack makeJeiNoneDummy() {
        return RitualRecipes.makeJeiDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"jei_dummy/none"));
    }

    public static void ritualRecipes(RecipeOutput recipeOutput) {
        RitualRecipes.craftingRituals(recipeOutput);
        RitualRecipes.familiarRituals(recipeOutput);
        RitualRecipes.possessRituals(recipeOutput);
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.SOUL_SHARD_ITEM.get()}), RitualRecipes.makeJeiNoneDummy(), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/resurrect_familiar")), 15, RITUAL_RESURRECT_FAMILIAR, PENTACLE_SUMMON_FOLIOT, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.OTHERWORLD_ESSENCE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.OTHERWORLD_ESSENCE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.OTHERWORLD_ESSENCE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.OTHERWORLD_ESSENCE.get()})).unlockedBy("has_otherworld_essence", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.OTHERWORLD_ESSENCE.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/resurrect_familiar"));
        RitualRecipes.summonRituals(recipeOutput);
    }

    private static void summonRituals(RecipeOutput recipeOutput) {
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()}), RitualRecipes.makeJeiNoneDummy(), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/summon_afrit_crusher")), 120, RITUAL_SUMMON_JOB, PENTACLE_SUMMON_AFRIT, Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND), Ingredient.of(OccultismTags.Items.IESNIUM_DUST), Ingredient.of(OccultismTags.Items.IESNIUM_DUST), Ingredient.of((TagKey)Tags.Items.GEMS_EMERALD)).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).spiritMaxAge(-1).spiritJobType(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crush_tier3")).entityToSummon((EntityType)OccultismEntities.AFRIT_TYPE.get()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_afrit_crusher"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()}), RitualRecipes.makeJeiNoneDummy(), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/summon_afrit_rain_weather")), 60, RITUAL_SUMMON_JOB, PENTACLE_SUMMON_AFRIT, Ingredient.of((TagKey)Tags.Items.SANDS), Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND), Ingredient.of((ItemLike[])new ItemLike[]{Items.CACTUS}), Ingredient.of((ItemLike[])new ItemLike[]{Items.DEAD_BUSH})).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).spiritMaxAge(120).entityToSummon((EntityType)OccultismEntities.AFRIT_TYPE.get()).spiritJobType(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"rain_weather")).entityToSacrifice(OccultismTags.Entities.COWS).entityToSacrificeDisplayName("ritual.occultism.sacrifice.cows").save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_afrit_rain_weather"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()}), RitualRecipes.makeJeiNoneDummy(), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/summon_afrit_thunder_weather")), 60, RITUAL_SUMMON_JOB, PENTACLE_SUMMON_AFRIT, Ingredient.of((TagKey)Tags.Items.BONES), Ingredient.of((TagKey)Tags.Items.GUNPOWDERS), Ingredient.of((TagKey)Tags.Items.GUNPOWDERS), Ingredient.of((ItemLike[])new ItemLike[]{Items.GHAST_TEAR})).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).spiritMaxAge(240).entityToSummon((EntityType)OccultismEntities.AFRIT_TYPE.get()).spiritJobType(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"thunder_weather")).entityToSacrifice(OccultismTags.Entities.COWS).entityToSacrificeDisplayName("ritual.occultism.sacrifice.cows").save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_afrit_thunder_weather"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.RITUAL_DUMMY_SUMMON_DEMONIC_HUSBAND.get(), "item.occultism.ritual_dummy.summon_demonic_husband"), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/summon_demonic_husband")), 60, RITUAL_SUMMON, PENTACLE_SUMMON_AFRIT, Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD), Ingredient.of((TagKey)Tags.Items.GEMS_EMERALD), Ingredient.of((TagKey)Tags.Items.GUNPOWDERS), Ingredient.of((ItemLike[])new ItemLike[]{Items.PORKCHOP}), Ingredient.of((TagKey)ItemTags.SWORDS), Ingredient.of((ItemLike[])new ItemLike[]{Items.GLASS_BOTTLE})).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).entityToSummon(OccultismEntities.DEMONIC_HUSBAND.get()).entityToSacrifice(OccultismTags.Entities.CHICKEN).entityToSacrificeDisplayName("ritual.occultism.sacrifice.chicken").save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_demonic_husband"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.RITUAL_DUMMY_SUMMON_DEMONIC_WIFE.get(), "item.occultism.ritual_dummy.summon_demonic_wife"), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/summon_demonic_wife")), 60, RITUAL_SUMMON, PENTACLE_SUMMON_AFRIT, Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD), Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND), Ingredient.of((TagKey)Tags.Items.GUNPOWDERS), Ingredient.of((ItemLike[])new ItemLike[]{Items.PORKCHOP}), Ingredient.of((TagKey)ItemTags.SWORDS), Ingredient.of((ItemLike[])new ItemLike[]{Items.GLASS_BOTTLE})).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).entityToSummon(OccultismEntities.DEMONIC_WIFE.get()).entityToSacrifice(OccultismTags.Entities.CHICKEN).entityToSacrificeDisplayName("ritual.occultism.sacrifice.chicken").save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_demonic_wife"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeJeiNoneDummy(), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/summon_djinni_clear_weather")), 60, RITUAL_SUMMON_JOB, PENTACLE_SUMMON_AFRIT, Ingredient.of((TagKey)Tags.Items.CROPS_BEETROOT), Ingredient.of((TagKey)Tags.Items.CROPS_CARROT), Ingredient.of((TagKey)Tags.Items.CROPS_POTATO), Ingredient.of((TagKey)Tags.Items.CROPS_WHEAT)).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).spiritMaxAge(60).spiritJobType(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"clear_weather")).entityToSummon(OccultismEntities.DJINNI.get()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_djinni_clear_weather"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeJeiNoneDummy(), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/summon_djinni_crusher")), 90, RITUAL_SUMMON_JOB, PENTACLE_SUMMON_AFRIT, Ingredient.of(OccultismTags.Items.IRON_DUST), Ingredient.of(OccultismTags.Items.GOLD_DUST), Ingredient.of(OccultismTags.Items.COPPER_DUST), Ingredient.of(OccultismTags.Items.SILVER_DUST)).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).spiritMaxAge(-1).spiritJobType(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crush_tier2")).entityToSummon(OccultismEntities.DJINNI.get()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_djinni_crusher"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeJeiNoneDummy(), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/summon_djinni_day_time")), 60, RITUAL_SUMMON_JOB, PENTACLE_SUMMON_AFRIT, Ingredient.of((ItemLike[])new ItemLike[]{Items.TORCH}), Ingredient.of((TagKey)ItemTags.SAPLINGS), Ingredient.of((ItemLike[])new ItemLike[]{Items.WHEAT}), Ingredient.of((TagKey)Tags.Items.DYES_YELLOW)).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).spiritMaxAge(60).spiritJobType(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"day_time")).entityToSummon(OccultismEntities.DJINNI.get()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_djinni_day_time"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeJeiNoneDummy(), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/summon_djinni_manage_machine")), 60, RITUAL_SUMMON_JOB, PENTACLE_SUMMON_AFRIT, Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_COAL), Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD), Ingredient.of((TagKey)Tags.Items.INGOTS_IRON), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.FURNACE})).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).spiritMaxAge(-1).spiritJobType(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"manage_machine")).entityToSummon(OccultismEntities.DJINNI.get()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_djinni_manage_machine"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeJeiNoneDummy(), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/summon_djinni_night_time")), 60, RITUAL_SUMMON_JOB, PENTACLE_SUMMON_AFRIT, Ingredient.of((TagKey)ItemTags.BEDS), Ingredient.of((ItemLike[])new ItemLike[]{Items.ROTTEN_FLESH}), Ingredient.of((TagKey)Tags.Items.BONES), Ingredient.of((TagKey)Tags.Items.DYES_BLACK)).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).spiritMaxAge(60).spiritJobType(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"night_time")).entityToSummon(OccultismEntities.DJINNI.get()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_djinni_night_time"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), RitualRecipes.makeJeiNoneDummy(), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/summon_foliot_cleaner")), 60, RITUAL_SUMMON_JOB, PENTACLE_SUMMON_FOLIOT, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BRUSH.get()}), Ingredient.of((TagKey)Tags.Items.CHESTS), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.DISPENSER}), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.HOPPER})).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).spiritMaxAge(-1).spiritJobType(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"cleaner")).entityToSummon(OccultismEntities.FOLIOT.get()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_foliot_cleaner"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), RitualRecipes.makeJeiNoneDummy(), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/summon_foliot_crusher")), 60, RITUAL_SUMMON_JOB, PENTACLE_SUMMON_FOLIOT, Ingredient.of((TagKey)Tags.Items.RAW_MATERIALS_IRON), Ingredient.of((TagKey)Tags.Items.RAW_MATERIALS_GOLD), Ingredient.of((TagKey)Tags.Items.RAW_MATERIALS_COPPER), Ingredient.of(OccultismTags.Items.RAW_MATERIALS_SILVER)).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).spiritMaxAge(-1).spiritJobType(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crush_tier1")).entityToSummon(OccultismEntities.FOLIOT.get()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_foliot_crusher"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), RitualRecipes.makeJeiNoneDummy(), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/summon_foliot_lumberjack")), 60, RITUAL_SUMMON_JOB, PENTACLE_SUMMON_FOLIOT, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.OTHERWORLD_SAPLING.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.OAK_SAPLING}), Ingredient.of((ItemLike[])new ItemLike[]{Items.BIRCH_SAPLING}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SPRUCE_SAPLING}), Ingredient.of((TagKey)ItemTags.AXES)).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).spiritMaxAge(-1).spiritJobType(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"lumberjack")).entityToSummon(OccultismEntities.FOLIOT.get()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_foliot_lumberjack"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), RitualRecipes.makeJeiNoneDummy(), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/summon_foliot_otherstone_trader")), 30, RITUAL_SUMMON_JOB, PENTACLE_SUMMON_FOLIOT, Ingredient.of((ItemLike[])new ItemLike[]{Blocks.STONE}), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.GRANITE}), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.DIORITE}), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.ANDESITE})).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).spiritMaxAge(3600).spiritJobType(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"trade_otherstone_t1")).entityToSummon(OccultismEntities.FOLIOT.get()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_foliot_otherstone_trader"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), RitualRecipes.makeJeiNoneDummy(), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/summon_foliot_sapling_trader")), 30, RITUAL_SUMMON_JOB, PENTACLE_SUMMON_FOLIOT, Ingredient.of((ItemLike[])new ItemLike[]{Items.OAK_SAPLING}), Ingredient.of((ItemLike[])new ItemLike[]{Items.BIRCH_SAPLING}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SPRUCE_SAPLING}), Ingredient.of((ItemLike[])new ItemLike[]{Items.JUNGLE_SAPLING})).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).spiritMaxAge(3600).spiritJobType(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"trade_otherworld_saplings_t1")).entityToSummon(OccultismEntities.FOLIOT.get()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_foliot_sapling_trader"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), RitualRecipes.makeJeiNoneDummy(), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/summon_foliot_transport_items")), 60, RITUAL_SUMMON_JOB, PENTACLE_SUMMON_FOLIOT, Ingredient.of((ItemLike[])new ItemLike[]{Items.MINECART}), Ingredient.of((TagKey)Tags.Items.CHESTS), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.DISPENSER}), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.HOPPER})).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).spiritMaxAge(-1).spiritJobType(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"transport_items")).entityToSummon(OccultismEntities.FOLIOT.get()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_foliot_transport_items"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_MARID.get()}), RitualRecipes.makeJeiNoneDummy(), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/summon_marid_crusher")), 150, RITUAL_SUMMON_JOB, PENTACLE_SUMMON_AFRIT, Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_DIAMOND), Ingredient.of((ItemLike[])new ItemLike[]{Items.GHAST_TEAR}), Ingredient.of(OccultismTags.Items.STORAGE_BLOCK_IESNIUM), Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_EMERALD)).unlockedBy("has_bound_marid", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_MARID.get()))).spiritMaxAge(-1).spiritJobType(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crush_tier4")).entityToSummon(OccultismEntities.MARID.get()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_marid_crusher"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.AFRIT_ESSENCE.get(), "item.occultism.ritual_dummy.summon_wild_afrit"), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/summon_wild_afrit")), 60, RITUAL_SUMMON, PENTACLE_SUMMON_WILD_AFRIT, Ingredient.of((TagKey)Tags.Items.NETHERRACKS), Ingredient.of((TagKey)Tags.Items.GEMS_QUARTZ), Ingredient.of((ItemLike[])new ItemLike[]{Items.FLINT_AND_STEEL}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GUNPOWDER})).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).entityToSummon(OccultismEntities.AFRIT_WILD.get()).entityToSacrificeDisplayName("ritual.occultism.sacrifice.cows").entityToSacrifice(OccultismTags.Entities.COWS).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_wild_afrit"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()}), RitualRecipes.makeLoreSpawnEgg(Items.WITHER_SKELETON_SKULL, "item.occultism.ritual_dummy.summon_wild_hunt"), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/summon_wild_hunt")), 30, RITUAL_SUMMON, PENTACLE_SUMMON_WILD_GREATER_SPIRIT, Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_COPPER), Ingredient.of(OccultismTags.Items.STORAGE_BLOCK_SILVER), Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_GOLD), Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND), Ingredient.of((TagKey)Tags.Items.NETHERRACKS), Ingredient.of((ItemLike[])new ItemLike[]{Items.SOUL_SAND})).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).entityToSummon(OccultismEntities.WILD_HUNT_WITHER_SKELETON.get()).entityToSacrificeDisplayName("ritual.occultism.sacrifice.humans").entityToSacrifice(OccultismTags.Entities.HUMANS).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_wild_hunt"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_OTHERWORLD_BIRD.get(), "item.occultism.ritual_dummy.summon_wild_otherworld_bird"), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/summon_wild_otherworld_bird")), 30, RITUAL_SUMMON, PENTACLE_POSSESS_DJINNI, Ingredient.of((TagKey)Tags.Items.FEATHERS), Ingredient.of((TagKey)Tags.Items.FEATHERS), Ingredient.of((ItemLike[])new ItemLike[]{Items.COBWEB}), Ingredient.of((TagKey)ItemTags.LEAVES), Ingredient.of((ItemLike[])new ItemLike[]{Items.EGG})).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).entityToSummon(OccultismEntities.OTHERWORLD_BIRD.get()).entityToSacrificeDisplayName("ritual.occultism.sacrifice.parrots").entityToSacrifice(OccultismTags.Entities.PARROTS).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_wild_otherworld_bird"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), RitualRecipes.makeLoreSpawnEgg(Items.PARROT_SPAWN_EGG, "item.occultism.ritual_dummy.summon_wild_parrot"), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/summon_wild_parrot")), 30, RITUAL_SUMMON, PENTACLE_SUMMON_FOLIOT, Ingredient.of((TagKey)Tags.Items.FEATHERS), Ingredient.of((TagKey)Tags.Items.DYES_GREEN), Ingredient.of((TagKey)Tags.Items.DYES_YELLOW), Ingredient.of((TagKey)Tags.Items.DYES_RED), Ingredient.of((TagKey)Tags.Items.DYES_BLUE), Ingredient.of((ItemLike[])new ItemLike[]{Items.EGG})).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).entityToSummon(EntityType.PARROT).entityToSacrificeDisplayName("ritual.occultism.sacrifice.chicken").entityToSacrifice(OccultismTags.Entities.CHICKEN).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_wild_parrot"));
    }

    private static void possessRituals(RecipeOutput recipeOutput) {
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()}), RitualRecipes.makeLoreSpawnEgg(Items.HEART_OF_THE_SEA, "item.occultism.ritual_dummy.possess_elder_guardian"), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/possess_elder_guardian")), 90, RITUAL_SUMMON, PENTACLE_POSSESS_AFRIT, Ingredient.of((ItemLike[])new ItemLike[]{Items.OXIDIZED_COPPER}), Ingredient.of((ItemLike[])new ItemLike[]{Items.PRISMARINE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.PRISMARINE_BRICKS}), Ingredient.of((ItemLike[])new ItemLike[]{Items.DARK_PRISMARINE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.WET_SPONGE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SEA_LANTERN}), Ingredient.of((ItemLike[])new ItemLike[]{Items.WATER_BUCKET}), Ingredient.of((ItemLike[])new ItemLike[]{Items.WATER_BUCKET}), Ingredient.of((ItemLike[])new ItemLike[]{Items.WATER_BUCKET}), Ingredient.of((TagKey)Tags.Items.GEMS_EMERALD)).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).entityToSummon((EntityType)OccultismEntities.POSSESSED_ELDER_GUARDIAN_TYPE.get()).entityToSacrificeDisplayName("ritual.occultism.sacrifice.elder_guardian").entityToSacrifice(OccultismTags.Entities.FISH).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/possess_elder_guardian"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI}), RitualRecipes.makeLoreSpawnEgg(Items.ENDER_PEARL, "item.occultism.ritual_dummy.possess_enderman"), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/possess_enderman")), 60, RITUAL_SUMMON, PENTACLE_POSSESS_DJINNI, Ingredient.of((TagKey)Tags.Items.BONES), Ingredient.of((TagKey)Tags.Items.STRINGS), Ingredient.of((TagKey)Tags.Items.END_STONES), Ingredient.of((ItemLike[])new ItemLike[]{Items.ROTTEN_FLESH})).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).entityToSummon((EntityType)OccultismEntities.POSSESSED_ENDERMAN_TYPE.get()).entityToSacrificeDisplayName("ritual.occultism.sacrifice.pigs").entityToSacrifice(OccultismTags.Entities.PIGS).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/possess_enderman"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), RitualRecipes.makeLoreSpawnEgg(Items.END_STONE, "item.occultism.ritual_dummy.possess_endermite"), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/possess_endermite")), 30, RITUAL_SUMMON, PENTACLE_POSSESS_FOLIOT, Ingredient.of((TagKey)ItemTags.DIRT), Ingredient.of((TagKey)Tags.Items.STONES), Ingredient.of((TagKey)ItemTags.DIRT), Ingredient.of((TagKey)Tags.Items.STONES)).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).entityToSummon((EntityType)OccultismEntities.POSSESSED_ENDERMITE_TYPE.get()).itemToUse(Ingredient.of((ItemLike[])new ItemLike[]{Items.EGG})).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/possess_endermite"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeLoreSpawnEgg(Items.GHAST_TEAR, "item.occultism.ritual_dummy.possess_ghast"), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/possess_ghast")), 60, RITUAL_SUMMON, PENTACLE_POSSESS_DJINNI, Ingredient.of((TagKey)Tags.Items.NETHERRACKS), Ingredient.of((TagKey)Tags.Items.NETHERRACKS), Ingredient.of((TagKey)Tags.Items.NETHERRACKS), Ingredient.of(OccultismTags.Items.MAGMA), Ingredient.of(OccultismTags.Items.MAGMA), Ingredient.of(OccultismTags.Items.MAGMA), Ingredient.of((ItemLike[])new ItemLike[]{Items.LAVA_BUCKET}), Ingredient.of((ItemLike[])new ItemLike[]{Items.LAVA_BUCKET}), Ingredient.of((ItemLike[])new ItemLike[]{Items.LAVA_BUCKET}), Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND)).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).entityToSummon((EntityType)OccultismEntities.POSSESSED_GHAST_TYPE.get()).entityToSacrificeDisplayName("ritual.occultism.sacrifice.cows").entityToSacrifice(OccultismTags.Entities.COWS).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/possess_ghast"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()}), RitualRecipes.makeLoreSpawnEgg(Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE, "item.occultism.ritual_dummy.possess_hoglin"), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/possess_hoglin")), 60, RITUAL_SUMMON, PENTACLE_POSSESS_AFRIT, Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_SCRAP}), Ingredient.of((TagKey)Tags.Items.LEATHERS), Ingredient.of((TagKey)Tags.Items.NETHERRACKS), Ingredient.of((TagKey)Tags.Items.NETHERRACKS), Ingredient.of((ItemLike[])new ItemLike[]{Items.PORKCHOP}), Ingredient.of((ItemLike[])new ItemLike[]{Items.PORKCHOP}), Ingredient.of((ItemLike[])new ItemLike[]{Items.PORKCHOP}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismBlocks.SPIRIT_ATTUNED_CRYSTAL})).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).entityToSummon((EntityType)OccultismEntities.POSSESSED_HOGLIN_TYPE.get()).entityToSacrificeDisplayName("ritual.occultism.sacrifice.pigs").entityToSacrifice(OccultismTags.Entities.PIGS).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/possess_hoglin"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), RitualRecipes.makeLoreSpawnEgg(Items.PHANTOM_MEMBRANE, "item.occultism.ritual_dummy.possess_phantom"), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/possess_phantom")), 30, RITUAL_SUMMON, PENTACLE_POSSESS_FOLIOT, Ingredient.of((TagKey)Tags.Items.LEATHERS), Ingredient.of((TagKey)Tags.Items.FEATHERS), Ingredient.of((TagKey)Tags.Items.LEATHERS), Ingredient.of((TagKey)Tags.Items.FEATHERS)).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).entityToSummon((EntityType)OccultismEntities.POSSESSED_PHANTOM_TYPE.get()).entityToSacrificeDisplayName("ritual.occultism.sacrifice.flying_passive").entityToSacrifice(OccultismTags.Entities.FLYING_PASSIVE).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/possess_phantom"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()}), RitualRecipes.makeLoreSpawnEgg(Items.SHULKER_SHELL, "item.occultism.ritual_dummy.possess_shulker"), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/possess_shulker")), 60, RITUAL_SUMMON, PENTACLE_POSSESS_AFRIT, Ingredient.of((ItemLike[])new ItemLike[]{Items.DRAGON_BREATH}), Ingredient.of((TagKey)Tags.Items.OBSIDIANS), Ingredient.of((TagKey)Tags.Items.END_STONES), Ingredient.of((ItemLike[])new ItemLike[]{Items.PURPLE_GLAZED_TERRACOTTA})).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).entityToSummon((EntityType)OccultismEntities.POSSESSED_SHULKER_TYPE.get()).entityToSacrificeDisplayName("ritual.occultism.sacrifice.cubemob").entityToSacrifice(OccultismTags.Entities.CUBEMOB).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/possess_shulker"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), RitualRecipes.makeLoreSpawnEgg(Items.SKELETON_SKULL, "item.occultism.ritual_dummy.possess_skeleton"), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/possess_skeleton")), 30, RITUAL_SUMMON, PENTACLE_POSSESS_FOLIOT, Ingredient.of((TagKey)Tags.Items.BONES), Ingredient.of((TagKey)Tags.Items.BONES), Ingredient.of((TagKey)Tags.Items.BONES), Ingredient.of((TagKey)Tags.Items.BONES)).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).entityToSummon((EntityType)OccultismEntities.POSSESSED_SKELETON_TYPE.get()).entityToSacrificeDisplayName("ritual.occultism.sacrifice.chicken").entityToSacrifice(OccultismTags.Entities.CHICKEN).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/possess_skeleton"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeLoreSpawnEgg(Items.ECHO_SHARD, "item.occultism.ritual_dummy.possess_warden"), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/possess_warden")), 60, RITUAL_SUMMON, PENTACLE_POSSESS_DJINNI, Ingredient.of((ItemLike[])new ItemLike[]{Items.SCULK_SHRIEKER}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SCULK_SENSOR}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SCULK}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SCULK}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SCULK_SHRIEKER}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SCULK_SENSOR}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SCULK}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SCULK}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SCULK_SHRIEKER}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SCULK_SENSOR}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SCULK}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SCULK})).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).entityToSacrificeDisplayName("ritual.occultism.sacrifice.axolotls").entityToSacrifice(OccultismTags.Entities.AXOLOTL).entityToSummon((EntityType)OccultismEntities.POSSESSED_WARDEN_TYPE.get()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/possess_warden"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeLoreSpawnEgg(Items.CHORUS_FRUIT, "item.occultism.ritual_dummy.possess_weak_shulker"), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/possess_weak_shulker")), 60, RITUAL_SUMMON, PENTACLE_POSSESS_DJINNI, Ingredient.of((TagKey)Tags.Items.ENDER_PEARLS), Ingredient.of((ItemLike[])new ItemLike[]{Items.PURPLE_CONCRETE}), Ingredient.of((TagKey)Tags.Items.END_STONES), Ingredient.of((ItemLike[])new ItemLike[]{Items.MAGENTA_CONCRETE})).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).entityToSacrifice(OccultismTags.Entities.CUBEMOB).entityToSacrificeDisplayName("ritual.occultism.sacrifice.cubemob").entityToSummon((EntityType)OccultismEntities.POSSESSED_WEAK_SHULKER_TYPE.get()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/possess_weak_shulker"));
    }

    private static void familiarRituals(RecipeOutput recipeOutput) {
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_BAT_FAMILIAR.get(), "item.occultism.ritual_dummy.familiar_bat"), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/familiar_bat")), 60, RITUAL_FAMILIAR, PENTACLE_POSSESS_DJINNI, Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLDEN_CARROT}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SPIDER_EYE}), Ingredient.of((TagKey)Tags.Items.DUSTS_GLOWSTONE), Ingredient.of((ItemLike[])new ItemLike[]{Items.LAVA_BUCKET}), Ingredient.of((ItemLike[])new ItemLike[]{Items.TORCH})).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).entityToSummon((EntityType)OccultismEntities.BAT_FAMILIAR_TYPE.get()).entityToSacrifice(OccultismTags.Entities.BATS).entityToSacrificeDisplayName("ritual.occultism.sacrifice.bats").save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/familiar_bat"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_BEAVER_FAMILIAR.get(), "item.occultism.ritual_dummy.familiar_beaver"), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/familiar_beaver")), 30, RITUAL_FAMILIAR, PENTACLE_POSSESS_FOLIOT, Ingredient.of((TagKey)ItemTags.LOGS), Ingredient.of((TagKey)ItemTags.LOGS), Ingredient.of((TagKey)ItemTags.LOGS), Ingredient.of((TagKey)ItemTags.LOGS)).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).entityToSummon((EntityType)OccultismEntities.BEAVER_FAMILIAR_TYPE.get()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/familiar_beaver"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_BEHOLDER_FAMILIAR.get(), "item.occultism.ritual_dummy.familiar_beholder"), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/familiar_beholder")), 30, RITUAL_FAMILIAR, PENTACLE_POSSESS_DJINNI, Ingredient.of((ItemLike[])new ItemLike[]{Items.SPIDER_EYE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SPIDER_EYE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SPIDER_EYE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SPIDER_EYE}), Ingredient.of((TagKey)Tags.Items.DUSTS_GLOWSTONE), Ingredient.of((TagKey)Tags.Items.DUSTS_GLOWSTONE), Ingredient.of((TagKey)Tags.Items.DUSTS_GLOWSTONE), Ingredient.of((TagKey)Tags.Items.DUSTS_GLOWSTONE)).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).entityToSummon((EntityType)OccultismEntities.BEHOLDER_FAMILIAR_TYPE.get()).entityToSacrifice(OccultismTags.Entities.SPIDERS).entityToSacrificeDisplayName("ritual.occultism.sacrifice.spiders").save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/familiar_beholder"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_BLACKSMITH_FAMILIAR.get(), "item.occultism.ritual_dummy.familiar_blacksmith"), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/familiar_blacksmith")), 30, RITUAL_FAMILIAR, PENTACLE_POSSESS_FOLIOT, Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_SHOVEL}), Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_PICKAXE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_AXE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.ANVIL}), Ingredient.of((TagKey)Tags.Items.STONES), Ingredient.of((TagKey)Tags.Items.STONES), Ingredient.of((TagKey)Tags.Items.STONES), Ingredient.of((TagKey)Tags.Items.STONES)).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).entityToSummon((EntityType)OccultismEntities.BLACKSMITH_FAMILIAR_TYPE.get()).entityToSacrifice(OccultismTags.Entities.ZOMBIES).entityToSacrificeDisplayName("ritual.occultism.sacrifice.zombies").save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/familiar_blacksmith"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_CTHULHU_FAMILIAR.get(), "item.occultism.ritual_dummy.familiar_cthulhu"), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/familiar_cthulhu")), 60, RITUAL_FAMILIAR, PENTACLE_POSSESS_DJINNI, Ingredient.of((TagKey)ItemTags.FISHES), Ingredient.of((TagKey)ItemTags.FISHES), Ingredient.of((TagKey)ItemTags.FISHES), Ingredient.of((TagKey)ItemTags.FISHES), Ingredient.of((TagKey)ItemTags.FISHES), Ingredient.of((TagKey)ItemTags.FISHES), Ingredient.of((TagKey)ItemTags.FISHES), Ingredient.of((TagKey)ItemTags.FISHES)).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).entityToSacrifice(OccultismTags.Entities.SQUID).entityToSacrificeDisplayName("ritual.occultism.sacrifice.squid").entityToSummon((EntityType)OccultismEntities.CTHULHU_FAMILIAR_TYPE.get()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/familiar_cthulhu"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_CHIMERA_FAMILIAR.get(), "item.occultism.ritual_dummy.familiar_chimera"), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/familiar_chimera")), 60, RITUAL_FAMILIAR, PENTACLE_POSSESS_DJINNI, Ingredient.of((TagKey)Tags.Items.LEATHERS), Ingredient.of((TagKey)Tags.Items.STRINGS), Ingredient.of((TagKey)Tags.Items.FEATHERS), Ingredient.of((TagKey)ItemTags.WOOL), Ingredient.of((TagKey)Tags.Items.BONES), Ingredient.of((ItemLike[])new ItemLike[]{Items.MUTTON}), Ingredient.of((ItemLike[])new ItemLike[]{Items.PORKCHOP}), Ingredient.of((ItemLike[])new ItemLike[]{Items.BEEF}), Ingredient.of((ItemLike[])new ItemLike[]{Items.CHICKEN})).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).entityToSummon((EntityType)OccultismEntities.CHIMERA_FAMILIAR_TYPE.get()).entityToSacrifice(OccultismTags.Entities.SHEEP).entityToSacrificeDisplayName("ritual.occultism.sacrifice.sheep").save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/familiar_chimera"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_DEER_FAMILIAR.get(), "item.occultism.ritual_dummy.familiar_deer"), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/familiar_deer")), 15, RITUAL_FAMILIAR, PENTACLE_POSSESS_FOLIOT, Ingredient.of((TagKey)Tags.Items.RODS_WOODEN), Ingredient.of((TagKey)Tags.Items.RODS_WOODEN), Ingredient.of((TagKey)Tags.Items.RODS_WOODEN), Ingredient.of((TagKey)Tags.Items.RODS_WOODEN), Ingredient.of((TagKey)Tags.Items.STRINGS), Ingredient.of((TagKey)Tags.Items.STRINGS)).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).entityToSummon((EntityType)OccultismEntities.DEER_FAMILIAR_TYPE.get()).entityToSacrifice(OccultismTags.Entities.COWS).entityToSacrificeDisplayName("ritual.occultism.sacrifice.cows").save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/familiar_deer"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_DEVIL_FAMILIAR.get(), "item.occultism.ritual_dummy.familiar_devil"), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/familiar_devil")), 60, RITUAL_FAMILIAR, PENTACLE_POSSESS_DJINNI, Ingredient.of((ItemLike[])new ItemLike[]{Items.LAVA_BUCKET}), Ingredient.of((ItemLike[])new ItemLike[]{Items.LAVA_BUCKET}), Ingredient.of((ItemLike[])new ItemLike[]{Items.LAVA_BUCKET}), Ingredient.of((ItemLike[])new ItemLike[]{Items.LAVA_BUCKET}), Ingredient.of((TagKey)Tags.Items.BONES), Ingredient.of((TagKey)Tags.Items.BONES), Ingredient.of((TagKey)Tags.Items.BONES), Ingredient.of((TagKey)Tags.Items.BONES)).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).entityToSummon((EntityType)OccultismEntities.DEVIL_FAMILIAR_TYPE.get()).entityToSacrifice(OccultismTags.Entities.HORSES).entityToSacrificeDisplayName("ritual.occultism.sacrifice.horses").save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/familiar_devil"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_DRAGON_FAMILIAR.get(), "item.occultism.ritual_dummy.familiar_dragon"), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/familiar_dragon")), 60, RITUAL_FAMILIAR, PENTACLE_POSSESS_DJINNI, Ingredient.of((ItemLike[])new ItemLike[]{Items.LAVA_BUCKET}), Ingredient.of((ItemLike[])new ItemLike[]{Items.FLINT_AND_STEEL}), Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_COAL), Ingredient.of((ItemLike[])new ItemLike[]{Items.QUARTZ_BLOCK}), Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_GOLD), Ingredient.of((TagKey)Tags.Items.GUNPOWDERS), Ingredient.of((ItemLike[])new ItemLike[]{Items.OBSIDIAN}), Ingredient.of((ItemLike[])new ItemLike[]{Items.OBSIDIAN})).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).entityToSummon((EntityType)OccultismEntities.DRAGON_FAMILIAR_TYPE.get()).entityToSacrifice(OccultismTags.Entities.HORSES).entityToSacrificeDisplayName("ritual.occultism.sacrifice.horses").save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/familiar_dragon"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_FAIRY_FAMILIAR.get(), "item.occultism.ritual_dummy.familiar_fairy"), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/familiar_fairy")), 30, RITUAL_FAMILIAR, PENTACLE_POSSESS_DJINNI, Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLDEN_APPLE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLDEN_APPLE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GHAST_TEAR}), Ingredient.of((TagKey)Tags.Items.GUNPOWDERS), Ingredient.of((TagKey)Tags.Items.GUNPOWDERS), Ingredient.of((TagKey)Tags.Items.GUNPOWDERS), Ingredient.of((ItemLike[])new ItemLike[]{Items.DRAGON_BREATH})).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).entityToSummon((EntityType)OccultismEntities.FAIRY_FAMILIAR_TYPE.get()).entityToSacrifice(OccultismTags.Entities.HORSES).entityToSacrificeDisplayName("ritual.occultism.sacrifice.horses").save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/familiar_fairy"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_GREEDY_FAMILIAR.get(), "item.occultism.ritual_dummy.familiar_greedy"), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/familiar_greedy")), 30, RITUAL_FAMILIAR, PENTACLE_POSSESS_FOLIOT, Ingredient.of((TagKey)Tags.Items.CHESTS), Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_IRON), Ingredient.of((ItemLike[])new ItemLike[]{Items.DISPENSER}), Ingredient.of((ItemLike[])new ItemLike[]{Items.HOPPER})).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).entityToSummon((EntityType)OccultismEntities.GREEDY_FAMILIAR_TYPE.get()).entityToSacrifice(OccultismTags.Entities.ZOMBIES).entityToSacrificeDisplayName("ritual.occultism.sacrifice.zombies").save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/familiar_greedy"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_GUARDIAN_FAMILIAR.get(), "item.occultism.ritual_dummy.familiar_guardian"), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/familiar_guardian")), 60, RITUAL_FAMILIAR, PENTACLE_POSSESS_AFRIT, Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND), Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND), Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND), Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND), Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLDEN_APPLE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLDEN_APPLE})).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).entityToSummon((EntityType)OccultismEntities.GUARDIAN_FAMILIAR_TYPE.get()).entityToSacrifice(OccultismTags.Entities.HUMANS).entityToSacrificeDisplayName("ritual.occultism.sacrifice.humans").save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/familiar_guardian"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_HEADLESS_FAMILIAR.get(), "item.occultism.ritual_dummy.familiar_headless"), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/familiar_headless")), 60, RITUAL_FAMILIAR, PENTACLE_POSSESS_DJINNI, Ingredient.of((TagKey)Tags.Items.CROPS_WHEAT), Ingredient.of((TagKey)Tags.Items.CROPS_WHEAT), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.HAY_BLOCK}), Ingredient.of((TagKey)Tags.Items.RODS_WOODEN), Ingredient.of((TagKey)Tags.Items.RODS_WOODEN), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.CARVED_PUMPKIN})).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).entityToSummon((EntityType)OccultismEntities.HEADLESS_FAMILIAR_TYPE.get()).entityToSacrifice(OccultismTags.Entities.SNOW_GOLEM).entityToSacrificeDisplayName("ritual.occultism.sacrifice.snow_golem").save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/familiar_headless"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_MUMMY_FAMILIAR.get(), "item.occultism.ritual_dummy.familiar_mummy"), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/familiar_mummy")), 30, RITUAL_FAMILIAR, PENTACLE_POSSESS_DJINNI, Ingredient.of((TagKey)Tags.Items.SLIMEBALLS), Ingredient.of((TagKey)Tags.Items.SLIMEBALLS), Ingredient.of((ItemLike[])new ItemLike[]{Items.PAPER}), Ingredient.of((ItemLike[])new ItemLike[]{Items.PAPER}), Ingredient.of((TagKey)ItemTags.WOOL), Ingredient.of((TagKey)ItemTags.WOOL), Ingredient.of((TagKey)ItemTags.WOOL), Ingredient.of((TagKey)ItemTags.WOOL)).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).entityToSummon((EntityType)OccultismEntities.MUMMY_FAMILIAR_TYPE.get()).entityToSacrifice(OccultismTags.Entities.LLAMAS).entityToSacrificeDisplayName("ritual.occultism.sacrifice.llamas").save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/familiar_mummy"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_OTHERWORLD_BIRD.get(), "item.occultism.ritual_dummy.familiar_otherworld_bird"), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/familiar_otherworld_bird")), 30, RITUAL_FAMILIAR, PENTACLE_POSSESS_DJINNI, Ingredient.of((TagKey)Tags.Items.FEATHERS), Ingredient.of((TagKey)Tags.Items.FEATHERS), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.COBWEB}), Ingredient.of((TagKey)ItemTags.LEAVES), Ingredient.of((TagKey)Tags.Items.STRINGS)).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).entityToSummon((EntityType)OccultismEntities.OTHERWORLD_BIRD_TYPE.get()).entityToSacrifice(OccultismTags.Entities.PARROTS).entityToSacrificeDisplayName("ritual.occultism.sacrifice.parrots").save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/familiar_otherworld_bird"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_PARROT_FAMILIAR.get(), "item.occultism.ritual_dummy.familiar_parrot"), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/familiar_parrot")), 30, RITUAL_FAMILIAR, PENTACLE_POSSESS_FOLIOT, Ingredient.of((TagKey)Tags.Items.FEATHERS), Ingredient.of((TagKey)Tags.Items.DYES_GREEN), Ingredient.of((TagKey)Tags.Items.DYES_YELLOW), Ingredient.of((TagKey)Tags.Items.DYES_RED), Ingredient.of((TagKey)Tags.Items.DYES_BLUE), Ingredient.of((TagKey)Tags.Items.STRINGS)).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).entityToSummon(EntityType.PARROT).entityToSacrifice(OccultismTags.Entities.CHICKEN).entityToSacrificeDisplayName("ritual.occultism.sacrifice.chicken").save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/familiar_parrot"));
    }

    private static void craftingRituals(RecipeOutput recipeOutput) {
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), new ItemStack((ItemLike)OccultismItems.DIMENSIONAL_MATRIX.get()), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/craft_dimensional_matrix")), 240, RITUAL_CRAFT_WITH_SPIRIT_NAME, PENTACLE_CRAFT_DJINNI, Ingredient.of((ItemLike[])new ItemLike[]{Items.QUARTZ_BLOCK}), Ingredient.of((ItemLike[])new ItemLike[]{Items.QUARTZ_BLOCK}), Ingredient.of((ItemLike[])new ItemLike[]{Items.QUARTZ_BLOCK}), Ingredient.of((TagKey)Tags.Items.ENDER_PEARLS)).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_dimensional_matrix"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), new ItemStack((ItemLike)OccultismBlocks.DIMENSIONAL_MINESHAFT.get()), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/craft_dimensional_mineshaft")), 240, RITUAL_CRAFT, PENTACLE_CRAFT_DJINNI, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.OTHERSTONE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.OTHERSTONE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.OTHERSTONE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.OTHERSTONE.get()}), Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD), Ingredient.of(OccultismTags.Items.STORAGE_BLOCK_IESNIUM), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.SPIRIT_ATTUNED_CRYSTAL.get()})).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_dimensional_mineshaft"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), new ItemStack((ItemLike)OccultismItems.FAMILIAR_RING.get()), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/craft_familiar_ring")), 90, RITUAL_CRAFT, PENTACLE_CRAFT_DJINNI, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.SOUL_GEM_ITEM.get()}), Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD), Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD), Ingredient.of(OccultismTags.Items.SILVER_INGOT), Ingredient.of(OccultismTags.Items.SILVER_INGOT)).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_familiar_ring"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), new ItemStack((ItemLike)OccultismItems.INFUSED_LENSES.get()), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/craft_infused_lenses")), 60, RITUAL_CRAFT, PENTACLE_CRAFT_FOLIOT, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.LENSES.get()}), Ingredient.of(OccultismTags.Items.SILVER_INGOT), Ingredient.of(OccultismTags.Items.SILVER_INGOT), Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD)).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_infused_lenses"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), new ItemStack((ItemLike)OccultismItems.INFUSED_PICKAXE.get()), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/craft_dimensional_matrix")), 60, RITUAL_CRAFT_WITH_SPIRIT_NAME, PENTACLE_CRAFT_DJINNI, Ingredient.of((TagKey)Tags.Items.RODS_WOODEN), Ingredient.of((TagKey)Tags.Items.RODS_WOODEN), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.SPIRIT_ATTUNED_PICKAXE_HEAD.get()}), Ingredient.of(OccultismTags.Items.SILVER_INGOT), Ingredient.of(OccultismTags.Items.SILVER_INGOT)).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_infused_pickaxe"));
        RitualRecipes.minerRecipes(recipeOutput);
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), new ItemStack((ItemLike)OccultismItems.SATCHEL.get()), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/craft_satchel")), 240, RITUAL_CRAFT_WITH_SPIRIT_NAME, PENTACLE_CRAFT_FOLIOT, Ingredient.of((TagKey)Tags.Items.CHESTS_WOODEN), Ingredient.of((TagKey)Tags.Items.LEATHERS), Ingredient.of((TagKey)Tags.Items.LEATHERS), Ingredient.of((TagKey)Tags.Items.STRINGS), Ingredient.of(OccultismTags.Items.SILVER_INGOT)).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_satchel"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), new ItemStack((ItemLike)OccultismItems.SOUL_GEM_ITEM.get()), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/craft_soul_gem")), 60, RITUAL_CRAFT, PENTACLE_CRAFT_DJINNI, Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND), Ingredient.of((TagKey)Tags.Items.INGOTS_COPPER), Ingredient.of(OccultismTags.Items.SILVER_INGOT), Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.SOUL_SAND}), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.SOUL_SAND}), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.SOUL_SAND}), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.SOUL_SAND})).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_soul_gem"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), new ItemStack((ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER1.get()), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/craft_stabilizer_tier1")), 120, RITUAL_CRAFT, PENTACLE_CRAFT_FOLIOT, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.OTHERSTONE_PEDESTAL.get()}), Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_COPPER), Ingredient.of(OccultismTags.Items.BLAZE_DUST), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.SPIRIT_ATTUNED_GEM.get()})).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_stabilizer_tier1"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), new ItemStack((ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER2.get()), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/craft_stabilizer_tier2")), 240, RITUAL_CRAFT, PENTACLE_CRAFT_DJINNI, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER1.get()}), Ingredient.of(OccultismTags.Items.STORAGE_BLOCK_SILVER), Ingredient.of((ItemLike[])new ItemLike[]{Items.GHAST_TEAR}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.SPIRIT_ATTUNED_GEM.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.SPIRIT_ATTUNED_GEM.get()})).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_stabilizer_tier2"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()}), new ItemStack((ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER3.get()), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/craft_stabilizer_tier3")), 240, RITUAL_CRAFT, PENTACLE_CRAFT_AFRIT, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER2.get()}), Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_GOLD), Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHER_STAR}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.SPIRIT_ATTUNED_CRYSTAL.get()})).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_stabilizer_tier3"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_MARID.get()}), new ItemStack((ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER4.get()), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/craft_stabilizer_tier4")), 240, RITUAL_CRAFT, PENTACLE_CRAFT_MARID, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER3.get()}), Ingredient.of(OccultismTags.Items.STORAGE_BLOCK_IESNIUM), Ingredient.of((ItemLike[])new ItemLike[]{Items.DRAGON_HEAD}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.SPIRIT_ATTUNED_CRYSTAL.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.SPIRIT_ATTUNED_CRYSTAL.get()})).unlockedBy("has_bound_marid", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_MARID.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_stabilizer_tier4"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), new ItemStack((ItemLike)OccultismBlocks.STABLE_WORMHOLE.get()), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/craft_stable_wormhole")), 120, RITUAL_CRAFT, PENTACLE_CRAFT_FOLIOT, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.WORMHOLE_FRAME.get()}), Ingredient.of((TagKey)Tags.Items.ENDER_PEARLS), Ingredient.of((TagKey)Tags.Items.GEMS_QUARTZ), Ingredient.of((TagKey)Tags.Items.GEMS_QUARTZ)).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_stable_wormhole"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), new ItemStack((ItemLike)OccultismBlocks.STORAGE_CONTROLLER_BASE.get()), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/craft_storage_controller_base")), 60, RITUAL_CRAFT, PENTACLE_CRAFT_FOLIOT, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.OTHERSTONE_PEDESTAL.get()}), Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD), Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD), Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD)).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_storage_controller_base"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), new ItemStack((ItemLike)OccultismItems.STORAGE_REMOTE.get()), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/craft_storage_remote")), 120, RITUAL_CRAFT, PENTACLE_CRAFT_DJINNI, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.STORAGE_REMOTE_INERT.get()}), Ingredient.of((TagKey)Tags.Items.ENDER_PEARLS), Ingredient.of((TagKey)Tags.Items.ENDER_PEARLS), Ingredient.of((TagKey)Tags.Items.GEMS_QUARTZ)).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_storage_remote"));
    }

    private static void minerRecipes(RecipeOutput recipeOutput) {
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()}), new ItemStack((ItemLike)OccultismItems.MINER_AFRIT_DEEPS.get()), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/craft_miner_afrit_deeps")), 120, RITUAL_CRAFT_MINER_SPIRIT, PENTACLE_CRAFT_AFRIT, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.MINER_DJINNI_ORES.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.IESNIUM_PICKAXE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.SPIRIT_ATTUNED_CRYSTAL.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.AFRIT_ESSENCE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.ECHO_SHARD}), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.CRYING_OBSIDIAN})).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_miner_afrit_deeps"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), new ItemStack((ItemLike)OccultismItems.MINER_DJINNI_ORES.get()), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/craft_miner_djinni_ores")), 60, RITUAL_CRAFT_MINER_SPIRIT, PENTACLE_CRAFT_DJINNI, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.MINER_FOLIOT_UNSPECIALIZED.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.IESNIUM_PICKAXE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.SPIRIT_ATTUNED_CRYSTAL.get()}), Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD), Ingredient.of((TagKey)Tags.Items.GEMS_LAPIS), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.SPIRIT_ATTUNED_CRYSTAL.get()})).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_miner_djinni_ores"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), new ItemStack((ItemLike)OccultismItems.MINER_FOLIOT_UNSPECIALIZED.get()), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/craft_miner_foliot_unspecialized")), 60, RITUAL_CRAFT_MINER_SPIRIT, PENTACLE_CRAFT_FOLIOT, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.IESNIUM_PICKAXE.get()}), Ingredient.of((TagKey)Tags.Items.RAW_MATERIALS_IRON), Ingredient.of((TagKey)Tags.Items.GRAVELS)).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_miner_foliot_unspecialized"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_MARID.get()}), new ItemStack((ItemLike)OccultismItems.MINER_MARID_MASTER.get()), RitualRecipes.makeRitualDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/craft_miner_marid_master")), 120, RITUAL_CRAFT_MINER_SPIRIT, PENTACLE_CRAFT_MARID, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.MINER_AFRIT_DEEPS.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.IESNIUM_PICKAXE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.SPIRIT_ATTUNED_CRYSTAL.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_PICKAXE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.DRAGON_BREATH}), Ingredient.of((ItemLike[])new ItemLike[]{Items.TOTEM_OF_UNDYING}), Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHER_STAR})).unlockedBy("has_bound_marid", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_MARID.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_miner_marid_master"));
    }
}

