/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.datagen.recipe;

import com.klikli_dev.occultism.datagen.recipe.MinerRecipes;
import com.klikli_dev.occultism.datagen.recipe.RitualRecipes;
import com.klikli_dev.occultism.datagen.recipe.builders.CrushingRecipeBuilder;
import com.klikli_dev.occultism.datagen.recipe.builders.MinerRecipeBuilder;
import com.klikli_dev.occultism.datagen.recipe.builders.SpiritFireRecipeBuilder;
import com.klikli_dev.occultism.datagen.recipe.builders.SpiritTradeRecipeBuilder;
import com.klikli_dev.occultism.registry.OccultismBlocks;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.klikli_dev.occultism.registry.OccultismTags;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;

public class OccultismRecipeProvider
extends RecipeProvider {
    public OccultismRecipeProvider(PackOutput p_248933_, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(p_248933_, lookupProvider);
    }

    private static void metalRecipes(RecipeOutput pRecipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)OccultismBlocks.IESNIUM_BLOCK.get())).pattern("ppp").pattern("ppp").pattern("ppp").define(Character.valueOf('p'), OccultismTags.Items.IESNIUM_INGOT).unlockedBy("has_iesnium_ingot", OccultismRecipeProvider.has(OccultismTags.Items.IESNIUM_INGOT)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/iesnium_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.IESNIUM_INGOT.get()), (int)9).requires(OccultismTags.Items.STORAGE_BLOCK_IESNIUM).unlockedBy("has_iesnium_block", OccultismRecipeProvider.has(OccultismTags.Items.STORAGE_BLOCK_IESNIUM)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/iesnium_ingot_from_block"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.IESNIUM_INGOT.get())).pattern("ppp").pattern("ppp").pattern("ppp").define(Character.valueOf('p'), OccultismTags.Items.IESNIUM_NUGGET).unlockedBy("has_iesnium_nugget", OccultismRecipeProvider.has(OccultismTags.Items.IESNIUM_NUGGET)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/iesnium_ingot_from_nuggets"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.IESNIUM_NUGGET.get()), (int)9).requires(OccultismTags.Items.IESNIUM_INGOT).unlockedBy("has_iesnium_ingot", OccultismRecipeProvider.has(OccultismTags.Items.IESNIUM_INGOT)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/iesnium_nugget"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismBlocks.RAW_IESNIUM_BLOCK.get())).pattern("ppp").pattern("ppp").pattern("ppp").define(Character.valueOf('p'), OccultismTags.Items.RAW_IESNIUM).unlockedBy("has_raw_iesnium", OccultismRecipeProvider.has(OccultismTags.Items.RAW_IESNIUM)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/raw_iesnium_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.RAW_IESNIUM.get()), (int)9).requires(OccultismTags.Items.STORAGE_BLOCK_RAW_IESNIUM).unlockedBy("has_raw_iesnium_block", OccultismRecipeProvider.has(OccultismTags.Items.STORAGE_BLOCK_RAW_IESNIUM)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/raw_iesnium_ingot_from_block"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)OccultismBlocks.SILVER_BLOCK.get())).pattern("ppp").pattern("ppp").pattern("ppp").define(Character.valueOf('p'), OccultismTags.Items.SILVER_INGOT).unlockedBy("has_silver_ingot", OccultismRecipeProvider.has(OccultismTags.Items.SILVER_INGOT)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/silver_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.SILVER_INGOT.get()), (int)9).requires(OccultismTags.Items.STORAGE_BLOCK_SILVER).unlockedBy("has_silver_block", OccultismRecipeProvider.has(OccultismTags.Items.STORAGE_BLOCK_SILVER)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/silver_ingot_from_block"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.SILVER_INGOT.get())).pattern("ppp").pattern("ppp").pattern("ppp").define(Character.valueOf('p'), OccultismTags.Items.SILVER_NUGGET).unlockedBy("has_silver_nugget", OccultismRecipeProvider.has(OccultismTags.Items.SILVER_NUGGET)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/silver_ingot_from_nuggets"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.SILVER_NUGGET.get()), (int)9).requires(OccultismTags.Items.SILVER_INGOT).unlockedBy("has_silver_ingot", OccultismRecipeProvider.has(OccultismTags.Items.SILVER_INGOT)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/silver_nugget"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismBlocks.RAW_SILVER_BLOCK.get())).pattern("ppp").pattern("ppp").pattern("ppp").define(Character.valueOf('p'), OccultismTags.Items.RAW_SILVER).unlockedBy("has_raw_silver", OccultismRecipeProvider.has(OccultismTags.Items.RAW_SILVER)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/raw_silver_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.RAW_SILVER.get()), (int)9).requires(OccultismTags.Items.STORAGE_BLOCK_RAW_SILVER).unlockedBy("has_raw_silver_block", OccultismRecipeProvider.has(OccultismTags.Items.STORAGE_BLOCK_RAW_SILVER)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/raw_silver_ingot_from_block"));
    }

    private static void blastingRecipes(RecipeOutput pRecipeOutput) {
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of(OccultismTags.Items.COPPER_DUST), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.COPPER_INGOT, (float)0.7f, (int)100).unlockedBy("has_copper_dust", OccultismRecipeProvider.has(OccultismTags.Items.COPPER_DUST)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"blasting/copper_ingot_from_dust"));
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of(OccultismTags.Items.GOLD_DUST), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.GOLD_INGOT, (float)0.7f, (int)100).unlockedBy("has_gold_dust", OccultismRecipeProvider.has(OccultismTags.Items.GOLD_DUST)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"blasting/gold_ingot_from_dust"));
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of(OccultismTags.Items.IESNIUM_ORE), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.IESNIUM_INGOT.get()), (float)0.7f, (int)100).unlockedBy("has_iesnium_ore", OccultismRecipeProvider.has(OccultismTags.Items.IESNIUM_ORE)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"blasting/iesnium_ingot"));
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of(OccultismTags.Items.IESNIUM_DUST), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.IESNIUM_INGOT.get()), (float)0.7f, (int)100).unlockedBy("has_iesnium_dust", OccultismRecipeProvider.has(OccultismTags.Items.IESNIUM_DUST)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"blasting/iesnium_ingot_from_dust"));
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of(OccultismTags.Items.RAW_IESNIUM), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.IESNIUM_INGOT.get()), (float)0.7f, (int)100).unlockedBy("has_raw_iesnium", OccultismRecipeProvider.has(OccultismTags.Items.RAW_IESNIUM)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"blasting/iesnium_ingot_from_raw"));
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of(OccultismTags.Items.IRON_DUST), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.IRON_INGOT, (float)0.7f, (int)100).unlockedBy("has_iron_dust", OccultismRecipeProvider.has(OccultismTags.Items.IRON_DUST)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"blasting/iron_ingot_from_dust"));
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of(OccultismTags.Items.SILVER_ORE), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.SILVER_INGOT.get()), (float)0.7f, (int)100).unlockedBy("has_silver_ore", OccultismRecipeProvider.has(OccultismTags.Items.SILVER_ORE)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"blasting/silver_ingot"));
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of(OccultismTags.Items.SILVER_DUST), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.SILVER_INGOT.get()), (float)0.7f, (int)100).unlockedBy("has_silver_dust", OccultismRecipeProvider.has(OccultismTags.Items.SILVER_DUST)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"blasting/silver_ingot_from_dust"));
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of(OccultismTags.Items.RAW_SILVER), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.SILVER_INGOT.get()), (float)0.7f, (int)100).unlockedBy("has_raw_silver", OccultismRecipeProvider.has(OccultismTags.Items.RAW_SILVER)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"blasting/silver_ingot_from_raw"));
    }

    protected void buildRecipes(RecipeOutput pRecipeOutput) {
        OccultismRecipeProvider.blastingRecipes(pRecipeOutput);
        this.craftingRecipes(pRecipeOutput);
        this.smeltingRecipes(pRecipeOutput);
        this.crushingRecipes(pRecipeOutput);
        this.miningRecipes(pRecipeOutput);
        this.spiritFireRecipes(pRecipeOutput);
        this.spiritTradeRecipes(pRecipeOutput);
        this.ritualRecipes(pRecipeOutput);
    }

    private void ritualRecipes(RecipeOutput recipeOutput) {
        RitualRecipes.ritualRecipes(recipeOutput);
    }

    private void spiritTradeRecipes(RecipeOutput pRecipeOutput) {
        SpiritTradeRecipeBuilder.spiritTradeRecipe(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.OTHERWORLD_SAPLING_NATURAL.get()}), new ItemStack((ItemLike)OccultismBlocks.OTHERWORLD_SAPLING.get())).unlockedBy("has_otherworld_sapling_natural", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.OTHERWORLD_SAPLING_NATURAL.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"spirit_trade/otherworld_sapling"));
        SpiritTradeRecipeBuilder.spiritTradeRecipe(Ingredient.of((TagKey)Tags.Items.STONES), new ItemStack((ItemLike)OccultismBlocks.OTHERSTONE.get(), 2)).unlockedBy("has_stone", OccultismRecipeProvider.has((TagKey)Tags.Items.STONES)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"spirit_trade/stone_to_otherstone"));
        SpiritTradeRecipeBuilder.spiritTradeRecipe(Ingredient.of((TagKey)Tags.Items.STONES), new ItemStack((ItemLike)OccultismBlocks.OTHERSTONE.get(), 4)).unlockedBy("has_stone", OccultismRecipeProvider.has((TagKey)Tags.Items.STONES)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"spirit_trade/test"));
    }

    private void spiritFireRecipes(RecipeOutput pRecipeOutput) {
        SpiritFireRecipeBuilder.spiritFireRecipe(Ingredient.of((TagKey)Tags.Items.FEATHERS), new ItemStack((ItemLike)OccultismItems.AWAKENED_FEATHER.get())).unlockedBy("has_feather", OccultismRecipeProvider.has((TagKey)Tags.Items.FEATHERS)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"spirit_fire/awakened_feather"));
        SpiritFireRecipeBuilder.spiritFireRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.WRITABLE_BOOK}), new ItemStack((ItemLike)OccultismItems.BOOK_OF_BINDING_EMPTY.get())).unlockedBy("has_writable_book", OccultismRecipeProvider.has((ItemLike)Items.WRITABLE_BOOK)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"spirit_fire/book_of_binding_empty"));
        SpiritFireRecipeBuilder.spiritFireRecipe(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.CHALK_GOLD_IMPURE.get()}), new ItemStack((ItemLike)OccultismItems.CHALK_GOLD.get())).unlockedBy("has_chalk_gold_impure", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.CHALK_GOLD_IMPURE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"spirit_fire/chalk_gold"));
        SpiritFireRecipeBuilder.spiritFireRecipe(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.CHALK_PURPLE_IMPURE.get()}), new ItemStack((ItemLike)OccultismItems.CHALK_PURPLE.get())).unlockedBy("has_chalk_purple_impure", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.CHALK_PURPLE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"spirit_fire/chalk_purple"));
        SpiritFireRecipeBuilder.spiritFireRecipe(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.CHALK_RED_IMPURE.get()}), new ItemStack((ItemLike)OccultismItems.CHALK_RED.get())).unlockedBy("has_chalk_red_impure", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.CHALK_RED.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"spirit_fire/chalk_red"));
        SpiritFireRecipeBuilder.spiritFireRecipe(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get()}), new ItemStack((ItemLike)OccultismItems.CHALK_WHITE.get())).unlockedBy("has_chalk_white_impure", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.CHALK_WHITE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"spirit_fire/chalk_white"));
        SpiritFireRecipeBuilder.spiritFireRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Blocks.ANDESITE}), new ItemStack((ItemLike)OccultismBlocks.OTHERSTONE.get())).unlockedBy("has_andesite", OccultismRecipeProvider.has((ItemLike)Blocks.ANDESITE)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"spirit_fire/otherstone"));
        SpiritFireRecipeBuilder.spiritFireRecipe(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.OTHERWORLD_LOG.get()}), new ItemStack((ItemLike)OccultismItems.OTHERWORLD_ASHES.get())).unlockedBy("has_otherworld_log", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.OTHERWORLD_LOG.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"spirit_fire/otherworld_ashes"));
        SpiritFireRecipeBuilder.spiritFireRecipe(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.DEMONS_DREAM_ESSENCE.get()}), new ItemStack((ItemLike)OccultismItems.OTHERWORLD_ESSENCE.get())).unlockedBy("has_demons_dream_essence", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.DEMONS_DREAM_ESSENCE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"spirit_fire/otherworld_essence"));
        SpiritFireRecipeBuilder.spiritFireRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.OAK_SAPLING}), new ItemStack((ItemLike)OccultismItems.OTHERWORLD_SAPLING_NATURAL.get())).unlockedBy("has_oak_sapling", OccultismRecipeProvider.has((ItemLike)Items.OAK_SAPLING)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"spirit_fire/otherworld_sapling_natural"));
        SpiritFireRecipeBuilder.spiritFireRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.BLACK_DYE}), new ItemStack((ItemLike)OccultismItems.PURIFIED_INK.get())).unlockedBy("has_black_dye", OccultismRecipeProvider.has((ItemLike)Items.BLACK_DYE)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"spirit_fire/purified_ink"));
        SpiritFireRecipeBuilder.spiritFireRecipe(Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND), new ItemStack((ItemLike)OccultismItems.SPIRIT_ATTUNED_GEM.get())).unlockedBy("has_diamond", OccultismRecipeProvider.has((TagKey)Tags.Items.GEMS_DIAMOND)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"spirit_fire/spirit_attuned_gem"));
        SpiritFireRecipeBuilder.spiritFireRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOOK}), new ItemStack((ItemLike)OccultismItems.TABOO_BOOK.get())).unlockedBy("has_book", OccultismRecipeProvider.has((ItemLike)Items.BOOK)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"spirit_fire/taboo_book"));
    }

    private void miningRecipes(RecipeOutput pRecipeOutput) {
        MinerRecipeBuilder.minerRecipe(OccultismTags.Items.Miners.MASTER, OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)"ores/stella_arcanum")), 100).unlockedBy("has_stella_arcanum_ore", OccultismRecipeProvider.has(OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)"ores/stella_arcanum")))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"miner/master/stella_arcanum"));
        MinerRecipes.basic_resources(pRecipeOutput);
        MinerRecipes.deeps(pRecipeOutput);
        MinerRecipes.master_resources(pRecipeOutput);
        MinerRecipes.ores(pRecipeOutput);
        MinerRecipeBuilder.minerRecipe((ItemLike)OccultismItems.DEBUG_WAND.get(), (ItemLike)OccultismBlocks.OTHERSTONE.get(), 200).unlockedBy("has_miner", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get()))).allowEmpty().save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"miner/debug_wand"));
    }

    private void crushingRecipes(RecipeOutput pRecipeOutput) {
        CrushingRecipeBuilder.crushingRecipe(OccultismTags.Items.DATURA_CROP, OccultismTags.Items.DATURA_SEEDS, 200).unlockedBy("has_datura", OccultismRecipeProvider.has(OccultismTags.Items.DATURA_CROP)).setAllowEmpty(false).setResultAmount(2).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crushing/datura"));
        this.crushingMetalRecipe("allthemodium", pRecipeOutput);
        this.crushingMetalRecipe("iesnium", pRecipeOutput);
        this.crushingMetalRecipe("aluminum", pRecipeOutput);
        this.crushingMetalRecipe("signalum", pRecipeOutput);
        this.crushingMetalRecipe("uranium", pRecipeOutput);
        this.crushingMetalRecipe("graphite", pRecipeOutput);
        this.crushingMetalRecipe("azure_silver", pRecipeOutput);
        this.crushingMetalRecipe("zinc", pRecipeOutput);
        this.crushingMetalRecipe("lumium", pRecipeOutput);
        this.crushingMetalRecipe("osmium", pRecipeOutput);
        this.crushingMetalRecipe("nickel", pRecipeOutput);
        this.crushingMetalRecipe("lead", pRecipeOutput);
        this.crushingMetalRecipe("bronze", pRecipeOutput);
        this.crushingMetalRecipe("cobalt", pRecipeOutput);
        this.crushingMetalRecipe("unobtainium", pRecipeOutput);
        this.crushingMetalRecipe("tungsten", pRecipeOutput);
        this.crushingMetalRecipe("iridium", pRecipeOutput);
        this.crushingMetalRecipe("steel", pRecipeOutput);
        this.crushingMetalRecipe("enderium", pRecipeOutput);
        this.crushingMetalRecipe("electrum", pRecipeOutput);
        this.crushingMetalRecipe("constantan", pRecipeOutput);
        this.crushingMetalRecipe("tin", pRecipeOutput);
        this.crushingMetalRecipe("netherite", pRecipeOutput);
        this.crushingMetalRecipe("brass", pRecipeOutput);
        this.crushingMetalRecipe("crimson_iron", pRecipeOutput);
        this.crushingMetalRecipe("platinum", pRecipeOutput);
        this.crushingMetalRecipe("invar", pRecipeOutput);
        this.crushingMetalRecipe("vibranium", pRecipeOutput);
        this.crushingMetalRecipe("silver", pRecipeOutput);
        this.crushingMetalRecipe("copper", pRecipeOutput);
        this.crushingMetalRecipe("pewter", pRecipeOutput);
        this.crushingMetalRecipe("mithril", pRecipeOutput);
        this.crushingMetalRecipe("gold", pRecipeOutput);
        this.crushingMetalRecipe("quicksilver", pRecipeOutput);
        this.crushingMetalRecipe("iron", pRecipeOutput);
        this.crushingGemRecipe("diamond", pRecipeOutput);
        this.crushingGemRecipe("emerald", pRecipeOutput);
        this.crushingGemRecipe("lapis", pRecipeOutput);
        this.crushingGemRecipe("quartz", pRecipeOutput);
        this.crushingGemRecipe("coal", pRecipeOutput);
        this.crushingGemRecipe("redstone", pRecipeOutput);
        this.crushingGemRecipe("apatite", pRecipeOutput);
        this.crushingGemRecipe("sulfur", pRecipeOutput);
        this.crushingGemRecipe("fluorite", pRecipeOutput);
        this.crushingGemRecipe("cinnabar", pRecipeOutput);
        this.crushingGemRecipe("amber", pRecipeOutput);
        this.crushingGemRecipe("certus_quartz", pRecipeOutput);
        this.crushingGemRecipe("charged_certus_quartz", pRecipeOutput);
        this.crushingGemRecipe("peridot", pRecipeOutput);
        this.crushingGemRecipe("ruby", pRecipeOutput);
        this.crushingGemRecipe("sapphire", pRecipeOutput);
        this.crushingGemRecipe("topaz", pRecipeOutput);
        this.crushingGemRecipe("arcane_crystal", pRecipeOutput);
        CrushingRecipeBuilder.crushingRecipe((TagKey<Item>)Tags.Items.RODS_BLAZE, (ItemLike)Items.BLAZE_POWDER, 200).allowEmpty().setResultAmount(4).unlockedBy("has_blaze_rod", OccultismRecipeProvider.has((TagKey)Tags.Items.RODS_BLAZE)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crushing/blaze_powder_from_rod"));
        CrushingRecipeBuilder.crushingRecipe((TagKey<Item>)Tags.Items.OBSIDIANS, OccultismTags.Items.OBSIDIAN_DUST, 200).allowEmpty().unlockedBy("has_obsidian", OccultismRecipeProvider.has((TagKey)Tags.Items.OBSIDIANS)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crushing/obsidian_dust"));
        CrushingRecipeBuilder.crushingRecipe((TagKey<Item>)Tags.Items.END_STONES, OccultismTags.Items.END_STONE_DUST, 200).allowEmpty().unlockedBy("has_end_stone", OccultismRecipeProvider.has((TagKey)Tags.Items.END_STONES)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crushing/end_stone_dust"));
    }

    private void crushingGemRecipe(String gemName, RecipeOutput recipeOutput) {
        CrushingRecipeBuilder.crushingRecipe(OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)("ores/" + gemName))), OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)("dusts/" + gemName))), 200).unlockedBy("has_" + gemName, OccultismRecipeProvider.has(OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)("ores/" + gemName))))).setResultAmount(4).setAllowEmpty(false).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)("crushing/" + gemName + "_dust")));
        CrushingRecipeBuilder.crushingRecipe(OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)("gems/" + gemName))), OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)("dusts/" + gemName))), 200).unlockedBy("has_" + gemName + "_gem", OccultismRecipeProvider.has(OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)("gems/" + gemName))))).setResultAmount(1).setAllowEmpty(false).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)("crushing/" + gemName + "_dust_from_gem")));
    }

    private void crushingMetalRecipe(String metalName, RecipeOutput recipeOutput) {
        CrushingRecipeBuilder.crushingRecipe(OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)("ores/" + metalName))), OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)("dusts/" + metalName))), 200).unlockedBy("has_" + metalName, OccultismRecipeProvider.has(OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)("ores/" + metalName))))).setResultAmount(2).setAllowEmpty(false).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)("crushing/" + metalName + "_dust")));
        CrushingRecipeBuilder.crushingRecipe(OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)("raw_materials/" + metalName))), OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)("dusts/" + metalName))), 200).unlockedBy("has_raw_" + metalName, OccultismRecipeProvider.has(OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)("raw_materials/" + metalName))))).setResultAmount(2).setAllowEmpty(false).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)("crushing/" + metalName + "_dust_from_raw")));
        CrushingRecipeBuilder.crushingRecipe(OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)("storage_blocks/raw_" + metalName))), OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)("dusts/" + metalName))), 1600).unlockedBy("has_raw_" + metalName + "_block", OccultismRecipeProvider.has(OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)("storage_blocks/raw_" + metalName))))).setResultAmount(18).setAllowEmpty(false).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)("crushing/" + metalName + "_dust_from_raw_block")));
        CrushingRecipeBuilder.crushingRecipe(OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)("ingots/" + metalName))), OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)("dusts/" + metalName))), 200).unlockedBy("has_" + metalName + "_ingot", OccultismRecipeProvider.has(OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)("ingots/" + metalName))))).setResultAmount(1).setAllowEmpty(false).setIgnoreCrushingMultiplier(true).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)("crushing/" + metalName + "_dust_from_ingot")));
    }

    private void craftingRecipes(RecipeOutput pRecipeOutput) {
        OccultismRecipeProvider.metalRecipes(pRecipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_EMPTY.get())).requires((ItemLike)OccultismItems.AWAKENED_FEATHER.get()).requires((ItemLike)OccultismItems.PURIFIED_INK.get()).requires((ItemLike)OccultismItems.TABOO_BOOK.get()).unlockedBy("has_taboo_book", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.TABOO_BOOK.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/book_of_binding_empty"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_AFRIT.get())).pattern("cpf").pattern("pbp").pattern(" p ").define(Character.valueOf('p'), Tags.Items.DYES_PURPLE).define(Character.valueOf('b'), (ItemLike)OccultismItems.TABOO_BOOK.get()).define(Character.valueOf('c'), (ItemLike)OccultismItems.PURIFIED_INK.get()).define(Character.valueOf('f'), (ItemLike)OccultismItems.AWAKENED_FEATHER.get()).unlockedBy("has_taboo_book", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.TABOO_BOOK.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/book_of_binding_afrit"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_AFRIT.get())).pattern(" p ").pattern("pbp").pattern(" p ").define(Character.valueOf('p'), Tags.Items.DYES_PURPLE).define(Character.valueOf('b'), (ItemLike)OccultismItems.BOOK_OF_BINDING_EMPTY.get()).unlockedBy("has_taboo_book", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_EMPTY.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/book_of_binding_afrit_from_empty"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get())).requires((ItemLike)OccultismItems.BOOK_OF_BINDING_AFRIT.get()).requires((ItemLike)OccultismItems.DICTIONARY_OF_SPIRITS.get()).unlockedBy("has_book_of_binding_afrit", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_AFRIT.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/book_of_binding_bound_afrit"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_DJINNI.get())).pattern("cgf").pattern("gbg").pattern(" g ").define(Character.valueOf('c'), (ItemLike)OccultismItems.PURIFIED_INK.get()).define(Character.valueOf('b'), (ItemLike)OccultismItems.TABOO_BOOK.get()).define(Character.valueOf('g'), Tags.Items.DYES_GREEN).define(Character.valueOf('f'), (ItemLike)OccultismItems.AWAKENED_FEATHER.get()).unlockedBy("has_taboo_book", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.TABOO_BOOK.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/book_of_binding_djinni"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_DJINNI.get())).pattern(" g ").pattern("gbg").pattern(" g ").define(Character.valueOf('g'), Tags.Items.DYES_GREEN).define(Character.valueOf('b'), (ItemLike)OccultismItems.BOOK_OF_BINDING_EMPTY.get()).unlockedBy("has_empty_binding", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_EMPTY.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/book_of_binding_djinni_from_empty"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get())).requires((ItemLike)OccultismItems.BOOK_OF_BINDING_DJINNI.get()).requires((ItemLike)OccultismItems.DICTIONARY_OF_SPIRITS.get()).unlockedBy("has_book_of_binding_djinni", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_DJINNI.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/book_of_binding_bound_djinni"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get())).requires(OccultismTags.Items.BOOK_OF_CALLING_DJINNI).unlockedBy("has_book_of_calling_djinni", OccultismRecipeProvider.has(OccultismTags.Items.BOOK_OF_CALLING_DJINNI)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/book_of_binding_bound_djinni_from_calling"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_FOLIOT.get())).pattern("cwf").pattern("wbw").pattern(" w ").define(Character.valueOf('c'), (ItemLike)OccultismItems.PURIFIED_INK.get()).define(Character.valueOf('b'), (ItemLike)OccultismItems.TABOO_BOOK.get()).define(Character.valueOf('w'), Tags.Items.DYES_WHITE).define(Character.valueOf('f'), (ItemLike)OccultismItems.AWAKENED_FEATHER.get()).unlockedBy("has_taboo_book", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.TABOO_BOOK.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/book_of_binding_foliot"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_FOLIOT.get())).pattern(" w ").pattern("wbw").pattern(" w ").define(Character.valueOf('w'), Tags.Items.DYES_WHITE).define(Character.valueOf('b'), (ItemLike)OccultismItems.BOOK_OF_BINDING_EMPTY.get()).unlockedBy("has_empty_binding", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_EMPTY.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/book_of_binding_foliot_from_empty"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get())).requires((ItemLike)OccultismItems.BOOK_OF_BINDING_FOLIOT.get()).requires((ItemLike)OccultismItems.DICTIONARY_OF_SPIRITS.get()).unlockedBy("has_book_of_binding_foliot", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_FOLIOT.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/book_of_binding_bound_foliot"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get())).requires(OccultismTags.Items.BOOK_OF_CALLING_FOLIOT).unlockedBy("has_book_of_calling_foliot", OccultismRecipeProvider.has(OccultismTags.Items.BOOK_OF_CALLING_FOLIOT)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/book_of_binding_bound_foliot_from_calling"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_MARID.get())).pattern("cof").pattern("pbp").pattern(" o ").define(Character.valueOf('c'), (ItemLike)OccultismItems.PURIFIED_INK.get()).define(Character.valueOf('b'), (ItemLike)OccultismItems.TABOO_BOOK.get()).define(Character.valueOf('o'), Tags.Items.DYES_ORANGE).define(Character.valueOf('p'), Tags.Items.DYES_PURPLE).define(Character.valueOf('f'), (ItemLike)OccultismItems.AWAKENED_FEATHER.get()).unlockedBy("has_taboo_book", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.TABOO_BOOK.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/book_of_binding_marid"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_MARID.get())).pattern(" o ").pattern("pbp").pattern(" o ").define(Character.valueOf('o'), Tags.Items.DYES_ORANGE).define(Character.valueOf('p'), Tags.Items.DYES_PURPLE).define(Character.valueOf('b'), (ItemLike)OccultismItems.BOOK_OF_BINDING_EMPTY.get()).unlockedBy("has_empty_binding", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_EMPTY.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/book_of_binding_marid_from_empty"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_MARID.get())).requires((ItemLike)OccultismItems.BOOK_OF_BINDING_MARID.get()).requires((ItemLike)OccultismItems.DICTIONARY_OF_SPIRITS.get()).unlockedBy("has_book_of_binding_marid", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_MARID.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/book_of_binding_bound_marid"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_CALLING_DJINNI_MANAGE_MACHINE.get())).requires((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()).requires((ItemLike)Items.FURNACE).unlockedBy("has_book_of_binding_bound_djinni", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/book_of_calling_djinni_manage_machine"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_CALLING_FOLIOT_CLEANER.get())).requires((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()).requires((ItemLike)OccultismItems.BRUSH.get()).unlockedBy("has_book_of_binding_bound_foliot", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/book_of_calling_foliot_cleaner"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_CALLING_FOLIOT_LUMBERJACK.get())).requires((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()).requires(OccultismTags.Items.METAL_AXES).unlockedBy("has_book_of_binding_bound_foliot", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/book_of_calling_foliot_lumberjack"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_CALLING_FOLIOT_TRANSPORT_ITEMS.get())).requires((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()).requires(Tags.Items.CHESTS).unlockedBy("has_book_of_binding_bound_foliot", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/book_of_calling_foliot_transport_items"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BRUSH.get())).pattern("ppp").pattern("wws").define(Character.valueOf('p'), ItemTags.PLANKS).define(Character.valueOf('w'), ItemTags.WOOL).define(Character.valueOf('s'), Tags.Items.STRINGS).unlockedBy("has_wool", OccultismRecipeProvider.has((TagKey)ItemTags.WOOL)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/brush"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)OccultismItems.BUTCHER_KNIFE.get())).pattern(" is").pattern("is ").pattern("s  ").define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).define(Character.valueOf('s'), Tags.Items.RODS_WOODEN).unlockedBy("has_iron_ingot", OccultismRecipeProvider.has((TagKey)Tags.Items.INGOTS_IRON)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/butcher_knife"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)OccultismBlocks.CANDLE_WHITE.get())).pattern("s").pattern("t").define(Character.valueOf('s'), Tags.Items.STRINGS).define(Character.valueOf('t'), OccultismTags.Items.TALLOW).unlockedBy("has_tallow", OccultismRecipeProvider.has(OccultismTags.Items.TALLOW)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/candle"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.CHALK_GOLD_IMPURE.get())).requires((ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get()).requires(OccultismTags.Items.GOLD_DUST).requires(Tags.Items.DUSTS_GLOWSTONE).unlockedBy("has_chalk_white", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/chalk_gold_impure"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.CHALK_PURPLE_IMPURE.get())).requires((ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get()).requires(OccultismTags.Items.END_STONE_DUST).requires(OccultismTags.Items.OBSIDIAN_DUST).requires(OccultismTags.Items.OBSIDIAN_DUST).unlockedBy("has_chalk_white", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/chalk_purple_impure"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.CHALK_RED_IMPURE.get())).requires((ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get()).requires((ItemLike)OccultismItems.AFRIT_ESSENCE.get()).requires((ItemLike)Items.BLAZE_POWDER).unlockedBy("has_chalk_white", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/chalk_red_impure"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get())).pattern("xy").pattern("xy").pattern("xy").define(Character.valueOf('x'), (ItemLike)OccultismItems.BURNT_OTHERSTONE.get()).define(Character.valueOf('y'), (ItemLike)OccultismItems.OTHERWORLD_ASHES.get()).unlockedBy("has_ashes", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.OTHERWORLD_ASHES.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/chalk_white_impure"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)OccultismItems.DEMONS_DREAM_ESSENCE.get())).pattern("ppp").pattern("ppp").pattern("ppp").define(Character.valueOf('p'), Ingredient.fromValues(Stream.of(new Ingredient.TagValue(OccultismTags.Items.DATURA_CROP), new Ingredient.TagValue(OccultismTags.Items.DATURA_SEEDS)))).unlockedBy("has_datura", OccultismRecipeProvider.has(OccultismTags.Items.DATURA_CROP)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/demons_dream_essence_from_fruit_or_seed"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.DICTIONARY_OF_SPIRITS.get())).requires(OccultismTags.Items.DATURA_SEEDS).requires(OccultismTags.Items.BOOKS).unlockedBy("has_datura", OccultismRecipeProvider.has(OccultismTags.Items.DATURA_SEEDS)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/dictionary_of_spirits"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)OccultismItems.DIVINATION_ROD.get())).pattern("xyx").pattern("x x").pattern(" x ").define(Character.valueOf('x'), Tags.Items.RODS_WOODEN).define(Character.valueOf('y'), (ItemLike)OccultismItems.SPIRIT_ATTUNED_GEM.get()).unlockedBy("has_spirit_attuned_gem", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.SPIRIT_ATTUNED_GEM.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/divination_rod"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)OccultismItems.OTHERWORLD_GOGGLES.get())).pattern(" l ").pattern("lil").pattern(" f ").define(Character.valueOf('l'), Tags.Items.LEATHERS).define(Character.valueOf('i'), (ItemLike)OccultismItems.INFUSED_LENSES.get()).define(Character.valueOf('f'), (ItemLike)OccultismItems.LENS_FRAME.get()).unlockedBy("has_infused_lenses", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.INFUSED_LENSES.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/goggles"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismBlocks.GOLDEN_SACRIFICIAL_BOWL.get())).pattern("ggg").pattern("gbg").pattern("ggg").define(Character.valueOf('g'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('b'), (ItemLike)OccultismBlocks.SACRIFICIAL_BOWL.get()).unlockedBy("has_sacrificial_bowl", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.SACRIFICIAL_BOWL.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/golden_sacrificial_bowl"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)OccultismItems.IESNIUM_PICKAXE.get())).pattern("iii").pattern(" s ").pattern(" s ").define(Character.valueOf('i'), OccultismTags.Items.IESNIUM_INGOT).define(Character.valueOf('s'), Tags.Items.RODS_WOODEN).unlockedBy("has_iesnium_ingot", OccultismRecipeProvider.has(OccultismTags.Items.IESNIUM_INGOT)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/iesnium_pickaxe"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.LENS_FRAME.get())).pattern("ooo").pattern("s s").pattern("ooo").define(Character.valueOf('o'), (ItemLike)OccultismBlocks.OTHERSTONE.get()).define(Character.valueOf('s'), OccultismTags.Items.SILVER_INGOT).unlockedBy("has_silver_ingot", OccultismRecipeProvider.has(OccultismTags.Items.SILVER_INGOT)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/lens_frame"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.LENSES.get())).pattern("ppp").pattern("pgp").pattern("ppp").define(Character.valueOf('p'), Tags.Items.GLASS_PANES).define(Character.valueOf('g'), (ItemLike)OccultismItems.SPIRIT_ATTUNED_GEM.get()).unlockedBy("has_spirit_attuned_gem", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.SPIRIT_ATTUNED_GEM.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/lenses"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get())).pattern(" s ").pattern("sis").pattern(" ss").define(Character.valueOf('s'), OccultismTags.Items.SILVER_INGOT).define(Character.valueOf('i'), OccultismTags.Items.IESNIUM_INGOT).unlockedBy("has_silver_ingot", OccultismRecipeProvider.has(OccultismTags.Items.SILVER_INGOT)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/magic_lamp_empty"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.OTHERSTONE_FRAME.get())).pattern("ooo").pattern("o o").pattern("ooo").define(Character.valueOf('o'), (ItemLike)OccultismBlocks.OTHERSTONE.get()).unlockedBy("has_otherstone", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.OTHERSTONE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/otherstone_frame"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)OccultismBlocks.OTHERSTONE_PEDESTAL.get())).pattern("s s").pattern(" o ").pattern("sss").define(Character.valueOf('s'), (ItemLike)OccultismBlocks.OTHERSTONE_SLAB.get()).define(Character.valueOf('o'), (ItemLike)OccultismBlocks.OTHERSTONE.get()).unlockedBy("has_otherstone", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.OTHERSTONE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/otherstone_pedestal"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)OccultismBlocks.OTHERSTONE_SLAB.get()), (int)6).pattern("ooo").define(Character.valueOf('o'), (ItemLike)OccultismBlocks.OTHERSTONE.get()).unlockedBy("has_otherstone", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.OTHERSTONE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/otherstone_slab"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)OccultismItems.OTHERSTONE_TABLET.get())).pattern("sss").pattern("sss").pattern("sss").define(Character.valueOf('s'), (ItemLike)OccultismBlocks.OTHERSTONE_SLAB.get()).unlockedBy("has_otherstone_slab", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.OTHERSTONE_SLAB.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/otherstone_tablet"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)OccultismBlocks.SACRIFICIAL_BOWL.get())).pattern("o o").pattern("ooo").define(Character.valueOf('o'), (ItemLike)OccultismBlocks.OTHERSTONE.get()).unlockedBy("has_otherstone", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.OTHERSTONE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/sacrificial_bowl"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismBlocks.SPIRIT_ATTUNED_CRYSTAL.get())).pattern("gg").pattern("gg").define(Character.valueOf('g'), (ItemLike)OccultismItems.SPIRIT_ATTUNED_GEM.get()).unlockedBy("has_spirit_attuned_gem", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.SPIRIT_ATTUNED_GEM.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/spirit_attuned_crystal"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.SPIRIT_ATTUNED_PICKAXE_HEAD.get())).pattern("ggg").define(Character.valueOf('g'), (ItemLike)OccultismItems.SPIRIT_ATTUNED_GEM.get()).unlockedBy("has_spirit_attuned_gem", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.SPIRIT_ATTUNED_GEM.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/spirit_attuned_pickaxe_head"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismBlocks.SPIRIT_CAMPFIRE.get())).pattern(" S ").pattern("S#S").pattern("LLL").define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).define(Character.valueOf('L'), ItemTags.LOGS).define(Character.valueOf('#'), OccultismTags.Items.DATURA_CROP).unlockedBy("has_datura", OccultismRecipeProvider.has(OccultismTags.Items.DATURA_CROP)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/spirit_campfire"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)OccultismBlocks.SPIRIT_LANTERN.get())).pattern("XXX").pattern("X#X").pattern("XXX").define(Character.valueOf('X'), Tags.Items.NUGGETS_IRON).define(Character.valueOf('#'), (ItemLike)OccultismBlocks.SPIRIT_TORCH.get()).unlockedBy("has_spirit_torch", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.SPIRIT_TORCH.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/spirit_lantern"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)OccultismBlocks.SPIRIT_TORCH.get())).pattern("X").pattern("#").pattern("S").define(Character.valueOf('X'), ItemTags.COALS).define(Character.valueOf('#'), OccultismTags.Items.DATURA_CROP).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).unlockedBy("has_datura", OccultismRecipeProvider.has(OccultismTags.Items.DATURA_CROP)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/spirit_torch"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismBlocks.STORAGE_CONTROLLER.get())).pattern("d").pattern("b").define(Character.valueOf('d'), (ItemLike)OccultismItems.DIMENSIONAL_MATRIX.get()).define(Character.valueOf('b'), (ItemLike)OccultismBlocks.STORAGE_CONTROLLER_BASE.get()).unlockedBy("has_dimensional_matrix", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.DIMENSIONAL_MATRIX.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/storage_controller"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)OccultismItems.STORAGE_REMOTE_INERT.get())).pattern("gtg").pattern("bgb").pattern("bbb").define(Character.valueOf('t'), (ItemLike)OccultismItems.OTHERSTONE_TABLET.get()).define(Character.valueOf('b'), ItemTags.STONE_BUTTONS).define(Character.valueOf('g'), Tags.Items.INGOTS_GOLD).unlockedBy("has_otherstone_tablet", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.OTHERSTONE_TABLET.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/storage_remote_inert"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.WORMHOLE_FRAME.get())).pattern(" g ").pattern("gog").pattern(" g ").define(Character.valueOf('g'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('o'), (ItemLike)OccultismItems.OTHERSTONE_FRAME.get()).unlockedBy("has_otherstone_frame", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.OTHERSTONE_FRAME.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/wormhole_frame"));
    }

    private void smeltingRecipes(RecipeOutput pRecipeOutput) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.OTHERSTONE.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BURNT_OTHERSTONE.get()), (float)0.15f, (int)200).unlockedBy("has_otherstone", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.OTHERSTONE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"smelting/burnt_otherstone"));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of(OccultismTags.Items.COPPER_DUST), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.COPPER_INGOT, (float)0.7f, (int)200).unlockedBy("has_copper_dust", OccultismRecipeProvider.has(OccultismTags.Items.COPPER_DUST)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"smelting/copper_ingot_from_dust"));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of(OccultismTags.Items.GOLD_DUST), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.GOLD_INGOT, (float)0.7f, (int)200).unlockedBy("has_gold_dust", OccultismRecipeProvider.has(OccultismTags.Items.GOLD_DUST)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"smelting/gold_ingot_from_dust"));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of(OccultismTags.Items.IESNIUM_ORE), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.IESNIUM_INGOT.get()), (float)0.7f, (int)200).unlockedBy("has_iesnium_ore", OccultismRecipeProvider.has(OccultismTags.Items.IESNIUM_ORE)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"smelting/iesnium_ingot"));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of(OccultismTags.Items.IESNIUM_DUST), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.IESNIUM_INGOT.get()), (float)0.7f, (int)200).unlockedBy("has_iesnium_dust", OccultismRecipeProvider.has(OccultismTags.Items.IESNIUM_DUST)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"smelting/iesnium_ingot_from_dust"));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of(OccultismTags.Items.RAW_IESNIUM), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.IESNIUM_INGOT.get()), (float)0.7f, (int)200).unlockedBy("has_raw_iesnium", OccultismRecipeProvider.has(OccultismTags.Items.RAW_IESNIUM)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"smelting/iesnium_ingot_from_raw"));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of(OccultismTags.Items.IRON_DUST), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.IRON_INGOT, (float)0.7f, (int)200).unlockedBy("has_iron_dust", OccultismRecipeProvider.has(OccultismTags.Items.IRON_DUST)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"smelting/iron_ingot_from_dust"));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of(OccultismTags.Items.SILVER_ORE), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.SILVER_INGOT.get()), (float)0.7f, (int)200).unlockedBy("has_silver_ore", OccultismRecipeProvider.has(OccultismTags.Items.SILVER_ORE)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"smelting/silver_ingot"));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of(OccultismTags.Items.SILVER_DUST), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.SILVER_INGOT.get()), (float)0.7f, (int)200).unlockedBy("has_silver_dust", OccultismRecipeProvider.has(OccultismTags.Items.SILVER_DUST)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"smelting/silver_ingot_from_dust"));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of(OccultismTags.Items.RAW_SILVER), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.SILVER_INGOT.get()), (float)0.7f, (int)200).unlockedBy("has_raw_silver", OccultismRecipeProvider.has(OccultismTags.Items.RAW_SILVER)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"smelting/silver_ingot_from_raw"));
    }
}

