/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.datagen.loot;

import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.common.block.crops.IReplantableCrops;
import com.klikli_dev.occultism.common.block.otherworld.IOtherworldBlock;
import com.klikli_dev.occultism.registry.OccultismBlocks;
import com.klikli_dev.occultism.registry.OccultismDataComponents;
import com.klikli_dev.occultism.registry.OccultismItems;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

public class OccultismBlockLoot
extends BlockLootSubProvider {
    protected static final float[] DEFAULT_SAPLING_DROP_RATES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};
    protected static final float[] INCREASED_SAPLING_DROP_RATES = new float[]{0.1f, 0.2f, 0.3f, 0.4f};

    public OccultismBlockLoot(HolderLookup.Provider pRegistries) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), pRegistries);
    }

    public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> pGenerator) {
        this.generate();
        this.map.forEach(pGenerator::accept);
    }

    @NotNull
    public Iterable<Block> getKnownBlocks() {
        return BuiltInRegistries.BLOCK.stream().filter(block -> Optional.of(BuiltInRegistries.BLOCK.getKey(block)).filter(key -> key.getNamespace().equals("occultism")).isPresent()).collect(Collectors.toSet());
    }

    protected void generate() {
        OccultismBlocks.BLOCKS.getEntries().stream().map(DeferredHolder::get).forEach(block -> {
            OccultismBlocks.BlockDataGenSettings settings = OccultismBlocks.BLOCK_DATA_GEN_SETTINGS.get(BuiltInRegistries.BLOCK.getKey(block));
            if (settings.lootTableType == OccultismBlocks.LootTableType.EMPTY) {
                this.registerDropNothingLootTable((Block)block);
            } else if (settings.lootTableType == OccultismBlocks.LootTableType.REPLANTABLE_CROP) {
                IReplantableCrops cropsBlock = (IReplantableCrops)block;
                LootItemBlockStatePropertyCondition.Builder lootCondition = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)CropBlock.AGE, 7));
                this.add((Block)block, this.createCropDrops((Block)block, cropsBlock.getCropsItem().asItem(), cropsBlock.getSeedsItem().asItem(), (LootItemCondition.Builder)lootCondition));
            } else if (settings.lootTableType == OccultismBlocks.LootTableType.DROP_SELF) {
                this.dropSelf((Block)block);
            } else if (settings.lootTableType == OccultismBlocks.LootTableType.OTHERWORLD_BLOCK) {
                this.registerOtherworldBlockTable((Block)block);
            }
        });
        this.add((Block)OccultismBlocks.OTHERWORLD_LEAVES.get(), block -> this.createLeavesDrops((Block)block, (Block)OccultismBlocks.OTHERWORLD_SAPLING.get(), DEFAULT_SAPLING_DROP_RATES));
        this.add((Block)OccultismBlocks.OTHERWORLD_LEAVES_NATURAL.get(), block -> this.createOtherworldLeavesDrops((Block)block, Blocks.OAK_SAPLING, (Block)OccultismBlocks.OTHERWORLD_SAPLING_NATURAL.get(), INCREASED_SAPLING_DROP_RATES));
        this.add((Block)OccultismBlocks.SILVER_ORE.get(), this.createOreDrop((Block)OccultismBlocks.SILVER_ORE.get(), (Item)OccultismItems.RAW_SILVER.get()));
        this.add((Block)OccultismBlocks.SILVER_ORE_DEEPSLATE.get(), this.createOreDrop((Block)OccultismBlocks.SILVER_ORE_DEEPSLATE.get(), (Item)OccultismItems.RAW_SILVER.get()));
        this.add((Block)OccultismBlocks.IESNIUM_ORE.get(), this.createOreDrop((Block)OccultismBlocks.IESNIUM_ORE.get(), (Item)OccultismItems.RAW_IESNIUM.get()));
        this.dropSelfWithComponents((Block)OccultismBlocks.STORAGE_CONTROLLER.get(), (DataComponentType)OccultismDataComponents.STORAGE_CONTROLLER_CONTENTS.get(), (DataComponentType)OccultismDataComponents.SORT_DIRECTION.get(), (DataComponentType)OccultismDataComponents.SORT_TYPE.get(), (DataComponentType)OccultismDataComponents.CRAFTING_MATRIX.get(), (DataComponentType)OccultismDataComponents.ORDER_STACK.get());
        this.dropSelfWithComponents((Block)OccultismBlocks.STABLE_WORMHOLE.get(), (DataComponentType)OccultismDataComponents.LINKED_STORAGE_CONTROLLER.get(), (DataComponentType)OccultismDataComponents.SORT_DIRECTION.get(), (DataComponentType)OccultismDataComponents.SORT_TYPE.get(), (DataComponentType)OccultismDataComponents.CRAFTING_MATRIX.get(), (DataComponentType)OccultismDataComponents.ORDER_STACK.get());
    }

    protected void registerOtherworldBlockTable(Block block) {
        if (block instanceof IOtherworldBlock) {
            this.add(block, this.createOtherworldBlockTable(block));
        } else {
            Occultism.LOGGER.warn("Tried to register otherworld block loot table for non-otherworld block {}", (Object)BuiltInRegistries.BLOCK.getKey((Object)block));
        }
    }

    protected LootTable.Builder createOtherworldBlockTable(Block block) {
        IOtherworldBlock otherworldBlock = (IOtherworldBlock)block;
        return this.createOtherworldBlockTable(block, (ItemLike)otherworldBlock.getCoveredBlock(), (ItemLike)otherworldBlock.getUncoveredBlock());
    }

    protected LootTable.Builder createOtherworldBlockTable(Block block, ItemLike coveredDrop, ItemLike uncoveredDrop) {
        LootItemBlockStatePropertyCondition.Builder uncoveredCondition = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty(IOtherworldBlock.UNCOVERED, true));
        LootPool.Builder builder = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)uncoveredDrop).when((LootItemCondition.Builder)uncoveredCondition)).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)coveredDrop)));
        return LootTable.lootTable().withPool(builder);
    }

    protected LootTable.Builder createOtherworldLeavesDrops(Block leavesBlock, Block coveredSapling, Block uncoveredSapling, float ... chances) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        LootItemBlockStatePropertyCondition.Builder uncoveredCondition = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)leavesBlock).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty(IOtherworldBlock.UNCOVERED, true));
        AlternativesEntry.Builder saplingLootItem = ((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)uncoveredSapling).when((LootItemCondition.Builder)uncoveredCondition)).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)coveredSapling));
        return this.createSilkTouchOrShearsDispatchTable(leavesBlock, ((AlternativesEntry.Builder)this.applyExplosionCondition((ItemLike)leavesBlock, (ConditionUserBuilder)saplingLootItem)).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float[])chances))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(this.doesNotHaveShearsOrSilkTouch()).add(((LootPoolSingletonContainer.Builder)this.applyExplosionDecay((ItemLike)leavesBlock, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float[])new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f}))));
    }

    public void registerDropNothingLootTable(Block block) {
    }

    protected final void dropSelfWithComponents(Block pBlock, DataComponentType<?> ... pIncludes) {
        this.dropSelfWithComponents(pBlock, this.copyComponents(pIncludes));
    }

    protected void dropSelfWithComponents(Block pBlock, CopyComponentsFunction.Builder data) {
        this.add(pBlock, this.createSelfWithComponentsDrop(pBlock, data));
    }

    protected LootTable.Builder createSelfWithComponentsDrop(Block pBlock, CopyComponentsFunction.Builder data) {
        return LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)pBlock, (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)pBlock).apply((LootItemFunction.Builder)data))));
    }

    protected CopyComponentsFunction.Builder copyComponents(DataComponentType<?> ... pIncludes) {
        CopyComponentsFunction.Builder builder = CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY);
        for (DataComponentType<?> include : pIncludes) {
            builder.include(include);
        }
        return builder;
    }

    private LootItemCondition.Builder hasShearsOrSilkTouch() {
        return HAS_SHEARS.or(this.hasSilkTouch());
    }

    private LootItemCondition.Builder doesNotHaveShearsOrSilkTouch() {
        return this.hasShearsOrSilkTouch().invert();
    }
}

