/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.datagen;

import com.klikli_dev.occultism.common.block.ChalkGlyphBlock;
import com.klikli_dev.occultism.common.block.storage.StableWormholeBlock;
import com.klikli_dev.occultism.registry.OccultismBlocks;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;

public class StandardBlockStateProvider
extends BlockStateProvider {
    public StandardBlockStateProvider(PackOutput gen, ExistingFileHelper exFileHelper) {
        super(gen, "occultism", exFileHelper);
    }

    protected void registerStatesAndModels() {
        OccultismBlocks.BLOCKS.getEntries().stream().map(DeferredHolder::get).filter(block -> block instanceof ChalkGlyphBlock).forEach(this::generateGlyphBlockState);
        this.simpleBlock((Block)OccultismBlocks.STORAGE_CONTROLLER.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/storage_controller")));
        this.models().withExistingParent("item/storage_controller", this.modLoc("block/storage_controller"));
        this.simpleBlock((Block)OccultismBlocks.STORAGE_CONTROLLER_BASE.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/storage_controller_base")));
        this.models().withExistingParent("item/storage_controller_base", this.modLoc("block/storage_controller_base"));
        this.generateStableWormholeState((Block)OccultismBlocks.STABLE_WORMHOLE.get());
        this.directionalBlock((Block)OccultismBlocks.SACRIFICIAL_BOWL.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/sacrificial_bowl")));
        this.directionalBlock((Block)OccultismBlocks.STORAGE_STABILIZER_TIER1.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/storage_stabilizer_tier1")));
        this.directionalBlock((Block)OccultismBlocks.STORAGE_STABILIZER_TIER2.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/storage_stabilizer_tier2")));
        this.directionalBlock((Block)OccultismBlocks.STORAGE_STABILIZER_TIER3.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/storage_stabilizer_tier3")));
        this.directionalBlock((Block)OccultismBlocks.STORAGE_STABILIZER_TIER4.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/storage_stabilizer_tier4")));
    }

    protected void generateStableWormholeState(Block block) {
        ModelFile.ExistingModelFile linkedModel = this.models().getExistingFile(this.modLoc("block/stable_wormhole"));
        ModelFile.ExistingModelFile unlinkedModel = this.models().getExistingFile(this.modLoc("block/stable_wormhole_unlinked"));
        this.getVariantBuilder(block).forAllStates(state -> {
            Direction dir = (Direction)state.getValue((Property)BlockStateProperties.FACING);
            return ConfiguredModel.builder().modelFile((ModelFile)((Boolean)state.getValue(StableWormholeBlock.LINKED) != false ? linkedModel : unlinkedModel)).rotationX(dir == Direction.DOWN ? 180 : (dir.getAxis().isHorizontal() ? 90 : 0)).rotationY(dir.getAxis().isVertical() ? 0 : ((int)dir.toYRot() + 180) % 360).build();
        });
    }

    protected void generateGlyphBlockState(Block block) {
        ModelFile.ExistingModelFile parent = this.models().getExistingFile(this.modLoc("block/chalk_glyph/chalk_glyph"));
        this.getVariantBuilder(block).forAllStates(state -> {
            int sign = (Integer)state.getValue((Property)ChalkGlyphBlock.SIGN);
            ModelBuilder subModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("block/chalk_glyph/" + sign)).parent((ModelFile)parent)).texture("texture", this.modLoc("block/chalk_glyph/" + sign));
            return ConfiguredModel.builder().modelFile((ModelFile)subModel).rotationY((int)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot()).build();
        });
    }
}

