/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.datagen;

import com.klikli_dev.modonomicon.api.ModonomiconAPI;
import com.klikli_dev.modonomicon.api.datagen.CategoryEntryMap;
import com.klikli_dev.modonomicon.api.datagen.ModonomiconLanguageProvider;
import com.klikli_dev.modonomicon.api.datagen.SingleBookSubProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookCategoryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryParentModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookAndConditionModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookConditionModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookEntryReadConditionModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookModLoadedConditionModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookTrueConditionModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookCraftingRecipePageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookEntityPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookImagePageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookMultiblockPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookSmeltingRecipePageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookSpotlightPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import com.klikli_dev.occultism.datagen.book.FamiliarRitualsCategory;
import com.klikli_dev.occultism.integration.modonomicon.pages.BookRitualRecipePageModel;
import com.klikli_dev.occultism.integration.modonomicon.pages.BookSpiritFireRecipePageModel;
import com.klikli_dev.occultism.integration.modonomicon.pages.BookSpiritTradeRecipePageModel;
import com.klikli_dev.occultism.registry.OccultismBlocks;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class OccultismBookProvider
extends SingleBookSubProvider {
    public static final String COLOR_PURPLE = "ad03fc";
    public static final String DEMONS_DREAM = "Demon's Dream";

    public OccultismBookProvider(ModonomiconLanguageProvider lang) {
        super("dictionary_of_spirits", "occultism", (BiConsumer)lang);
    }

    protected void registerDefaultMacros() {
    }

    protected void generateCategories() {
        int sortNum = 1;
        BookCategoryModel gettingStartedCategory = this.add(this.makeGettingStartedCategory().withSortNumber(sortNum++));
        BookCategoryModel spiritsCategory = this.add(this.makeSpiritsSubcategory().withSortNumber(sortNum++));
        BookCategoryModel storageCategory = this.add(this.makeStorageCategory().withSortNumber(sortNum++));
        BookCategoryModel ritualsCategory = this.add(this.makeRitualsCategory().withSortNumber(sortNum++));
        BookCategoryModel summoningRitualsCategory = this.add(this.makeSummoningRitualsSubcategory().withSortNumber(sortNum++));
        BookCategoryModel possessionRitualsCategory = this.add(this.makePossessionRitualsSubcategory().withSortNumber(sortNum++));
        BookCategoryModel craftingRitualsCategory = this.add(this.makeCraftingRitualsSubcategory().withSortNumber(sortNum++));
        BookCategoryModel familiarRitualsCategory = this.add(new FamiliarRitualsCategory(this).generate().withSortNumber(sortNum++));
        BookCategoryModel pentaclesCategory = this.add(this.makePentaclesCategory().withSortNumber(sortNum++));
        BookEntryReadConditionModel introReadCondition = BookEntryReadConditionModel.create().withEntry(this.modLoc("getting_started/intro"));
        spiritsCategory.withCondition((BookConditionModel)introReadCondition);
        storageCategory.withCondition((BookConditionModel)introReadCondition);
        ritualsCategory.withCondition((BookConditionModel)introReadCondition);
        summoningRitualsCategory.withCondition((BookConditionModel)introReadCondition);
        possessionRitualsCategory.withCondition((BookConditionModel)introReadCondition);
        craftingRitualsCategory.withCondition((BookConditionModel)introReadCondition);
        familiarRitualsCategory.withCondition((BookConditionModel)introReadCondition);
        pentaclesCategory.withCondition((BookConditionModel)introReadCondition);
    }

    protected String bookName() {
        return "Dictionary of Spirits";
    }

    protected String bookTooltip() {
        return "An introduction to the spirit world.";
    }

    protected BookModel additionalSetup(BookModel book) {
        return super.additionalSetup(book).withModel(this.modLoc("dictionary_of_spirits_icon")).withCraftingTexture(this.modLoc("textures/gui/book/crafting_textures.png")).withGenerateBookItem(false).withCustomBookItem(this.modLoc("dictionary_of_spirits")).withAutoAddReadConditions(true);
    }

    private BookCategoryModel makeGettingStartedCategory() {
        this.context().category("getting_started");
        this.lang().add(this.context().categoryName(), "Getting Started");
        CategoryEntryMap entryMap = ModonomiconAPI.get().getEntryMap();
        entryMap.setMap(new String[]{"______\u0155___t___B___________P___D___", "__________________________________", "______i___r___\u00e7_b_____g_I_O_l_M___", "__________________________________", "______d___f_c_____R___a_s_________", "__________________________________", "______e_h_____\u1ea1_______m___________", "__________________________________", "________________C___p_S___w_x_y_z_"});
        BookEntryModel introEntry = this.makeIntroEntry(entryMap, 'i');
        BookEntryModel demonsDreamEntry = this.makeDemonsDreamEntry(entryMap, 'd');
        demonsDreamEntry.withParent(BookEntryParentModel.create((ResourceLocation)introEntry.getId()));
        BookEntryModel spiritFireEntry = this.makeSpiritFireEntry(entryMap, 'f');
        spiritFireEntry.withParent(BookEntryParentModel.create((ResourceLocation)demonsDreamEntry.getId()));
        BookEntryModel healingSpiritsEntry = this.makeHealingSpiritsEntry(entryMap, 'h');
        healingSpiritsEntry.withParent(BookEntryParentModel.create((ResourceLocation)demonsDreamEntry.getId()));
        BookEntryModel thirdEyeEntry = this.makeThirdEyeEntry(entryMap, 'e');
        thirdEyeEntry.withParent(BookEntryParentModel.create((ResourceLocation)demonsDreamEntry.getId()));
        BookEntryModel divinationRodEntry = this.makeDivinationRodEntry(entryMap, 'r');
        divinationRodEntry.withParent(BookEntryParentModel.create((ResourceLocation)spiritFireEntry.getId()));
        BookEntryModel theurgyDivinationRodEntry = this.makeTheurgyDivinationRodsEntry(entryMap, 't');
        theurgyDivinationRodEntry.withParent(BookEntryParentModel.create((ResourceLocation)divinationRodEntry.getId())).withCondition((BookConditionModel)BookAndConditionModel.create().withChildren(new BookConditionModel[]{BookEntryReadConditionModel.create().withEntry(divinationRodEntry.getId()), BookModLoadedConditionModel.create().withModId("theurgy")})).hideWhileLocked(true);
        BookEntryModel candleEntry = this.makeCandleEntry(entryMap, 'c');
        candleEntry.withParent(BookEntryParentModel.create((ResourceLocation)spiritFireEntry.getId()));
        BookEntryModel ritualPrepChalkEntry = this.makeRitualPrepChalkEntry(entryMap, '\u00e7');
        ritualPrepChalkEntry.withParent(BookEntryParentModel.create((ResourceLocation)candleEntry.getId()));
        BookEntryModel brushEntry = this.makeBrushEntry(entryMap, 'B');
        brushEntry.withParent(BookEntryParentModel.create((ResourceLocation)ritualPrepChalkEntry.getId()));
        BookEntryModel ritualPrepBowlEntry = this.makeRitualPrepBowlEntry(entryMap, 'b');
        ritualPrepBowlEntry.withParent(BookEntryParentModel.create((ResourceLocation)ritualPrepChalkEntry.getId()));
        BookEntryModel booksOfBinding = this.makeBooksOfBindingEntry(entryMap, '\u1ea1');
        booksOfBinding.withParent(BookEntryParentModel.create((ResourceLocation)candleEntry.getId()));
        BookEntryModel booksOfCalling = this.makeBooksOfCallingEntry(entryMap, 'C');
        booksOfCalling.withParent(BookEntryParentModel.create((ResourceLocation)booksOfBinding.getId()));
        BookEntryModel ritualEntry = this.makeRitualEntry(entryMap, 'R');
        ritualEntry.withParent(BookEntryParentModel.create((ResourceLocation)ritualPrepBowlEntry.getId())).withParent(BookEntryParentModel.create((ResourceLocation)booksOfBinding.getId()));
        BookEntryModel advancedChalksEntry = this.makeChalksEntry(entryMap, 'a');
        advancedChalksEntry.withParent(BookEntryParentModel.create((ResourceLocation)ritualEntry.getId()));
        BookEntryModel moreRitualsEntry = this.makeMoreRitualsEntry(entryMap, 'm');
        moreRitualsEntry.withParent(BookEntryParentModel.create((ResourceLocation)advancedChalksEntry.getId()));
        BookEntryModel greyParticlesEntry = this.makeGreyParticlesEntry(entryMap, 'p');
        greyParticlesEntry.withParent(BookEntryParentModel.create((ResourceLocation)ritualEntry.getId()));
        BookEntryModel spiritsSubcategory = this.makeSpiritsSubcategoryEntry(entryMap, 'S');
        spiritsSubcategory.withParent(BookEntryParentModel.create((ResourceLocation)greyParticlesEntry.getId()));
        BookEntryModel otherworldGoggles = this.makeOtherworldGogglesEntry(entryMap, 'g');
        otherworldGoggles.withParent(BookEntryParentModel.create((ResourceLocation)advancedChalksEntry.getId()));
        BookEntryModel infusedPickaxe = this.makeInfusedPickaxeEntry(entryMap, 'I');
        infusedPickaxe.withParent(BookEntryParentModel.create((ResourceLocation)otherworldGoggles.getId()));
        BookEntryModel iesnium = this.makeIesniumEntry(entryMap, 'O');
        iesnium.withParent(BookEntryParentModel.create((ResourceLocation)infusedPickaxe.getId()));
        BookEntryModel iesniumPickaxe = this.makeIesniumPickaxeEntry(entryMap, 'P');
        iesniumPickaxe.withParent(BookEntryParentModel.create((ResourceLocation)iesnium.getId()));
        BookEntryModel magicLampsEntry = this.makeMagicLampsEntry(entryMap, 'l');
        magicLampsEntry.withParent(BookEntryParentModel.create((ResourceLocation)iesnium.getId()));
        BookEntryModel spiritMinersEntry = this.makeSpiritMinersEntry(entryMap, 'M');
        spiritMinersEntry.withParent(BookEntryParentModel.create((ResourceLocation)magicLampsEntry.getId()));
        BookEntryModel mineshaftEntry = this.makeMineshaftEntry(entryMap, 'D');
        mineshaftEntry.withParent(BookEntryParentModel.create((ResourceLocation)spiritMinersEntry.getId()));
        BookEntryModel storageEntry = this.makeStorageEntry(entryMap, 's');
        storageEntry.withParent(BookEntryParentModel.create((ResourceLocation)advancedChalksEntry.getId()));
        BookEntryModel possessionRitualsEntry = this.makePossessionRitualsEntry(entryMap, 'w');
        possessionRitualsEntry.withParent(BookEntryParentModel.create((ResourceLocation)moreRitualsEntry.getId()));
        BookEntryModel familiarRitualsEntry = this.makeFamiliarRitualsEntry(entryMap, 'x');
        familiarRitualsEntry.withParent(BookEntryParentModel.create((ResourceLocation)moreRitualsEntry.getId()));
        BookEntryModel summoningRitualsEntry = this.makeSummoningRitualsEntry(entryMap, 'y');
        summoningRitualsEntry.withParent(BookEntryParentModel.create((ResourceLocation)moreRitualsEntry.getId()));
        BookEntryModel craftingRitualsEntry = this.makeCraftingRitualsEntry(entryMap, 'z');
        craftingRitualsEntry.withParent(BookEntryParentModel.create((ResourceLocation)moreRitualsEntry.getId()));
        return BookCategoryModel.create((ResourceLocation)this.modLoc(this.context().categoryId()), (String)this.context().categoryName()).withIcon((ItemLike)OccultismItems.DICTIONARY_OF_SPIRITS_ICON.get()).withEntries(new BookEntryModel[]{introEntry, demonsDreamEntry, spiritFireEntry, thirdEyeEntry, healingSpiritsEntry, divinationRodEntry, theurgyDivinationRodEntry, candleEntry, ritualPrepChalkEntry, ritualPrepBowlEntry, booksOfBinding, ritualEntry, brushEntry, moreRitualsEntry, greyParticlesEntry, booksOfCalling, spiritsSubcategory, advancedChalksEntry, otherworldGoggles, infusedPickaxe, iesnium, iesniumPickaxe, magicLampsEntry, spiritMinersEntry, mineshaftEntry, storageEntry, possessionRitualsEntry, familiarRitualsEntry, summoningRitualsEntry, craftingRitualsEntry});
    }

    private BookEntryModel makeIntroEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("intro");
        this.lang().add(this.context().entryName(), "About");
        this.lang().add(this.context().entryDescription(), "About using the Dictionary of Spirits");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "About");
        this.lang().add(this.context().pageText(), "This book aims to introduce the novice reader to the most common summoning rituals and equip them with a list of spirit names to summon.\nThe authors advise caution in the summoning of the listed entities and does not take responsibility for any harm caused.\n");
        this.context().page("help");
        BookTextPageModel help = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Getting Help");
        this.lang().add(this.context().pageText(), "If you run into any trouble while playing Occultism, please join our Discord server and ask for help.\n\\\n\\\n[Join us at https://invite.gg/klikli](https://invite.gg/klikli)\n");
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)OccultismItems.DICTIONARY_OF_SPIRITS_ICON.get()).withLocation(entryMap.get(Character.valueOf(icon))).withEntryBackground(0, 1).withPages(new BookPageModel[]{intro, help});
    }

    private BookEntryModel makeDemonsDreamEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("demons_dream");
        this.lang().add(this.context().entryName(), "Lifting the Veil");
        this.lang().add(this.context().entryDescription(), "Learn about the Otherworld and the Third Eye.");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "The Otherworld");
        this.lang().add(this.context().pageText(), "Hidden from mere human eyes exists another plane of existence, another *dimension* if you will, the [#](%1$s)Otherworld[#]().\nThis world is populated with entities often referred to as [#](%1$s)Demons[#]().\n".formatted(COLOR_PURPLE));
        this.context().page("intro2");
        BookTextPageModel intro2 = BookTextPageModel.create().withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "These Demons possess a wide variety of powers and useful skills, and for centuries magicians have sought to summon them for their own gain.\nThe first step on the journey to successfully summoning such an Entity is to learn how to interact with the Otherworld.\n");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.DATURA.get()})).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "%1$s is a herb that gives humans the [#](%2$s)Third Eye[#](),\nallowing them to see where the [#](%2$s)Otherworld[#]() intersects with our own.\nSeeds can be found **by breaking grass**.\n**Consuming** the grown fruit activates the ability *with a certain chance*.\n".formatted(DEMONS_DREAM, COLOR_PURPLE));
        this.context().page("harvest_effect");
        BookTextPageModel harvestEffect = BookTextPageModel.create().withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "An additional side effect of %1$s, is **the ability to interact with [#](%2$s)Otherworld[#]() materials**.\nThis is unique to %1$s, other ways to obtain [#](%2$s)Third Eye[#]() do not yield this ability.\nWhile under the effect of %1$s you are able to **harvest** Otherstone as well as Otherworld trees.\n".formatted(DEMONS_DREAM, COLOR_PURPLE));
        this.context().page("datura_screenshot");
        BookImagePageModel datureScreenshot = BookImagePageModel.create().withImages(new ResourceLocation[]{this.modLoc("textures/gui/book/datura_effect.png")});
        this.context().page("note_on_spirit_fire");
        BookTextPageModel spiritFire = BookTextPageModel.create().withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "**Hint**: The otherworld materials you obtain by harvesting under the effects of[#](%2$s)Third Eye[#]() **can be obtained more easily using [](item://occultism:spirit_fire)**. Proceed with the next entry in this book to learn more about spirit fire.\n".formatted(DEMONS_DREAM, COLOR_PURPLE));
        this.context().page("spotlight2");
        BookSpotlightPageModel spotlight2 = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.DEMONS_DREAM_ESSENCE.get()})).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "Multiple Demon's Dream fruits or seeds can be compressed into an essence that is much more potent. It *guarantees* the [#](%2$s)Third Eye[#]() and provides it for a longer amount of time, but comes with a lot of (positive and negative) side effects.\n".formatted(DEMONS_DREAM, COLOR_PURPLE));
        this.context().page("recipe_essence");
        BookCraftingRecipePageModel recipeEssence = (BookCraftingRecipePageModel)((BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/demons_dream_essence_from_fruit_or_seed"))).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "Fruit and seeds can be mixed freely to create the essence.\n");
        this.context().page("spotlight3");
        BookSpotlightPageModel spotlight3 = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.DEMONS_DREAM_ESSENCE.get()})).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "The essence can be purified in spirit fire (more on that later!) to obtain a version free from all negative side effects, while retaining the positive.\n".formatted(DEMONS_DREAM, COLOR_PURPLE));
        this.context().page("recipe_essence_pure");
        BookSpiritFireRecipePageModel recipeEssencePure = (BookSpiritFireRecipePageModel)BookSpiritFireRecipePageModel.create().withRecipeId1(this.modLoc("spirit_fire/otherworld_essence"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)OccultismItems.DATURA.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, intro2, spotlight, harvestEffect, datureScreenshot, spiritFire, spotlight2, recipeEssence, spotlight3, recipeEssencePure});
    }

    private BookEntryModel makeSpiritFireEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("spirit_fire");
        this.lang().add(this.context().entryName(), "It burns!");
        this.lang().add(this.context().entryDescription(), "Or does it?");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.SPIRIT_FIRE.get()})).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "[#](%1$s)Spiritfire[#]() is a special type of fire that exists mostly in [#](%1$s)The Other Place[#]()\nand does not harm living beings. Its special properties allow to use it to purify and convert\ncertain materials by burning them, without consuming them.\n".formatted(COLOR_PURPLE));
        this.context().page("spirit_fire_screenshot");
        BookImagePageModel spiritFireScreenshot = BookImagePageModel.create().withImages(new ResourceLocation[]{this.modLoc("textures/gui/book/spiritfire_instructions.png")}).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "Throw [](item://occultism:datura) to the ground and light it on fire with [](item://minecraft:flint_and_steel).\n");
        this.context().page("main_uses");
        BookTextPageModel mainUses = BookTextPageModel.create().withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "The main uses of [](item://occultism:spirit_fire) are to convert [](item://minecraft:diamond) into [](item://occultism:spirit_attuned_gem),\nto get basic ingredients such as [](item://occultism:otherstone) and [Otherworld Saplings](item://occultism:otherworld_sapling_natural),\nand to purify impure chalks.\n");
        this.context().page("otherstone_recipe");
        BookSpiritFireRecipePageModel otherstoneRecipe = (BookSpiritFireRecipePageModel)((BookSpiritFireRecipePageModel)BookSpiritFireRecipePageModel.create().withRecipeId1(this.modLoc("spirit_fire/otherstone"))).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "An easier way to obtain [](item://occultism:otherstone) than via divination.\n");
        this.context().page("otherworld_sapling_natural_recipe");
        BookSpiritFireRecipePageModel otherworldSaplingNaturalRecipe = (BookSpiritFireRecipePageModel)((BookSpiritFireRecipePageModel)BookSpiritFireRecipePageModel.create().withRecipeId1(this.modLoc("spirit_fire/otherworld_sapling_natural"))).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "An easier way to obtain [Otherworld Saplings](item://occultism:otherworld_sapling_natural) than via divination.\n");
        this.context().page("otherworld_ashes_recipe");
        BookSpiritFireRecipePageModel otherworldAshesRecipe = (BookSpiritFireRecipePageModel)BookSpiritFireRecipePageModel.create().withRecipeId1(this.modLoc("spirit_fire/otherworld_ashes"));
        this.context().page("gem_recipe");
        BookSpiritFireRecipePageModel gemRecipe = (BookSpiritFireRecipePageModel)BookSpiritFireRecipePageModel.create().withRecipeId1(this.modLoc("spirit_fire/spirit_attuned_gem"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)OccultismItems.SPIRIT_FIRE.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, spiritFireScreenshot, mainUses, otherstoneRecipe, otherworldSaplingNaturalRecipe, otherworldAshesRecipe, gemRecipe});
    }

    private BookEntryModel makeHealingSpiritsEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("healing_spirits");
        this.lang().add(this.context().entryName(), "Healing Spirits");
        this.lang().add(this.context().entryDescription(), "Fix up your spirit!");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.DATURA.get()})).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "Right-click a spirit with [](item://occultism:datura) to heal it.\n\\\n\\\nThis will work on **Familiars**, **Summoned Spirits** and also **Possessed Mobs**.\n");
        this.context().page("spotlight2");
        BookSpotlightPageModel spotlight2 = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.DEMONS_DREAM_ESSENCE.get()})).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "When compressing Demon's Dream fruits or seeds into essence, a much stronger instant healing effect can be achieved. This comes at the cost of efficiency: Feeding 9 fruits to a spirit in succession will heal it more than feeding it 9 fruits worth of essence.\n");
        this.context().page("spotlight3");
        BookSpotlightPageModel spotlight3 = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.OTHERWORLD_ESSENCE.get()})).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "Purifying the Demon's Dream Essence will yield a version that heals even more, negating the efficiency loss.\n");
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)Items.SPLASH_POTION).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, spotlight2, spotlight3});
    }

    private BookEntryModel makeThirdEyeEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("third_eye");
        this.lang().add(this.context().entryName(), "The Third Eye");
        this.lang().add(this.context().entryDescription(), "Do you see now?");
        this.context().page("about");
        BookTextPageModel about = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Third Eye");
        this.lang().add(this.context().pageText(), "The ability to see beyond the physical world is referred to as [#](%1$s)Third Eye[#]().\nHumans do not possess such an ability to see [#](%1$s)beyond the veil[#](),\nhowever with certain substances and contraptions the knowledgeable summoner can work around this limitation.\n".formatted(COLOR_PURPLE));
        this.context().page("how_to_obtain");
        BookTextPageModel howToObtain = BookTextPageModel.create().withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "The most comfortable, and most *expensive*, way to obtain this ability, is to wear spectacles\ninfused with spirits, that *lend* their sight to the wearer.\nA slightly more nauseating, but **very affordable** alternative is the consumption of certain herbs,\n[%1$s](entry://occultism:dictionary_of_spirits/getting_started/demons_dream) most prominent among them.\n".formatted(DEMONS_DREAM));
        this.context().page("otherworld_goggles");
        BookSpotlightPageModel otherworldGoggles = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.OTHERWORLD_GOGGLES.get()})).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "[These goggles](entry://occultism:dictionary_of_spirits/crafting_rituals/craft_otherworld_goggles) allow to see even more hidden Otherworld blocks,\nhowever they do not allow harvesting those materials.\nLow-tier materials can be harvested by consuming [%1$s](entry://occultism:dictionary_of_spirits/getting_started/demons_dream),\nbut more valuable materials require special tools.\n".formatted(DEMONS_DREAM));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon(this.modLoc("textures/mob_effect/third_eye.png")).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{about, howToObtain, otherworldGoggles});
    }

    private BookEntryModel makeDivinationRodEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("divination_rod");
        this.lang().add(this.context().entryName(), "Divination Rod");
        this.lang().add(this.context().entryDescription(), "Obtaining otherworld materials");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Divination");
        this.lang().add(this.context().pageText(), "To make it easier to get started, the materials obtained by divination now also have crafting recipes.\n**If you want the full experience, skip the following recipe page and move on to the\n[divination instructions](entry://occultism:dictionary_of_spirits/getting_started/divination_rod@divination_instructions).**\n");
        this.context().page("otherstone_recipe");
        BookSpiritFireRecipePageModel otherstoneRecipe = (BookSpiritFireRecipePageModel)BookSpiritFireRecipePageModel.create().withRecipeId1(this.modLoc("spirit_fire/otherstone"));
        this.context().page("otherworld_sapling_natural_recipe");
        BookSpiritFireRecipePageModel otherworldSaplingNaturalRecipe = (BookSpiritFireRecipePageModel)((BookSpiritFireRecipePageModel)BookSpiritFireRecipePageModel.create().withRecipeId1(this.modLoc("spirit_fire/otherworld_sapling_natural"))).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "**Beware**: the tree growing from the sapling will look like a normal oak tree.\nYou need to activate the [Third Eye](entry://occultism:dictionary_of_spirits/getting_started/demons_dream)\nto harvest the Otherworld Logs and Leaves.\n");
        this.context().page("divination_rod");
        BookSpotlightPageModel divinationRod = (BookSpotlightPageModel)BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.DIVINATION_ROD.get()})).withText(this.context().pageText()).withAnchor("divination_instructions");
        this.lang().add(this.context().pageText(), "Otherworld materials play an important role in interacting with spirits.\nAs they are rare and not visible to the naked eye, finding them requires special tools.\nThe divination rod allows to find Otherworld materials based on their similarities to materials common to our world.\n");
        this.context().page("spirit_attuned_gem_recipe");
        BookSpiritFireRecipePageModel spiritAttunedGemRecipe = (BookSpiritFireRecipePageModel)BookSpiritFireRecipePageModel.create().withRecipeId1(this.modLoc("spirit_fire/spirit_attuned_gem"));
        this.context().page("divination_rod_recipe");
        BookCraftingRecipePageModel divinationRodRecipe = (BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/divination_rod"));
        this.context().page("about_divination_rod");
        BookTextPageModel aboutDivinationRod = BookTextPageModel.create().withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "The divination rod uses a spirit attuned gem attached to a wooden rod.\nThe gem resonates with the chosen material, and this movement is amplified by the wooden rod,\nallowing to detect nearby Otherworld materials.    \n    \n    \nThe rod works by detecting resonance between real world and Otherworld materials.\nAttuned the rod to a real world material, and it will find the corresponding Otherworld block.\n");
        this.context().page("how_to_use");
        BookTextPageModel howToUse = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Use of the Rod");
        this.lang().add(this.context().pageText(), "[#](%1$s)Shift-right-click[#]() a block to attune the rod to the corresponding Otherworld block.\n- [](item://minecraft:andesite): [](item://occultism:otherstone)\n- [](item://minecraft:oak_wood):  [](item://occultism:otherworld_log)\n- [](item://minecraft:oak_leaves): [](item://occultism:otherworld_leaves)\n- [](item://minecraft:netherrack): [](item://occultism:iesnium_ore)\n\nThen [#](%1$s)right-click[#]() and hold until the rod animation finishes.".formatted(COLOR_PURPLE));
        this.context().page("how_to_use2");
        BookTextPageModel howToUse2 = BookTextPageModel.create().withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "After the animation finishes, the closest **found block will be highlighted\nwith white lines and can be seen through other blocks**.\nAdditionally you can watch the crystals for hints: a white crystal indicates no target blocks found,\na fully purple block means the found block is nearby. Mixes between white and purple show\nthat the target is rather far away.");
        this.context().page("how_to_use3");
        BookTextPageModel howToUse3 = BookTextPageModel.create().withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "[#](%1$s)Right-clicking[#]() without holding after a successful search will show the last found target block again.\n\\\n\\\nIf the mod *\"Theurgy\"* is installed the rod will not highlight the target block, but instead send a particle effect in the direction of the target block.\n".formatted(COLOR_PURPLE));
        this.context().page("divination_rod_screenshots");
        BookImagePageModel divinationRodScreenshots = BookImagePageModel.create().withImages(new ResourceLocation[]{this.modLoc("textures/gui/book/rod_far.png"), this.modLoc("textures/gui/book/rod_mid.png"), this.modLoc("textures/gui/book/rod_near.png")}).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "White means nothing was found.\nThe more purple you see, the closer you are.\n");
        this.context().page("troubleshooting");
        BookTextPageModel troubleshooting = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Troubleshooting");
        this.lang().add(this.context().pageText(), "If the rod does not create highlighted blocks for you, you can try to:\n- install theurgy, then a particle effect will be used instead\n- Open occultism-client.toml in your instance's /config folder and set useAlternativeDivinationRodRenderer = true\n");
        this.context().page("otherworld_groves");
        BookTextPageModel otherworldGroves = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Otherworld Groves");
        this.lang().add(this.context().pageText(), "Otherworld Groves are lush, overgrown caves, with [#](%1$s)Otherworld Trees[#](),\nand walls of [](item://occultism:otherstone), and represent the fastest way to get everything one\nneeds to get set up as a summoner.\nTo find them, attune your divination rod to Otherworld leaves\nor logs, as unlike Otherstone, they only spawn in these groves.\n".formatted(COLOR_PURPLE));
        this.context().page("otherworld_groves_2");
        BookTextPageModel otherworldGroves2 = BookTextPageModel.create().withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "**Hint:** In the Overworld, look **down**.\n");
        this.context().page("otherworld_trees");
        BookTextPageModel otherworldTrees = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Otherworld Trees");
        this.lang().add(this.context().pageText(), "Otherworld trees grow naturally in Otherworld Groves. To the naked eye they appear as oak trees,\nbut to the Third Eye they reveal their true nature.    \n**Important:** Otherworld Saplings can only be obtained by breaking the leaves manually, naturally only oak saplings drop.\n");
        this.context().page("otherworld_trees_2");
        BookTextPageModel otherworldTrees2 = BookTextPageModel.create().withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "Trees grown from Stable Otherworld Saplings as obtained from spirit traders do not have that limitation.\n");
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)OccultismItems.DIVINATION_ROD.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, otherstoneRecipe, otherworldSaplingNaturalRecipe, divinationRod, spiritAttunedGemRecipe, divinationRodRecipe, aboutDivinationRod, howToUse, howToUse2, howToUse3, divinationRodScreenshots, troubleshooting, otherworldGroves, otherworldGroves2, otherworldTrees, otherworldTrees2});
    }

    private BookEntryModel makeTheurgyDivinationRodsEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("theurgy_divination_rod");
        this.lang().add(this.context().entryName(), "More Divination Rods");
        this.lang().add(this.context().entryDescription(), "Finding other ores and resources.");
        this.context().page("intro");
        BookSpotlightPageModel intro = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.DIVINATION_ROD_T1.get()})).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "While the [](item://occultism:divination_rod) is a great tool for finding [#](%1$s)Otherworld Materials[#](), it would be useful to have a way to find *all other* ores and resources as well.\n\\\n\\\nThis is where the Theurgy Divination Rod comes in.\n".formatted(COLOR_PURPLE));
        this.context().page("recipe_rod");
        BookCraftingRecipePageModel recipeRod = (BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1("theurgy:crafting/shaped/divination_rod_t1");
        this.context().page("more_info");
        BookTextPageModel moreInfo = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "More Information");
        this.lang().add(this.context().pageText(), "To find out more about the Theurgy Divination Rod, check out *\"The Hermetica\"*, the Guidebook for Theurgy.\n[This Entry](entry://theurgy:the_hermetica/getting_started/about_divination_rods) has more information about the Theurgy Divination Rod.\n");
        this.context().page("recipe_hermetica");
        BookCraftingRecipePageModel recipeHermetica = (BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1("theurgy:crafting/shapeless/the_hermetica");
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)ItemRegistry.DIVINATION_ROD_T1.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, recipeRod, moreInfo, recipeHermetica});
    }

    private BookEntryModel makeCandleEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("candle");
        this.lang().add(this.context().entryName(), "Candles");
        this.lang().add(this.context().entryDescription(), "Let there be light!");
        this.context().page("intro");
        BookSpotlightPageModel intro = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.CANDLE_WHITE.get()})).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "Candles provide stability to rituals and are an important part of almost all pentacles.\n**Candles also act like bookshelves for enchantment purposes.**\n\\\n\\\nCandles from Minecraft and other Mods may be used in place of Occultism candles.\n");
        this.context().page("tallow");
        BookSpotlightPageModel tallow = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.TALLOW.get()})).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "Key ingredient for candles. Kill large animals like pigs, cows or sheep with a [](item://occultism:butcher_knife)\nto harvest [](item://occultism:tallow).\n");
        this.context().page("cleaver_recipe");
        BookCraftingRecipePageModel cleaverRecipe = (BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/butcher_knife"));
        this.context().page("candle_recipe");
        BookCraftingRecipePageModel candleRecipe = (BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/candle"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)OccultismBlocks.CANDLE_WHITE.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, tallow, cleaverRecipe, candleRecipe});
    }

    private BookEntryModel makeRitualPrepChalkEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("ritual_prep_chalk");
        this.lang().add(this.context().entryName(), "Ritual Preparations: Chalks");
        this.lang().add(this.context().entryDescription(), "Signs to find them, Signs to bring them all, and in the darkness bind them.");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Ritual Preparations: Chalks");
        this.lang().add(this.context().pageText(), "To summon spirits from the [#](%1$s)Other Place[#]() in *relative* safety,\nyou need to draw a fitting pentacle using chalk to contain their powers.\n".formatted(COLOR_PURPLE));
        this.context().page("white_chalk");
        BookSpotlightPageModel whiteChalkSpotlight = (BookSpotlightPageModel)BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.CHALK_WHITE.get()})).withText(this.context().pageText()).withAnchor("white_chalk");
        this.lang().add(this.context().pageText(), "White chalk is used to draw the most basic pentacles, such as for our first ritual.\n\\\n\\\nMore powerful summonings require appropriate more advanced chalk, see [Chalks](entry://occultism:dictionary_of_spirits/getting_started/chalks) for more information.\n");
        this.context().page("burnt_otherstone_recipe");
        BookSmeltingRecipePageModel burntOtherstoneRecipe = (BookSmeltingRecipePageModel)BookSmeltingRecipePageModel.create().withRecipeId1(this.modLoc("smelting/burnt_otherstone"));
        this.context().page("otherworld_ashes_recipe");
        BookSpiritFireRecipePageModel otherworldAshesRecipe = (BookSpiritFireRecipePageModel)BookSpiritFireRecipePageModel.create().withRecipeId1(this.modLoc("spirit_fire/otherworld_ashes"));
        this.context().page("impure_white_chalk_recipe");
        BookCraftingRecipePageModel impureWhiteChalkRecipe = (BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/chalk_white_impure"));
        this.context().page("white_chalk_recipe");
        BookSpiritFireRecipePageModel whiteChalkRecipe = (BookSpiritFireRecipePageModel)BookSpiritFireRecipePageModel.create().withRecipeId1(this.modLoc("spirit_fire/chalk_white"));
        this.context().page("usage");
        BookTextPageModel usage = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Usage");
        this.lang().add(this.context().pageText(), "Right-click on a block with the chalk to draw a single glyph. For decorative purposes you can repeatedly click a block to cycle through glyphs. The shown glyph does not matter for the ritual, only the color.\n".formatted(COLOR_PURPLE));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)OccultismItems.CHALK_WHITE.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, whiteChalkSpotlight, burntOtherstoneRecipe, otherworldAshesRecipe, impureWhiteChalkRecipe, whiteChalkRecipe, usage});
    }

    private BookEntryModel makeRitualPrepBowlEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("ritual_prep_bowl");
        this.lang().add(this.context().entryName(), "Ritual Preparations: Sacrificial Bowls");
        this.lang().add(this.context().entryDescription(), "There is no power without sacrifice.");
        this.context().page("sacrificial_bowl");
        BookSpotlightPageModel sacrificialBowlSpotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.SACRIFICIAL_BOWL.get()})).withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Ritual Preparations: Sacrificial Bowls");
        this.lang().add(this.context().pageText(), "These bowls are used to place the items we will sacrifice as part of a ritual and you will need a handful of them.\nNote: Their exact placement in the ritual does not matter - just keep them within 8 blocks horizontally of the pentacle center!\n");
        this.context().page("sacrificial_bowl_recipe");
        BookCraftingRecipePageModel sacrificialBowlRecipe = (BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/sacrificial_bowl"));
        this.context().page("golden_sacrificial_bowl");
        BookSpotlightPageModel goldenSacrificialBowlSpotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.GOLDEN_SACRIFICIAL_BOWL.get()})).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "Once everything has been set up and you are ready to start, this special sacrificial bowl is used to activate the ritual by [#](%1$s)right-clicking[#]() it with the activation item,\nusually a [Book of Binding](entry://getting_started/books_of_binding).\n".formatted(COLOR_PURPLE));
        this.context().page("golden_sacrificial_bowl_recipe");
        BookCraftingRecipePageModel goldenSacrificialBowlRecipe = (BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/golden_sacrificial_bowl"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)OccultismBlocks.GOLDEN_SACRIFICIAL_BOWL.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{sacrificialBowlSpotlight, sacrificialBowlRecipe, goldenSacrificialBowlSpotlight, goldenSacrificialBowlRecipe});
    }

    private BookEntryModel makeBooksOfBindingEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("books_of_binding");
        this.lang().add(this.context().entryName(), "Books of Binding");
        this.lang().add(this.context().entryDescription(), "Or how to identify your spirit");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Books of Binding");
        this.lang().add(this.context().pageText(), "To call forth a spirit, a [#](%1$s)Book of Binding[#]() must be used in the ritual.\nThere is a type of book corresponding to each type (or tier) of spirit.\nTo identify a spirit to summon, it's name must be written in the [#](%1$s)Book of Binding[#](), resulting in a [#](%1$s)Bound Book of Binding[#]() that can be used in the ritual.\n".formatted(COLOR_PURPLE));
        this.context().page("intro2");
        BookTextPageModel intro2 = BookTextPageModel.create().withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "**Note:** *The spirit names are eye candy only*, that means they are not relevant for the recipe. As long as you have the right spirit type in your book of binding it can be used.\n".formatted(COLOR_PURPLE));
        this.context().page("purified_ink_recipe");
        BookSpiritFireRecipePageModel purifiedInkRecipe = (BookSpiritFireRecipePageModel)((BookSpiritFireRecipePageModel)BookSpiritFireRecipePageModel.create().withRecipeId1(this.modLoc("spirit_fire/purified_ink"))).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "In order to craft [#](%1$s)Books of Binding[#]() to summon spirits, you need purified ink. Simply drop any black dye into [](item://occultism:spirit_fire) to purify it.\n".formatted(COLOR_PURPLE));
        this.context().page("awakened_feather_recipe");
        BookSpiritFireRecipePageModel awakenedFeatherRecipe = (BookSpiritFireRecipePageModel)((BookSpiritFireRecipePageModel)BookSpiritFireRecipePageModel.create().withRecipeId1(this.modLoc("spirit_fire/awakened_feather"))).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "In order to craft [#](%1$s)Books of Binding[#]() to summon spirits, you also need awakened feather. Simply drop any feather into [](item://occultism:spirit_fire) to awakened it.\n".formatted(COLOR_PURPLE));
        this.context().page("taboo_book_recipe");
        BookSpiritFireRecipePageModel tabooBookRecipe = (BookSpiritFireRecipePageModel)((BookSpiritFireRecipePageModel)BookSpiritFireRecipePageModel.create().withRecipeId1(this.modLoc("spirit_fire/taboo_book"))).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "Lastly you need taboo book to craft [#](%1$s)Books of Binding[#]() to summon spirits. Simply drop a book into [](item://occultism:spirit_fire) to get it.\n".formatted(COLOR_PURPLE));
        this.context().page("book_of_binding_foliot_recipe");
        BookCraftingRecipePageModel bookOfBindingFoliotRecipe = (BookCraftingRecipePageModel)((BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/book_of_binding_foliot"))).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "Craft a book of binding that will be used to call forth a [#](%1$s)Foliot[#]() spirit.\n".formatted(COLOR_PURPLE));
        this.context().page("book_of_binding_bound_foliot_recipe");
        BookCraftingRecipePageModel bookOfBindingBoundFoliotRecipe = (BookCraftingRecipePageModel)((BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/book_of_binding_bound_foliot"))).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "Add the name of the spirit to summon to your book of binding by crafting it with the Dictionary of Spirits. The Dictionary will not be used up.\n");
        this.context().page("book_of_binding_djinni_recipe");
        BookCraftingRecipePageModel bookOfBindingDjinniRecipe = (BookCraftingRecipePageModel)((BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/book_of_binding_djinni"))).withRecipeId2(this.modLoc("crafting/book_of_binding_bound_djinni"));
        this.context().page("book_of_binding_afrit_recipe");
        BookCraftingRecipePageModel bookOfBindingAfritRecipe = (BookCraftingRecipePageModel)((BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/book_of_binding_afrit"))).withRecipeId2(this.modLoc("crafting/book_of_binding_bound_afrit"));
        this.context().page("book_of_binding_marid_recipe");
        BookCraftingRecipePageModel bookOfBindingMaridRecipe = (BookCraftingRecipePageModel)((BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/book_of_binding_marid"))).withRecipeId2(this.modLoc("crafting/book_of_binding_bound_marid"));
        this.context().page("book_of_binding_empty");
        BookSpiritFireRecipePageModel alternativeBooks = (BookSpiritFireRecipePageModel)((BookSpiritFireRecipePageModel)BookSpiritFireRecipePageModel.create().withRecipeId1(this.modLoc("spirit_fire/book_of_binding_empty"))).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), " Alternatively, you can directly use the Binding Book: Empty instead of the previous three items. There are two ways to obtain this book. Place this book in the center of dyes to get specific book of binding.\n".formatted(COLOR_PURPLE));
        this.context().page("book_of_binding_empty_recipe");
        BookCraftingRecipePageModel bookOfBindingEmptyRecipe = (BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId2(this.modLoc("crafting/book_of_binding_empty"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, intro2, purifiedInkRecipe, awakenedFeatherRecipe, tabooBookRecipe, bookOfBindingFoliotRecipe, bookOfBindingBoundFoliotRecipe, bookOfBindingDjinniRecipe, bookOfBindingAfritRecipe, bookOfBindingMaridRecipe, alternativeBooks, bookOfBindingEmptyRecipe});
    }

    private BookEntryModel makeBooksOfCallingEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("books_of_calling");
        this.lang().add(this.context().entryName(), "Books of Calling");
        this.lang().add(this.context().entryDescription(), "Telling your spirits what to do");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Books of Calling");
        this.lang().add(this.context().pageText(), "Books of Calling allow to control a summoned spirit, and to store it to prevent essence decay or move it more easily.\n\\\n\\\nOnly spirits that require precise instructions - such as a work area or drop-off storage - come with a book of calling.\n");
        this.context().page("usage");
        BookTextPageModel usage = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Usage");
        this.lang().add(this.context().pageText(), "- [#](%1$s)Right-click[#]() air to open the configuration screen\n- [#](%1$s)Shift-right-click[#]() a block to apply the action selected in the configuration screen\n- [#](%1$s)Shift-right-click[#]() a spirit to capture it (must be of the same type)\n- [#](%1$s)Right-click[#]() with a book with a captured spirit to release it\n".formatted(COLOR_PURPLE));
        this.context().page("obtaining");
        BookTextPageModel obtaining = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "How to obtain Books of Calling");
        this.lang().add(this.context().pageText(), "If a summoned spirit supports the use of a Book of Calling, the summoning ritual will automatically spawn a book in the world alongside the spirit.\n\\\n\\\nIf you **lose the book**, there are also crafting recipes that just provide the book (without summoning a spirit).\n".formatted(COLOR_PURPLE));
        this.context().page("obtaining2");
        BookTextPageModel obtaining2 = BookTextPageModel.create().withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "The recipes can be found in this book or via JEI.\n\\\n\\\n[#](%1$s)Shift-right-click[#]() the spirit with the crafted book to assign it.\n".formatted(COLOR_PURPLE));
        this.context().page("storage");
        BookTextPageModel storage = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Storing Spirits");
        this.lang().add(this.context().pageText(), "To store spirits that do not have a fitting book of calling, you can use a [Soul Gem](entry://crafting_rituals/craft_soul_gem).\nSoul gems are much more versatile and allow to store almost all types of entities even animals and monsters, but not players or bosses.\n");
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)OccultismItems.BOOK_OF_CALLING_DJINNI_MANAGE_MACHINE.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, usage, obtaining, obtaining2, storage});
    }

    private BookEntryModel makeRitualEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("first_ritual");
        this.lang().add(this.context().entryName(), "First Ritual");
        this.lang().add(this.context().entryDescription(), "We're actually getting started now!");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "The Ritual (tm)");
        this.lang().add(this.context().pageText(), "These pages will walk the gentle reader through the process of the [first ritual](entry://summoning_rituals/summon_crusher_t1) step by step.\n\\\nWe **start** by placing the [](item://occultism:golden_sacrificial_bowl) and drawing the appropriate pentacle, [Aviar's Circle](entry://pentacles/summon_foliot) as seen on the left around it.\n".formatted(COLOR_PURPLE));
        this.context().page("multiblock");
        BookMultiblockPageModel multiblock = BookMultiblockPageModel.create().withMultiblockId(this.modLoc("summon_foliot")).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "Only the color and location of the chalk marks is relevant, not the glyph/sign.\n".formatted(COLOR_PURPLE));
        this.context().page("bowl_text");
        BookTextPageModel bowlText = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Sacrificial Bowls");
        this.lang().add(this.context().pageText(), "Next, place *at least* 4 [Sacrificial Bowls](item://occultism:sacrificial_bowl) close to the pentacle.\n\\\n\\\nThey must be placed **anywhere** within 8 blocks of the central [](item://occultism:golden_sacrificial_bowl). **The exact location does not matter.**\n".formatted(COLOR_PURPLE));
        this.context().page("bowl_placement");
        BookImagePageModel bowlPlacementImage = BookImagePageModel.create().withImages(new ResourceLocation[]{this.modLoc("textures/gui/book/bowl_placement.png")}).withBorder(true).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "Possible locations for the sacrificial bowls.\n".formatted(COLOR_PURPLE));
        this.context().page("ritual_text");
        BookTextPageModel ritualText = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Placing Ingredients");
        this.lang().add(this.context().pageText(), "Now it is time to place the ingredients you see on the next page in the (regular, not golden) sacrificial bowls. The ingredients will be consumed from the bowls as the ritual progresses.\n".formatted(COLOR_PURPLE));
        this.context().page("ritual_recipe");
        BookRitualRecipePageModel ritualRecipe = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/summon_foliot_crusher"));
        this.context().page("pentacle_link_hint");
        BookTextPageModel pentacleLinkHint = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "A Note about Ritual Recipes");
        this.lang().add(this.context().pageText(), "Ritual recipe pages, such as the previous pageshow not only the ingredients, but also the pentacle that you need to draw with chalk in order to use the ritual.\n\\\n\\\n**To show the pentacle, click the blue link** at the center top of the ritual page. You can then even preview it in-world.\n".formatted(COLOR_PURPLE));
        this.context().page("start_ritual");
        BookTextPageModel startRitualText = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Let there be ... spirits!");
        this.lang().add(this.context().pageText(), "Finally, [#](%1$s)right-click[#]() the [](item://occultism:golden_sacrificial_bowl) with the **bound** book of binding you created before and wait until the crusher spawns.\n\\\n\\\nNow all that remains is to drop appropriate ores near the crusher and wait for it to turn it into dust.\n".formatted(COLOR_PURPLE));
        this.context().page("automation");
        BookTextPageModel automationText = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Automatic Rituals");
        this.lang().add(this.context().pageText(), "Instead of right-clicking the golden sacrificial bowl with the final ingredient, you can also use a Hopper or any type of pipe to insert the item into the bowl. The ritual will start automatically.\\\nNote that any rituals that summon tamed animals or familiars will summon them untamed instead.\n".formatted(COLOR_PURPLE));
        this.context().page("redstone");
        BookTextPageModel redstoneText = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Redstone");
        this.lang().add(this.context().pageText(), "Depending on the ritual state the golden bowl will emit a different redstone level:\n- **0** if no ritual is active\n- **1** if the ritual is active, but waiting for a sacrifice\n- **2** if the ritual is active, but waiting for an item to be used\n- **4** if the ritual is active and running\n".formatted(COLOR_PURPLE));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)OccultismItems.PENTACLE.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, multiblock, bowlText, bowlPlacementImage, ritualText, ritualRecipe, pentacleLinkHint, startRitualText, automationText, redstoneText});
    }

    private BookEntryModel makeBrushEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("brush");
        this.lang().add(this.context().entryName(), "Brush");
        this.lang().add(this.context().entryDescription(), "Cleaning up!");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Next Steps");
        this.lang().add(this.context().pageText(), "Chalk is a pain to clean up, by [#](%1$s)right-clicking[#]() with a brush you can remove it from the world much more easily.\n".formatted(COLOR_PURPLE));
        this.context().page("brushRecipe");
        BookCraftingRecipePageModel brushRecipe = (BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/brush"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)OccultismItems.BRUSH.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, brushRecipe});
    }

    private BookEntryModel makeMoreRitualsEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("more_rituals");
        this.lang().add(this.context().entryName(), "More Rituals");
        this.lang().add(this.context().entryDescription(), "Ready for new challenges?");
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon(this.modLoc("textures/gui/book/robe.png")).withLocation(entryMap.get(Character.valueOf(icon))).withEntryBackground(1, 1).withCategoryToOpen(this.modLoc("rituals"));
    }

    private BookEntryModel makeGreyParticlesEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("grey_particles");
        this.lang().add(this.context().entryName(), "Grey particles?");
        this.lang().add(this.context().entryDescription(), "What to do when a ritual seems stuck!");
        this.context().page("text");
        BookTextPageModel text = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Ritual stuck?");
        this.lang().add(this.context().pageText(), "If a ritual appears stuck - no items being consumed - you should see grey particles around the [](item://occultism:golden_sacrificial_bowl). If this is the case the ritual requires you to either [use a specific item](entry://rituals/item_use) or [sacrifice a specific mob](entry://rituals/sacrifice).\n\\\n\\\nFind the ritual in the [Rituals](category://rituals) category and check for instructions.\n");
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)Items.GRAY_DYE).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{text});
    }

    private BookEntryModel makeSpiritsSubcategoryEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("spirits");
        this.lang().add(this.context().entryName(), "About Spirits");
        this.lang().add(this.context().entryDescription(), "Learn more about Spirits.");
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon(this.modLoc("textures/gui/book/spirits.png")).withCategoryToOpen(this.modLoc("spirits")).withEntryBackground(1, 1).withLocation(entryMap.get(Character.valueOf(icon)));
    }

    private BookEntryModel makeChalksEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("chalks");
        this.lang().add(this.context().entryName(), "More Chalks");
        this.lang().add(this.context().entryDescription(), "Better chalks for better rituals!");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "More Chalks");
        this.lang().add(this.context().pageText(), "For more advanced rituals the basic [White Chalk](entry://occultism:dictionary_of_spirits/getting_started/ritual_prep_chalk) is not sufficient. Instead chalks made from more arcane materials are required.\n");
        this.context().page("impure_gold_chalk_recipe");
        BookCraftingRecipePageModel impureGoldChalkRecipe = (BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/chalk_gold_impure"));
        this.context().page("gold_chalk_recipe");
        BookSpiritFireRecipePageModel goldChalkRecipe = (BookSpiritFireRecipePageModel)BookSpiritFireRecipePageModel.create().withRecipeId1(this.modLoc("spirit_fire/chalk_gold"));
        this.context().page("impure_purple_chalk_recipe");
        BookCraftingRecipePageModel impurePurpleChalkRecipe = (BookCraftingRecipePageModel)((BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/chalk_purple_impure"))).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "You do not need to visit the [#](%1$s)The End[#]() to obtain Endstone. You can summon a [Possessed Endermite](entry://possession_rituals/possess_endermite) which has a high chance to drop it.\n".formatted(COLOR_PURPLE));
        this.context().page("purple_chalk_recipe");
        BookSpiritFireRecipePageModel purpleChalkRecipe = (BookSpiritFireRecipePageModel)BookSpiritFireRecipePageModel.create().withRecipeId1(this.modLoc("spirit_fire/chalk_purple"));
        this.context().page("impure_red_chalk_recipe");
        BookCraftingRecipePageModel impureRedChalkRecipe = (BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/chalk_red_impure"));
        this.context().page("red_chalk_recipe");
        BookSpiritFireRecipePageModel redChalkRecipe = (BookSpiritFireRecipePageModel)BookSpiritFireRecipePageModel.create().withRecipeId1(this.modLoc("spirit_fire/chalk_red"));
        this.context().page("afrit_essence");
        BookSpotlightPageModel afritEssenceSpotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.AFRIT_ESSENCE.get()})).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "To obtain the essence of an [#](%1$s)Afrit[#]() for [](item://occultism:chalk_red) you need to [summon and kill an Unbound Afrit](entry://summoning_rituals/afrit_essence).\n".formatted(COLOR_PURPLE));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)OccultismItems.CHALK_GOLD.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, impureGoldChalkRecipe, goldChalkRecipe, impurePurpleChalkRecipe, purpleChalkRecipe, impureRedChalkRecipe, redChalkRecipe, afritEssenceSpotlight});
    }

    private BookEntryModel makeOtherworldGogglesEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("otherworld_goggles");
        this.lang().add(this.context().entryName(), "Otherworld Goggles");
        this.lang().add(this.context().entryDescription(), "Say no to drugs!");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.OTHERWORLD_GOGGLES.get()})).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "The [](item://occultism:otherworld_goggles) are what advanced summoners use to see the [#](%1$s)Otherworld[#](), to avoid the negative side effects of [](entry://occultism:dictionary_of_spirits/getting_started/demons_dream).\n\\\n\\\nMaking your first pair of these is seen by many as a rite of passage.\n".formatted(COLOR_PURPLE));
        this.context().page("crafting");
        BookTextPageModel crafting = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Crafting Goggles");
        this.lang().add(this.context().pageText(), "Crafting these goggles is a multi-step process described in detail in the Entry about [Crafting Otherworld Goggles](entry://crafting_rituals/craft_otherworld_goggles).\n".formatted(COLOR_PURPLE));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)OccultismItems.OTHERWORLD_GOGGLES.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, crafting});
    }

    private BookEntryModel makeInfusedPickaxeEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("infused_pickaxe");
        this.lang().add(this.context().entryName(), "Infused Pickaxe");
        this.lang().add(this.context().entryDescription(), "Tackling Otherworld Ores");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.INFUSED_PICKAXE.get()})).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "Beyond [](item://occultism:otherworld_log) and [](item://occultism:otherstone) there are also otherworld materials that require special tools to harvest.\n\\\n\\\nThis pickaxe is rather brittle, but it will do the job.\n");
        this.context().page("gem_recipe");
        BookSpiritFireRecipePageModel gemRecipe = (BookSpiritFireRecipePageModel)((BookSpiritFireRecipePageModel)BookSpiritFireRecipePageModel.create().withRecipeId1(this.modLoc("spirit_fire/spirit_attuned_gem"))).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "These gems, when infused with a spirit, can be used to interact with Otherword materials and are the key to crafting the pickaxe.\n");
        this.context().page("head_recipe");
        BookCraftingRecipePageModel headRecipe = (BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/spirit_attuned_pickaxe_head"));
        this.context().page("crafting");
        BookTextPageModel crafting = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Crafting");
        this.lang().add(this.context().pageText(), "After preparing the raw materials, the pickaxe needs to be infused with a spirit.\n\\\n\\\nFollow the instructions at [Craft Infuse Pickaxe](entry://crafting_rituals/craft_infused_pickaxe)\n".formatted(COLOR_PURPLE));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)OccultismItems.INFUSED_PICKAXE.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, gemRecipe, headRecipe, crafting});
    }

    private BookEntryModel makeIesniumEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("iesnium");
        this.lang().add(this.context().entryName(), "Iesnium Ore");
        this.lang().add(this.context().entryDescription(), "Myterious metals ...");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.IESNIUM_ORE.get()})).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "This is a rare metal that, to the naked eye, looks like [](item://minecraft:netherrack) and cannot be mined with a regular pickaxe.\n\\\n\\\nWhen mined with the correct tools, it can be used to craft powerful items (you will learn more about that later).\n".formatted(COLOR_PURPLE));
        this.context().page("where");
        BookTextPageModel where = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Where to find it");
        this.lang().add(this.context().pageText(), "Like Netherrack, Iesnium can be found in the Nether. In order to **see** it, you need to wear [Otherworld Goggles](entry://getting_started/otherworld_goggles).\n\\\n\\\nTo make searching for it simpler, attune a [Divination Rod](entry://getting_started/divination_rod) to it and righ-click and hold in the nether until it highlights a nearby block, which will hold the ore.\n".formatted(COLOR_PURPLE));
        this.context().page("how");
        BookTextPageModel how = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "How to mine it");
        this.lang().add(this.context().pageText(), "Iesnium can only be mined with the [Infused Pickaxe](entry://getting_started/infused_pickaxe) or an [](item://occultism:iesnium_pickaxe) (about which you will learn later).\n\\\n\\\nAfter identifying a block that holds Iesnium, you can mine it with the pickaxe you created in the previous step.\n".formatted(COLOR_PURPLE));
        this.context().page("processing");
        BookTextPageModel processing = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Processing");
        this.lang().add(this.context().pageText(), "Iesnium Ore, after mining, can be smelted directly into ingots, or placed down. When placed, it will not turn back into it's netherrack form. Consequently it can also be mined with any pickaxe then. This visible form of the Ore, when mined, will drop [](item://occultism:raw_iesnium).\n".formatted(COLOR_PURPLE));
        this.context().page("uses");
        BookTextPageModel uses = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Uses");
        this.lang().add(this.context().pageText(), "Iesnium can be used to craft an improved pickaxe, spirit lamps, and other powerful items. Follow the progress in this book to learn more about it.\n".formatted(COLOR_PURPLE));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)OccultismBlocks.IESNIUM_ORE.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, where, how, processing, uses});
    }

    private BookEntryModel makeIesniumPickaxeEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("iesnium_pickaxe");
        this.lang().add(this.context().entryName(), "Iesnium Pickaxe");
        this.lang().add(this.context().entryDescription(), "A more durable otherworld-appropriate pickaxe");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.IESNIUM_PICKAXE.get()})).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "Like the [Infused Pickaxe](entry://getting_started/infused_pickaxe), this pickaxe can be used to mine Tier 2 Otherworld Materials such as [](item://occultism:iesnium_ore). As it is made from metal, instead of brittle [](item://occultism:spirit_attuned_gem), it is very durable and can be used for a long time.\n".formatted(COLOR_PURPLE));
        this.context().page("crafting");
        BookCraftingRecipePageModel crafting = (BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/iesnium_pickaxe"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)OccultismItems.IESNIUM_PICKAXE.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, crafting});
    }

    private BookEntryModel makeMagicLampsEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("magic_lamps");
        this.lang().add(this.context().entryName(), "Magic Lamps");
        this.lang().add(this.context().entryDescription(), "Three wishes? Close, but not quite..");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get()})).withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Magic Lamps");
        this.lang().add(this.context().pageText(), "Magic Lamps can be used to keep spirits safe from [#](%1$s)Essence Decay[#](), while still having access to some of their powers. Most commonly they are used to access a [#](%1$s)Mining Dimension[#]() and act as (*lag free*) [#](%1$s)Void Miners[#]().\n".formatted(COLOR_PURPLE));
        this.context().page("crafting");
        BookCraftingRecipePageModel crafting = (BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/magic_lamp_empty"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, crafting});
    }

    private BookEntryModel makeSpiritMinersEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("spirit_miners");
        this.lang().add(this.context().entryName(), "Spirit Miners");
        this.lang().add(this.context().entryDescription(), "It's Free Real Estate (-> Resources)");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.MINER_FOLIOT_UNSPECIALIZED.get()})).withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Spirit Miners");
        this.lang().add(this.context().pageText(), "By summoning a spirit into a Magic Lamp and placing it in a [Dimensional Mineshaft (see next step)](entry://getting_started/mineshaft) it can be made to mine for you in a [#](%1$s)Mining Dimension[#](). This is a great way to get resources without having to go mining in the overworld (or other dimesions) yourself.\n".formatted(COLOR_PURPLE));
        this.context().page("crafting");
        BookTextPageModel crafting = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Crafting");
        this.lang().add(this.context().pageText(), "See [Foliot Miner](entry://crafting_rituals/craft_foliot_miner) and the subsequent entries for information on how to craft spirit miners.\n".formatted(COLOR_PURPLE));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)OccultismItems.MINER_FOLIOT_UNSPECIALIZED.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, crafting});
    }

    private BookEntryModel makeMineshaftEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("mineshaft");
        this.lang().add(this.context().entryName(), "Dimensional Mineshaft");
        this.lang().add(this.context().entryDescription(), "Ethically questionable, but very profitable");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.DIMENSIONAL_MINESHAFT.get()})).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "This block acts as a portal, for spirits only, to the [#](%1$s)Mining Dimension[#](). Place a Magic Lamp with a Miner Spirit in it, to make it mine for you.\n".formatted(COLOR_PURPLE));
        this.context().page("crafting");
        BookTextPageModel crafting = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Crafting");
        this.lang().add(this.context().pageText(), "See [Dimensional Mineshaft](entry://crafting_rituals/craft_dimensional_mineshaft) in the [Binding Rituals](category://crafting_rituals) Category.\n".formatted(COLOR_PURPLE));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)OccultismBlocks.DIMENSIONAL_MINESHAFT.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, crafting});
    }

    private BookEntryModel makeStorageEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("storage");
        this.lang().add(this.context().entryName(), "Magic Storage");
        this.lang().add(this.context().entryDescription(), "Looking for much much much more storage? Look no further!");
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)OccultismBlocks.STORAGE_CONTROLLER.get()).withLocation(entryMap.get(Character.valueOf(icon))).withEntryBackground(1, 1).withCategoryToOpen(this.modLoc("storage"));
    }

    private BookEntryModel makePossessionRitualsEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("possession_rituals");
        this.lang().add(this.context().entryName(), "Possession Rituals");
        this.lang().add(this.context().entryDescription(), "A different way to get rare drops ...");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Possession Rituals");
        this.lang().add(this.context().pageText(), "Possessed mobs are controlled by spirits, allowing the summoner to determine some of their properties. They usually have **high drop rates** for rare drops, but are generally harder to kill.\n\\\n\\\nYou probably will want to start by summoning a [Possessed Endermite](entry://possession_rituals/possess_endermite) to get [](item://minecraft:end_stone) to craft [Advanced Chalks](entry://getting_started/chalks).\n".formatted(COLOR_PURPLE));
        this.context().page("more");
        BookTextPageModel more = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "More Information");
        this.lang().add(this.context().pageText(), "To find out more about Possession Rituals, see the [Possession Rituals](category://possession_rituals) Category.\n".formatted(COLOR_PURPLE));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon(this.modLoc("textures/gui/book/possession.png")).withLocation(entryMap.get(Character.valueOf(icon))).withEntryBackground(1, 1).withPages(new BookPageModel[]{intro, more});
    }

    private BookEntryModel makeFamiliarRitualsEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("familiar_rituals");
        this.lang().add(this.context().entryName(), "Familiar Rituals");
        this.lang().add(this.context().entryDescription(), "Personal helpers that provide buffs or fight for you");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Familiar Rituals");
        this.lang().add(this.context().pageText(), "Familiars provide a variety of bonus effects, such as feather falling, water breathing, jump boosts and more, and may also assist you in combat.\n\\\n\\\nStore them in a [Familiar Ring](entry://crafting_rituals/craft_familiar_ring) to equip them as a curio.\n".formatted(COLOR_PURPLE));
        this.context().page("more");
        BookTextPageModel more = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "More Information");
        this.lang().add(this.context().pageText(), "To find more about Familiars, see the [Familiar Rituals](category://familiar_rituals) Category.\n".formatted(COLOR_PURPLE));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon(this.modLoc("textures/gui/book/parrot.png")).withLocation(entryMap.get(Character.valueOf(icon))).withEntryBackground(1, 1).withPages(new BookPageModel[]{intro, more});
    }

    private BookEntryModel makeSummoningRitualsEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("summoning_rituals");
        this.lang().add(this.context().entryName(), "Summoning Rituals");
        this.lang().add(this.context().entryDescription(), "Spirit helpers for your daily work life");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Summoning Rituals");
        this.lang().add(this.context().pageText(), "Summoning Rituals allow you to summon spirits to work for you. Unlike familiars, they are not personally bound to you, meaning they will not follow you around, but they will perform various work tasks for you. In fact the first ritual you performed, the [Foliot Crusher](entry://getting_started/first_ritual), was a summoning ritual.\n".formatted(COLOR_PURPLE));
        this.context().page("more");
        BookTextPageModel more = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "More Information");
        this.lang().add(this.context().pageText(), "To find more about Summoning Rituals, see the [Summoning Rituals](category://summoning_rituals) Category.\n".formatted(COLOR_PURPLE));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon(this.modLoc("textures/gui/book/summoning.png")).withLocation(entryMap.get(Character.valueOf(icon))).withEntryBackground(1, 1).withPages(new BookPageModel[]{intro, more});
    }

    private BookEntryModel makeCraftingRitualsEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("crafting_rituals");
        this.lang().add(this.context().entryName(), "Infusion Rituals");
        this.lang().add(this.context().entryDescription(), "Infuse spirits into items to create powerful tools");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Infusion Rituals");
        this.lang().add(this.context().pageText(), "Infusion rituals are all about crafting powerful items, by binding (\"infusing\") spirits into objects.The spirits will provide special functionality to the items.\n".formatted(COLOR_PURPLE));
        this.context().page("more");
        BookTextPageModel more = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "More Information");
        this.lang().add(this.context().pageText(), "To find more about Infusing items, see the [Infusion Rituals](category://crafting_rituals) Category.\n".formatted(COLOR_PURPLE));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon(this.modLoc("textures/gui/book/infusion.png")).withLocation(entryMap.get(Character.valueOf(icon))).withEntryBackground(1, 1).withPages(new BookPageModel[]{intro, more});
    }

    private BookCategoryModel makeSpiritsSubcategory() {
        this.context().category("spirits");
        this.lang().add(this.context().categoryName(), "Spirits");
        CategoryEntryMap entryMap = ModonomiconAPI.get().getEntryMap();
        entryMap.setMap(new String[]{"___________________________", "___________________________", "___<_0_n_u_w_______________", "___________________________", "_____d_____________________", "___________________________", "___________________________"});
        BookEntryModel overview = this.makeSpiritsOverviewEntry(entryMap, '0');
        BookEntryModel returnToGettingStarted = this.makeReturnToGettingStartedEntry(entryMap, '<');
        returnToGettingStarted.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId()));
        returnToGettingStarted.withCondition((BookConditionModel)BookTrueConditionModel.create());
        BookEntryModel essenceDecay = this.makeEssenceDecayEntry(entryMap, 'd');
        essenceDecay.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId()));
        BookEntryModel trueNames = this.makeTrueNamesEntry(entryMap, 'n');
        trueNames.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId()));
        BookEntryModel unboundSpirits = this.makeUnboundSpiritsEntry(entryMap, 'u');
        unboundSpirits.withParent(BookEntryParentModel.create((ResourceLocation)trueNames.getId()));
        BookEntryModel wildHunt = this.makeWildHuntEntry(entryMap, 'w');
        wildHunt.withParent(BookEntryParentModel.create((ResourceLocation)unboundSpirits.getId()));
        return BookCategoryModel.create((ResourceLocation)this.modLoc(this.context().categoryId()), (String)this.context().categoryName()).withIcon(this.modLoc("textures/gui/book/spirits.png")).withShowCategoryButton(true).withEntries(new BookEntryModel[]{overview, returnToGettingStarted, trueNames, essenceDecay, unboundSpirits, wildHunt});
    }

    private BookEntryModel makeReturnToGettingStartedEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("return_to_getting_started");
        this.lang().add(this.context().entryName(), "Return to getting started");
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismItems.DICTIONARY_OF_SPIRITS_ICON.get()).withCategoryToOpen(this.modLoc("getting_started")).withEntryBackground(1, 2).withLocation(entryMap.get(Character.valueOf(icon)));
    }

    private BookEntryModel makeSpiritsOverviewEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("overview");
        this.lang().add(this.context().entryName(), "On Spirits");
        this.lang().add(this.context().entryDescription(), "An overview of the supernatural");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "On Spirits");
        this.lang().add(this.context().pageText(), "[#](%1$s)Spirit[#](), commonly referred to also as [#](%1$s)Demon[#](), is a general term for a variety of supernatural entities usually residing in [#](%1$s)The Other Place[#](), a plane of existence entirely separate from our own.\n".formatted(COLOR_PURPLE));
        this.context().page("shapes");
        BookTextPageModel shapes = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Shapes");
        this.lang().add(this.context().pageText(), "When in our world Spirits can take a variety of forms, by morphing their essence into [#](%1$s)Chosen Forms[#](). Alternatively, they can inhabit objects or even living beings.\n".formatted(COLOR_PURPLE));
        this.context().page("tiers");
        BookTextPageModel tiers = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Types of Spirits");
        this.lang().add(this.context().pageText(), "There are four major \"ranks\" of spirits identified by researchers, but there are a myriad spirits below and in between these ranks, and some great entities of terrible power, referred to only as [#](%1$s)Greater Spirits[#](), that are beyond classification.\n".formatted(COLOR_PURPLE));
        this.context().page("foliot");
        BookTextPageModel foliot = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Foliot");
        this.lang().add(this.context().pageText(), "The lowest identified class of spirit. Equipped with some intelligence and a modicum of power they are most often used for manual labor or minor artifacts.\n".formatted(COLOR_PURPLE));
        this.context().page("djinni");
        BookTextPageModel djinni = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Djinni");
        this.lang().add(this.context().pageText(), "The most commonly summoned class. There is a great variety of Djinni, differing both in intelligence and power. Djinni can be used for a variety of task, ranging from higher artifacts over possession of living beings to carrying out tasks in their Chosen Form.\n".formatted(COLOR_PURPLE));
        this.context().page("afrit");
        BookTextPageModel afrit = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Afrit");
        this.lang().add(this.context().pageText(), "Even more powerful than Djinni, Afrit are used for the creation of major artifacts and the possession of powerful beings.\n".formatted(COLOR_PURPLE));
        this.context().page("marid");
        BookTextPageModel marid = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Marid");
        this.lang().add(this.context().pageText(), "The strongest identified class of spirits. Due to their power and vast intellect attempting a summoning is extremely dangerous and usually only carried out by the most experienced summoners, and even then usually in groups.\n".formatted(COLOR_PURPLE));
        this.context().page("greater_spirits");
        BookTextPageModel greaterSpirits = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Greater Spirits");
        this.lang().add(this.context().pageText(), "Spirits of power so great it is beyond measure. No summons have been attempted in living memory, and records of summonings in ancient times are mostly considered apocryphal.\n".formatted(COLOR_PURPLE));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon(this.modLoc("textures/gui/book/spirits.png")).withLocation(entryMap.get(Character.valueOf(icon))).withEntryBackground(0, 1).withPages(new BookPageModel[]{intro, shapes, tiers, foliot, djinni, afrit, marid, greaterSpirits});
    }

    private BookEntryModel makeEssenceDecayEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("essence_decay");
        this.lang().add(this.context().entryName(), "Essence Decay");
        this.lang().add(this.context().entryDescription(), "Even the immortal are not immune to time.");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Essence Decay");
        this.lang().add(this.context().pageText(), "When residing in our plane of existence, spirits experience [#](%1$s)Essence Decay[#](), the slow rot of their \"body\". The more powerful the spirit, the slower the decay, but only the most powerful can stop it entirely. Once fully decayed they are returned to [#](%1$s)The Other Place[#]() and can only be re-summoned once fully recovered.\n".formatted(COLOR_PURPLE));
        this.context().page("countermeasures");
        BookTextPageModel countermeasures = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Countermeasures");
        this.lang().add(this.context().pageText(), "The summoner can slow or even stop essence decay by binding the spirit into an object, or summoning it into a living being. Additionally the pentacle used can influence the effects of essence decay to a degree.\n".formatted(COLOR_PURPLE));
        this.context().page("affected_spirits");
        BookTextPageModel affectedSpirits = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Affected Spirits");
        this.lang().add(this.context().pageText(), "Only tier 1 spirits are affected by essence decay, by default. All higher tiers are immune and will not despawn. Modpacks may modify this behaviour.\n".formatted(COLOR_PURPLE));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)Items.ROTTEN_FLESH).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, countermeasures, affectedSpirits});
    }

    private BookEntryModel makeTrueNamesEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("true_names");
        this.lang().add(this.context().entryName(), "True Names");
        this.lang().add(this.context().entryDescription(), "How to call spirits.");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "True Names");
        this.lang().add(this.context().pageText(), "To summon a spirit the magician needs to know their [#](%1$s)True Name[#](). By calling the true naming during the summoning ritual the Spirit is drawn forth from [#](%1$s)The Other Place[#]() and forced to do the summoners bidding.\n\\\n\\\n*It should be noted, that it does not matter which spirit name is used in summoning, only the spirit tier is relevant.*\n".formatted(COLOR_PURPLE));
        this.context().page("finding_names");
        BookTextPageModel findingNames = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Finding Names");
        this.lang().add(this.context().pageText(), "In ancient summoners had to research and experiment to find [#](%1$s)True Names[#](). Some spirits can be convinced to share their knowledge of true names of other demons, either by promising a swift return to [#](%1$s)The Other Place[#](), or by more ... *persuasive* measures.\n".formatted(COLOR_PURPLE));
        this.context().page("using_names");
        BookTextPageModel usingNames = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Using Names to Summon a Spirit");
        this.lang().add(this.context().pageText(), "For your convenience, in this work you will find the known names of spirits of all 4 ranks, as well as some beyond that. To summon a spirit, copy their name from this book into the appropriate book of binding, then use this bound book of binding to activate a ritual.\n".formatted(COLOR_PURPLE));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)Items.WRITABLE_BOOK).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, findingNames, usingNames});
    }

    private BookEntryModel makeUnboundSpiritsEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("unbound_spirits");
        this.lang().add(this.context().entryName(), "Unbound Spirits");
        this.lang().add(this.context().entryDescription(), "Try not to lose your spirits!");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Unbound Spirits");
        this.lang().add(this.context().pageText(), "Generally spirits are summoned [#](%1$s)bound[#](), which refers to any condition that keeps them under control of the summoner. A side effect of binding spells is that part of the spirit remains in [#](%1$s)The Other Place[#](), robbing them of large portions of the power, but at the same time also protecting their essence from foreign access in this world.\n".formatted(COLOR_PURPLE));
        this.context().page("unbound");
        BookTextPageModel unbound = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Forego the Leash");
        this.lang().add(this.context().pageText(), "In order to access a spirit's essence, or unleash it's full destructive power, it needs to be summoned [#](%1$s)unbound[#](). Unbound summonings use pentacles that are intentionally incomplete or unstable, allowing to call on the spirit, but not putting any constraints on it.\n".formatted(COLOR_PURPLE));
        this.context().page("unbound2");
        BookTextPageModel unbound2 = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Beware!");
        this.lang().add(this.context().pageText(), "The lack of restraints when summoning spirits unbound makes these rituals incredibly dangerous, but you may find that the rewards are worth the risk - and often there is no way around them to achieve certain results.\n".formatted(COLOR_PURPLE));
        this.context().page("essence");
        BookTextPageModel essence = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Spirit Essence");
        this.lang().add(this.context().pageText(), "Unbound summonings are the only way to obtain [Afrit Essence](entry://summoning_rituals/afrit_essence), a powerful substance required for crafting [](item://occultism:chalk_red) which is used for the most powerful binding pentacles.\n".formatted(COLOR_PURPLE));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon(this.modLoc("textures/gui/book/unbound_spirits.png")).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, unbound, unbound2, essence});
    }

    private BookEntryModel makeWildHuntEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("wild_hunt");
        this.lang().add(this.context().entryName(), "The Wild Hunt");
        this.lang().add(this.context().entryDescription(), "You better watch out, you better not cry ...");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "The Wild Hunt");
        this.lang().add(this.context().pageText(), "A group of legendary Greater Spirits, usually appearing in the form of wither skeletons, with their skeleton minions. The Greater Spirits are bound to their minions in such fashion that they are virtually invulnerable until their minions have been sent back to [#](%1$s)The Other Place[#]().\n".formatted(COLOR_PURPLE));
        this.context().page("wither_skull");
        BookTextPageModel witherSkull = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Wither Skeleton Skulls");
        this.lang().add(this.context().pageText(), "While it is incredibly dangerous to call on the Wild Hunt, some summoners have been known to do so for quick access to the rare wither skeleton skulls they are known to leave behind. Summoning the wild hunt is described in detail on the page on obtaining [Wither Skeleton Skulls](entry://summoning_rituals/wither_skull).\n".formatted(COLOR_PURPLE));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon(this.modLoc("textures/gui/book/wild_hunt.png")).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, witherSkull});
    }

    private BookCategoryModel makePentaclesCategory() {
        this.context().category("pentacles");
        CategoryEntryMap entryMap = ModonomiconAPI.get().getEntryMap();
        entryMap.setMap(new String[]{"____________________", "__p_a_b_c_d_e_f_____", "____________________", "__o___g_h_i_________", "____________________", "__u_j_k_l_m_________", "____________________"});
        BookEntryModel overview = this.makePentaclesOverviewEntry(entryMap, 'o');
        BookEntryModel paraphernalia = this.makeParaphernaliaEntry(entryMap, 'p');
        paraphernalia.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId()));
        BookEntryModel chalkUses = this.makeChalkUsesEntry(entryMap, 'u');
        chalkUses.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId()));
        BookEntryModel summonFoliot = this.makeSummonFoliotEntry(entryMap, 'a');
        summonFoliot.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId()));
        BookEntryModel summonDjinni = this.makeSummonDjinniEntry(entryMap, 'b');
        summonDjinni.withParent(BookEntryParentModel.create((ResourceLocation)summonFoliot.getId()));
        BookEntryModel summonWildAfrit = this.makeSummonWildAfritEntry(entryMap, 'c');
        summonWildAfrit.withParent(BookEntryParentModel.create((ResourceLocation)summonDjinni.getId()));
        BookEntryModel summonAfrit = this.makeSummonAfritEntry(entryMap, 'd');
        summonAfrit.withParent(BookEntryParentModel.create((ResourceLocation)summonWildAfrit.getId()));
        BookEntryModel summonMarid = this.makeSummonMaridEntry(entryMap, 'e');
        summonMarid.withParent(BookEntryParentModel.create((ResourceLocation)summonAfrit.getId()));
        BookEntryModel summonWildGreaterSpirit = this.makeSummonWildGreaterSpiritEntry(entryMap, 'f');
        summonWildGreaterSpirit.withParent(BookEntryParentModel.create((ResourceLocation)summonMarid.getId()));
        BookEntryModel possessFoliot = this.makePossessFoliotEntry(entryMap, 'g');
        possessFoliot.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId()));
        BookEntryModel possessDjinni = this.makePossessDjinniEntry(entryMap, 'h');
        possessDjinni.withParent(BookEntryParentModel.create((ResourceLocation)possessFoliot.getId()));
        BookEntryModel possessAfrit = this.makePossessAfritEntry(entryMap, 'i');
        possessAfrit.withParent(BookEntryParentModel.create((ResourceLocation)possessDjinni.getId()));
        BookEntryModel craftFoliot = this.makeCraftFoliotEntry(entryMap, 'j');
        craftFoliot.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId()));
        BookEntryModel craftDjinni = this.makeCraftDjinniEntry(entryMap, 'k');
        craftDjinni.withParent(BookEntryParentModel.create((ResourceLocation)craftFoliot.getId()));
        BookEntryModel craftAfrit = this.makeCraftAfritEntry(entryMap, 'l');
        craftAfrit.withParent(BookEntryParentModel.create((ResourceLocation)craftDjinni.getId()));
        BookEntryModel craftMarid = this.makeCraftMaridEntry(entryMap, 'm');
        craftMarid.withParent(BookEntryParentModel.create((ResourceLocation)craftAfrit.getId()));
        overview.withCondition((BookConditionModel)BookTrueConditionModel.create());
        paraphernalia.withCondition((BookConditionModel)BookTrueConditionModel.create());
        chalkUses.withCondition((BookConditionModel)BookTrueConditionModel.create());
        summonFoliot.withCondition((BookConditionModel)BookTrueConditionModel.create());
        summonDjinni.withCondition((BookConditionModel)BookTrueConditionModel.create());
        summonWildAfrit.withCondition((BookConditionModel)BookTrueConditionModel.create());
        summonAfrit.withCondition((BookConditionModel)BookTrueConditionModel.create());
        summonMarid.withCondition((BookConditionModel)BookTrueConditionModel.create());
        summonWildGreaterSpirit.withCondition((BookConditionModel)BookTrueConditionModel.create());
        possessFoliot.withCondition((BookConditionModel)BookTrueConditionModel.create());
        possessDjinni.withCondition((BookConditionModel)BookTrueConditionModel.create());
        possessAfrit.withCondition((BookConditionModel)BookTrueConditionModel.create());
        craftFoliot.withCondition((BookConditionModel)BookTrueConditionModel.create());
        craftDjinni.withCondition((BookConditionModel)BookTrueConditionModel.create());
        craftAfrit.withCondition((BookConditionModel)BookTrueConditionModel.create());
        craftMarid.withCondition((BookConditionModel)BookTrueConditionModel.create());
        return BookCategoryModel.create((ResourceLocation)this.modLoc(this.context().categoryId()), (String)this.context().categoryName()).withIcon((ItemLike)OccultismItems.PENTACLE.get()).withEntries(new BookEntryModel[]{overview, paraphernalia, chalkUses, summonFoliot, summonDjinni, summonWildAfrit, summonAfrit, summonMarid, summonWildGreaterSpirit, possessFoliot, possessDjinni, possessAfrit, craftFoliot, craftDjinni, craftAfrit, craftMarid});
    }

    private BookEntryModel makePentaclesOverviewEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("pentacles_overview");
        this.context().page("intro1");
        BookTextPageModel intro1 = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("intro2");
        BookTextPageModel intro2 = BookTextPageModel.create().withText(this.context().pageText());
        this.context().page("intro3");
        BookTextPageModel intro3 = BookTextPageModel.create().withText(this.context().pageText());
        this.context().page("intro4");
        BookTextPageModel intro4 = BookTextPageModel.create().withText(this.context().pageText());
        this.context().page("bowl_placement");
        BookImagePageModel bowlPlacementImage = BookImagePageModel.create().withImages(new ResourceLocation[]{this.modLoc("textures/gui/book/bowl_placement.png")}).withBorder(true);
        this.context().page("bowl_text");
        BookTextPageModel bowlText = BookTextPageModel.create().withText(this.context().pageText());
        this.context().page("summoning_pentacles");
        BookTextPageModel summoningPentacles = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("infusion_pentacles");
        BookTextPageModel infusionPentacles = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("possession_pentacles");
        BookTextPageModel possessionPentacles = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismBlocks.SPIRIT_ATTUNED_CRYSTAL.get()).withLocation(entryMap.get(Character.valueOf(icon))).withEntryBackground(0, 1).withPages(new BookPageModel[]{intro1, intro2, intro3, intro4, bowlPlacementImage, bowlText, summoningPentacles, infusionPentacles, possessionPentacles});
    }

    private BookEntryModel makeParaphernaliaEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("paraphernalia");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("candle");
        BookSpotlightPageModel candle = BookSpotlightPageModel.create().withText(this.context().pageText()).withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.CANDLE_WHITE.get()}));
        this.context().page("crystal");
        BookSpotlightPageModel crystal = BookSpotlightPageModel.create().withText(this.context().pageText()).withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.SPIRIT_ATTUNED_CRYSTAL.get()}));
        this.context().page("gem_recipe");
        BookSpiritFireRecipePageModel gemRecipe = (BookSpiritFireRecipePageModel)BookSpiritFireRecipePageModel.create().withRecipeId1(this.modLoc("spirit_fire/spirit_attuned_gem"));
        this.context().page("crystal_recipe");
        BookCraftingRecipePageModel crystalRecipe = (BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/spirit_attuned_crystal"));
        this.context().page("skeleton_skull");
        BookSpotlightPageModel skeletonSkull = BookSpotlightPageModel.create().withText(this.context().pageText()).withItem(Ingredient.of((ItemLike[])new ItemLike[]{Blocks.SKELETON_SKULL}));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)Blocks.SKELETON_SKULL).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, candle, crystal, gemRecipe, crystalRecipe, skeletonSkull});
    }

    private BookEntryModel makeChalkUsesEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("chalk_uses");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("intro2");
        BookTextPageModel intro2 = BookTextPageModel.create().withText(this.context().pageText());
        this.context().page("white_chalk");
        BookSpotlightPageModel whiteChalk = BookSpotlightPageModel.create().withText(this.context().pageText()).withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.CHALK_WHITE.get()}));
        this.context().page("white_chalk_uses");
        BookTextPageModel whiteChalkUses = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("white_chalk_uses2");
        BookTextPageModel whiteChalkUses2 = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("golden_chalk");
        BookSpotlightPageModel goldChalk = BookSpotlightPageModel.create().withText(this.context().pageText()).withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.CHALK_GOLD.get()}));
        this.context().page("golden_chalk_uses");
        BookTextPageModel goldChalkUses = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("purple_chalk");
        BookSpotlightPageModel purpleChalk = BookSpotlightPageModel.create().withText(this.context().pageText()).withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.CHALK_PURPLE.get()}));
        this.context().page("purple_chalk_uses");
        BookTextPageModel purpleChalkUses = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("red_chalk");
        BookSpotlightPageModel redChalk = BookSpotlightPageModel.create().withText(this.context().pageText()).withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.CHALK_RED.get()}));
        this.context().page("red_chalk_uses");
        BookTextPageModel redChalkUses = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismItems.CHALK_PURPLE.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, intro2, whiteChalk, whiteChalkUses, whiteChalkUses2, goldChalk, goldChalkUses, purpleChalk, purpleChalkUses, redChalk, redChalkUses});
    }

    private BookEntryModel makeSummonFoliotEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("summon_foliot");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("multiblock");
        BookMultiblockPageModel multiblock = BookMultiblockPageModel.create().withMultiblockId(this.modLoc("summon_foliot"));
        this.context().page("uses");
        BookTextPageModel uses = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismItems.PENTACLE.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, multiblock, uses});
    }

    private BookEntryModel makePossessFoliotEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("possess_foliot");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("multiblock");
        BookMultiblockPageModel multiblock = BookMultiblockPageModel.create().withMultiblockId(this.modLoc("possess_foliot"));
        this.context().page("uses");
        BookTextPageModel uses = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismItems.PENTACLE.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, multiblock, uses});
    }

    private BookEntryModel makeCraftFoliotEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("craft_foliot");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("multiblock");
        BookMultiblockPageModel multiblock = BookMultiblockPageModel.create().withMultiblockId(this.modLoc("craft_foliot"));
        this.context().page("uses");
        BookTextPageModel uses = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismItems.PENTACLE.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, multiblock, uses});
    }

    private BookEntryModel makeSummonDjinniEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("summon_djinni");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("multiblock");
        BookMultiblockPageModel multiblock = BookMultiblockPageModel.create().withMultiblockId(this.modLoc("summon_djinni"));
        this.context().page("uses");
        BookTextPageModel uses = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismItems.PENTACLE.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, multiblock, uses});
    }

    private BookEntryModel makePossessDjinniEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("possess_djinni");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("multiblock");
        BookMultiblockPageModel multiblock = BookMultiblockPageModel.create().withMultiblockId(this.modLoc("possess_djinni"));
        this.context().page("uses");
        BookTextPageModel uses = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("uses2");
        BookTextPageModel uses2 = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismItems.PENTACLE.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, multiblock, uses, uses2});
    }

    private BookEntryModel makeCraftDjinniEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("craft_djinni");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("multiblock");
        BookMultiblockPageModel multiblock = BookMultiblockPageModel.create().withMultiblockId(this.modLoc("craft_djinni"));
        this.context().page("uses");
        BookTextPageModel uses = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismItems.PENTACLE.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, multiblock, uses});
    }

    private BookEntryModel makeSummonAfritEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("summon_afrit");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("multiblock");
        BookMultiblockPageModel multiblock = BookMultiblockPageModel.create().withMultiblockId(this.modLoc("summon_afrit"));
        this.context().page("uses");
        BookTextPageModel uses = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismItems.PENTACLE.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, multiblock, uses});
    }

    private BookEntryModel makeSummonWildAfritEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("summon_wild_afrit");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("multiblock");
        BookMultiblockPageModel multiblock = BookMultiblockPageModel.create().withMultiblockId(this.modLoc("summon_wild_afrit"));
        this.context().page("uses");
        BookTextPageModel uses = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismItems.PENTACLE.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, multiblock, uses});
    }

    private BookEntryModel makePossessAfritEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("possess_afrit");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("multiblock");
        BookMultiblockPageModel multiblock = BookMultiblockPageModel.create().withMultiblockId(this.modLoc("possess_afrit"));
        this.context().page("uses");
        BookTextPageModel uses = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismItems.PENTACLE.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, multiblock, uses});
    }

    private BookEntryModel makeCraftAfritEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("craft_afrit");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("multiblock");
        BookMultiblockPageModel multiblock = BookMultiblockPageModel.create().withMultiblockId(this.modLoc("craft_afrit"));
        this.context().page("uses");
        BookTextPageModel uses = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismItems.PENTACLE.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, multiblock, uses});
    }

    private BookEntryModel makeSummonMaridEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("summon_marid");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("multiblock");
        BookMultiblockPageModel multiblock = BookMultiblockPageModel.create().withMultiblockId(this.modLoc("summon_marid"));
        this.context().page("uses");
        BookTextPageModel uses = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismItems.PENTACLE.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, multiblock, uses});
    }

    private BookEntryModel makeCraftMaridEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("craft_marid");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("multiblock");
        BookMultiblockPageModel multiblock = BookMultiblockPageModel.create().withMultiblockId(this.modLoc("craft_marid"));
        this.context().page("uses");
        BookTextPageModel uses = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismItems.PENTACLE.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, multiblock, uses});
    }

    private BookEntryModel makeSummonWildGreaterSpiritEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("summon_wild_greater_spirit");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("multiblock");
        BookMultiblockPageModel multiblock = BookMultiblockPageModel.create().withMultiblockId(this.modLoc("summon_wild_greater_spirit"));
        this.context().page("uses");
        BookTextPageModel uses = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismItems.PENTACLE.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, multiblock, uses});
    }

    private BookCategoryModel makeRitualsCategory() {
        this.context().category("rituals");
        CategoryEntryMap entryMap = ModonomiconAPI.get().getEntryMap();
        entryMap.setMap(new String[]{"___________________", "______________p_s__", "___________________", "________o_i_k______", "___________________", "______________c_f__", "___________________"});
        BookEntryModel ritualOverview = this.makeRitualOverviewEntry(entryMap, 'o');
        BookEntryModel itemUse = this.makeItemUseEntry(entryMap, 'i');
        itemUse.withParent(BookEntryParentModel.create((ResourceLocation)ritualOverview.getId()));
        BookEntryModel sacrifice = this.makeSacrificeEntry(entryMap, 'k');
        sacrifice.withParent(BookEntryParentModel.create((ResourceLocation)itemUse.getId()));
        BookEntryModel summoning = this.makeSummoningRitualsSubcategoryEntry(entryMap, 's');
        summoning.withParent(BookEntryParentModel.create((ResourceLocation)sacrifice.getId()));
        BookEntryModel possession = this.makePossessionRitualsSubcategoryEntry(entryMap, 'p');
        possession.withParent(BookEntryParentModel.create((ResourceLocation)sacrifice.getId()));
        BookEntryModel crafting = this.makeCraftingRitualsSubcategoryEntry(entryMap, 'c');
        crafting.withParent(BookEntryParentModel.create((ResourceLocation)sacrifice.getId()));
        BookEntryModel familiars = this.makeFamiliarRitualsSubcategoryEntry(entryMap, 'f');
        familiars.withParent(BookEntryParentModel.create((ResourceLocation)sacrifice.getId()));
        itemUse.withCondition((BookConditionModel)BookTrueConditionModel.create());
        sacrifice.withCondition((BookConditionModel)BookTrueConditionModel.create());
        summoning.withCondition((BookConditionModel)BookTrueConditionModel.create());
        possession.withCondition((BookConditionModel)BookTrueConditionModel.create());
        crafting.withCondition((BookConditionModel)BookTrueConditionModel.create());
        familiars.withCondition((BookConditionModel)BookTrueConditionModel.create());
        return BookCategoryModel.create((ResourceLocation)this.modLoc(this.context().categoryId()), (String)this.context().categoryName()).withIcon(this.modLoc("textures/gui/book/robe.png")).withEntries(new BookEntryModel[]{ritualOverview, itemUse, sacrifice, summoning, possession, crafting, familiars});
    }

    private BookEntryModel makeRitualOverviewEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("overview");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("steps");
        BookTextPageModel steps = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("additional_requirements");
        BookTextPageModel additional_requirements = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon(this.modLoc("textures/gui/book/robe.png")).withLocation(entryMap.get(Character.valueOf(icon))).withEntryBackground(0, 1).withPages(new BookPageModel[]{intro, steps, additional_requirements});
    }

    private BookEntryModel makeSacrificeEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("sacrifice");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)Items.IRON_SWORD).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro});
    }

    private BookEntryModel makeItemUseEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("item_use");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)Items.FLINT_AND_STEEL).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro});
    }

    private BookEntryModel makeSummoningRitualsSubcategoryEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("summoning_rituals");
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon(this.modLoc("textures/gui/book/summoning.png")).withCategoryToOpen(this.modLoc("summoning_rituals")).withEntryBackground(1, 1).withLocation(entryMap.get(Character.valueOf(icon)));
    }

    private BookEntryModel makePossessionRitualsSubcategoryEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("possession_rituals");
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon(this.modLoc("textures/gui/book/possession.png")).withCategoryToOpen(this.modLoc("possession_rituals")).withEntryBackground(1, 1).withLocation(entryMap.get(Character.valueOf(icon)));
    }

    private BookEntryModel makeCraftingRitualsSubcategoryEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("crafting_rituals");
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon(this.modLoc("textures/gui/book/infusion.png")).withCategoryToOpen(this.modLoc("crafting_rituals")).withEntryBackground(1, 1).withLocation(entryMap.get(Character.valueOf(icon)));
    }

    private BookEntryModel makeFamiliarRitualsSubcategoryEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("familiar_rituals");
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon(this.modLoc("textures/gui/book/parrot.png")).withCategoryToOpen(this.modLoc("familiar_rituals")).withEntryBackground(1, 1).withLocation(entryMap.get(Character.valueOf(icon)));
    }

    private BookEntryModel makeReturnToRitualsEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("return_to_rituals");
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon(this.modLoc("textures/gui/book/robe.png")).withCategoryToOpen(this.modLoc("rituals")).withEntryBackground(1, 2).withLocation(entryMap.get(Character.valueOf(icon)));
    }

    private BookCategoryModel makeSummoningRitualsSubcategory() {
        this.context().category("summoning_rituals");
        CategoryEntryMap entryMap = ModonomiconAPI.get().getEntryMap();
        entryMap.setMap(new String[]{"___________b___l______", "______________________", "_________c_d_h_k______", "______________________", "___r_o________________", "______________________", "_________1_e_i_a_m___", "______________________", "_________2_f_j________", "______________________", "_________3_g__________", "______________________", "_________4____________"});
        BookEntryModel overview = this.makeSummoningRitualsOverviewEntry(entryMap, 'o');
        BookEntryModel returnToRituals = this.makeReturnToRitualsEntry(entryMap, 'r');
        returnToRituals.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId()));
        returnToRituals.withCondition((BookConditionModel)BookTrueConditionModel.create());
        BookEntryModel summonT1Crusher = this.makeSummonCrusherT1Entry(entryMap, '1');
        summonT1Crusher.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId()));
        BookEntryModel summonT2Crusher = this.makeSummonCrusherT2Entry(entryMap, '2');
        summonT2Crusher.withParent(BookEntryParentModel.create((ResourceLocation)summonT1Crusher.getId()));
        BookEntryModel summonT3Crusher = this.makeSummonCrusherT3Entry(entryMap, '3');
        summonT3Crusher.withParent(BookEntryParentModel.create((ResourceLocation)summonT2Crusher.getId()));
        BookEntryModel summonT4Crusher = this.makeSummonCrusherT4Entry(entryMap, '4');
        summonT4Crusher.withParent(BookEntryParentModel.create((ResourceLocation)summonT3Crusher.getId()));
        BookEntryModel summonLumberjack = this.makeSummonLumberjackEntry(entryMap, 'c');
        summonLumberjack.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId()));
        BookEntryModel summonTransportItems = this.makeSummonTransportItemsEntry(entryMap, 'd');
        summonTransportItems.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId()));
        BookEntryModel summonCleaner = this.makeSummonCleanerEntry(entryMap, 'b');
        summonCleaner.withParent(BookEntryParentModel.create((ResourceLocation)summonTransportItems.getId()));
        BookEntryModel summonManageMachine = this.makeSummonManageMachineEntry(entryMap, 'h');
        summonManageMachine.withParent(BookEntryParentModel.create((ResourceLocation)summonTransportItems.getId()));
        BookEntryModel tradeSpirits = this.makeTradeSpiritsEntry(entryMap, 'e');
        tradeSpirits.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId()));
        BookEntryModel summonOtherworldSaplingTrader = this.makeSummonOtherworldSaplingTraderEntry(entryMap, 'f');
        summonOtherworldSaplingTrader.withParent(BookEntryParentModel.create((ResourceLocation)tradeSpirits.getId()));
        BookEntryModel summonOtherstoneTrader = this.makeSummonOtherstoneTraderEntry(entryMap, 'g');
        summonOtherstoneTrader.withParent(BookEntryParentModel.create((ResourceLocation)summonOtherworldSaplingTrader.getId()));
        BookEntryModel summonWildParrot = this.makeSummonWildParrotEntry(entryMap, 'i');
        summonWildParrot.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId()));
        BookEntryModel summonWildOtherworldBird = this.makeSummonWildOtherworldBirdEntry(entryMap, 'j');
        summonWildOtherworldBird.withParent(BookEntryParentModel.create((ResourceLocation)summonWildParrot.getId()));
        BookEntryModel weatherMagic = this.makeWeatherMagicEntry(entryMap, 'k');
        weatherMagic.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId()));
        BookEntryModel timeMagic = this.makeTimeMagicEntry(entryMap, 'l');
        timeMagic.withParent(BookEntryParentModel.create((ResourceLocation)weatherMagic.getId()));
        BookEntryModel afritEssence = this.makeAfritEssenceEntry(entryMap, 'a');
        afritEssence.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId()));
        BookEntryModel witherSkull = this.makeWitherSkullEntry(entryMap, 'm');
        witherSkull.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId()));
        overview.withCondition((BookConditionModel)BookTrueConditionModel.create());
        summonT1Crusher.withCondition((BookConditionModel)BookTrueConditionModel.create());
        summonT2Crusher.withCondition((BookConditionModel)BookTrueConditionModel.create());
        summonT3Crusher.withCondition((BookConditionModel)BookTrueConditionModel.create());
        summonT4Crusher.withCondition((BookConditionModel)BookTrueConditionModel.create());
        summonLumberjack.withCondition((BookConditionModel)BookTrueConditionModel.create());
        summonTransportItems.withCondition((BookConditionModel)BookTrueConditionModel.create());
        summonCleaner.withCondition((BookConditionModel)BookTrueConditionModel.create());
        summonManageMachine.withCondition((BookConditionModel)BookTrueConditionModel.create());
        tradeSpirits.withCondition((BookConditionModel)BookTrueConditionModel.create());
        summonOtherworldSaplingTrader.withCondition((BookConditionModel)BookTrueConditionModel.create());
        summonOtherstoneTrader.withCondition((BookConditionModel)BookTrueConditionModel.create());
        summonWildParrot.withCondition((BookConditionModel)BookTrueConditionModel.create());
        summonWildOtherworldBird.withCondition((BookConditionModel)BookTrueConditionModel.create());
        weatherMagic.withCondition((BookConditionModel)BookTrueConditionModel.create());
        timeMagic.withCondition((BookConditionModel)BookTrueConditionModel.create());
        afritEssence.withCondition((BookConditionModel)BookTrueConditionModel.create());
        witherSkull.withCondition((BookConditionModel)BookTrueConditionModel.create());
        return BookCategoryModel.create((ResourceLocation)this.modLoc(this.context().categoryId()), (String)this.context().categoryName()).withIcon(this.modLoc("textures/gui/book/summoning.png")).withShowCategoryButton(true).withEntries(new BookEntryModel[]{overview, returnToRituals, afritEssence, summonCleaner, summonT1Crusher, summonT2Crusher, summonT3Crusher, summonT4Crusher, summonLumberjack, summonManageMachine, summonTransportItems, tradeSpirits, summonOtherstoneTrader, summonOtherworldSaplingTrader, summonWildOtherworldBird, summonWildParrot, timeMagic, weatherMagic, witherSkull, afritEssence});
    }

    private BookEntryModel makeSummoningRitualsOverviewEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("overview");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon(this.modLoc("textures/gui/book/summoning.png")).withLocation(entryMap.get(Character.valueOf(icon))).withEntryBackground(0, 1).withPages(new BookPageModel[]{intro});
    }

    private BookEntryModel makeAfritEssenceEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("afrit_essence");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/summon_wild_afrit"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismItems.AFRIT_ESSENCE.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, ritual});
    }

    private BookEntryModel makeSummonCrusherT1Entry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("summon_crusher_t1");
        this.lang().add(this.context().entryName(), "Summon Foliot Crusher");
        this.context().page("about_crushers");
        BookTextPageModel aboutCrushers = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Crusher Spirits");
        this.lang().add(this.context().pageText(), "Crusher spirits are summoned to crush ores into dusts, effectively multiplying the metal output. They will pick up appropriate ores and drop the resulting dusts into the world. A purple particle effect and a crushing sound indicate the crusher is at work.\n");
        this.context().page("automation");
        BookTextPageModel automation = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Automation");
        this.lang().add(this.context().pageText(), "To ease automation, try summoning a [Transporter Spirit](entry://occultism:dictionary_of_spirits/summoning_rituals/summon_transport_items)\nto place items from chests in the crusher's inventory, and a [Janitor Spirit](entry://occultism:dictionary_of_spirits/summoning_rituals/summon_cleaner) to collect the processed items.\n");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Foliot Crusher");
        this.lang().add(this.context().pageText(), "The foliot crusher is the most basic crusher spirit.\n\\\n\\\nIt will crush **one** ore into **two** corresponding dusts.\n");
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/summon_foliot_crusher"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismItems.COPPER_DUST.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{aboutCrushers, automation, intro, ritual});
    }

    private BookEntryModel makeSummonCrusherT2Entry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("summon_crusher_t2");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/summon_djinni_crusher"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismItems.IRON_DUST.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, ritual});
    }

    private BookEntryModel makeSummonCrusherT3Entry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("summon_crusher_t3");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/summon_afrit_crusher"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismItems.SILVER_DUST.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, ritual});
    }

    private BookEntryModel makeSummonCrusherT4Entry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("summon_crusher_t4");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/summon_marid_crusher"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismItems.GOLD_DUST.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, ritual});
    }

    private BookEntryModel makeSummonLumberjackEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("summon_lumberjack");
        this.lang().add(this.context().entryName(), "Summon Foliot Lumberjack");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Foliot Lumberjack");
        this.lang().add(this.context().pageText(), "The lumberjack will harvest trees in it's working area. If a deposit location is set it will collect the dropped items into the specified chest, and re-plant saplings.\n");
        this.context().page("prerequisites");
        BookTextPageModel prerequisites = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Prerequisites");
        this.lang().add(this.context().pageText(), "Summoning the lumberjack requires a [Stable Otherworld Sapling](item://occultism:otherworld_sapling). You can obtain it by summoning an [Otherworld Sapling Trader](entry://summoning_rituals/summon_otherworld_sapling_trader).\n");
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/summon_foliot_lumberjack"));
        this.context().page("book_of_calling");
        BookCraftingRecipePageModel bookOfCalling = (BookCraftingRecipePageModel)((BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/book_of_calling_foliot_lumberjack"))).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "If you lose the book of calling, you can craft a new one.\n[#](%1$s)Shift-right-click[#]() the spirit with the crafted book to assign it.\n".formatted(COLOR_PURPLE));
        this.context().page("usage");
        BookTextPageModel usage = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Usage");
        this.lang().add(this.context().pageText(), "Use the book of calling to set the work area and deposit location of the lumberjack.\n\\\n\\\nSee [Books of Calling](entry://getting_started/books_of_calling) for more information.\n");
        this.context().page("usage2");
        BookTextPageModel usage2 = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Lazy Lumberjack?");
        this.lang().add(this.context().pageText(), "The spirit might pause for a few minutes after clearing his work area, even if trees have regrown since. This is a performance-saving measure and not a bug, he will continue on his own.\n\\\n\\\nSet the work area again to make him continue work immediately.\n");
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismItems.BRUSH.get()).withIcon((ItemLike)Items.IRON_AXE).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, prerequisites, ritual, bookOfCalling, usage, usage2});
    }

    private BookEntryModel makeSummonTransportItemsEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("summon_transport_items");
        this.lang().add(this.context().entryName(), "Summon Foliot Transporter");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Foliot Transporter");
        this.lang().add(this.context().pageText(), "The transporter is useful in that you don't need a train of hoppers transporting stuff, and can use any inventory to take from and deposit.\n\\\n\\\nTo make it take from an inventory simply sneak and interact with it's book of calling on the inventory you want.\n");
        this.context().page("intro2");
        BookTextPageModel intro2 = BookTextPageModel.create().withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "You can also dictate which inventory it deposits to in the same way.\n\\\nThe transporter will move all items it can access from one inventory to another, including machines. It can also deposit into the inventories of other spirits. By setting the extract and insert side they can be used to automate various transport tasks.\n");
        this.context().page("spirit_inventories");
        BookTextPageModel spirit_inventories = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Spirit Inventories");
        this.lang().add(this.context().pageText(), "The Transporter can also interact with the inventories of other spirits. This is especially useful to automatically supply a [Crusher spirit](entry://summoning_rituals/summon_crusher_t1) with items to crush.\n");
        this.context().page("item_filters");
        BookTextPageModel itemFilters = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Item Filters");
        this.lang().add(this.context().pageText(), "By default the Transporter is in \"Whitelist\" mode and will not move anything. Shift-click the transporter to open the config UI. You can then add items to the filter list to make it move only those items, or set it to \"Blacklist\" to move everything *except* the filtered items. You can also enter a tag in the text field below to filter by tag.\n");
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/summon_foliot_transport_items"));
        this.context().page("book_of_calling");
        BookCraftingRecipePageModel bookOfCalling = (BookCraftingRecipePageModel)((BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/book_of_calling_foliot_transport_items"))).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "If you lose the book of calling, you can craft a new one.\n[#](%1$s)Shift-right-click[#]() the spirit with the crafted book to assign it.\n".formatted(COLOR_PURPLE));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)Items.MINECART).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, intro2, spirit_inventories, itemFilters, ritual, bookOfCalling});
    }

    private BookEntryModel makeSummonCleanerEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("summon_cleaner");
        this.lang().add(this.context().entryName(), "Summon Foliot Janitor");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Foliot Janitor");
        this.lang().add(this.context().pageText(), "The janitor will pick up dropped items and deposit them into a target inventory. You can configure an allow/block list to specify which items to pick up or ignore. **Warning**: By default it is set to \"allow\" mode, so it will only pick up items you specify in the allow list.\nYou can use tags to handle whole groups of items.\n");
        this.context().page("intro2");
        BookTextPageModel intro2 = BookTextPageModel.create().withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "To bind the janitor to an inventory simply sneak and interact with the janitor book of calling on that inventory. You can also interact with a block while holding the janitor book of calling to have it deposit items there. You can also have it wander around a select area by pulling up that interface. To configure an allow/block list sneak and interact with the janitor.\n");
        this.context().page("tip");
        BookTextPageModel tip = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Pro tip");
        this.lang().add(this.context().pageText(), "The Janitor will pick up crushed items from a [Crusher spirit](entry://summoning_rituals/summon_crusher_t1) and deposit them into a chest.\n\\\n\\\nCombine that with a [Transporter Spirit](entry://summoning_rituals/summon_transport_items) to automate the whole process.\n");
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/summon_foliot_cleaner"));
        this.context().page("book_of_calling");
        BookCraftingRecipePageModel bookOfCalling = (BookCraftingRecipePageModel)((BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/book_of_calling_foliot_cleaner"))).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "If you lose the book of calling, you can craft a new one.\n[#](%1$s)Shift-right-click[#]() the spirit with the crafted book to assign it.\n".formatted(COLOR_PURPLE));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismItems.BRUSH.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, intro2, tip, ritual, bookOfCalling});
    }

    private BookEntryModel makeSummonManageMachineEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("summon_manage_machine");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("tutorial");
        BookTextPageModel tutorial = BookTextPageModel.create().withText(this.context().pageText());
        this.context().page("tutorial2");
        BookTextPageModel tutorial2 = BookTextPageModel.create().withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/summon_djinni_manage_machine"));
        this.context().page("book_of_calling");
        BookCraftingRecipePageModel bookOfCalling = (BookCraftingRecipePageModel)((BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/book_of_calling_djinni_manage_machine"))).withText(this.context().pageText());
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)Items.LEVER).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, tutorial, tutorial2, ritual, bookOfCalling});
    }

    private BookEntryModel makeTradeSpiritsEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("trade_spirits");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("intro2");
        BookTextPageModel intro2 = BookTextPageModel.create().withText(this.context().pageText());
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon(this.modLoc("textures/gui/book/cash.png")).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, intro2});
    }

    private BookEntryModel makeSummonOtherstoneTraderEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("summon_otherstone_trader");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("trade");
        BookSpiritTradeRecipePageModel trade = (BookSpiritTradeRecipePageModel)BookSpiritTradeRecipePageModel.create().withRecipeId1(this.modLoc("spirit_trade/stone_to_otherstone"));
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/summon_foliot_otherstone_trader"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismBlocks.OTHERSTONE.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, trade, ritual});
    }

    private BookEntryModel makeSummonOtherworldSaplingTraderEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("summon_otherworld_sapling_trader");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("trade");
        BookSpiritTradeRecipePageModel trade = (BookSpiritTradeRecipePageModel)((BookSpiritTradeRecipePageModel)BookSpiritTradeRecipePageModel.create().withRecipeId1(this.modLoc("spirit_trade/otherworld_sapling"))).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "To trade, drop an your offered item next to the trader, he will pick it up and drop the exchanged item.\n");
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/summon_foliot_sapling_trader"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismBlocks.OTHERWORLD_SAPLING.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, trade, ritual});
    }

    private BookEntryModel makeSummonWildParrotEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("summon_wild_parrot");
        this.context().page("entity");
        BookEntityPageModel entity = BookEntityPageModel.create().withEntityId("minecraft:parrot").withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/summon_wild_parrot"));
        this.context().page("description");
        BookTextPageModel description = BookTextPageModel.create().withText(this.context().pageText());
        this.context().page("description2");
        BookTextPageModel description2 = BookTextPageModel.create().withText(this.context().pageText());
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon(this.modLoc("textures/gui/book/parrot.png")).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{entity, ritual, description, description2});
    }

    private BookEntryModel makeSummonWildOtherworldBirdEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("summon_wild_otherworld_bird");
        this.context().page("entity");
        BookEntityPageModel entity = BookEntityPageModel.create().withEntityId("occultism:otherworld_bird").withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/summon_wild_otherworld_bird"));
        this.context().page("description");
        BookTextPageModel description = BookTextPageModel.create().withText(this.context().pageText());
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon(this.modLoc("textures/gui/book/otherworld_bird.png")).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{entity, ritual, description});
    }

    private BookEntryModel makeWeatherMagicEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("weather_magic");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("ritual_clear");
        BookRitualRecipePageModel ritualClear = (BookRitualRecipePageModel)((BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/summon_djinni_clear_weather"))).withAnchor("clear");
        this.context().page("ritual_rain");
        BookRitualRecipePageModel ritualRain = (BookRitualRecipePageModel)((BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/summon_afrit_rain_weather"))).withAnchor("rain");
        this.context().page("ritual_thunder");
        BookRitualRecipePageModel ritualThunder = (BookRitualRecipePageModel)((BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/summon_afrit_thunder_weather"))).withAnchor("thunder");
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)Items.WHEAT).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, ritualClear, ritualRain, ritualThunder});
    }

    private BookEntryModel makeTimeMagicEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("time_magic");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("ritual_day");
        BookRitualRecipePageModel ritualDay = (BookRitualRecipePageModel)((BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/summon_djinni_day_time"))).withAnchor("day");
        this.context().page("ritual_night");
        BookRitualRecipePageModel ritualNight = (BookRitualRecipePageModel)((BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/summon_djinni_night_time"))).withAnchor("night");
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)Items.CLOCK).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, ritualDay, ritualNight});
    }

    private BookEntryModel makeWitherSkullEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("wither_skull");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/summon_wild_hunt"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)Items.WITHER_SKELETON_SKULL).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, ritual});
    }

    private BookCategoryModel makeCraftingRitualsSubcategory() {
        this.context().category("crafting_rituals");
        CategoryEntryMap entryMap = ModonomiconAPI.get().getEntryMap();
        entryMap.setMap(new String[]{"___________________________", "_______b_e_x_p_q___________", "___________________________", "_______d_h_c_______________", "___________________________", "___9_0_____________________", "___________________________", "_______f_z_a__g____________", "___________________________", "___________n_m_o___________", "___________________________", "___________i_j_k_l_________", "___________________________"});
        BookEntryModel overview = this.makeCraftingRitualsOverviewEntry(entryMap, '0');
        BookEntryModel returnToRituals = this.makeReturnToRitualsEntry(entryMap, '9');
        returnToRituals.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId()));
        returnToRituals.withCondition((BookConditionModel)BookTrueConditionModel.create());
        BookEntryModel craftInfusedPickaxe = this.makeCraftInfusedPickaxeEntry(entryMap, 'd');
        craftInfusedPickaxe.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId()));
        BookEntryModel craftDimensionalMineshaft = this.makeCraftDimensionalMineshaftEntry(entryMap, 'b');
        craftDimensionalMineshaft.withParent(BookEntryParentModel.create((ResourceLocation)craftInfusedPickaxe.getId()));
        BookEntryModel craftFoliotMiner = this.makeCraftFoliotMinerEntry(entryMap, 'e');
        craftFoliotMiner.withParent(BookEntryParentModel.create((ResourceLocation)craftDimensionalMineshaft.getId()));
        BookEntryModel craftDjinniMiner = this.makeCraftDjinniMinerEntry(entryMap, 'x');
        craftDjinniMiner.withParent(BookEntryParentModel.create((ResourceLocation)craftFoliotMiner.getId()));
        BookEntryModel craftAfritMiner = this.makeCraftAfritMinerEntry(entryMap, 'p');
        craftAfritMiner.withParent(BookEntryParentModel.create((ResourceLocation)craftDjinniMiner.getId()));
        BookEntryModel craftMaridMiner = this.makeCraftMaridMinerEntry(entryMap, 'q');
        craftMaridMiner.withParent(BookEntryParentModel.create((ResourceLocation)craftAfritMiner.getId()));
        BookEntryModel craftStorageSystem = this.makeCraftStorageSystemEntry(entryMap, 'z');
        craftStorageSystem.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId()));
        BookEntryModel craftDimensionalMatrix = this.makeCraftDimensionalMatrixEntry(entryMap, 'a');
        craftDimensionalMatrix.withParent(BookEntryParentModel.create((ResourceLocation)craftStorageSystem.getId()));
        BookEntryModel craftStorageControllerBase = this.makeCraftStorageControllerBaseEntry(entryMap, 'n');
        craftStorageControllerBase.withParent(BookEntryParentModel.create((ResourceLocation)craftDimensionalMatrix.getId()));
        BookEntryModel craftStabilizerTier1 = this.makeCraftStabilizerTier1Entry(entryMap, 'i');
        craftStabilizerTier1.withParent(BookEntryParentModel.create((ResourceLocation)craftStorageControllerBase.getId()));
        BookEntryModel craftStabilizerTier2 = this.makeCraftStabilizerTier2Entry(entryMap, 'j');
        craftStabilizerTier2.withParent(BookEntryParentModel.create((ResourceLocation)craftStabilizerTier1.getId()));
        BookEntryModel craftStabilizerTier3 = this.makeCraftStabilizerTier3Entry(entryMap, 'k');
        craftStabilizerTier3.withParent(BookEntryParentModel.create((ResourceLocation)craftStabilizerTier2.getId()));
        BookEntryModel craftStabilizerTier4 = this.makeCraftStabilizerTier4Entry(entryMap, 'l');
        craftStabilizerTier4.withParent(BookEntryParentModel.create((ResourceLocation)craftStabilizerTier3.getId()));
        BookEntryModel craftStableWormhole = this.makeCraftStableWormholeEntry(entryMap, 'm');
        craftStableWormhole.withParent(BookEntryParentModel.create((ResourceLocation)craftStorageControllerBase.getId()));
        BookEntryModel craftStorageRemote = this.makeCraftStorageRemoteEntry(entryMap, 'o');
        craftStorageRemote.withParent(BookEntryParentModel.create((ResourceLocation)craftStableWormhole.getId()));
        BookEntryModel craftOtherworldGoggles = this.makeCraftOtherworldGogglesEntry(entryMap, 'f');
        craftOtherworldGoggles.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId()));
        BookEntryModel craftSatchel = this.makeCraftSatchelEntry(entryMap, 'g');
        craftSatchel.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId()));
        BookEntryModel craftSoulGem = this.makeCraftSoulGemEntry(entryMap, 'h');
        craftSoulGem.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId()));
        BookEntryModel craftFamiliarRing = this.makeCraftFamiliarRingEntry(entryMap, 'c');
        craftFamiliarRing.withParent(BookEntryParentModel.create((ResourceLocation)craftSoulGem.getId()));
        overview.withCondition((BookConditionModel)BookTrueConditionModel.create());
        craftInfusedPickaxe.withCondition((BookConditionModel)BookTrueConditionModel.create());
        craftDimensionalMineshaft.withCondition((BookConditionModel)BookTrueConditionModel.create());
        craftFoliotMiner.withCondition((BookConditionModel)BookTrueConditionModel.create());
        craftDjinniMiner.withCondition((BookConditionModel)BookTrueConditionModel.create());
        craftAfritMiner.withCondition((BookConditionModel)BookTrueConditionModel.create());
        craftMaridMiner.withCondition((BookConditionModel)BookTrueConditionModel.create());
        craftStorageSystem.withCondition((BookConditionModel)BookTrueConditionModel.create());
        craftDimensionalMatrix.withCondition((BookConditionModel)BookTrueConditionModel.create());
        craftStorageControllerBase.withCondition((BookConditionModel)BookTrueConditionModel.create());
        craftStabilizerTier1.withCondition((BookConditionModel)BookTrueConditionModel.create());
        craftStabilizerTier2.withCondition((BookConditionModel)BookTrueConditionModel.create());
        craftStabilizerTier3.withCondition((BookConditionModel)BookTrueConditionModel.create());
        craftStabilizerTier4.withCondition((BookConditionModel)BookTrueConditionModel.create());
        craftStableWormhole.withCondition((BookConditionModel)BookTrueConditionModel.create());
        craftStorageRemote.withCondition((BookConditionModel)BookTrueConditionModel.create());
        craftOtherworldGoggles.withCondition((BookConditionModel)BookTrueConditionModel.create());
        craftSatchel.withCondition((BookConditionModel)BookTrueConditionModel.create());
        craftSoulGem.withCondition((BookConditionModel)BookTrueConditionModel.create());
        craftFamiliarRing.withCondition((BookConditionModel)BookTrueConditionModel.create());
        return BookCategoryModel.create((ResourceLocation)this.modLoc(this.context().categoryId()), (String)this.context().categoryName()).withIcon(this.modLoc("textures/gui/book/infusion.png")).withShowCategoryButton(true).withEntries(new BookEntryModel[]{overview, returnToRituals, craftStorageSystem, craftDimensionalMatrix, craftDimensionalMineshaft, craftInfusedPickaxe, craftFoliotMiner, craftDjinniMiner, craftAfritMiner, craftMaridMiner, craftOtherworldGoggles, craftSatchel, craftSoulGem, craftFamiliarRing, craftStabilizerTier1, craftStabilizerTier2, craftStabilizerTier3, craftStabilizerTier4, craftStableWormhole, craftStorageControllerBase, craftStorageRemote});
    }

    private BookEntryModel makeCraftingRitualsOverviewEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("overview");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon(this.modLoc("textures/gui/book/infusion.png")).withLocation(entryMap.get(Character.valueOf(icon))).withEntryBackground(0, 1).withPages(new BookPageModel[]{intro});
    }

    private BookEntryModel makeCraftStorageSystemEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("craft_storage_system");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.STORAGE_CONTROLLER.get()})).withText(this.context().pageText());
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)Items.CHEST).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight});
    }

    private BookEntryModel makeCraftDimensionalMatrixEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("craft_dimensional_matrix");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.DIMENSIONAL_MATRIX.get()})).withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/craft_dimensional_matrix"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismItems.DIMENSIONAL_MATRIX.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritual});
    }

    private BookEntryModel makeCraftDimensionalMineshaftEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("craft_dimensional_mineshaft");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.DIMENSIONAL_MINESHAFT.get()})).withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/craft_dimensional_mineshaft"));
        this.context().page("description");
        BookTextPageModel description = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismBlocks.DIMENSIONAL_MINESHAFT.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritual, description});
    }

    private BookEntryModel makeCraftInfusedPickaxeEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("craft_infused_pickaxe");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.INFUSED_PICKAXE.get()})).withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/craft_infused_pickaxe"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismItems.INFUSED_PICKAXE.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritual});
    }

    private BookEntryModel makeCraftStorageControllerBaseEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("craft_storage_controller_base");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.STORAGE_CONTROLLER_BASE.get()})).withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/craft_storage_controller_base"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismBlocks.STORAGE_CONTROLLER_BASE.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritual});
    }

    private BookEntryModel makeCraftStabilizerTier1Entry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("craft_stabilizer_tier1");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER1.get()})).withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/craft_stabilizer_tier1"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER1.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritual});
    }

    private BookEntryModel makeCraftStabilizerTier2Entry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("craft_stabilizer_tier2");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER2.get()})).withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/craft_stabilizer_tier2"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER2.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritual});
    }

    private BookEntryModel makeCraftStabilizerTier3Entry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("craft_stabilizer_tier3");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER3.get()})).withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/craft_stabilizer_tier3"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER3.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritual});
    }

    private BookEntryModel makeCraftStabilizerTier4Entry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("craft_stabilizer_tier4");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER4.get()})).withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/craft_stabilizer_tier4"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER4.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritual});
    }

    private BookEntryModel makeCraftStableWormholeEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("craft_stable_wormhole");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.STABLE_WORMHOLE.get()})).withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/craft_stable_wormhole"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismBlocks.STABLE_WORMHOLE.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritual});
    }

    private BookEntryModel makeCraftStorageRemoteEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("craft_storage_remote");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.STORAGE_REMOTE.get()})).withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/craft_storage_remote"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismItems.STORAGE_REMOTE.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritual});
    }

    private BookEntryModel makeCraftFoliotMinerEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("craft_foliot_miner");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("magic_lamp");
        BookTextPageModel lamp = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("magic_lamp_recipe");
        BookCraftingRecipePageModel lampRecipe = (BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/magic_lamp_empty"));
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.MINER_FOLIOT_UNSPECIALIZED.get()})).withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/craft_miner_foliot_unspecialized"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismItems.MINER_FOLIOT_UNSPECIALIZED.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, lamp, lampRecipe, spotlight, ritual});
    }

    private BookEntryModel makeCraftDjinniMinerEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("craft_djinni_miner");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.MINER_DJINNI_ORES.get()})).withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/craft_miner_djinni_ores"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismItems.MINER_DJINNI_ORES.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritual});
    }

    private BookEntryModel makeCraftAfritMinerEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("craft_afrit_miner");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.MINER_AFRIT_DEEPS.get()})).withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/craft_miner_afrit_deeps"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismItems.MINER_AFRIT_DEEPS.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritual});
    }

    private BookEntryModel makeCraftMaridMinerEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("craft_marid_miner");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.MINER_MARID_MASTER.get()})).withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/craft_miner_marid_master"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismItems.MINER_MARID_MASTER.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritual});
    }

    private BookEntryModel makeCraftSatchelEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("craft_satchel");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.SATCHEL.get()})).withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/craft_satchel"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismItems.SATCHEL.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritual});
    }

    private BookEntryModel makeCraftSoulGemEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("craft_soul_gem");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.SOUL_GEM_ITEM.get()})).withText(this.context().pageText());
        this.context().page("usage");
        BookTextPageModel usage = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/craft_soul_gem"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismItems.SOUL_GEM_ITEM.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, usage, ritual});
    }

    private BookEntryModel makeCraftFamiliarRingEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("craft_familiar_ring");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.FAMILIAR_RING.get()})).withText(this.context().pageText());
        this.context().page("usage");
        BookTextPageModel usage = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/craft_familiar_ring"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismItems.FAMILIAR_RING.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, usage, ritual});
    }

    private BookEntryModel makeCraftOtherworldGogglesEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("craft_otherworld_goggles");
        this.context().page("goggles_spotlight");
        BookSpotlightPageModel gogglesSpotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.OTHERWORLD_GOGGLES.get()})).withText(this.context().pageText());
        this.context().page("goggles_more");
        BookTextPageModel gogglesMore = BookTextPageModel.create().withText(this.context().pageText());
        this.context().page("lenses_spotlight");
        BookSpotlightPageModel lensesSpotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.LENSES.get()})).withText(this.context().pageText());
        this.context().page("lenses_more");
        BookTextPageModel lensesMore = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("lenses_recipe");
        BookCraftingRecipePageModel lensesRecipe = (BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/lenses"));
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/craft_infused_lenses"));
        this.context().page("goggles_recipe");
        BookCraftingRecipePageModel gogglesRecipe = (BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/goggles"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismItems.OTHERWORLD_GOGGLES.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{gogglesSpotlight, gogglesMore, lensesSpotlight, lensesMore, lensesRecipe, ritual, gogglesRecipe});
    }

    private BookCategoryModel makePossessionRitualsSubcategory() {
        this.context().category("possession_rituals");
        CategoryEntryMap entryMap = ModonomiconAPI.get().getEntryMap();
        entryMap.setMap(new String[]{"___________________________", "___________________________", "___________________________", "_______D_E_A_I_L_M_________", "___r_o_____________________", "_______F_G_H_J_K_N_________", "___________________________", "___________________________", "___________________________"});
        BookEntryModel overview = this.makePossessionRitualsOverviewEntry(entryMap, 'o');
        BookEntryModel returnToRituals = this.makeReturnToRitualsEntry(entryMap, 'r');
        returnToRituals.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId()));
        returnToRituals.withCondition((BookConditionModel)BookTrueConditionModel.create());
        BookEntryModel possessEndermite = this.makePossessEndermiteEntry(entryMap, 'D');
        possessEndermite.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId()));
        BookEntryModel possessEnderman = this.makePossessEndermanEntry(entryMap, 'E');
        possessEnderman.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId()));
        BookEntryModel possessGhast = this.makePossessGhastEntry(entryMap, 'F');
        possessGhast.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId()));
        BookEntryModel possessSkeleton = this.makePossessSkeletonEntry(entryMap, 'G');
        possessSkeleton.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId()));
        BookEntryModel possessPhantom = this.makePossessPhantomEntry(entryMap, 'I');
        possessPhantom.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId()));
        BookEntryModel possessWeakShulker = this.makePossessWeakShulkerEntry(entryMap, 'J');
        possessWeakShulker.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId()));
        BookEntryModel possessShulker = this.makePossessShulkerEntry(entryMap, 'K');
        possessShulker.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId()));
        BookEntryModel possessElderGuardian = this.makePossessElderGuardianEntry(entryMap, 'L');
        possessElderGuardian.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId()));
        BookEntryModel possessWarden = this.makePossessWardenEntry(entryMap, 'M');
        possessWarden.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId()));
        BookEntryModel possessHoglin = this.makePossessHoglinEntry(entryMap, 'N');
        possessHoglin.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId()));
        this.context().category("summoning_rituals");
        BookEntryModel possessWitherSkeleton = this.makeWitherSkullEntry(entryMap, 'H');
        possessWitherSkeleton.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId()));
        BookEntryModel afritEssence = this.makeAfritEssenceEntry(entryMap, 'A');
        afritEssence.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId()));
        this.context().category("possession_rituals");
        overview.withCondition((BookConditionModel)BookTrueConditionModel.create());
        possessEnderman.withCondition((BookConditionModel)BookTrueConditionModel.create());
        possessEndermite.withCondition((BookConditionModel)BookTrueConditionModel.create());
        possessGhast.withCondition((BookConditionModel)BookTrueConditionModel.create());
        possessSkeleton.withCondition((BookConditionModel)BookTrueConditionModel.create());
        possessPhantom.withCondition((BookConditionModel)BookTrueConditionModel.create());
        possessWeakShulker.withCondition((BookConditionModel)BookTrueConditionModel.create());
        possessShulker.withCondition((BookConditionModel)BookTrueConditionModel.create());
        possessElderGuardian.withCondition((BookConditionModel)BookTrueConditionModel.create());
        possessWarden.withCondition((BookConditionModel)BookTrueConditionModel.create());
        possessHoglin.withCondition((BookConditionModel)BookTrueConditionModel.create());
        possessWitherSkeleton.withCondition((BookConditionModel)BookTrueConditionModel.create());
        afritEssence.withCondition((BookConditionModel)BookTrueConditionModel.create());
        return BookCategoryModel.create((ResourceLocation)this.modLoc(this.context().categoryId()), (String)this.context().categoryName()).withIcon(this.modLoc("textures/gui/book/possession.png")).withShowCategoryButton(true).withEntries(new BookEntryModel[]{overview, returnToRituals, possessEnderman, possessEndermite, possessGhast, possessSkeleton, possessPhantom, possessWeakShulker, possessShulker, possessElderGuardian, possessWarden, possessHoglin, possessWitherSkeleton, afritEssence});
    }

    private BookEntryModel makePossessionRitualsOverviewEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("overview");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon(this.modLoc("textures/gui/book/possession.png")).withLocation(entryMap.get(Character.valueOf(icon))).withEntryBackground(0, 1).withPages(new BookPageModel[]{intro});
    }

    private BookEntryModel makePossessEndermanEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("possess_enderman");
        this.context().page("entity");
        BookEntityPageModel entity = BookEntityPageModel.create().withEntityId("occultism:possessed_enderman").withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/possess_enderman"));
        this.context().page("description");
        BookTextPageModel description = BookTextPageModel.create().withText(this.context().pageText());
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)Items.ENDER_PEARL).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{entity, ritual, description});
    }

    private BookEntryModel makePossessEndermiteEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("possess_endermite");
        this.context().page("entity");
        BookEntityPageModel entity = BookEntityPageModel.create().withEntityId("occultism:possessed_endermite").withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/possess_endermite"));
        this.context().page("description");
        BookTextPageModel description = BookTextPageModel.create().withText(this.context().pageText());
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)Blocks.END_STONE).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{entity, ritual, description});
    }

    private BookEntryModel makePossessGhastEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("possess_ghast");
        this.lang().add(this.context().entryName(), "Possessed Ghast");
        this.context().page("entity");
        BookEntityPageModel entity = BookEntityPageModel.create().withEntityId("occultism:possessed_ghast").withScale(0.5f).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "**Drops**: 1-3x [](item://minecraft:ghast_tear)\n");
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/possess_ghast"));
        this.context().page("description");
        BookTextPageModel description = BookTextPageModel.create().withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "In this ritual a [#](%1$s)Ghast[#]() is spawned using the life energy of a [#](%1$s)Cow[#]() and immediately possessed by the summoned [#](%1$s)Djinni[#](). The [#](%1$s)Possessed Ghast[#]() will always drop at least one [](item://minecraft:ghast_tear) when killed.\n".formatted(COLOR_PURPLE));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)Items.GHAST_TEAR).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{entity, ritual, description});
    }

    private BookEntryModel makePossessSkeletonEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("possess_skeleton");
        this.context().page("entity");
        BookEntityPageModel entity = BookEntityPageModel.create().withEntityId("occultism:possessed_skeleton").withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/possess_skeleton"));
        this.context().page("description");
        BookTextPageModel description = BookTextPageModel.create().withText(this.context().pageText());
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)Items.SKELETON_SKULL).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{entity, ritual, description});
    }

    private BookEntryModel makePossessPhantomEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("possess_phantom");
        this.lang().add(this.context().entryName(), "Possessed Phantom");
        this.context().page("entity");
        BookEntityPageModel entity = BookEntityPageModel.create().withEntityId("occultism:possessed_phantom").withScale(0.5f).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "**Drops**: 1-4x [](item://minecraft:phantom_membrane)\n");
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/possess_phantom"));
        this.context().page("description");
        BookTextPageModel description = BookTextPageModel.create().withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "In this ritual a [#](%1$s)Phantom[#]() is spawned using the life energy of a [#](%1$s)Flying Passive Mob[#]() and immediately possessed by the summoned [#](%1$s)Foliot[#](). The [#](%1$s)Possessed Phantom[#]() will always drop at least one [](item://minecraft:phantom_membrane) when killed. Using this ritual is easy to trap the phantom and you can has comfy sleep.\n".formatted(COLOR_PURPLE));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)Items.PHANTOM_MEMBRANE).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{entity, ritual, description});
    }

    private BookEntryModel makePossessWeakShulkerEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("possess_weak_shulker");
        this.lang().add(this.context().entryName(), "Possessed Weak Shulker");
        this.context().page("entity");
        BookEntityPageModel entity = BookEntityPageModel.create().withEntityId("occultism:possessed_weak_shulker").withScale(0.5f).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "**Drops**: 1-3x [](item://minecraft:chorus_fruit);\nand as 10% to drop a [](item://minecraft:shulker_shell);\n");
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/possess_weak_shulker"));
        this.context().page("description");
        BookTextPageModel description = BookTextPageModel.create().withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "In this ritual a [#](%1$s)Shulker[#]() is spawned using the life energy of a [#](%1$s)Cube Mob[#]() and immediately possessed by the summoned [#](%1$s)Djinni[#](). The [#](%1$s)Possessed Weak Shulker[#]() will always drop at least one [](item://minecraft:chorus_fruit) when killed and as a chance to drop [](item://minecraft:shulker_shell). You can use vanilla shulker multiplication to get normal shulkers with more chance to drop their shells.\n".formatted(COLOR_PURPLE));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)Items.CHORUS_FRUIT).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{entity, ritual, description});
    }

    private BookEntryModel makePossessShulkerEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("possess_shulker");
        this.lang().add(this.context().entryName(), "Possessed Shulker");
        this.context().page("entity");
        BookEntityPageModel entity = BookEntityPageModel.create().withEntityId("occultism:possessed_shulker").withScale(0.5f).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "**Drops**: 1-2x [](item://minecraft:shulker_shell);\n");
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/possess_shulker"));
        this.context().page("description");
        BookTextPageModel description = BookTextPageModel.create().withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "In this ritual a [#](%1$s)Shulker[#]() is spawned using the life energy of a [#](%1$s)Cube Mob[#]() and immediately possessed by the summoned [#](%1$s)Afrit[#](). The [#](%1$s)Possessed Shulker[#]() will always drop at least one [](item://minecraft:shulker_shell) when killed. You can use vanilla shulker multiplication to get normal shulkers but their have less chance to drop shells.\n".formatted(COLOR_PURPLE));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)Items.SHULKER_SHELL).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{entity, ritual, description});
    }

    private BookEntryModel makePossessElderGuardianEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("possess_elder_guardian");
        this.lang().add(this.context().entryName(), "Possessed Elder Guardian");
        this.context().page("entity");
        BookEntityPageModel entity = BookEntityPageModel.create().withEntityId("occultism:possessed_elder_guardian").withScale(0.5f).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "**Drops**: 2-4x [](item://minecraft:nautilus_shell);\nand as 40% to drop a [](item://minecraft:heart_of_the_sea);\nAlso commom Elder Guardian loot;\n");
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/possess_elder_guardian"));
        this.context().page("description");
        BookTextPageModel description = BookTextPageModel.create().withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "In this ritual a [#](%1$s)Elder Guardian[#]() is spawned using the life energy of a [#](%1$s)Fish[#]() and immediately possessed by the summoned [#](%1$s)Afrit[#](). The [#](%1$s)Possessed Elder Guardian[#]() will always drop at least one [](item://minecraft:nautilus_shell), having a chance to drop [](item://minecraft:heart_of_the_sea) and a lot of things that normal Elder Guardian drops.\n".formatted(COLOR_PURPLE));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)Items.HEART_OF_THE_SEA).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{entity, ritual, description});
    }

    private BookEntryModel makePossessWardenEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("possess_warden");
        this.lang().add(this.context().entryName(), "Possessed Warden");
        this.context().page("entity");
        BookEntityPageModel entity = BookEntityPageModel.create().withEntityId("occultism:possessed_warden").withScale(1.0f).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "**Drops**: 1x [](item://minecraft:echo_shard)\nand items related to ancient city;\n");
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/possess_warden"));
        this.context().page("description");
        BookTextPageModel description = BookTextPageModel.create().withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "In this ritual a [#](%1$s)Warden[#]() is spawned using the life energy of a [#](%1$s)Axolotl[#]() and immediately possessed by the summoned [#](%1$s)Djinni[#](). The [#](%1$s)Possessed Warden[#]() will always drop at least one [](item://minecraft:echo_shard) when killed and as a chance to drop [](item://minecraft:disc_fragment_5), [](item://minecraft:music_disc_otherside), [](item://minecraft:silence_armor_trim_smithing_template), [](item://minecraft:ward_armor_trim_smithing_template). If you try to escape, this possessed Warden will go to the floor like a normal warden.\n".formatted(COLOR_PURPLE));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)Items.ECHO_SHARD).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{entity, ritual, description});
    }

    private BookEntryModel makePossessHoglinEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("possess_hoglin");
        this.lang().add(this.context().entryName(), "Possessed Hoglin");
        this.context().page("entity");
        BookEntityPageModel entity = BookEntityPageModel.create().withEntityId("occultism:possessed_hoglin").withScale(0.7f).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "  **Drops**: Can drop: [](item://minecraft:netherite_upgrade_smithing_template),\n  return back [](item://minecraft:netherite_scrap) or nothing;\n");
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/possess_hoglin"));
        this.context().page("description");
        BookTextPageModel description = BookTextPageModel.create().withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "In this ritual a [#](%1$s)Hoglin[#]() is spawned using the life energy of a [#](%1$s)Pig[#]() and immediately possessed by the summoned [#](%1$s)Afrit[#](). The [#](%1$s)Possessed Hoglin[#]() can drop a [](item://minecraft:netherite_upgrade_smithing_template), [](item://minecraft:snout_armor_trim_smithing_template), return back [](item://minecraft:netherite_scrap) or nothing when killed. You need to kill this mob before the transformation to a Zoglin if you don't want to perform the ritual in the nether.\n".formatted(COLOR_PURPLE));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{entity, ritual, description});
    }

    private BookCategoryModel makeStorageCategory() {
        this.context().category("storage");
        CategoryEntryMap entryMap = ModonomiconAPI.get().getEntryMap();
        entryMap.setMap(new String[]{"___________________________", "_________w_r_______________", "___________________________", "_____0_c___s_1_2_3_4________", "___________________________", "_________d_________________", "___________________________"});
        BookEntryModel overview = this.makeStorageOverviewEntry(entryMap, '0');
        this.context().category("storage");
        BookEntryModel storageController = this.makeStorageControllerEntry(entryMap, 'c');
        storageController.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId()));
        BookEntryModel storageStabilizer = this.makeStorageStabilizerEntry(entryMap, 's');
        storageStabilizer.withParent(BookEntryParentModel.create((ResourceLocation)storageController.getId()));
        this.context().category("crafting_rituals");
        BookEntryModel craftStabilizerTier1 = this.makeCraftStabilizerTier1Entry(entryMap, '1');
        craftStabilizerTier1.withParent(BookEntryParentModel.create((ResourceLocation)storageStabilizer.getId()));
        BookEntryModel craftStabilizerTier2 = this.makeCraftStabilizerTier2Entry(entryMap, '2');
        craftStabilizerTier2.withParent(BookEntryParentModel.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)craftStabilizerTier1.getId().getNamespace(), (String)("storage/" + craftStabilizerTier1.getId().getPath()))));
        BookEntryModel craftStabilizerTier3 = this.makeCraftStabilizerTier3Entry(entryMap, '3');
        craftStabilizerTier3.withParent(BookEntryParentModel.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)craftStabilizerTier2.getId().getNamespace(), (String)("storage/" + craftStabilizerTier2.getId().getPath()))));
        BookEntryModel craftStabilizerTier4 = this.makeCraftStabilizerTier4Entry(entryMap, '4');
        craftStabilizerTier4.withParent(BookEntryParentModel.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)craftStabilizerTier3.getId().getNamespace(), (String)("storage/" + craftStabilizerTier3.getId().getPath()))));
        BookEntryModel craftStableWormhole = this.makeCraftStableWormholeEntry(entryMap, 'w');
        craftStableWormhole.withParent(BookEntryParentModel.create((ResourceLocation)storageController.getId()));
        BookEntryModel craftStorageRemote = this.makeCraftStorageRemoteEntry(entryMap, 'r');
        craftStorageRemote.withParent(BookEntryParentModel.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)craftStableWormhole.getId().getNamespace(), (String)("storage/" + craftStableWormhole.getId().getPath()))));
        this.context().category("summoning_rituals");
        BookEntryModel summonManageMachine = this.makeSummonManageMachineEntry(entryMap, 'd');
        summonManageMachine.withParent(BookEntryParentModel.create((ResourceLocation)storageController.getId()));
        this.context().category("storage");
        return BookCategoryModel.create((ResourceLocation)this.modLoc(this.context().categoryId()), (String)this.context().categoryName()).withIcon((ItemLike)Items.CHEST).withEntries(new BookEntryModel[]{overview, storageController, storageStabilizer, craftStabilizerTier1, craftStabilizerTier2, craftStabilizerTier3, craftStabilizerTier4, craftStableWormhole, craftStorageRemote, summonManageMachine});
    }

    private BookEntryModel makeStorageOverviewEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("overview");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("intro2");
        BookTextPageModel intro2 = BookTextPageModel.create().withText(this.context().pageText());
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)Items.CHEST).withLocation(entryMap.get(Character.valueOf(icon))).withEntryBackground(0, 1).withPages(new BookPageModel[]{intro, intro2});
    }

    private BookEntryModel makeStorageControllerEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("storage_controller");
        this.context().page("intro");
        BookSpotlightPageModel intro = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.STORAGE_CONTROLLER.get()})).withText(this.context().pageText());
        this.context().page("usage");
        BookTextPageModel usage = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("safety");
        BookTextPageModel safety = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("size");
        BookTextPageModel size = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("unique_items");
        BookTextPageModel uniqueItems = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("config");
        BookTextPageModel config = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("mods");
        BookTextPageModel mods = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("matrix_ritual");
        BookRitualRecipePageModel matrixRitual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/craft_dimensional_matrix"));
        this.context().page("base_ritual");
        BookRitualRecipePageModel baseRitual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/craft_storage_controller_base"));
        this.context().page("recipe");
        BookCraftingRecipePageModel recipe = (BookCraftingRecipePageModel)((BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/storage_controller"))).withText(this.context().pageText());
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismBlocks.STORAGE_CONTROLLER.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, usage, safety, size, uniqueItems, config, mods, matrixRitual, baseRitual, recipe});
    }

    private BookEntryModel makeStorageStabilizerEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("storage_stabilizer");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER1.get()})).withText(this.context().pageText());
        this.context().page("upgrade");
        BookTextPageModel upgrade = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("build_instructions");
        BookTextPageModel buildInstructions = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("demo");
        BookMultiblockPageModel demo = BookMultiblockPageModel.create().withMultiblockId(this.modLoc("storage_stabilizer_demo")).withMultiblockName(this.context().pageTitle());
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismBlocks.STORAGE_CONTROLLER.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, upgrade, buildInstructions, demo});
    }
}

