/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.datagen;

import com.klikli_dev.occultism.registry.OccultismItems;
import java.util.ArrayList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredItem;

public class ItemModelsGenerator
extends ItemModelProvider {
    public ItemModelsGenerator(PackOutput packOutput, ExistingFileHelper existingFileHelper) {
        super(packOutput, "occultism", existingFileHelper);
    }

    protected void registerModels() {
        BuiltInRegistries.ITEM.forEach(item -> {
            ResourceLocation key = BuiltInRegistries.ITEM.getKey(item);
            if (key.getPath().startsWith("ritual_dummy/")) {
                this.registerRitualDummy("item/" + key.getPath());
            }
        });
        this.registerAdvancementItem();
        this.registerSpawnEgg(OccultismItems.SPAWN_EGG_DEMONIC_WIFE);
        this.registerSpawnEgg(OccultismItems.SPAWN_EGG_DEMONIC_HUSBAND);
        this.registerItemGenerated(this.name((Item)OccultismItems.SOUL_SHARD_ITEM.get()));
        this.registerItemGenerated(this.name((Item)OccultismItems.DEMONS_DREAM_ESSENCE.get()));
        this.registerItemGenerated(this.name((Item)OccultismItems.OTHERWORLD_ESSENCE.get()));
    }

    protected String name(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item).getPath();
    }

    private ItemModelBuilder registerItemGenerated(String name) {
        return this.registerItemGenerated(name, name);
    }

    private ItemModelBuilder registerItemGenerated(String name, String texture) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.modLoc("item/" + texture));
    }

    private void registerRitualDummy(String name) {
        ((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile("occultism:item/ritual_dummy"));
    }

    private void registerSpawnEgg(DeferredItem<Item> spawnEgg) {
        ((ItemModelBuilder)this.getBuilder("item/" + spawnEgg.getId().getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/template_spawn_egg"));
    }

    private void registerAdvancementItem() {
        String[] textures = new String[]{"cthulhu_icon", "bat_icon", "deer_icon", "devil_icon", "greedy_icon", "hat_icon", "dragon_icon", "blacksmith_icon", "guardian_icon", "headless_icon", "chimera_icon", "shub_niggurath_icon", "shub_niggurath_spawn_icon", "beholder_icon", "fairy_icon", "mummy_icon", "beaver_icon"};
        ArrayList<ItemModelBuilder> icons = new ArrayList<ItemModelBuilder>();
        for (String texture : textures) {
            icons.add((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent("item/advancement/" + texture, this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/advancement/" + texture)));
        }
        ItemModelBuilder builder = (ItemModelBuilder)this.withExistingParent("item/advancement_icon", this.mcLoc("item/generated"));
        for (int i = 0; i < icons.size(); ++i) {
            builder.override().predicate(this.mcLoc("custom_model_data"), (float)i).model((ModelFile)icons.get(i)).end();
        }
    }
}

