/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.crafting.recipe.result;

import com.klikli_dev.occultism.crafting.recipe.result.RecipeResult;
import com.klikli_dev.occultism.crafting.recipe.result.RecipeResultType;
import com.klikli_dev.occultism.crafting.recipe.result.WeightedRecipeResult;
import com.klikli_dev.occultism.registry.OccultismRecipeResults;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class WeightedItemRecipeResult
extends WeightedRecipeResult {
    public static final MapCodec<WeightedItemRecipeResult> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ItemStack.OPTIONAL_CODEC.fieldOf("stack").forGetter(WeightedItemRecipeResult::getStack), (App)Codec.INT.fieldOf("weight").forGetter(WeightedRecipeResult::weight)).apply((Applicative)builder, WeightedItemRecipeResult::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, WeightedItemRecipeResult> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, WeightedItemRecipeResult::getStack, (StreamCodec)ByteBufCodecs.INT, WeightedRecipeResult::weight, WeightedItemRecipeResult::new);
    private final ItemStack stack;
    @Nullable
    private ItemStack[] cachedStacks;

    public WeightedItemRecipeResult(ItemStack stack, int weight) {
        super(weight);
        this.stack = stack;
    }

    @Override
    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public ItemStack[] getStacks() {
        if (this.cachedStacks == null) {
            this.cachedStacks = new ItemStack[]{this.stack};
        }
        return this.cachedStacks;
    }

    @Override
    public RecipeResultType<?> getType() {
        return (RecipeResultType)OccultismRecipeResults.WEIGHTED_ITEM.get();
    }

    @Override
    public RecipeResult copyWithCount(int count) {
        return new WeightedItemRecipeResult(this.stack.copyWithCount(count), this.weight.asInt());
    }

    @Override
    public RecipeResult copyWithWeight(int weight) {
        return new WeightedItemRecipeResult(this.stack, weight);
    }
}

