/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.crafting.recipe;

import com.klikli_dev.occultism.registry.OccultismRecipes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;

public class SpiritTradeRecipe
extends ShapelessRecipe {
    public static final StreamCodec<RegistryFriendlyByteBuf, SpiritTradeRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);
    private static final MapCodec<SpiritTradeRecipe> CODEC = RecordCodecBuilder.mapCodec(p_340779_ -> p_340779_.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(p_301127_ -> p_301127_.getGroup()), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(p_301133_ -> p_301133_.category()), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(p_301142_ -> p_301142_.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY)), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(p_301021_ -> {
        Object[] aingredient = (Ingredient[])p_301021_.toArray(Ingredient[]::new);
        if (aingredient.length == 0) {
            return DataResult.error(() -> "No ingredients for shapeless recipe");
        }
        return aingredient.length > ShapedRecipePattern.getMaxHeight() * ShapedRecipePattern.getMaxWidth() ? DataResult.error(() -> "Too many ingredients for shapeless recipe. The maximum is: %s".formatted(ShapedRecipePattern.getMaxHeight() * ShapedRecipePattern.getMaxWidth())) : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])aingredient));
    }, DataResult::success).forGetter(p_300975_ -> p_300975_.getIngredients())).apply((Applicative)p_340779_, (group, category, result, ingredients) -> new SpiritTradeRecipe((String)group, (ItemStack)result, (NonNullList<Ingredient>)ingredients)));
    public static Serializer SERIALIZER = new Serializer();

    public SpiritTradeRecipe(String group, ItemStack result, NonNullList<Ingredient> input) {
        super(group, CraftingBookCategory.MISC, result, input);
    }

    public boolean isSpecial() {
        return true;
    }

    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    public boolean matches(@Nonnull CraftingInput inventory, @Nonnull Level level) {
        return false;
    }

    public ItemStack assemble(CraftingInput pCraftingContainer, HolderLookup.Provider pRegistries) {
        return null;
    }

    public RecipeType<?> getType() {
        return (RecipeType)OccultismRecipes.SPIRIT_TRADE_TYPE.get();
    }

    public List<ItemStack> consume(List<ItemStack> input) {
        List<ItemStack> result = input.stream().map(ItemStack::copy).collect(Collectors.toList());
        for (Ingredient ingredient : this.getIngredients()) {
            Iterator<ItemStack> it = result.iterator();
            while (it.hasNext()) {
                ItemStack stack = it.next();
                if (!ingredient.test(stack)) continue;
                stack.shrink(1);
                if (!stack.isEmpty()) continue;
                it.remove();
            }
        }
        return result;
    }

    public boolean isValid(ItemStack ... input) {
        return this.isValid(Arrays.asList(input));
    }

    public boolean isValid(List<ItemStack> input) {
        List cached = input.stream().map(ItemStack::copy).collect(Collectors.toList());
        for (Ingredient ingredient : this.getIngredients()) {
            boolean matched = false;
            Iterator it = cached.iterator();
            while (it.hasNext()) {
                ItemStack stack = (ItemStack)it.next();
                if (!ingredient.test(stack)) continue;
                matched = true;
                stack.shrink(1);
                if (!stack.isEmpty()) continue;
                it.remove();
            }
            if (matched) continue;
            return false;
        }
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<SpiritTradeRecipe> {
        private static SpiritTradeRecipe fromNetwork(RegistryFriendlyByteBuf p_319905_) {
            String s = p_319905_.readUtf();
            CraftingBookCategory craftingbookcategory = (CraftingBookCategory)p_319905_.readEnum(CraftingBookCategory.class);
            int i = p_319905_.readVarInt();
            NonNullList nonnulllist = NonNullList.withSize((int)i, (Object)Ingredient.EMPTY);
            nonnulllist.replaceAll(p_319735_ -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)p_319905_));
            ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)p_319905_);
            return new SpiritTradeRecipe(s, itemstack, (NonNullList<Ingredient>)nonnulllist);
        }

        private static void toNetwork(RegistryFriendlyByteBuf p_320371_, SpiritTradeRecipe p_320323_) {
            p_320371_.writeUtf(p_320323_.getGroup());
            p_320371_.writeEnum((Enum)p_320323_.category());
            p_320371_.writeVarInt(p_320323_.getIngredients().size());
            for (Ingredient ingredient : p_320323_.getIngredients()) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)p_320371_, (Object)ingredient);
            }
            ItemStack.STREAM_CODEC.encode((Object)p_320371_, (Object)p_320323_.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY));
        }

        public MapCodec<SpiritTradeRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, SpiritTradeRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

