/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.config;

import net.neoforged.neoforge.common.ModConfigSpec;

public class OccultismServerConfig {
    public final StorageSettings storage;
    public final SpiritJobSettings spiritJobs;
    public final RitualSettings rituals;
    public final DimensionalMineshaftSettings dimensionalMineshaft;
    public final ItemSettings itemSettings;
    public final ModConfigSpec spec;

    public OccultismServerConfig() {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        this.storage = new StorageSettings(builder);
        this.spiritJobs = new SpiritJobSettings(builder);
        this.rituals = new RitualSettings(builder);
        this.dimensionalMineshaft = new DimensionalMineshaftSettings(builder);
        this.itemSettings = new ItemSettings(builder);
        this.spec = builder.build();
    }

    public static class StorageSettings {
        public final ModConfigSpec.IntValue stabilizerTier1AdditionalMaxItemTypes;
        public final ModConfigSpec.LongValue stabilizerTier1AdditionalMaxTotalItemCount;
        public final ModConfigSpec.IntValue stabilizerTier2AdditionalMaxItemTypes;
        public final ModConfigSpec.LongValue stabilizerTier2AdditionalMaxTotalItemCount;
        public final ModConfigSpec.IntValue stabilizerTier3AdditionalMaxItemTypes;
        public final ModConfigSpec.LongValue stabilizerTier3AdditionalMaxTotalItemCount;
        public final ModConfigSpec.IntValue stabilizerTier4AdditionalMaxItemTypes;
        public final ModConfigSpec.LongValue stabilizerTier4AdditionalMaxTotalItemCount;
        public final ModConfigSpec.IntValue controllerMaxItemTypes;
        public final ModConfigSpec.LongValue controllerMaxTotalItemCount;
        public final ModConfigSpec.BooleanValue unlinkWormholeOnBreak;

        public StorageSettings(ModConfigSpec.Builder builder) {
            builder.comment("Storage Settings").push("storage");
            this.stabilizerTier1AdditionalMaxItemTypes = builder.comment("The amount of additional slots the storage stabilizer tier 1 provides. 1 Slot holds one item type.").defineInRange("stabilizerTier1AdditionalMaxItemTypes", 64, 0, Integer.MAX_VALUE);
            this.stabilizerTier1AdditionalMaxTotalItemCount = builder.comment("The amount by which the stabilizer increases the maximum total item count the controller can hold. This is not per slot but the total amount of all items combined.").defineInRange("stabilizerTier1AdditionalMaxTotalItemCount", 512000L, 0L, Integer.MAX_VALUE);
            this.stabilizerTier2AdditionalMaxItemTypes = builder.comment("The amount of slots the storage stabilizer tier 2 provides.").defineInRange("stabilizerTier2AdditionalMaxItemTypes", 128, 0, Integer.MAX_VALUE);
            this.stabilizerTier2AdditionalMaxTotalItemCount = builder.comment("The amount by which the stabilizer increases the maximum total item count the controller can hold. This is not per slot but the total amount of all items combined.").defineInRange("stabilizerTier2AdditionalMaxTotalItemCount", 1024000L, 0L, Integer.MAX_VALUE);
            this.stabilizerTier3AdditionalMaxItemTypes = builder.comment("The amount of slots the storage stabilizer tier 3 provides.").defineInRange("stabilizerTier3AdditionalMaxItemTypes", 256, 0, Integer.MAX_VALUE);
            this.stabilizerTier3AdditionalMaxTotalItemCount = builder.comment("The amount by which the stabilizer increases the maximum total item count the controller can hold. This is not per slot but the total amount of all items combined.").defineInRange("stabilizerTier3AdditionalMaxTotalItemCount", 2048000L, 0L, Integer.MAX_VALUE);
            this.stabilizerTier4AdditionalMaxItemTypes = builder.comment("The amount of slots the storage stabilizer tier 4 provides.").defineInRange("stabilizerTier4AdditionalMaxItemTypes", 512, 0, Integer.MAX_VALUE);
            this.stabilizerTier4AdditionalMaxTotalItemCount = builder.comment("The amount by which the stabilizer increases the maximum total item count the controller can hold. This is not per slot but the total amount of all items combined.").defineInRange("stabilizerTier4AdditionalMaxTotalItemCount", 4096000L, 0L, Long.MAX_VALUE);
            this.controllerMaxItemTypes = builder.comment("The amount of slots the storage actuator provides.").defineInRange("controllerMaxItemTypes", 128, 0, Integer.MAX_VALUE);
            this.controllerMaxTotalItemCount = builder.comment("The stack size the storage actuator uses.").defineInRange("controllerMaxTotalItemCount", 256000L, 0L, Long.MAX_VALUE);
            this.unlinkWormholeOnBreak = builder.comment("True to use the configured controllerStackSize for all items, instead of the stack sizes provided by item type (such as 16 for ender pearls, 64 for iron ingot). WARNING: Setting this to false may have a negative impact on performance.").define("unlinkWormholeOnBreak", false);
            builder.pop();
        }
    }

    public static class SpiritJobSettings {
        public final ModConfigSpec.ConfigValue<Double> tier1CrusherTimeMultiplier;
        public final ModConfigSpec.ConfigValue<Double> tier2CrusherTimeMultiplier;
        public final ModConfigSpec.ConfigValue<Double> tier3CrusherTimeMultiplier;
        public final ModConfigSpec.ConfigValue<Double> tier4CrusherTimeMultiplier;
        public final ModConfigSpec.ConfigValue<Double> tier1CrusherOutputMultiplier;
        public final ModConfigSpec.ConfigValue<Double> tier2CrusherOutputMultiplier;
        public final ModConfigSpec.ConfigValue<Double> tier3CrusherOutputMultiplier;
        public final ModConfigSpec.ConfigValue<Double> tier4CrusherOutputMultiplier;
        public final ModConfigSpec.IntValue drikwingFamiliarSlowFallingSeconds;
        public final ModConfigSpec.IntValue crusherResultPickupDelay;
        public final ModConfigSpec.IntValue blacksmithFamiliarUpgradeCost;
        public final ModConfigSpec.IntValue blacksmithFamiliarUpgradeCooldown;
        public final ModConfigSpec.ConfigValue<Double> blacksmithFamiliarRepairChance;

        public SpiritJobSettings(ModConfigSpec.Builder builder) {
            builder.comment("Spirit Job Settings").push("spirit_job");
            this.drikwingFamiliarSlowFallingSeconds = builder.comment("The duration for the slow falling effect applied by a drikwing.").defineInRange("drikwingFamiliarSlowFallingSeconds", 15, 0, Integer.MAX_VALUE);
            this.tier1CrusherTimeMultiplier = builder.comment("The multiplier to each crushing recipe's crushing_time for Tier 1 (Foliot) Crusher Spirits.").define("tier1CrusherTimeMultiplier", (Object)2.0);
            this.tier2CrusherTimeMultiplier = builder.comment("The multiplier to each crushing recipe's crushing_time for Tier 2 (Djinni) Crusher Spirits.").define("tier2CrusherTimeMultiplier", (Object)1.0);
            this.tier3CrusherTimeMultiplier = builder.comment("Currently unused. The multiplier to each crushing recipe's crushing_time for Tier 3 (Afrit) Crusher Spirits.").define("tier3CrusherTimeMultiplier", (Object)0.5);
            this.tier4CrusherTimeMultiplier = builder.comment("Currently unused. The multiplier to each crushing recipe's crushing_time for Tier 4 (Marid) Crusher Spirits.").define("tier4CrusherTimeMultiplier", (Object)0.2);
            this.tier1CrusherOutputMultiplier = builder.comment("The multiplier to each crushing recipe's output count for Tier 1 (Foliot) Crusher Spirits.").define("tier1CrusherOutputMultiplier", (Object)1.0);
            this.tier2CrusherOutputMultiplier = builder.comment("The multiplier to each crushing recipe's output count for Tier 2 (Djinni) Crusher Spirits.").define("tier2CrusherOutputMultiplier", (Object)1.5);
            this.tier3CrusherOutputMultiplier = builder.comment("The multiplier to each crushing recipe's output count for Tier 3 (Afrit) Crusher Spirits.").define("tier3CrusherOutputMultiplier", (Object)2.0);
            this.tier4CrusherOutputMultiplier = builder.comment("The multiplier to each crushing recipe's output count for Tier 4 (Marid) Crusher Spirits.").define("tier4CrusherOutputMultiplier", (Object)3.0);
            this.crusherResultPickupDelay = builder.comment("The minimum ticks before a crusher can pick up an item it dropped. Default is 3 Seconds = 3 * 20 Ticks.").defineInRange("crusherResultPickupDelay", 60, 0, Integer.MAX_VALUE);
            this.blacksmithFamiliarRepairChance = builder.comment("The chance for a blacksmith familiar to repair an item (by 2 durability) whenever stone is picked up. 1.0 = 100%, 0.0 = 0%.").define("blacksmithFamiliarRepairChance", (Object)0.05);
            this.blacksmithFamiliarUpgradeCost = builder.comment("The amount of iron required for a blacksmith familiar to upgrade another familiar.").defineInRange("blacksmithFamiliarUpgradeCost", 18, 0, Integer.MAX_VALUE);
            this.blacksmithFamiliarUpgradeCooldown = builder.comment("The cooldown for a blacksmith familiar to upgrade another familiar.").defineInRange("blacksmithFamiliarUpgradeCooldown", 400, 0, Integer.MAX_VALUE);
            builder.pop();
        }
    }

    public static class RitualSettings {
        public final ModConfigSpec.BooleanValue enableClearWeatherRitual;
        public final ModConfigSpec.BooleanValue enableRainWeatherRitual;
        public final ModConfigSpec.BooleanValue enableThunderWeatherRitual;
        public final ModConfigSpec.BooleanValue enableDayTimeRitual;
        public final ModConfigSpec.BooleanValue enableNightTimeRitual;
        public final ModConfigSpec.BooleanValue enableRemainingIngredientCountMatching;
        public final ModConfigSpec.DoubleValue ritualDurationMultiplier;

        public RitualSettings(ModConfigSpec.Builder builder) {
            builder.comment("Ritual Settings").push("rituals");
            this.enableClearWeatherRitual = builder.comment("Enables the ritual to clear rainy weather.").define("enableClearWeatherRitual", true);
            this.enableRainWeatherRitual = builder.comment("Enables the ritual to start rainy weather.").define("enableRainWeatherRitual", true);
            this.enableThunderWeatherRitual = builder.comment("Enables the ritual to start a thunderstorm.").define("enableThunderWeatherRitual", true);
            this.enableDayTimeRitual = builder.comment("Enables the ritual to set time to day.").define("enableDayTimeRitual", true);
            this.enableNightTimeRitual = builder.comment("Enables the ritual to set time to night.").define("enableNightTimeRitual", true);
            this.enableRemainingIngredientCountMatching = builder.comment("If enabled, rituals are interrupted if *more* ingredients are present than needed. This should usually be disabled, but can improve performance if (very very) many rituals are running.").define("enableRemainingIngredientCountMatching", false);
            this.ritualDurationMultiplier = builder.comment("Set a value below 1.0 to speed up rituals.").defineInRange("ritualDurationMultiplier", 1.0, 0.05, Double.MAX_VALUE);
            builder.pop();
        }
    }

    public static class DimensionalMineshaftSettings {
        public final MinerSpiritSettings minerFoliotUnspecialized;
        public final MinerSpiritSettings minerDjinniOres;
        public final MinerSpiritSettings minerAfritDeeps;
        public final MinerSpiritSettings minerMaridMaster;

        public DimensionalMineshaftSettings(ModConfigSpec.Builder builder) {
            builder.comment("Dimensional Mineshaft Settings").push("dimensional_mineshaft");
            this.minerFoliotUnspecialized = new MinerSpiritSettings("miner_foliot_unspecialized", builder, 400, 1, 1000);
            this.minerDjinniOres = new MinerSpiritSettings("miner_djinni_ores", builder, 300, 1, 400);
            this.minerAfritDeeps = new MinerSpiritSettings("miner_afrit_deeps", builder, 200, 1, 800);
            this.minerMaridMaster = new MinerSpiritSettings("miner_marid_master", builder, 100, 1, 1600);
            builder.pop();
        }

        public static class MinerSpiritSettings {
            public final ModConfigSpec.IntValue maxMiningTime;
            public final ModConfigSpec.IntValue rollsPerOperation;
            public final ModConfigSpec.IntValue durability;

            public MinerSpiritSettings(String oreName, ModConfigSpec.Builder builder, int maxMiningTime, int rollsPerOperation, int durability) {
                builder.comment("Miner Spirit Settings").push(oreName);
                this.maxMiningTime = builder.comment("The amount of time it takes the spirit to perform one mining operation.").defineInRange("maxMiningTime", maxMiningTime, 0, Integer.MAX_VALUE);
                this.rollsPerOperation = builder.comment("The amount of blocks the spirit will obtain per mining operation").defineInRange("rollsPerOperation", rollsPerOperation, 0, Integer.MAX_VALUE);
                this.durability = builder.comment("The amount of mining operations the spirit can perform before breaking.").defineInRange("durability", durability, 0, Integer.MAX_VALUE);
                builder.pop();
            }
        }
    }

    public static class ItemSettings {
        public ItemSettings(ModConfigSpec.Builder builder) {
            builder.comment("Item Settings").push("items");
            builder.pop();
        }
    }
}

