/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.ritual;

import com.klikli_dev.occultism.common.blockentity.GoldenSacrificialBowlBlockEntity;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.common.ritual.Ritual;
import com.klikli_dev.occultism.crafting.recipe.RitualRecipe;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.klikli_dev.occultism.util.ItemNBTUtil;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class SummonRitual
extends Ritual {
    private final boolean tame;

    public SummonRitual(RitualRecipe recipe, boolean tame) {
        super(recipe);
        this.tame = tame;
    }

    public ItemStack getBookOfCallingBound(RegistryAccess registryAccess, ItemStack activationItem) {
        ItemStack result = this.recipe.getResultItem((HolderLookup.Provider)registryAccess).copy();
        if (result.getItem() == OccultismItems.JEI_DUMMY_NONE.get()) {
            return ItemStack.EMPTY;
        }
        if (!activationItem.isComponentsPatchEmpty()) {
            result.applyComponents(activationItem.getComponents());
        }
        return result;
    }

    public void finishBookOfCallingSetup(ItemStack bookOfCalling, SpiritEntity spirit, @Nullable Player player) {
        ItemNBTUtil.setSpiritEntityUUID(bookOfCalling, spirit.getUUID());
        if (player != null) {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)bookOfCalling);
        } else {
            ItemEntity entityitem = new ItemEntity(spirit.level(), spirit.getX(), spirit.getY() + 0.5, spirit.getZ(), bookOfCalling);
            entityitem.setPickUpDelay(40);
            entityitem.setDeltaMovement(entityitem.getDeltaMovement().multiply(0.0, 1.0, 0.0));
            spirit.level().addFreshEntity((Entity)entityitem);
        }
    }

    public void spawnEntity(Entity entity, Level level) {
        for (ServerPlayer player : level.getEntitiesOfClass(ServerPlayer.class, entity.getBoundingBox().inflate(50.0))) {
            CriteriaTriggers.SUMMONED_ENTITY.trigger(player, entity);
        }
        level.addFreshEntity(entity);
    }

    public void applyEntityNbt(Entity entity) {
        if (this.recipe.getEntityNbt() != null) {
            CompoundTag tag = entity.saveWithoutId(new CompoundTag());
            tag.merge(this.recipe.getEntityNbt());
            entity.load(tag);
        }
    }

    @Override
    public void finish(Level level, BlockPos goldenBowlPosition, GoldenSacrificialBowlBlockEntity blockEntity, @Nullable ServerPlayer castingPlayer, ItemStack activationItem) {
        Entity entity;
        super.finish(level, goldenBowlPosition, blockEntity, castingPlayer, activationItem);
        ItemStack copy = activationItem.copy();
        ItemStack result = this.getBookOfCallingBound(level.registryAccess(), activationItem);
        activationItem.shrink(1);
        ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)goldenBowlPosition.getX() + 0.5, (double)goldenBowlPosition.getY() + 0.5, (double)goldenBowlPosition.getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        EntityType<?> entityType = this.recipe.getEntityToSummon();
        if (entityType != null && (entity = this.createSummonedEntity(entityType, level, goldenBowlPosition, blockEntity, (Player)castingPlayer)) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            this.prepareLivingEntityForSpawn(living, level, goldenBowlPosition, blockEntity, (Player)castingPlayer, ItemNBTUtil.getBoundSpiritName(copy), this.tame);
            this.applyEntityNbt((Entity)living);
            this.initSummoned(living, level, goldenBowlPosition, blockEntity, (Player)castingPlayer);
            this.spawnEntity((Entity)living, level);
            if (result != ItemStack.EMPTY && living instanceof SpiritEntity) {
                this.finishBookOfCallingSetup(result, (SpiritEntity)living, (Player)castingPlayer);
            }
        }
    }

    public Entity createSummonedEntity(EntityType<?> entityType, Level level, BlockPos goldenBowlPosition, GoldenSacrificialBowlBlockEntity blockEntity, @Nullable Player castingPlayer) {
        return entityType.create(level);
    }

    public void initSummoned(LivingEntity living, Level level, BlockPos goldenBowlPosition, GoldenSacrificialBowlBlockEntity blockEntity, @Nullable Player castingPlayer) {
        if (living instanceof SpiritEntity) {
            SpiritEntity spirit = (SpiritEntity)living;
            spirit.setSpiritMaxAge(this.recipe.getSpiritMaxAge());
        }
    }

    public void prepareLivingEntityForSpawn(LivingEntity livingEntity, Level level, BlockPos goldenBowlPosition, GoldenSacrificialBowlBlockEntity blockEntity, @Nullable Player castingPlayer, String spiritName, boolean setTamed) {
        if (setTamed && livingEntity instanceof TamableAnimal) {
            TamableAnimal tamableAnimal = (TamableAnimal)livingEntity;
            if (castingPlayer != null) {
                tamableAnimal.tame(castingPlayer);
            }
        }
        livingEntity.absMoveTo((double)goldenBowlPosition.getX(), (double)goldenBowlPosition.getY(), (double)goldenBowlPosition.getZ(), (float)level.random.nextInt(360), 0.0f);
        if (!spiritName.isEmpty()) {
            livingEntity.setCustomName((Component)Component.literal((String)spiritName));
        }
        if (livingEntity instanceof Mob) {
            Mob mob = (Mob)livingEntity;
            EventHooks.finalizeMobSpawn((Mob)mob, (ServerLevelAccessor)((ServerLevelAccessor)level), (DifficultyInstance)level.getCurrentDifficultyAt(goldenBowlPosition), (MobSpawnType)MobSpawnType.MOB_SUMMONED, null);
        }
    }
}

