/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.misc;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.klikli_dev.occultism.common.misc.IMapItemHandlerModifiable;
import com.klikli_dev.occultism.common.misc.ItemStackKey;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.Stack;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class MapItemStackHandler
implements IItemHandler,
IItemHandlerModifiable,
IMapItemHandlerModifiable,
INBTSerializable<CompoundTag> {
    protected static final int VIRTUAL_SLOT = -1;
    private static final Codec<Map<ItemStackKey, Integer>> MAP_CODEC = Codec.list((Codec)Codec.pair((Codec)ItemStackKey.CODEC.fieldOf("itemStackkey").codec(), (Codec)Codec.INT.fieldOf("int").codec())).xmap(list -> list.stream().collect(Collectors.toMap(Pair::getFirst, Pair::getSecond)), map -> map.entrySet().stream().map(e -> Pair.of((Object)((ItemStackKey)e.getKey()), (Object)((Integer)e.getValue()))).collect(Collectors.toList()));
    public static final Codec<MapItemStackHandler> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MAP_CODEC.fieldOf("keyToCountMap").forGetter(handler -> handler.keyToCountMap), (App)MAP_CODEC.fieldOf("keyToSlot").forGetter(handler -> handler.keyToSlot), (App)Codec.INT.listOf().fieldOf("emptySlots").forGetter(handler -> handler.emptySlots), (App)Codec.INT.fieldOf("nextSlot").forGetter(handler -> handler.nextSlotIndex), (App)Codec.INT.fieldOf("maxSlots").forGetter(handler -> handler.maxItemTypes), (App)Codec.LONG.fieldOf("totalItemCount").forGetter(handler -> handler.totalItemCount), (App)Codec.LONG.fieldOf("maxTotalItemCount").forGetter(handler -> handler.maxTotalItemCount)).apply((Applicative)instance, (keyToCountMap, keyToSlot, emptySlots, nextSlot, maxSlots, totalItemCount, maxTotalItemCount) -> new MapItemStackHandler((Object2IntOpenHashMap<ItemStackKey>)new Object2IntOpenHashMap(keyToCountMap), (BiMap<ItemStackKey, Integer>)HashBiMap.create((Map)keyToSlot), emptySlots.stream().collect(Collectors.toCollection(Stack::new)), (int)nextSlot, (int)maxSlots, (long)totalItemCount, (long)maxTotalItemCount)));
    protected Object2IntOpenHashMap<ItemStackKey> keyToCountMap;
    protected BiMap<ItemStackKey, Integer> keyToSlot;
    protected Stack<Integer> emptySlots;
    protected int nextSlotIndex;
    protected int maxItemTypes;
    protected long totalItemCount;
    protected long maxTotalItemCount;

    public MapItemStackHandler() {
        this(-1, -1L);
    }

    public MapItemStackHandler(int maxItemTypes, long maxTotalItemCount) {
        this((Object2IntOpenHashMap<ItemStackKey>)new Object2IntOpenHashMap(), (BiMap<ItemStackKey, Integer>)HashBiMap.create(), new Stack<Integer>(), 0, maxItemTypes, 0L, maxTotalItemCount);
    }

    public MapItemStackHandler(Object2IntOpenHashMap<ItemStackKey> keyToCountMap, BiMap<ItemStackKey, Integer> keyToSlot, Stack<Integer> emptySlots, int nextSlotIndex, int maxItemTypes, long totalItemCount, long maxTotalItemCount) {
        this.keyToCountMap = keyToCountMap;
        this.keyToSlot = keyToSlot;
        this.emptySlots = emptySlots;
        this.nextSlotIndex = nextSlotIndex;
        this.maxItemTypes = maxItemTypes;
        this.totalItemCount = totalItemCount;
        this.maxTotalItemCount = maxTotalItemCount;
    }

    public Object2IntOpenHashMap<ItemStackKey> keyToCountMap() {
        return this.keyToCountMap;
    }

    public long totalItemCount() {
        return this.totalItemCount;
    }

    public int maxItemTypes() {
        return this.maxItemTypes;
    }

    public void maxItemTypes(int maxItemTypes) {
        this.maxItemTypes = maxItemTypes;
    }

    public long maxTotalItemCount() {
        return this.maxTotalItemCount;
    }

    public void maxTotalItemCount(long maxTotalItemCount) {
        this.maxTotalItemCount = maxTotalItemCount;
    }

    @Override
    public int get(ItemStack stack) {
        return this.get(ItemStackKey.of(stack));
    }

    @Override
    public int get(ItemStackKey key) {
        return this.keyToCountMap.getOrDefault((Object)key, 0);
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        return (CompoundTag)CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this).getOrThrow();
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt).resultOrPartial(e -> {
            throw new RuntimeException("Failed to decode MapItemStackHandler: " + e);
        }).ifPresent(handler -> {
            this.keyToCountMap = handler.keyToCountMap;
            this.keyToSlot = handler.keyToSlot;
            this.emptySlots = handler.emptySlots;
            this.nextSlotIndex = handler.nextSlotIndex;
            this.maxItemTypes = handler.maxItemTypes;
            this.totalItemCount = handler.totalItemCount;
            this.maxTotalItemCount = handler.maxTotalItemCount;
        });
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        ItemStackKey key = ItemStackKey.of(stack);
        Integer existingSlot = (Integer)this.keyToSlot.get((Object)key);
        if (existingSlot != null && existingSlot != slot) {
            return;
        }
        if (existingSlot == null && this.keyToSlot.inverse().get((Object)slot) == null && slot < this.nextSlotIndex && !stack.isEmpty()) {
            this.keyToSlot.put((Object)key, (Object)slot);
            this.emptySlots.remove((Object)slot);
            this.keyToCountMap.put((Object)key, stack.getCount());
            this.totalItemCount += (long)stack.getCount();
            this.onContentsChanged(key);
        } else if (existingSlot != null && existingSlot == slot) {
            int existing = this.keyToCountMap.getOrDefault((Object)key, 0);
            this.totalItemCount -= (long)existing;
            if (stack.isEmpty()) {
                this.keyToCountMap.removeInt((Object)key);
                this.removeFromSlots(key);
            } else {
                this.keyToCountMap.put((Object)key, stack.getCount());
                this.totalItemCount += (long)stack.getCount();
            }
            this.onContentsChanged(key);
        }
    }

    public int getSlots() {
        return this.nextSlotIndex + 1;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        ItemStackKey key = (ItemStackKey)this.keyToSlot.inverse().get((Object)slot);
        return key != null ? key.stack() : ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        return this.insertItem(stack, simulate);
    }

    @Override
    @NotNull
    public ItemStack insertItem(@NotNull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStackKey key = ItemStackKey.of(stack);
        if (!this.isItemValid(-1, key)) {
            return stack;
        }
        int existing = this.keyToCountMap.getOrDefault((Object)key, 0);
        int limit = this.getStackLimit(stack);
        if (existing > 0) {
            limit -= existing;
        }
        if (existing == 0 && this.maxItemTypes != -1 && this.keyToCountMap.size() >= this.maxItemTypes) {
            return stack;
        }
        if ((limit = Math.min(limit, Math.toIntExact(this.maxTotalItemCount - this.totalItemCount))) <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.getCount() > limit;
        if (!simulate) {
            if (existing <= 0) {
                this.keyToCountMap.put((Object)key, reachedLimit ? limit : stack.getCount());
                this.addToSlots(key);
            } else {
                this.keyToCountMap.put((Object)key, existing + (reachedLimit ? limit : stack.getCount()));
            }
            this.totalItemCount += reachedLimit ? (long)limit : (long)stack.getCount();
            this.onContentsChanged(key);
        }
        return reachedLimit ? stack.copyWithCount(stack.getCount() - limit) : ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        this.validateSlotIndex(slot);
        ItemStackKey key = (ItemStackKey)this.keyToSlot.inverse().get((Object)slot);
        if (key == null) {
            return ItemStack.EMPTY;
        }
        int existing = this.keyToCountMap.getInt((Object)key);
        if (existing <= 0) {
            return ItemStack.EMPTY;
        }
        int toExtract = amount;
        if (existing <= toExtract) {
            if (!simulate) {
                this.keyToCountMap.removeInt((Object)key);
                this.totalItemCount -= (long)existing;
                this.removeFromSlots(key);
                this.onContentsChanged(key);
                return key.stack().copyWithCount(existing);
            }
            return key.stack().copyWithCount(existing);
        }
        if (!simulate) {
            this.keyToCountMap.put((Object)key, existing - toExtract);
            this.totalItemCount -= (long)toExtract;
            this.onContentsChanged(key);
        }
        return key.stack().copyWithCount(toExtract);
    }

    @Override
    @NotNull
    public ItemStack extractItem(ItemStackKey key, int amount, boolean simulate) {
        Integer slot = (Integer)this.keyToSlot.get((Object)key);
        if (slot == null) {
            return ItemStack.EMPTY;
        }
        return this.extractItem(slot, amount, simulate);
    }

    @Override
    @NotNull
    public ItemStack extractItem(ItemStack stack, int amount, boolean simulate) {
        ItemStackKey key = ItemStackKey.of(stack);
        return this.extractItem(key, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return Integer.MAX_VALUE;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.isItemValid(slot, ItemStackKey.of(stack));
    }

    @Override
    public boolean isItemValid(int slot, @NotNull ItemStackKey key) {
        return true;
    }

    protected void addToSlots(ItemStackKey key) {
        if (!this.emptySlots.empty()) {
            Integer index = this.emptySlots.pop();
            this.keyToSlot.put((Object)key, (Object)index);
        } else {
            this.keyToSlot.put((Object)key, (Object)this.nextSlotIndex++);
        }
    }

    protected void removeFromSlots(ItemStackKey key) {
        Integer index = (Integer)this.keyToSlot.get((Object)key);
        if (index != null) {
            this.keyToSlot.remove((Object)key);
            this.emptySlots.push(index);
        }
    }

    protected int getStackLimit(@NotNull ItemStack stack) {
        return this.getSlotLimit(-1);
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || !this.fitsInMaxSlots(slot)) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + (this.maxItemTypes != -1 ? this.maxItemTypes : Integer.MAX_VALUE) + ")");
        }
    }

    protected boolean fitsInMaxSlots(int slot) {
        return this.maxItemTypes != -1 && slot < this.maxItemTypes;
    }

    protected void onContentsChanged(ItemStackKey key) {
    }
}

