/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.item.tool;

import com.klikli_dev.occultism.registry.OccultismTags;
import com.klikli_dev.occultism.util.EntityUtil;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;

public class SoulGemItem
extends Item {
    private static final MapCodec<EntityType<?>> ENTITY_TYPE_FIELD_CODEC = BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("id");

    public SoulGemItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        if (context.getHand() != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        Player player = context.getPlayer();
        ItemStack itemStack = context.getItemInHand();
        Level level = context.getLevel();
        Direction facing = context.getClickedFace();
        BlockPos pos = context.getClickedPos();
        if (itemStack.has(DataComponents.ENTITY_DATA)) {
            if (!level.isClientSide) {
                CompoundTag entityData = ((CustomData)itemStack.get(DataComponents.ENTITY_DATA)).getUnsafe();
                itemStack.remove(DataComponents.ENTITY_DATA);
                EntityType<?> type = EntityUtil.entityTypeFromNbt(entityData);
                facing = facing == null ? Direction.UP : facing;
                BlockPos spawnPos = pos.immutable();
                if (!level.getBlockState(spawnPos).getCollisionShape((BlockGetter)level, spawnPos).isEmpty()) {
                    spawnPos = spawnPos.relative(facing);
                }
                entityData.remove("Pos");
                CompoundTag wrapper = new CompoundTag();
                wrapper.put("EntityTag", (Tag)entityData);
                Entity entity = type.create(level);
                entity.load(entityData);
                entity.absMoveTo((double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5, 0.0f, 0.0f);
                level.addFreshEntity(entity);
                player.swing(context.getHand());
                player.inventoryMenu.broadcastChanges();
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        if (!target.isAlive()) {
            return InteractionResult.PASS;
        }
        if (target.level().isClientSide) {
            return InteractionResult.PASS;
        }
        if (target instanceof Player) {
            return InteractionResult.FAIL;
        }
        if (stack.has(DataComponents.ENTITY_DATA)) {
            return InteractionResult.FAIL;
        }
        if (target.getType().is(OccultismTags.Entities.SOUL_GEM_DENY_LIST)) {
            player.sendSystemMessage((Component)Component.translatable((String)(this.getDescriptionId() + ".message.entity_type_denied")));
            return InteractionResult.FAIL;
        }
        stack.set(DataComponents.ENTITY_DATA, (Object)CustomData.of((CompoundTag)target.serializeNBT((HolderLookup.Provider)player.level().registryAccess())));
        player.swing(hand);
        player.setItemInHand(hand, stack);
        target.remove(Entity.RemovalReason.DISCARDED);
        player.inventoryMenu.broadcastChanges();
        return InteractionResult.SUCCESS;
    }

    public String getDescriptionId(ItemStack stack) {
        return stack.has(DataComponents.ENTITY_DATA) ? this.getDescriptionId() : this.getDescriptionId() + "_empty";
    }

    protected EntityType<?> getType(ItemStack pStack) {
        CustomData customdata = (CustomData)pStack.getOrDefault(DataComponents.ENTITY_DATA, (Object)CustomData.EMPTY);
        return (EntityType)customdata.read(ENTITY_TYPE_FIELD_CODEC).getOrThrow();
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        if (pStack.has(DataComponents.ENTITY_DATA)) {
            EntityType<?> type = this.getType(pStack);
            pTooltipComponents.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip_filled"), (Object[])new Object[]{type.getDescription()}));
        } else {
            pTooltipComponents.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip_empty")));
        }
    }
}

