/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.item.tool;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.BookAddress;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.item.ModonomiconItem;
import com.klikli_dev.modonomicon.registry.DataComponentRegistry;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class GuideBookItem
extends ModonomiconItem {
    public static final ResourceLocation DICTIONARY_OF_SPIRITS = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"dictionary_of_spirits");

    public GuideBookItem(Item.Properties properties) {
        super(properties);
        this.craftingRemainingItem = this;
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack itemInHand = pPlayer.getItemInHand(pUsedHand);
        if (!itemInHand.has((Supplier)DataComponentRegistry.BOOK_ID)) {
            itemInHand.set((Supplier)DataComponentRegistry.BOOK_ID, (Object)DICTIONARY_OF_SPIRITS);
        }
        if (pLevel.isClientSide) {
            Book book = BookDataManager.get().getBook(DICTIONARY_OF_SPIRITS);
            BookGuiManager.get().openBook(BookAddress.defaultFor((Book)book));
        }
        return InteractionResultHolder.sidedSuccess((Object)itemInHand, (boolean)pLevel.isClientSide);
    }

    public Component getName(ItemStack pStack) {
        Book book = BookDataManager.get().getBook(DICTIONARY_OF_SPIRITS);
        if (book != null) {
            return Component.translatable((String)book.getName());
        }
        return super.getName(pStack);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        Book book = BookDataManager.get().getBook(DICTIONARY_OF_SPIRITS);
        if (book != null) {
            if (tooltipFlag.isAdvanced()) {
                list.add((Component)Component.literal((String)"Book ID: ").withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.literal((String)book.getId().toString()).withStyle(ChatFormatting.RED)));
            }
            if (!book.getTooltip().isBlank()) {
                list.add((Component)Component.translatable((String)book.getTooltip()).withStyle(ChatFormatting.GRAY));
            }
        } else {
            CompoundTag compound = new CompoundTag();
            for (TypedDataComponent entry : itemStack.getComponents()) {
                Tag tag = (Tag)entry.encodeValue((DynamicOps)NbtOps.INSTANCE).getOrThrow();
                ResourceLocation key = BuiltInRegistries.DATA_COMPONENT_TYPE.getKey((Object)entry.type());
                compound.put(key.toString(), tag);
            }
            list.add((Component)Component.translatable((String)"tooltip.modonomicon.no_book_found_for_stack", (Object[])new Object[]{NbtUtils.toPrettyComponent((Tag)compound)}).withStyle(ChatFormatting.DARK_GRAY));
        }
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        return itemStack.copy();
    }

    public ItemStack getCreativeModeTabDisplayStack() {
        ItemStack stack = new ItemStack((ItemLike)this);
        stack.set((Supplier)DataComponentRegistry.BOOK_ID, (Object)DICTIONARY_OF_SPIRITS);
        return stack;
    }
}

