/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.item.tool;

import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.client.divination.ScanManager;
import com.klikli_dev.occultism.common.block.otherworld.IOtherworldBlock;
import com.klikli_dev.occultism.integration.theurgy.TheurgyIntegration;
import com.klikli_dev.occultism.network.Networking;
import com.klikli_dev.occultism.network.messages.MessageSetDivinationResult;
import com.klikli_dev.occultism.registry.OccultismBlocks;
import com.klikli_dev.occultism.registry.OccultismDataComponents;
import com.klikli_dev.occultism.registry.OccultismSounds;
import com.klikli_dev.occultism.util.Math3DUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class DivinationRodItem
extends Item {
    public static final float NOT_FOUND = 7.0f;
    public static final float SEARCHING = 8.0f;

    public DivinationRodItem(Item.Properties properties) {
        super(properties);
    }

    public void onUseTick(Level pLevel, LivingEntity pLivingEntity, ItemStack pStack, int pRemainingUseDuration) {
        if (pLivingEntity.level().isClientSide && pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            ScanManager.instance.updateScan(player, false);
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockState state;
        Level level = context.getLevel();
        Player player = context.getPlayer();
        BlockPos pos = context.getClickedPos();
        ItemStack stack = context.getItemInHand();
        if (player.isShiftKeyDown() && !(state = level.getBlockState(pos)).isAir()) {
            Block block = this.getOtherBlock(state, player.isCreative());
            if (block != null) {
                if (!level.isClientSide) {
                    String translationKey = block instanceof IOtherworldBlock ? ((IOtherworldBlock)block).getUncoveredBlock().getDescriptionId() : block.getDescriptionId();
                    stack.set(OccultismDataComponents.DIVINATION_LINKED_BLOCK, (Object)block.builtInRegistryHolder());
                    player.sendSystemMessage((Component)Component.translatable((String)(this.getDescriptionId() + ".message.linked_block"), (Object[])new Object[]{Component.translatable((String)translationKey)}));
                }
                level.playSound(player, player.blockPosition(), OccultismSounds.TUNING_FORK.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            } else if (!level.isClientSide) {
                player.sendSystemMessage((Component)Component.translatable((String)(this.getDescriptionId() + ".message.no_link_found")));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!player.isShiftKeyDown()) {
            if (stack.has(OccultismDataComponents.DIVINATION_LINKED_BLOCK)) {
                stack.set(OccultismDataComponents.DIVINATION_DISTANCE, (Object)Float.valueOf(8.0f));
                player.startUsingItem(hand);
                level.playSound(player, player.blockPosition(), OccultismSounds.TUNING_FORK.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                if (level.isClientSide) {
                    ScanManager.instance.beginScan(player, (Block)((Holder)stack.get(OccultismDataComponents.DIVINATION_LINKED_BLOCK)).value());
                }
            } else if (!level.isClientSide) {
                player.sendSystemMessage((Component)Component.translatable((String)(this.getDescriptionId() + ".message.no_linked_block")));
            }
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entityLiving) {
        if (!(entityLiving instanceof Player)) {
            return stack;
        }
        Player player = (Player)entityLiving;
        player.getCooldowns().addCooldown((Item)this, 40);
        stack.set(OccultismDataComponents.DIVINATION_DISTANCE, (Object)Float.valueOf(7.0f));
        if (level.isClientSide) {
            BlockPos result = ScanManager.instance.finishScan(player);
            float distance = this.getDistance(player.position(), result);
            stack.set(OccultismDataComponents.DIVINATION_DISTANCE, (Object)Float.valueOf(distance));
            Networking.sendToServer(new MessageSetDivinationResult(result, distance));
            if (result != null) {
                stack.set(OccultismDataComponents.DIVINATION_POS, (Object)result);
                if (TheurgyIntegration.isLoaded()) {
                    TheurgyIntegration.spawnDivinationResultParticle(result, level, entityLiving);
                } else {
                    Occultism.SELECTED_BLOCK_RENDERER.selectBlock(result, System.currentTimeMillis() + 10000L);
                }
            }
        }
        return stack;
    }

    public int getUseDuration(ItemStack pStack, LivingEntity p_344979_) {
        return 40;
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity pLivingEntity, int pTimeCharged) {
        BlockPos result;
        if (!stack.has(OccultismDataComponents.DIVINATION_POS)) {
            stack.set(OccultismDataComponents.DIVINATION_DISTANCE, (Object)Float.valueOf(7.0f));
        } else {
            result = (BlockPos)stack.get(OccultismDataComponents.DIVINATION_POS);
            float distance = this.getDistance(pLivingEntity.position(), result);
            stack.set(OccultismDataComponents.DIVINATION_DISTANCE, (Object)Float.valueOf(distance));
        }
        if (level.isClientSide) {
            ScanManager.instance.cancelScan();
            if (stack.has(OccultismDataComponents.DIVINATION_POS)) {
                result = (BlockPos)stack.get(OccultismDataComponents.DIVINATION_POS);
                if (TheurgyIntegration.isLoaded()) {
                    TheurgyIntegration.spawnDivinationResultParticle(result, level, pLivingEntity);
                } else {
                    Occultism.SELECTED_BLOCK_RENDERER.selectBlock(result, System.currentTimeMillis() + 10000L);
                }
            }
        }
        super.releaseUsing(stack, level, pLivingEntity, pTimeCharged);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        if (pStack.has(OccultismDataComponents.DIVINATION_LINKED_BLOCK)) {
            Block block = (Block)((Holder)pStack.get(OccultismDataComponents.DIVINATION_LINKED_BLOCK)).value();
            String translationKey = block instanceof IOtherworldBlock ? ((IOtherworldBlock)block).getUncoveredBlock().getDescriptionId() : block.getDescriptionId();
            pTooltipComponents.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip.linked_block"), (Object[])new Object[]{Component.translatable((String)translationKey).withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.ITALIC})}));
        } else {
            pTooltipComponents.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip.no_linked_block")));
        }
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
    }

    public Block getOtherBlock(BlockState state, boolean isCreative) {
        if (state.getBlock() == Blocks.ANDESITE || state.getBlock() == OccultismBlocks.OTHERSTONE_NATURAL.get() || state.getBlock() == OccultismBlocks.OTHERSTONE.get()) {
            return (Block)OccultismBlocks.OTHERSTONE_NATURAL.get();
        }
        if (state.getBlock() == Blocks.OAK_LOG || state.getBlock() == OccultismBlocks.OTHERWORLD_LOG_NATURAL.get() || state.getBlock() == OccultismBlocks.OTHERWORLD_LOG.get()) {
            return (Block)OccultismBlocks.OTHERWORLD_LOG_NATURAL.get();
        }
        if (state.getBlock() == Blocks.OAK_LEAVES || state.getBlock() == OccultismBlocks.OTHERWORLD_LEAVES_NATURAL.get() || state.getBlock() == OccultismBlocks.OTHERWORLD_LEAVES.get()) {
            return (Block)OccultismBlocks.OTHERWORLD_LEAVES_NATURAL.get();
        }
        if (state.getBlock() == Blocks.NETHERRACK || state.getBlock() == OccultismBlocks.IESNIUM_ORE_NATURAL.get() || state.getBlock() == OccultismBlocks.IESNIUM_ORE.get()) {
            return (Block)OccultismBlocks.IESNIUM_ORE_NATURAL.get();
        }
        return isCreative ? state.getBlock() : null;
    }

    public float getDistance(Vec3 playerPosition, BlockPos result) {
        if (result == null) {
            return 7.0f;
        }
        Vec3 resultCenter = Math3DUtil.center(result);
        Vec3 playerPosition2d = new Vec3(playerPosition.x, 0.0, playerPosition.z);
        Vec3 resultCenter2d = new Vec3(resultCenter.x, 0.0, resultCenter.z);
        double distance = playerPosition2d.distanceTo(resultCenter2d);
        if (distance < 6.0) {
            return 0.0f;
        }
        if (distance < 15.0) {
            return 1.0f;
        }
        if (distance < 25.0) {
            return 2.0f;
        }
        if (distance < 35.0) {
            return 3.0f;
        }
        if (distance < 45.0) {
            return 4.0f;
        }
        if (distance < 65.0) {
            return 5.0f;
        }
        return 6.0f;
    }
}

