/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.familiar;

import com.google.common.collect.ImmutableList;
import com.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.klikli_dev.occultism.common.entity.familiar.FamiliarEntity;
import com.klikli_dev.occultism.registry.OccultismAdvancements;
import com.klikli_dev.occultism.util.FamiliarUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DevilFamiliarEntity
extends FamiliarEntity
implements GeoEntity {
    private final float heightOffset;
    AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public DevilFamiliarEntity(EntityType<? extends DevilFamiliarEntity> type, Level level) {
        super(type, level);
        this.heightOffset = this.getRandom().nextFloat() * 5.0f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return FamiliarEntity.createAttributes().add(Attributes.MOVEMENT_SPEED, (double)0.3f);
    }

    protected void playStepSound(BlockPos pPos, BlockState pBlock) {
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FamiliarEntity.SitGoal(this, this));
        this.goalSelector.addGoal(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(3, (Goal)new FamiliarEntity.FollowOwnerGoal(this, 1.0, 3.0f, 1.0f));
        this.goalSelector.addGoal(4, (Goal)new AttackGoal(this, 5.0f));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new FollowMobGoal((Mob)this, 1.0, 3.0f, 7.0f));
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.level().isClientSide && this.swinging) {
            Vec3 direction = Vec3.directionFromRotation((Vec2)this.getRotationVector()).scale(0.6);
            for (int i = 0; i < 5; ++i) {
                Vec3 pos = this.position().add(direction.x + (double)(this.getRandom().nextFloat() - 0.5f) * 0.7, 1.5 + (double)(this.getRandom().nextFloat() - 0.5f) * 0.7, direction.z + (double)(this.getRandom().nextFloat() - 0.5f) * 0.7);
                this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, pos.x, pos.y, pos.z, direction.x * 0.25, 0.0, direction.z * 0.25);
            }
        }
    }

    public float getAnimationHeight(float partialTicks) {
        return Mth.cos((float)(((float)this.tickCount + this.heightOffset + partialTicks) / 3.5f));
    }

    @Override
    public Iterable<MobEffectInstance> getFamiliarEffects() {
        return ImmutableList.of((Object)new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 300, 0, false, false));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        AnimationController mainController = new AnimationController((GeoAnimatable)this, "mainController", 0, this::animPredicate);
        controllerRegistrar.add(mainController);
    }

    public int getCurrentSwingDuration() {
        return 11;
    }

    private <T extends GeoAnimatable> PlayState animPredicate(AnimationState<T> tAnimationState) {
        if (this.swinging) {
            return tAnimationState.setAndContinue(RawAnimation.begin().thenPlay("attack"));
        }
        if (this.isSitting()) {
            tAnimationState.getController().setAnimation(RawAnimation.begin().thenPlay("sitting"));
            return PlayState.CONTINUE;
        }
        return tAnimationState.setAndContinue(tAnimationState.isMoving() ? RawAnimation.begin().thenPlay("walk") : RawAnimation.begin().thenPlay("idle"));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    public static class AttackGoal
    extends Goal {
        private static final int MAX_COOLDOWN = 20;
        protected final FamiliarEntity entity;
        private final float range;
        private int cooldown = 20;

        public AttackGoal(FamiliarEntity entity, float range) {
            this.entity = entity;
            this.range = range;
        }

        public boolean canUse() {
            return this.cooldown-- < 0 && this.entity.getFamiliarOwner() instanceof Player && !this.getNearbyEnemies().isEmpty();
        }

        private List<LivingEntity> getNearbyEnemies() {
            return FamiliarUtil.getOwnerEnemies(this.entity.getFamiliarOwner(), (LivingEntity)this.entity, this.range);
        }

        public void start() {
            List<LivingEntity> enemies = this.getNearbyEnemies();
            if (!enemies.isEmpty() && this.entity instanceof DevilFamiliarEntity) {
                ((FamiliarTrigger)((Object)OccultismAdvancements.FAMILIAR.get())).trigger(this.entity.getFamiliarOwner(), FamiliarTrigger.Type.DEVIL_FIRE);
            }
            this.attack(enemies);
            this.entity.swing(InteractionHand.MAIN_HAND);
            this.cooldown = 20;
        }

        protected void attack(List<LivingEntity> enemies) {
            for (Entity entity : enemies) {
                entity.hurt(this.entity.damageSources().playerAttack((Player)this.entity.getFamiliarOwner()), 4.0f);
                entity.setRemainingFireTicks(80);
            }
        }

        public void stop() {
            this.cooldown = 20;
        }
    }
}

