/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.familiar;

import com.google.common.collect.ImmutableList;
import com.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.klikli_dev.occultism.common.entity.familiar.DevilFamiliarEntity;
import com.klikli_dev.occultism.common.entity.familiar.FamiliarEntity;
import com.klikli_dev.occultism.registry.OccultismAdvancements;
import com.klikli_dev.occultism.registry.OccultismEffects;
import com.klikli_dev.occultism.registry.OccultismItems;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.EatBlockGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class DeerFamiliarEntity
extends FamiliarEntity {
    private static final ResourceLocation SPEED_BONUS = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"deer_speed_bonus");
    private static final byte START_EATING = 10;
    private int eatTimer;
    private int neckRotTimer;
    private int oNeckRotTimer;

    public DeerFamiliarEntity(EntityType<? extends DeerFamiliarEntity> type, Level level) {
        super(type, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new FamiliarEntity.SitGoal(this, this));
        this.goalSelector.addGoal(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(3, (Goal)new FamiliarEntity.FollowOwnerGoal(this, 1.0, 3.0f, 1.0f));
        this.goalSelector.addGoal(4, (Goal)new EatBlockGoal((Mob)this));
        this.goalSelector.addGoal(5, (Goal)new DevilFamiliarEntity.AttackGoal(this, 5.0f){

            @Override
            public boolean canUse() {
                return super.canUse() && DeerFamiliarEntity.this.hasBlacksmithUpgrade();
            }
        });
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new FollowMobGoal((Mob)this, 1.0, 3.0f, 7.0f));
    }

    @Override
    public void setFamiliarOwner(LivingEntity owner) {
        if (this.hasRedNose()) {
            ((FamiliarTrigger)((Object)OccultismAdvancements.FAMILIAR.get())).trigger(owner, FamiliarTrigger.Type.RARE_VARIANT);
        }
        super.setFamiliarOwner(owner);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide && !this.hasGlowingTag() && this.hasRedNose()) {
            this.setGlowingTag(true);
        }
        if (this.level().isClientSide) {
            --this.eatTimer;
            this.oNeckRotTimer = this.neckRotTimer;
            this.neckRotTimer = this.isEating() ? Math.min(this.neckRotTimer + 1, 10) : Math.max(this.neckRotTimer - 1, 0);
        }
        if (!this.level().isClientSide) {
            LivingEntity owner = this.getFamiliarOwner();
            if (owner != null && this.distanceToSqr((Entity)owner) > 50.0) {
                if (this.getAttribute(Attributes.MOVEMENT_SPEED).getModifier(SPEED_BONUS) == null) {
                    this.getAttribute(Attributes.MOVEMENT_SPEED).addTransientModifier(new AttributeModifier(SPEED_BONUS, 0.15, AttributeModifier.Operation.ADD_VALUE));
                }
            } else if (this.getAttribute(Attributes.MOVEMENT_SPEED).getModifier(SPEED_BONUS) != null) {
                this.getAttribute(Attributes.MOVEMENT_SPEED).removeModifier(SPEED_BONUS);
            }
        }
    }

    public float getNeckRot(float partialTick) {
        return 0.4f + Mth.lerp((float)(Mth.lerp((float)partialTick, (float)this.oNeckRotTimer, (float)this.neckRotTimer) / 10.0f), (float)0.0f, (float)1.5f);
    }

    public void ate() {
        if (this.getRandom().nextDouble() < 0.25) {
            this.spawnAtLocation((ItemLike)OccultismItems.DATURA_SEEDS.get(), 0);
            LivingEntity owner = this.getOwner();
            if (owner instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)owner;
                ((FamiliarTrigger)((Object)OccultismAdvancements.FAMILIAR.get())).trigger(serverPlayer, FamiliarTrigger.Type.DEER_POOP);
            }
        }
    }

    @Override
    public Iterable<MobEffectInstance> getFamiliarEffects() {
        return ImmutableList.of((Object)new MobEffectInstance(MobEffects.JUMP, 300, 0, false, true), (Object)new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 300, 0, false, true), (Object)new MobEffectInstance(OccultismEffects.STEP_HEIGHT, 300, 0, false, true));
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        this.setRedNose(this.getRandom().nextDouble() < 0.1);
        return super.finalizeSpawn(level, difficultyIn, reason, spawnDataIn);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (!compound.contains("variants")) {
            this.setRedNose(compound.getBoolean("hasRedNose"));
        }
    }

    @Override
    public boolean canBlacksmithUpgrade() {
        return !this.hasBlacksmithUpgrade();
    }

    public boolean hasRedNose() {
        return this.hasVariant(0);
    }

    private void setRedNose(boolean b) {
        this.setVariant(0, b);
    }

    public boolean isEating() {
        return this.eatTimer > 0;
    }

    private void startEating() {
        this.eatTimer = 40;
        this.neckRotTimer = 0;
    }

    public void handleEntityEvent(byte id) {
        if (id == 10) {
            this.startEating();
        } else {
            super.handleEntityEvent(id);
        }
    }
}

