/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.familiar;

import com.google.common.collect.ImmutableList;
import com.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.klikli_dev.occultism.common.entity.familiar.DevilFamiliarEntity;
import com.klikli_dev.occultism.common.entity.familiar.FamiliarEntity;
import com.klikli_dev.occultism.common.entity.familiar.GoatFamiliarEntity;
import com.klikli_dev.occultism.common.entity.familiar.ResizableFamiliarEntity;
import com.klikli_dev.occultism.registry.OccultismAdvancements;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ItemBasedSteering;
import net.minecraft.world.entity.ItemSteerable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.CommonHooks;

public class ChimeraFamiliarEntity
extends ResizableFamiliarEntity
implements ItemSteerable,
PlayerRideableJumping {
    public static final byte NO_ATTACKER = 0;
    public static final byte LION_ATTACKER = 1;
    public static final byte GOAT_ATTACKER = 2;
    public static final byte SNAKE_ATTACKER = 3;
    private static final ResourceLocation DAMAGE_BONUS = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"chimera_damage_bonus");
    private static final ResourceLocation SPEED_BONUS = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"chimera_speed_bonus");
    private static final byte RIDING_SIZE = 80;
    private static final double SHRINK_CHANCE = 0.005;
    private static final int ATTACK_TIME = 10;
    private static final EntityDataAccessor<Byte> ATTACKER = SynchedEntityData.defineId(ChimeraFamiliarEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private final ItemBasedSteering boost = new DummyBoostHelper();
    private int goatNoseTimer = this.getRandom().nextInt(100);
    private int attackTimer;
    private float playerJumpPendingScale;
    private boolean isJumping;

    public ChimeraFamiliarEntity(EntityType<? extends ChimeraFamiliarEntity> type, Level level) {
        super((EntityType<? extends ResizableFamiliarEntity>)type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return ChimeraFamiliarEntity.createMobAttributes().add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.MAX_HEALTH, 20.0).add(Attributes.JUMP_STRENGTH, 0.7);
    }

    private boolean isRiderJumping(Player rider) {
        return this.jumping;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new FamiliarEntity.SitGoal(this, this));
        this.goalSelector.addGoal(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(5, (Goal)new FamiliarEntity.FollowOwnerGoal(this, 1.0, 3.0f, 1.0f));
        this.goalSelector.addGoal(6, (Goal)new AttackGoal(this, 10.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new FollowMobGoal((Mob)this, 1.0, 3.0f, 7.0f));
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide && this.getRandom().nextDouble() < 0.005) {
            this.setSize((byte)(this.getSize() - 1));
        }
        --this.attackTimer;
        if (this.attackTimer == 0) {
            this.setAttacker((byte)0);
        }
        if (this.level().isClientSide) {
            ++this.goatNoseTimer;
            if (this.attackTimer > 0 && this.getAttacker() == 1) {
                Vec3 direction = Vec3.directionFromRotation((Vec2)this.getRotationVector()).scale((double)this.getScale());
                for (int i = 0; i < 5; ++i) {
                    Vec3 pos = this.position().add(direction.x + (double)(this.getRandom().nextFloat() - 0.5f) * 0.7, 1.0 + (double)(this.getRandom().nextFloat() - 0.5f) * 0.7, direction.z + (double)(this.getRandom().nextFloat() - 0.5f) * 0.7);
                    this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, pos.x, pos.y, pos.z, direction.x * 0.1, 0.0, direction.z * 0.1);
                }
            }
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData) {
        this.setGoat(true);
        this.setSize((byte)0);
        this.setFlaps(this.getRandom().nextBoolean());
        this.setRing(this.getRandom().nextBoolean());
        this.setBeard(this.getRandom().nextBoolean());
        this.setHat(this.getRandom().nextDouble() < 0.1);
        return super.finalizeSpawn(pLevel, pDifficulty, pReason, pSpawnData);
    }

    public boolean isControlledByLocalInstance() {
        return true;
    }

    @Override
    public Iterable<MobEffectInstance> getFamiliarEffects() {
        return ImmutableList.of();
    }

    @Override
    public void setSize(byte size) {
        super.setSize(size);
        this.calcSizeModifiers();
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ATTACKER, (Object)0);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (!compound.contains("variants")) {
            this.setFlaps(compound.getBoolean("hasFlaps"));
            this.setRing(compound.getBoolean("hasRing"));
            if (compound.contains("hasBeard")) {
                this.setBeard(compound.getBoolean("hasBeard"));
            }
            this.setHat(compound.getBoolean("hasHat"));
            this.setGoat(compound.getBoolean("hasGoat"));
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("hasFlaps", this.hasFlaps());
        compound.putBoolean("hasRing", this.hasRing());
        compound.putBoolean("hasBeard", this.hasBeard());
        compound.putBoolean("hasHat", this.hasHat());
        compound.putBoolean("hasGoat", this.hasGoat());
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> pKey) {
        super.onSyncedDataUpdated(pKey);
        if (ATTACKER.equals(pKey)) {
            this.attackTimer = 10;
        }
    }

    private double getAttackBonus() {
        return Mth.lerp((double)((double)this.getSize() / 100.0), (double)0.0, (double)3.0);
    }

    private double getSpeedBonus() {
        return Mth.lerp((double)((double)this.getSize() / 100.0), (double)0.0, (double)0.08);
    }

    public boolean hasFlaps() {
        return this.hasVariant(0);
    }

    public boolean hasRing() {
        return this.hasVariant(1);
    }

    public boolean hasBeard() {
        return this.hasVariant(2);
    }

    public boolean hasHat() {
        return this.hasVariant(3);
    }

    public boolean hasGoat() {
        return this.hasVariant(4);
    }

    public byte getAttacker() {
        return (Byte)this.entityData.get(ATTACKER);
    }

    private void setAttacker(byte b) {
        this.entityData.set(ATTACKER, (Object)b);
    }

    private void setFlaps(boolean b) {
        this.setVariant(0, b);
    }

    private void setRing(boolean b) {
        this.setVariant(1, b);
    }

    private void setBeard(boolean b) {
        this.setVariant(2, b);
    }

    private void setHat(boolean b) {
        this.setVariant(3, b);
    }

    private void setGoat(boolean b) {
        this.setVariant(4, b);
    }

    private void calcSizeModifiers() {
        if (this.getSize() <= 80) {
            this.ejectPassengers();
        }
        this.getAttribute(Attributes.ATTACK_DAMAGE).removeModifier(DAMAGE_BONUS);
        this.getAttribute(Attributes.MOVEMENT_SPEED).removeModifier(SPEED_BONUS);
        this.getAttribute(Attributes.ATTACK_DAMAGE).addTransientModifier(new AttributeModifier(DAMAGE_BONUS, this.getAttackBonus(), AttributeModifier.Operation.ADD_VALUE));
        this.getAttribute(Attributes.MOVEMENT_SPEED).addTransientModifier(new AttributeModifier(SPEED_BONUS, this.getSpeedBonus(), AttributeModifier.Operation.ADD_VALUE));
    }

    public float getNoseGoatRot(float partialTicks) {
        if (this.goatNoseTimer % 200 >= 40) {
            return 0.0f;
        }
        float progress = ((float)(this.goatNoseTimer % 200) + partialTicks) / 40.0f;
        return Mth.sin((float)(progress * (float)Math.PI * 4.0f)) * 0.1f;
    }

    public float getAttackProgress(float partialTicks) {
        if (this.attackTimer <= 0) {
            return 0.0f;
        }
        return ((float)(10 - this.attackTimer) + partialTicks) / 10.0f;
    }

    public Vec3 getPassengerRidingPosition(Entity pEntity) {
        return super.getPassengerRidingPosition(pEntity).subtract(0.0, 0.6, 0.0);
    }

    @Override
    protected InteractionResult mobInteract(Player playerIn, InteractionHand hand) {
        ItemStack stack = playerIn.getItemInHand(hand);
        FoodProperties food = stack.getItem().getFoodProperties(stack, (LivingEntity)this);
        if (this.hasGoat() && stack.getItem() == Items.GOLDEN_APPLE && playerIn == this.getFamiliarOwner()) {
            if (!this.level().isClientSide) {
                stack.shrink(1);
                this.setGoat(false);
                GoatFamiliarEntity goat = new GoatFamiliarEntity(this.level(), this.hasRing(), this.hasBeard(), this.getSize(), this.getFamiliarOwner());
                goat.setPos(this.getX(), this.getY(), this.getZ());
                this.level().addFreshEntity((Entity)goat);
                ((FamiliarTrigger)((Object)OccultismAdvancements.FAMILIAR.get())).trigger((LivingEntity)playerIn, FamiliarTrigger.Type.GOAT_DETACH);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (this.getSize() < 100 && food != null && stack.is(ItemTags.MEAT)) {
            stack.shrink(1);
            this.setSize((byte)(this.getSize() + food.nutrition()));
            this.heal(4.0f);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (!(this.isSitting() || this.isVehicle() || playerIn.isSecondaryUseActive() || this.getFamiliarOwner() != playerIn || this.getSize() <= 80)) {
            if (!this.level().isClientSide) {
                playerIn.startRiding((Entity)this);
                ((FamiliarTrigger)((Object)OccultismAdvancements.FAMILIAR.get())).trigger((LivingEntity)playerIn, FamiliarTrigger.Type.CHIMERA_RIDE);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.mobInteract(playerIn, hand);
    }

    @Override
    public void setFamiliarOwner(LivingEntity owner) {
        if (this.hasHat()) {
            ((FamiliarTrigger)((Object)OccultismAdvancements.FAMILIAR.get())).trigger(owner, FamiliarTrigger.Type.RARE_VARIANT);
        }
        super.setFamiliarOwner(owner);
    }

    public boolean boost() {
        return false;
    }

    protected void tickRidden(Player rider, Vec3 travelVec) {
        super.tickRidden(rider, travelVec);
        this.setRot(rider.getYRot(), rider.getXRot() * 0.5f);
        this.yBodyRot = this.yHeadRot = this.getYRot();
        this.yRotO = this.yHeadRot;
        this.boost.tickBoost();
        if (this.isControlledByLocalInstance() && this.onGround()) {
            this.setIsJumping(false);
            if (this.playerJumpPendingScale > 0.0f && !this.isJumping()) {
                this.executeRidersJump(this.playerJumpPendingScale, travelVec);
            }
            this.playerJumpPendingScale = 0.0f;
        }
    }

    public double getCustomJump() {
        return this.getAttributeValue(Attributes.JUMP_STRENGTH) * 2.0;
    }

    protected void executeRidersJump(float pPlayerJumpPendingScale, Vec3 pTravelVector) {
        double d0 = this.getCustomJump() * (double)pPlayerJumpPendingScale * (double)this.getBlockJumpFactor();
        double d1 = d0 + (double)this.getJumpBoostPower();
        Vec3 vec3 = this.getDeltaMovement();
        this.setDeltaMovement(vec3.x, d1, vec3.z);
        this.setIsJumping(true);
        this.hasImpulse = true;
        CommonHooks.onLivingJump((LivingEntity)this);
        if (pTravelVector.z > 0.0) {
            float f = Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180)));
            float f1 = Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180)));
            this.setDeltaMovement(this.getDeltaMovement().add((double)(-0.4f * f * pPlayerJumpPendingScale), 0.0, (double)(0.4f * f1 * pPlayerJumpPendingScale)));
        }
    }

    public boolean isJumping() {
        return this.isJumping;
    }

    public void setIsJumping(boolean pJumping) {
        this.isJumping = pJumping;
    }

    protected Vec3 getRiddenInput(Player rider, Vec3 travelVec) {
        if (this.isVehicle()) {
            float forward = rider.zza;
            float strafe = rider.xxa * 0.5f;
            if (forward < 0.0f) {
                forward *= 0.25f;
            }
            return super.getRiddenInput(rider, new Vec3((double)strafe, 0.0, (double)forward));
        }
        return super.getRiddenInput(rider, travelVec);
    }

    protected float getRiddenSpeed(Player rider) {
        return (float)this.getAttributeValue(Attributes.MOVEMENT_SPEED) * 0.8f;
    }

    protected int calculateFallDamage(float pDistance, float pDamageMultiplier) {
        return super.calculateFallDamage(pDistance - 3.0f, pDamageMultiplier);
    }

    protected float getJumpPower() {
        return super.getJumpPower() * 1.35f;
    }

    private byte[] possibleAttackers() {
        byte[] byArray;
        if (this.hasGoat()) {
            byte[] byArray2 = new byte[3];
            byArray2[0] = 1;
            byArray2[1] = 2;
            byArray = byArray2;
            byArray2[2] = 3;
        } else {
            byte[] byArray3 = new byte[2];
            byArray3[0] = 1;
            byArray = byArray3;
            byArray3[1] = 3;
        }
        return byArray;
    }

    protected float nextStep() {
        return this.moveDist + 1.6f;
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        Entity entity = this.getFirstPassenger();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return livingEntity;
        }
        return null;
    }

    public void onPlayerJump(int pJumpPower) {
        if (pJumpPower < 0) {
            pJumpPower = 0;
        }
        this.playerJumpPendingScale = pJumpPower >= 90 ? 1.0f : 0.6f + 0.4f * (float)pJumpPower / 90.0f;
    }

    public boolean canJump() {
        return true;
    }

    public boolean causeFallDamage(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    public void handleStartJump(int pJumpPower) {
    }

    public void handleStopJump() {
    }

    private static class DummyBoostHelper
    extends ItemBasedSteering {
        public DummyBoostHelper() {
            super(null, null, null);
        }

        public void onSynced() {
        }

        public boolean boost(RandomSource pRand) {
            return false;
        }

        public void addAdditionalSaveData(CompoundTag pNbt) {
        }

        public void readAdditionalSaveData(CompoundTag pNbt) {
        }

        public void setSaddle(boolean pSaddled) {
        }

        public boolean hasSaddle() {
            return false;
        }
    }

    private static class AttackGoal
    extends DevilFamiliarEntity.AttackGoal {
        ChimeraFamiliarEntity chimera;

        public AttackGoal(ChimeraFamiliarEntity chimera, float range) {
            super(chimera, range);
            this.chimera = chimera;
        }

        @Override
        protected void attack(List<LivingEntity> enemies) {
            byte attacker = this.randomAttacker();
            this.chimera.setAttacker(attacker);
            for (LivingEntity e : enemies) {
                e.hurt(this.chimera.damageSources().playerAttack((Player)this.chimera.getFamiliarOwner()), (float)this.chimera.getAttributeValue(Attributes.ATTACK_DAMAGE));
                switch (attacker) {
                    case 1: {
                        e.setRemainingFireTicks(80);
                        break;
                    }
                    case 2: {
                        Vec3 direction = e.position().vectorTo(this.chimera.position());
                        e.knockback(2.0, direction.x, direction.z);
                        break;
                    }
                    case 3: {
                        e.addEffect(new MobEffectInstance(MobEffects.POISON, 200));
                    }
                }
            }
        }

        private byte randomAttacker() {
            byte[] attackers = this.chimera.possibleAttackers();
            return attackers[this.chimera.getRandom().nextInt(attackers.length)];
        }
    }
}

