/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.familiar;

import com.google.common.collect.ImmutableList;
import com.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.klikli_dev.occultism.common.entity.familiar.CthulhuFamiliarEntity;
import com.klikli_dev.occultism.common.entity.familiar.FamiliarEntity;
import com.klikli_dev.occultism.registry.OccultismAdvancements;
import com.klikli_dev.occultism.registry.OccultismEffects;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;

public class BeaverFamiliarEntity
extends FamiliarEntity {
    private final WaterBoundPathNavigation waterNavigator;
    private final GroundPathNavigation groundNavigator;
    private BlockPos treeTarget;

    public BeaverFamiliarEntity(EntityType<? extends BeaverFamiliarEntity> type, Level level) {
        super(type, level);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.waterNavigator = new WaterBoundPathNavigation((Mob)this, level);
        this.groundNavigator = new GroundPathNavigation((Mob)this, level);
        this.moveControl = new CthulhuFamiliarEntity.MoveController(this);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return FamiliarEntity.createMobAttributes().add(NeoForgeMod.SWIM_SPEED, 1.0);
    }

    public void updateSwimming() {
        if (!this.level().isClientSide) {
            if (this.isInWater()) {
                this.navigation = this.waterNavigator;
                this.setSwimming(true);
            } else {
                this.navigation = this.groundNavigator;
                this.setSwimming(false);
            }
        }
    }

    @Override
    public void setFamiliarOwner(LivingEntity owner) {
        if (this.hasBigTail()) {
            ((FamiliarTrigger)((Object)OccultismAdvancements.FAMILIAR.get())).trigger(owner, FamiliarTrigger.Type.RARE_VARIANT);
        }
        super.setFamiliarOwner(owner);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.goalSelector.addGoal(1, (Goal)new FamiliarEntity.SitGoal(this, this));
        this.goalSelector.addGoal(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(4, (Goal)new ChopTreeGoal(this));
        this.goalSelector.addGoal(5, (Goal)new CthulhuFamiliarEntity.FollowOwnerWaterGoal(this, 1.0, 3.0f, 1.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new FollowMobGoal((Mob)this, 1.0, 3.0f, 7.0f));
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData) {
        this.setBigTail(this.getRandom().nextDouble() < 0.1);
        this.setEars(this.getRandom().nextBoolean());
        this.setWhiskers(this.getRandom().nextBoolean());
        return super.finalizeSpawn(pLevel, pDifficulty, pReason, pSpawnData);
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public boolean hasWhiskers() {
        return this.hasVariant(0);
    }

    private void setWhiskers(boolean b) {
        this.setVariant(0, b);
    }

    public boolean hasEars() {
        return this.hasVariant(1);
    }

    private void setEars(boolean b) {
        this.setVariant(1, b);
    }

    public boolean hasBigTail() {
        return this.hasVariant(2);
    }

    private void setBigTail(boolean b) {
        this.setVariant(2, b);
    }

    @Override
    public Iterable<MobEffectInstance> getFamiliarEffects() {
        return ImmutableList.of((Object)new MobEffectInstance(OccultismEffects.BEAVER_HARVEST, 300));
    }

    public void setTreeTarget(BlockPos pos) {
        this.treeTarget = pos;
    }

    private static class ChopTreeGoal
    extends Goal {
        private final BeaverFamiliarEntity beaver;

        private ChopTreeGoal(BeaverFamiliarEntity beaver) {
            this.beaver = beaver;
            this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return !this.beaver.isSitting() && this.beaver.isEffectEnabled(this.beaver.getFamiliarOwner()) && this.beaver.treeTarget != null && this.beaver.level().getBlockState(this.beaver.treeTarget).is(BlockTags.LOGS);
        }

        public void start() {
            if (this.beaver.treeTarget == null) {
                return;
            }
            this.beaver.getNavigation().moveTo((double)this.beaver.treeTarget.getX(), (double)this.beaver.treeTarget.getY(), (double)this.beaver.treeTarget.getZ(), 1.0);
        }

        public void tick() {
            if (this.beaver.treeTarget == null) {
                return;
            }
            if (this.beaver.distanceToSqr(this.beaver.treeTarget.getX(), this.beaver.treeTarget.getY(), this.beaver.treeTarget.getZ()) > 4.0) {
                this.beaver.getNavigation().moveTo((double)this.beaver.treeTarget.getX(), (double)this.beaver.treeTarget.getY(), (double)this.beaver.treeTarget.getZ(), 1.0);
            } else {
                LinkedList<BlockPos> positions = new LinkedList<BlockPos>();
                HashSet<BlockPos> harvesting = new HashSet<BlockPos>();
                positions.add(this.beaver.treeTarget);
                while (!positions.isEmpty() && harvesting.size() < 15) {
                    BlockPos pos = (BlockPos)positions.pop();
                    harvesting.add(pos);
                    for (BlockPos p : BlockPos.withinManhattan((BlockPos)pos, (int)1, (int)1, (int)1)) {
                        if (harvesting.contains(p) || !this.beaver.level().getBlockState(p).is(BlockTags.LOGS)) continue;
                        positions.add(p.immutable());
                        harvesting.add(pos);
                    }
                }
                if (!positions.isEmpty()) {
                    this.beaver.treeTarget = null;
                    return;
                }
                for (BlockPos p : harvesting) {
                    this.beaver.level().destroyBlock(p, true);
                }
                this.beaver.treeTarget = null;
                ((FamiliarTrigger)((Object)OccultismAdvancements.FAMILIAR.get())).trigger(this.beaver.getFamiliarOwner(), FamiliarTrigger.Type.BEAVER_WOODCHOP);
            }
        }
    }
}

