/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.ai.goal;

import com.klikli_dev.occultism.common.entity.ai.BlockSorter;
import com.klikli_dev.occultism.common.entity.ai.goal.PausableGoal;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.util.Math3DUtil;
import com.klikli_dev.occultism.util.StorageUtil;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class ExtractItemsGoal
extends PausableGoal {
    protected final SpiritEntity entity;
    protected final BlockSorter targetSorter;
    protected BlockPos targetBlock = null;

    public ExtractItemsGoal(SpiritEntity entity) {
        this.entity = entity;
        this.targetSorter = new BlockSorter((Entity)entity);
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
    }

    private BlockPos getMoveTarget() {
        double angle = Math3DUtil.yaw(this.entity.position(), Math3DUtil.center(this.targetBlock));
        return this.targetBlock.relative(Direction.fromYRot((double)angle).getOpposite());
    }

    @Override
    public boolean canUse() {
        if (this.entity.getTarget() != null) {
            return false;
        }
        if (!this.entity.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
            return false;
        }
        this.resetTarget();
        return !this.isPaused() && this.targetBlock != null;
    }

    @Override
    public boolean canContinueToUse() {
        return !this.isPaused() && this.targetBlock != null && !this.entity.getItemInHand(InteractionHand.MAIN_HAND).isEmpty();
    }

    public void stop() {
        this.entity.getNavigation().stop();
        this.resetTarget();
    }

    public void tick() {
        if (this.targetBlock != null) {
            if (this.entity.level().getBlockEntity(this.targetBlock) != null) {
                BlockEntity blockEntity = this.entity.level().getBlockEntity(this.targetBlock);
                float accessDistance = 1.86f;
                double distance = this.entity.position().distanceTo(Math3DUtil.center(this.targetBlock));
                if (distance < 2.5 && distance >= (double)accessDistance && this.canSeeTarget() && blockEntity instanceof Container) {
                    Container container = (Container)blockEntity;
                    this.toggleChest(container, true);
                }
                if (distance < (double)accessDistance) {
                    this.entity.getNavigation().stop();
                } else {
                    BlockPos moveTarget = this.getMoveTarget();
                    this.entity.getNavigation().moveTo(this.entity.getNavigation().createPath(moveTarget, 0), 1.0);
                }
                if (distance < (double)accessDistance && this.canSeeTarget()) {
                    ItemStack remaining;
                    ItemStack toExtract;
                    IItemHandler blockEntityHandler = (IItemHandler)this.entity.level().getCapability(Capabilities.ItemHandler.BLOCK, blockEntity.getBlockPos(), blockEntity.getBlockState(), blockEntity, (Object)this.entity.getDepositFacing());
                    if (blockEntityHandler == null) {
                        this.resetTarget();
                        return;
                    }
                    IItemHandler entityHandler = (IItemHandler)this.entity.getCapability(Capabilities.ItemHandler.ENTITY);
                    int slot = StorageUtil.getFirstMatchingSlot(blockEntityHandler, (IItemHandler)this.entity.getFilterItems(), this.entity.getTagFilter(), this.entity.isFilterBlacklist());
                    if (slot >= 0 && !(toExtract = blockEntityHandler.extractItem(slot, Integer.MAX_VALUE, true).copy()).isEmpty() && (remaining = ItemHandlerHelper.insertItem((IItemHandler)entityHandler, (ItemStack)toExtract, (boolean)true)).getCount() < toExtract.getCount()) {
                        ItemStack extracted = blockEntityHandler.extractItem(slot, toExtract.getCount() - remaining.getCount(), false);
                        ItemHandlerHelper.insertItem((IItemHandler)entityHandler, (ItemStack)extracted, (boolean)false);
                    }
                    if (blockEntity instanceof Container) {
                        Container container = (Container)blockEntity;
                        this.toggleChest(container, false);
                    }
                }
            } else {
                this.resetTarget();
            }
        }
    }

    public boolean canSeeTarget() {
        return true;
    }

    public void toggleChest(Container blockEntity, boolean open) {
        if (blockEntity instanceof ChestBlockEntity) {
            ChestBlockEntity chest = (ChestBlockEntity)blockEntity;
            if (open) {
                this.entity.level().blockEvent(this.targetBlock, chest.getBlockState().getBlock(), 1, 1);
            } else {
                this.entity.level().blockEvent(this.targetBlock, chest.getBlockState().getBlock(), 1, 0);
            }
        }
    }

    private void resetTarget() {
        Optional<BlockPos> targetPos = this.entity.getExtractPosition();
        targetPos.ifPresent(pos -> {
            this.targetBlock = pos;
            IItemHandler handler = (IItemHandler)this.entity.level().getCapability(Capabilities.ItemHandler.BLOCK, this.targetBlock, (Object)this.entity.getExtractFacing());
            if (handler == null) {
                this.entity.setExtractPosition(null);
            }
        });
    }
}

