/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.effect;

import com.klikli_dev.occultism.registry.OccultismEffects;
import java.util.function.Consumer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.client.extensions.common.IClientMobEffectExtensions;

public class DoubleJumpEffect
extends MobEffect {
    public static final ResourceLocation ICON = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"textures/mob_effect/double_jump.png");
    public static final IClientMobEffectExtensions EFFECT_RENDERER = new IClientMobEffectExtensions(){

        public boolean renderInventoryIcon(MobEffectInstance instance, EffectRenderingInventoryScreen<?> screen, GuiGraphics guiGraphics, int x, int y, int blitOffset) {
            guiGraphics.blit(ICON, x + 6, y + 7, 18, 18, 0.0f, 0.0f, 255, 255, 256, 256);
            return false;
        }

        public boolean renderGuiIcon(MobEffectInstance instance, Gui gui, GuiGraphics guiGraphics, int x, int y, float z, float alpha) {
            guiGraphics.blit(ICON, x + 3, y + 3, 18, 18, 0.0f, 0.0f, 255, 255, 256, 256);
            return false;
        }
    };

    public DoubleJumpEffect() {
        super(MobEffectCategory.BENEFICIAL, 0xFFFF00);
    }

    public static int getMaxJumps(Player player) {
        MobEffectInstance effect = player.getEffect(OccultismEffects.DOUBLE_JUMP);
        if (effect != null) {
            return 1 + effect.getAmplifier();
        }
        return 0;
    }

    public boolean applyEffectTick(LivingEntity entityLivingBaseIn, int amplifier) {
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public boolean isInstantenous() {
        return false;
    }

    public void initializeClient(Consumer<IClientMobEffectExtensions> consumer) {
        consumer.accept(EFFECT_RENDERER);
    }
}

