/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.container.storage;

import com.klikli_dev.occultism.api.common.blockentity.IStorageController;
import com.klikli_dev.occultism.api.common.container.IStorageControllerContainer;
import com.klikli_dev.occultism.api.common.data.GlobalBlockPos;
import com.klikli_dev.occultism.common.misc.ItemStackComparator;
import com.klikli_dev.occultism.common.misc.StorageControllerCraftingInventory;
import com.klikli_dev.occultism.common.misc.StorageControllerSlot;
import com.klikli_dev.occultism.network.Networking;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.PlayerMainInvWrapper;

public abstract class StorageControllerContainerBase
extends AbstractContainerMenu
implements IStorageControllerContainer {
    public static ConcurrentMap<BlockPos, UUID> openContainers = new ConcurrentHashMap<BlockPos, UUID>();
    public Inventory playerInventory;
    public Player player;
    protected ResultContainer result;
    protected StorageControllerCraftingInventory matrix;
    protected SimpleContainer orderInventory;
    protected RecipeHolder<CraftingRecipe> currentRecipe;
    protected boolean recipeLocked = false;

    protected StorageControllerContainerBase(@Nullable MenuType<?> type, int id, Inventory playerInventory) {
        super(type, id);
        this.playerInventory = playerInventory;
        this.player = playerInventory.player;
        this.result = new ResultContainer();
        this.orderInventory = new SimpleContainer(1);
    }

    public static boolean canOpen(Player player, BlockPos pos) {
        if (!openContainers.containsKey(pos) || ((UUID)openContainers.get(pos)).equals(player.getUUID())) {
            return true;
        }
        player.sendSystemMessage((Component)Component.translatable((String)"messages.occultism.container_already_open").withStyle(ChatFormatting.RED));
        return false;
    }

    public static void reserve(Player player, BlockPos pos) {
        openContainers.put(pos, player.getUUID());
    }

    @Override
    public GlobalBlockPos getStorageControllerGlobalBlockPos() {
        return GlobalBlockPos.from((BlockEntity)this.getStorageController());
    }

    @Override
    public CraftingContainer getCraftMatrix() {
        return this.matrix;
    }

    public void slotsChanged(Container inventoryIn) {
        if (this.recipeLocked) {
            return;
        }
        this.updateCraftingSlots(false);
        this.broadcastChanges();
        this.findRecipeForMatrix();
    }

    @Override
    public SimpleContainer getOrderSlot() {
        return this.orderInventory;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        if (player.level().isClientSide) {
            return ItemStack.EMPTY;
        }
        ItemStack result = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            result = slotStack.copy();
            IStorageController storageController = this.getStorageController();
            if (index == 0) {
                this.craftShift(player, storageController);
                return ItemStack.EMPTY;
            }
            if (storageController != null) {
                int remainingItems = storageController.insertStack(slotStack, false);
                ItemStack remainingItemStack = remainingItems == 0 ? ItemStack.EMPTY : slotStack.copyWithCount(remainingItems);
                slot.set(remainingItemStack);
                this.broadcastChanges();
                Networking.sendTo((ServerPlayer)player, storageController.getMessageUpdateStacks());
                if (!remainingItemStack.isEmpty()) {
                    slot.onTake(player, slotStack);
                }
                return ItemStack.EMPTY;
            }
        }
        return result;
    }

    public void removed(Player playerIn) {
        this.updateCraftingSlots(false);
        this.updateOrderSlot(true);
        super.removed(playerIn);
        openContainers.values().removeIf(uuid -> uuid.equals(playerIn.getUUID()));
    }

    protected void setupPlayerInventorySlots() {
        int playerInventoryTop = 174;
        int playerInventoryLeft = 56;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)this.playerInventory, j + i * 9 + 9, playerInventoryLeft + j * 18, playerInventoryTop + i * 18));
            }
        }
    }

    protected void setupCraftingGrid() {
        int craftingGridTop = 113;
        int craftingGridLeft = 85;
        int index = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.addSlot(new Slot((Container)this.matrix, index++, craftingGridLeft + j * 18, craftingGridTop + i * 18));
            }
        }
    }

    protected void setupCraftingOutput() {
        int craftingOutputTop = 131;
        int craftingOutputLeft = 178;
        StorageControllerSlot slotCraftOutput = new StorageControllerSlot(this.playerInventory.player, (CraftingContainer)this.matrix, (Container)this.result, this, 0, craftingOutputLeft, craftingOutputTop);
        this.addSlot((Slot)slotCraftOutput);
    }

    protected void setupOrderInventorySlot() {
        int orderSlotTop = 36;
        int orderSlotLeft = 13;
        this.addSlot(new Slot((Container)this.orderInventory, 0, orderSlotLeft, orderSlotTop));
    }

    protected abstract void setupPlayerHotbar();

    protected void findRecipeForMatrixClient() {
        Optional optional = this.player.level().getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)CraftingInput.of((int)this.matrix.getWidth(), (int)this.matrix.getHeight(), (List)this.matrix.getItems()), this.player.level());
        optional.ifPresentOrElse(iCraftingRecipe -> {
            this.currentRecipe = iCraftingRecipe;
        }, () -> {
            this.currentRecipe = null;
        });
    }

    protected void findRecipeForMatrix() {
        if (!this.player.level().isClientSide) {
            this.currentRecipe = null;
            ServerPlayer serverplayerentity = (ServerPlayer)this.player;
            ItemStack itemstack = ItemStack.EMPTY;
            Optional optional = this.player.level().getServer().getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)CraftingInput.of((int)this.matrix.getWidth(), (int)this.matrix.getHeight(), (List)this.matrix.getItems()), this.player.level());
            if (optional.isPresent()) {
                RecipeHolder icraftingrecipe = (RecipeHolder)optional.get();
                if (this.result.setRecipeUsed(this.player.level(), serverplayerentity, icraftingrecipe)) {
                    itemstack = ((CraftingRecipe)icraftingrecipe.value()).assemble((RecipeInput)CraftingInput.of((int)this.matrix.getWidth(), (int)this.matrix.getHeight(), (List)this.matrix.getItems()), (HolderLookup.Provider)serverplayerentity.level().registryAccess());
                    this.currentRecipe = icraftingrecipe;
                }
            }
            this.result.setItem(0, itemstack);
            serverplayerentity.connection.send((Packet)new ClientboundContainerSetSlotPacket(this.containerId, 0, 0, itemstack));
        }
    }

    protected void craftShift(Player player, IStorageController storageController) {
        ItemStack newResult;
        if (this.matrix == null) {
            return;
        }
        this.findRecipeForMatrixClient();
        if (this.currentRecipe == null) {
            return;
        }
        this.recipeLocked = true;
        ArrayList<ItemStack> recipeCopy = new ArrayList<ItemStack>(this.matrix.getContainerSize());
        for (int i = 0; i < this.matrix.getContainerSize(); ++i) {
            recipeCopy.add(this.matrix.getItem(i).copy());
        }
        ItemStack result = ((CraftingRecipe)this.currentRecipe.value()).assemble((RecipeInput)CraftingInput.of((int)this.matrix.getWidth(), (int)this.matrix.getHeight(), (List)this.matrix.getItems()), (HolderLookup.Provider)player.level().registryAccess());
        if (result.isEmpty()) {
            return;
        }
        int resultStackSize = result.getCount();
        ArrayList<ItemStack> resultList = new ArrayList<ItemStack>();
        int crafted = 0;
        while (crafted + resultStackSize <= result.getMaxStackSize() && this.currentRecipe != null && (newResult = ((CraftingRecipe)this.currentRecipe.value()).assemble((RecipeInput)CraftingInput.of((int)this.matrix.getWidth(), (int)this.matrix.getHeight(), (List)this.matrix.getItems()), (HolderLookup.Provider)player.level().registryAccess()).copy()).getItem() == result.getItem() && ItemHandlerHelper.insertItemStacked((IItemHandler)new PlayerMainInvWrapper(this.playerInventory), (ItemStack)newResult, (boolean)true).isEmpty() && ((CraftingRecipe)this.currentRecipe.value()).matches((RecipeInput)CraftingInput.of((int)this.matrix.getWidth(), (int)this.matrix.getHeight(), (List)this.matrix.getItems()), player.level())) {
            resultList.add(newResult);
            CraftingInput craftingInput = CraftingInput.of((int)this.matrix.getWidth(), (int)this.matrix.getHeight(), (List)this.matrix.getItems());
            CraftingInput.Positioned positionedCraftingInput = CraftingInput.ofPositioned((int)this.matrix.getWidth(), (int)this.matrix.getHeight(), (List)this.matrix.getItems());
            NonNullList remainingCraftingItems = ((CraftingRecipe)this.currentRecipe.value()).getRemainingItems((RecipeInput)craftingInput);
            int left = positionedCraftingInput.left();
            int top = positionedCraftingInput.top();
            for (int k = 0; k < craftingInput.height(); ++k) {
                for (int l = 0; l < craftingInput.width(); ++l) {
                    int currentSlot = l + left + (k + top) * this.matrix.getWidth();
                    ItemStack currentCraftingItem = (ItemStack)remainingCraftingItems.get(l + k * craftingInput.width());
                    ItemStack stackInSlot = this.matrix.getItem(currentSlot);
                    if (currentCraftingItem.isEmpty()) {
                        this.matrix.getItem(currentSlot).shrink(1);
                        continue;
                    }
                    if (!stackInSlot.getItem().getCraftingRemainingItem(stackInSlot).isEmpty()) {
                        ItemStack container = stackInSlot.getItem().getCraftingRemainingItem(stackInSlot);
                        if (!stackInSlot.isStackable()) {
                            stackInSlot = container;
                            this.matrix.setItem(currentSlot, stackInSlot);
                            continue;
                        }
                        stackInSlot.shrink(1);
                        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)container);
                        continue;
                    }
                    if (!currentCraftingItem.isEmpty()) {
                        if (stackInSlot.isEmpty()) {
                            this.matrix.setItem(currentSlot, currentCraftingItem);
                            continue;
                        }
                        if (!stackInSlot.isDamageableItem() && ItemStack.isSameItemSameComponents((ItemStack)stackInSlot, (ItemStack)currentCraftingItem)) {
                            this.matrix.setItem(currentSlot, currentCraftingItem);
                            continue;
                        }
                        if (ItemStack.isSameItem((ItemStack)stackInSlot, (ItemStack)currentCraftingItem)) {
                            this.matrix.setItem(currentSlot, currentCraftingItem);
                            continue;
                        }
                        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)newResult);
                        continue;
                    }
                    if (stackInSlot.isEmpty()) continue;
                    this.matrix.removeItem(currentSlot, 1);
                    stackInSlot = this.matrix.getItem(currentSlot);
                }
            }
            crafted += resultStackSize;
            for (int i = 0; i < this.matrix.getContainerSize(); ++i) {
                ItemStack stackInSlot = this.matrix.getItem(i);
                if (!stackInSlot.isEmpty()) continue;
                ItemStack recipeStack = (ItemStack)recipeCopy.get(i);
                ItemStackComparator comparator = !recipeStack.isEmpty() ? new ItemStackComparator(recipeStack) : null;
                ItemStack requestedItem = this.getStorageController().getOneOfMostCommonItem(comparator, false);
                this.matrix.setItem(i, requestedItem);
            }
            this.slotsChanged((Container)this.matrix);
        }
        ItemStack finalResult = new ItemStack((ItemLike)result.getItem(), 0);
        finalResult.applyComponents(result.getComponents());
        for (ItemStack intermediateResult : resultList) {
            finalResult.setCount(finalResult.getCount() + intermediateResult.getCount());
        }
        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)finalResult);
        this.broadcastChanges();
        this.recipeLocked = false;
        this.slotsChanged((Container)this.matrix);
        Networking.sendTo((ServerPlayer)player, this.getStorageController().getMessageUpdateStacks());
    }
}

