/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.container.storage;

import com.klikli_dev.occultism.common.container.storage.SatchelInventory;
import com.klikli_dev.occultism.common.container.storage.SatchelSlot;
import com.klikli_dev.occultism.registry.OccultismContainers;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.klikli_dev.occultism.util.CuriosUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class SatchelContainer
extends AbstractContainerMenu {
    public static final int SATCHEL_SIZE = 117;
    protected Container satchelInventory;
    protected Inventory playerInventory;
    protected int selectedSlot;

    public SatchelContainer(int id, Inventory playerInventory, Container satchelInventory, int selectedSlot) {
        super(OccultismContainers.SATCHEL.get(), id);
        this.satchelInventory = satchelInventory;
        this.playerInventory = playerInventory;
        this.selectedSlot = selectedSlot;
        this.setupSatchelSlots();
        this.setupPlayerInventorySlots();
        this.setupPlayerHotbar();
    }

    public static SatchelContainer createClientContainer(int id, Inventory playerInventory, FriendlyByteBuf buffer) {
        int selectedSlot = buffer.readVarInt();
        return new SatchelContainer(id, playerInventory, (Container)new SimpleContainer(117), selectedSlot);
    }

    public void broadcastChanges() {
        if (this.satchelInventory instanceof SatchelInventory) {
            ((SatchelInventory)this.satchelInventory).writeItemStack();
        }
        super.broadcastChanges();
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index >= this.satchelInventory.getContainerSize() && itemstack.getItem() == OccultismItems.SATCHEL.get()) {
                return ItemStack.EMPTY;
            }
            if (index < this.satchelInventory.getContainerSize() ? !this.moveItemStackTo(itemstack1, this.satchelInventory.getContainerSize(), this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, this.satchelInventory.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public boolean stillValid(Player player) {
        if (this.selectedSlot == -1) {
            return CuriosUtil.getBackpack(player).getItem() == OccultismItems.SATCHEL.get();
        }
        if (this.selectedSlot < 0 || this.selectedSlot >= player.getInventory().getContainerSize()) {
            return false;
        }
        return player.getInventory().getItem(this.selectedSlot).getItem() == OccultismItems.SATCHEL.get();
    }

    protected void setupPlayerInventorySlots() {
        int playerInventoryTop = 174;
        int playerInventoryLeft = 44;
        int hotbarSlots = 9;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)this.playerInventory, j + i * 9 + hotbarSlots, playerInventoryLeft + j * 18, playerInventoryTop + i * 18));
            }
        }
    }

    protected void setupPlayerHotbar() {
        int hotbarTop = 232;
        int hotbarLeft = 44;
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)this.playerInventory, i, hotbarLeft + i * 18, hotbarTop));
        }
    }

    protected void setupSatchelSlots() {
        int height = 9;
        int width = 13;
        int x = 8;
        int y = 8;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                this.addSlot(new SatchelSlot(this.satchelInventory, j + i * width, x + j * 18, y + i * 18));
            }
        }
    }
}

