/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.blockentity;

import com.klikli_dev.modonomicon.api.ModonomiconAPI;
import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.common.blockentity.SacrificialBowlBlockEntity;
import com.klikli_dev.occultism.common.item.DummyTooltipItem;
import com.klikli_dev.occultism.common.item.spirit.BookOfBindingItem;
import com.klikli_dev.occultism.common.ritual.Ritual;
import com.klikli_dev.occultism.crafting.recipe.RitualRecipe;
import com.klikli_dev.occultism.registry.OccultismBlockEntities;
import com.klikli_dev.occultism.registry.OccultismParticles;
import com.klikli_dev.occultism.registry.OccultismRecipes;
import com.klikli_dev.occultism.util.EntityUtil;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoldenSacrificialBowlBlockEntity
extends SacrificialBowlBlockEntity {
    public RecipeHolder<RitualRecipe> currentRitualRecipe;
    public ResourceLocation currentRitualRecipeId;
    public UUID castingPlayerId;
    public ServerPlayer castingPlayer;
    public List<Ingredient> remainingAdditionalIngredients = new ArrayList<Ingredient>();
    public List<ItemStack> consumedIngredients = new ArrayList<ItemStack>();
    public boolean sacrificeProvided;
    public boolean itemUseProvided;
    public int currentTime;
    public Consumer<PlayerInteractEvent.RightClickItem> rightClickItemListener = this::onPlayerRightClickItem;
    public Consumer<LivingDeathEvent> livingDeathEventListener = this::onLivingDeath;

    public GoldenSacrificialBowlBlockEntity(BlockPos worldPos, BlockState state) {
        super(OccultismBlockEntities.GOLDEN_SACRIFICIAL_BOWL.get(), worldPos, state);
        this.itemStackHandler = new ItemStackHandler(1){

            private ItemStack handleDummyInsert(int slot, @NotNull ItemStack stack, boolean simulate) {
                Item item;
                ItemStack insertResult = super.insertItem(slot, stack, simulate);
                ItemStack activationItemStack = this.getStackInSlot(0);
                if (!simulate && insertResult.getCount() != stack.getCount() && (item = stack.getItem()) instanceof DummyTooltipItem) {
                    DummyTooltipItem activationItem = (DummyTooltipItem)item;
                    activationItem.performRitual(GoldenSacrificialBowlBlockEntity.this.level, GoldenSacrificialBowlBlockEntity.this.getBlockPos(), GoldenSacrificialBowlBlockEntity.this, null, activationItemStack);
                    activationItemStack.shrink(1);
                }
                return insertResult;
            }

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                if (stack.getItem() instanceof DummyTooltipItem) {
                    return this.handleDummyInsert(slot, stack, simulate);
                }
                if (GoldenSacrificialBowlBlockEntity.this.getCurrentRitualRecipe() != null) {
                    return stack;
                }
                RecipeHolder ritualRecipe = GoldenSacrificialBowlBlockEntity.this.level.getRecipeManager().getAllRecipesFor((RecipeType)OccultismRecipes.RITUAL_TYPE.get()).stream().filter(r -> ((RitualRecipe)r.value()).matches(GoldenSacrificialBowlBlockEntity.this.level, GoldenSacrificialBowlBlockEntity.this.getBlockPos(), stack)).findFirst().orElse(null);
                if (ritualRecipe == null) {
                    return stack;
                }
                ItemStack insertResult = super.insertItem(slot, stack, simulate);
                ItemStack activationItemStack = this.getStackInSlot(0);
                if (!simulate && insertResult.getCount() != stack.getCount() && ritualRecipe != null && ((RitualRecipe)ritualRecipe.value()).getRitual().isValid(GoldenSacrificialBowlBlockEntity.this.level, GoldenSacrificialBowlBlockEntity.this.getBlockPos(), GoldenSacrificialBowlBlockEntity.this, null, activationItemStack, (List<Ingredient>)((RitualRecipe)ritualRecipe.value()).getIngredients())) {
                    GoldenSacrificialBowlBlockEntity.this.startRitual(null, activationItemStack, (RecipeHolder<RitualRecipe>)ritualRecipe);
                }
                return insertResult;
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            protected void onContentsChanged(int slot) {
                if (!((GoldenSacrificialBowlBlockEntity)GoldenSacrificialBowlBlockEntity.this).level.isClientSide) {
                    GoldenSacrificialBowlBlockEntity.this.lastChangeTime = GoldenSacrificialBowlBlockEntity.this.level.getGameTime();
                    GoldenSacrificialBowlBlockEntity.this.markNetworkDirty();
                }
            }
        };
    }

    private static boolean helpWithPentacle(Level level, BlockPos pos, Player player) {
        Map<BlockPos, Block> pentacleDiff = null;
        Map<BlockPos, Block> bestPentacleDiff = null;
        List<Multiblock> pentacleMultiblocks = level.getRecipeManager().getAllRecipesFor((RecipeType)OccultismRecipes.RITUAL_TYPE.get()).stream().map(r -> ((RitualRecipe)r.value()).getPentacleId()).distinct().map(arg_0 -> ((ModonomiconAPI)ModonomiconAPI.get()).getMultiblock(arg_0)).toList();
        Multiblock bestMatch = null;
        for (Multiblock pentacle : pentacleMultiblocks) {
            pentacleDiff = GoldenSacrificialBowlBlockEntity.getDifference(pentacle, level, pos);
            if (bestPentacleDiff != null && bestPentacleDiff.size() <= pentacleDiff.size()) continue;
            bestPentacleDiff = pentacleDiff;
            bestMatch = pentacle;
        }
        if (bestPentacleDiff != null && !bestPentacleDiff.isEmpty() && bestPentacleDiff.size() < 4) {
            player.displayClientMessage((Component)Component.translatable((String)"ritual.occultism.pentacle_help", (Object[])new Object[]{Component.translatable((String)Util.makeDescriptionId((String)"multiblock", (ResourceLocation)bestMatch.getId())), GoldenSacrificialBowlBlockEntity.pentacleDiffToComponent(bestPentacleDiff)}), false);
            return true;
        }
        if (bestPentacleDiff != null && !bestPentacleDiff.isEmpty()) {
            player.displayClientMessage((Component)Component.translatable((String)"ritual.occultism.pentacle_help.no_pentacle"), false);
            return true;
        }
        return false;
    }

    private static MutableComponent pentacleDiffToComponent(Map<BlockPos, Block> bestPentacleDiff) {
        MutableComponent text = Component.literal((String)"");
        for (Map.Entry<BlockPos, Block> entry : bestPentacleDiff.entrySet()) {
            text.append((Component)Component.translatable((String)entry.getValue().getDescriptionId()));
            text.append((Component)Component.translatable((String)"ritual.occultism.pentacle_help_at_glue"));
            BlockPos pos = entry.getKey();
            text.append((Component)Component.literal((String)("x: " + pos.getX() + ", y: " + pos.getY() + ", z: " + pos.getZ() + "\n")));
        }
        return text;
    }

    private static boolean helpWithRitual(Level level, BlockPos pos, ServerPlayer player, ItemStack activationItem) {
        ArrayList<Ingredient> ritualDiff = null;
        ArrayList<Ingredient> bestRitualDiff = null;
        RitualRecipe bestRitual = null;
        Stream<Multiblock> pentacleMultiblocks = level.getRecipeManager().getAllRecipesFor((RecipeType)OccultismRecipes.RITUAL_TYPE.get()).stream().map(r -> ((RitualRecipe)r.value()).getPentacleId()).distinct().map(arg_0 -> ((ModonomiconAPI)ModonomiconAPI.get()).getMultiblock(arg_0));
        Optional<Multiblock> pentacle = pentacleMultiblocks.filter(p -> p.validate(level, pos) != null).findFirst();
        if (pentacle.isEmpty()) {
            return false;
        }
        for (RecipeHolder recipe : level.getRecipeManager().getAllRecipesFor((RecipeType)OccultismRecipes.RITUAL_TYPE.get())) {
            if (((RitualRecipe)recipe.value()).getPentacle() != pentacle.orElseThrow()) continue;
            ritualDiff = new ArrayList<Ingredient>((Collection<Ingredient>)((RitualRecipe)recipe.value()).getIngredients());
            List<ItemStack> items = ((RitualRecipe)recipe.value()).getRitual().getItemsOnSacrificialBowls(level, pos);
            boolean found = false;
            for (int i = ritualDiff.size() - 1; i >= 0; --i) {
                found = false;
                for (int j = 0; j < items.size(); ++j) {
                    if (!((Ingredient)ritualDiff.get(i)).test(items.get(j))) continue;
                    items.remove(j);
                    found = true;
                    break;
                }
                if (!found) continue;
                ritualDiff.remove(i);
            }
            if (bestRitualDiff != null && bestRitualDiff.size() <= ritualDiff.size()) continue;
            bestRitualDiff = ritualDiff;
            bestRitual = (RitualRecipe)recipe.value();
        }
        if (bestRitualDiff != null && !bestRitualDiff.isEmpty() && bestRitualDiff.size() < 4) {
            player.displayClientMessage((Component)Component.translatable((String)"ritual.occultism.ritual_help", (Object[])new Object[]{Component.translatable((String)bestRitual.getRitual().getStartedMessage(player)), GoldenSacrificialBowlBlockEntity.ritualDiffToComponent((List<Ingredient>)bestRitualDiff)}), false);
            return true;
        }
        return false;
    }

    private static Object ritualDiffToComponent(List<Ingredient> ritualDiff) {
        Random rand = new Random();
        MutableComponent text = Component.literal((String)"");
        for (Ingredient ingredient : ritualDiff) {
            if (ingredient.getItems().length == 0) continue;
            text.append(ingredient.getItems()[rand.nextInt(ingredient.getItems().length)].getDisplayName());
            text.append("\n");
        }
        return text;
    }

    public static Map<BlockPos, Block> getDifference(Multiblock multiblock, Level level, BlockPos pos) {
        HashMap<BlockPos, Block> minDifference = new HashMap<BlockPos, Block>();
        int minDiffSize = Integer.MAX_VALUE;
        for (Rotation rot : Rotation.values()) {
            HashMap<BlockPos, Block> difference = new HashMap<BlockPos, Block>();
            Pair sim = multiblock.simulate(level, pos, rot, false, false);
            for (Multiblock.SimulateResult result : (Collection)sim.getSecond()) {
                if (result.test(level, rot)) continue;
                difference.put(result.getWorldPosition(), result.getStateMatcher().getDisplayedState(0L).getBlock());
            }
            if (difference.size() >= minDiffSize) continue;
            minDifference = difference;
            minDiffSize = difference.size();
        }
        return minDifference;
    }

    public RecipeHolder<RitualRecipe> getCurrentRitualRecipe() {
        if (this.currentRitualRecipeId != null && this.level != null) {
            Optional recipe = this.level.getRecipeManager().byKey(this.currentRitualRecipeId);
            recipe.map(r -> r).ifPresent(r -> {
                this.currentRitualRecipe = r;
            });
            NeoForge.EVENT_BUS.addListener(this.rightClickItemListener);
            NeoForge.EVENT_BUS.addListener(this.livingDeathEventListener);
            this.currentRitualRecipeId = null;
        }
        return this.currentRitualRecipe;
    }

    public int getSignal(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        if (this.getCurrentRitualRecipe() == null) {
            return 0;
        }
        if (!this.sacrificeFulfilled()) {
            return 1;
        }
        if (!this.itemUseFulfilled()) {
            return 2;
        }
        return 8;
    }

    public void tick() {
        RecipeHolder<RitualRecipe> recipe = this.getCurrentRitualRecipe();
        if (!this.level.isClientSide && recipe != null) {
            this.restoreCastingPlayer();
            if (this.remainingAdditionalIngredients == null) {
                this.restoreRemainingAdditionalIngredients();
                if (this.remainingAdditionalIngredients == null) {
                    Occultism.LOGGER.warn("Could not restore remainingAdditionalIngredients during tick - level seems to be null. Will attempt again next tick.");
                    return;
                }
            }
            ItemStackHandler handler = this.itemStackHandler;
            if (!((RitualRecipe)recipe.value()).getRitual().isValid(this.level, this.getBlockPos(), this, (Player)this.castingPlayer, handler.getStackInSlot(0), this.remainingAdditionalIngredients)) {
                this.stopRitual(false);
                return;
            }
            if (!this.sacrificeFulfilled() || !this.itemUseFulfilled()) {
                if (this.level.getGameTime() % 20L == 0L) {
                    this.level.updateNeighborsAt(this.getBlockPos(), this.getBlockState().getBlock());
                }
                if (this.level.random.nextInt(16) == 0) {
                    ((ServerLevel)this.level).sendParticles((ParticleOptions)OccultismParticles.RITUAL_WAITING.get(), (double)this.getBlockPos().getX() + this.level.random.nextGaussian(), (double)this.getBlockPos().getY() + 0.5, (double)this.getBlockPos().getZ() + this.level.random.nextGaussian(), 3, 0.0, 0.0, 0.0, 0.0);
                    ((ServerLevel)this.level).sendParticles((ParticleOptions)OccultismParticles.RITUAL_WAITING.get(), (double)this.getBlockPos().getX() + this.level.random.nextGaussian(), (double)this.getBlockPos().getY() + 0.5, (double)this.getBlockPos().getZ() + this.level.random.nextGaussian(), 3, 0.0, 0.0, 0.0, 0.0);
                }
                return;
            }
            if (this.level.random.nextInt(16) == 0) {
                ((ServerLevel)this.level).sendParticles((ParticleOptions)ParticleTypes.PORTAL, (double)this.getBlockPos().getX() + 0.5 + this.level.random.nextGaussian() / 3.0, (double)this.getBlockPos().getY() + 0.5, (double)this.getBlockPos().getZ() + 0.5 + this.level.random.nextGaussian() / 3.0, 5, 0.0, 0.0, 0.0, 0.0);
            }
            if (this.level.getGameTime() % (long)((int)(20.0 * (Double)Occultism.SERVER_CONFIG.rituals.ritualDurationMultiplier.get())) == 0L) {
                ++this.currentTime;
            }
            ((RitualRecipe)recipe.value()).getRitual().update(this.level, this.getBlockPos(), this, (Player)this.castingPlayer, handler.getStackInSlot(0), this.currentTime);
            if (!((RitualRecipe)recipe.value()).getRitual().consumeAdditionalIngredients(this.level, this.getBlockPos(), this.remainingAdditionalIngredients, this.currentTime, this.consumedIngredients)) {
                this.stopRitual(false);
                return;
            }
            if (((RitualRecipe)recipe.value()).getDuration() >= 0 && this.currentTime >= ((RitualRecipe)recipe.value()).getDuration()) {
                this.stopRitual(true);
            }
        }
    }

    public void restoreCastingPlayer() {
        if (this.castingPlayer == null && this.castingPlayerId != null && this.level.getGameTime() % 600L == 0L) {
            this.castingPlayer = EntityUtil.getPlayerByUuiDGlobal(this.castingPlayerId).orElse(null);
            this.setChanged();
            this.markNetworkDirty();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean activate(Level level, BlockPos pos, Player player, InteractionHand hand, Direction face) {
        if (hand == InteractionHand.OFF_HAND) {
            return false;
        }
        if (level.isClientSide) return true;
        if (!(player instanceof ServerPlayer)) return true;
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ItemStack activationItem = player.getItemInHand(hand);
        if (activationItem == ItemStack.EMPTY) {
            return false;
        }
        if (activationItem.getItem() instanceof DummyTooltipItem) {
            ((DummyTooltipItem)activationItem.getItem()).performRitual(level, pos, this, player, activationItem);
            return true;
        }
        if (this.getCurrentRitualRecipe() != null) {
            this.stopRitual(false);
            return true;
        }
        RecipeHolder ritualRecipe = this.level.getRecipeManager().getAllRecipesFor((RecipeType)OccultismRecipes.RITUAL_TYPE.get()).stream().filter(r -> ((RitualRecipe)r.value()).matches(level, pos, activationItem)).findFirst().orElse(null);
        if (ritualRecipe != null) {
            if (((RitualRecipe)ritualRecipe.value()).getRitual().isValid(level, pos, this, player, activationItem, (List<Ingredient>)((RitualRecipe)ritualRecipe.value()).getIngredients())) {
                this.itemStackHandler.insertItem(0, activationItem.split(1), false);
                this.startRitual(serverPlayer, activationItem, (RecipeHolder<RitualRecipe>)ritualRecipe);
                return true;
            }
            player.displayClientMessage((Component)Component.translatable((String)((RitualRecipe)ritualRecipe.value()).getRitual().getConditionsMessage(serverPlayer)), true);
            return false;
        }
        if (activationItem.getItem() instanceof BookOfBindingItem) {
            player.displayClientMessage((Component)Component.translatable((String)String.format("ritual.%s.book_not_bound", "occultism")), false);
            return false;
        }
        if (GoldenSacrificialBowlBlockEntity.helpWithPentacle(level, pos, player)) return false;
        if (GoldenSacrificialBowlBlockEntity.helpWithRitual(level, pos, serverPlayer, activationItem)) return false;
        player.displayClientMessage((Component)Component.translatable((String)String.format("ritual.%s.does_not_exist", "occultism")), false);
        return false;
    }

    public void startRitual(@Nullable ServerPlayer player, ItemStack activationItem, RecipeHolder<RitualRecipe> ritualRecipe) {
        if (!this.level.isClientSide) {
            this.currentRitualRecipe = ritualRecipe;
            this.castingPlayerId = player == null ? null : player.getUUID();
            this.castingPlayer = player;
            this.currentTime = 0;
            this.sacrificeProvided = false;
            this.itemUseProvided = false;
            this.consumedIngredients.clear();
            this.remainingAdditionalIngredients = new ArrayList<Ingredient>((Collection<Ingredient>)((RitualRecipe)this.currentRitualRecipe.value()).getIngredients());
            ((RitualRecipe)this.currentRitualRecipe.value()).getRitual().start(this.level, this.getBlockPos(), this, player, this.itemStackHandler.getStackInSlot(0));
            NeoForge.EVENT_BUS.addListener(this.rightClickItemListener);
            NeoForge.EVENT_BUS.addListener(this.livingDeathEventListener);
            this.setChanged();
            this.markNetworkDirty();
            this.level.updateNeighborsAt(this.getBlockPos(), this.getBlockState().getBlock());
        }
    }

    public void stopRitual(boolean finished) {
        if (!this.level.isClientSide) {
            RecipeHolder<RitualRecipe> recipe = this.getCurrentRitualRecipe();
            if (recipe != null) {
                ItemStackHandler handler = this.itemStackHandler;
                if (finished) {
                    ItemStack activationItem = handler.getStackInSlot(0);
                    ((RitualRecipe)recipe.value()).getRitual().finish(this.level, this.getBlockPos(), this, this.castingPlayer, activationItem);
                } else {
                    ((RitualRecipe)recipe.value()).getRitual().interrupt(this.level, this.getBlockPos(), this, this.castingPlayer, handler.getStackInSlot(0));
                    Containers.dropItemStack((Level)this.level, (double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), (ItemStack)handler.extractItem(0, 1, false));
                }
            }
            this.currentRitualRecipe = null;
            this.castingPlayerId = null;
            this.castingPlayer = null;
            this.currentTime = 0;
            this.sacrificeProvided = false;
            this.itemUseProvided = false;
            if (this.remainingAdditionalIngredients != null) {
                this.remainingAdditionalIngredients.clear();
            }
            this.consumedIngredients.clear();
            NeoForge.EVENT_BUS.unregister(this.rightClickItemListener);
            NeoForge.EVENT_BUS.unregister(this.livingDeathEventListener);
            this.setChanged();
            this.markNetworkDirty();
            this.level.updateNeighborsAt(this.getBlockPos(), this.getBlockState().getBlock());
        }
    }

    public boolean sacrificeFulfilled() {
        return !((RitualRecipe)this.getCurrentRitualRecipe().value()).requiresSacrifice() || this.sacrificeProvided;
    }

    public boolean itemUseFulfilled() {
        return !((RitualRecipe)this.getCurrentRitualRecipe().value()).requiresItemUse() || this.itemUseProvided;
    }

    public void notifySacrifice(LivingEntity entityLivingBase) {
        this.sacrificeProvided = true;
    }

    public void notifyItemUse(PlayerInteractEvent.RightClickItem event) {
        this.itemUseProvided = true;
    }

    public void onPlayerRightClickItem(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        if (!player.level().isClientSide && this.getCurrentRitualRecipe() != null && this.getBlockPos().distSqr((Vec3i)event.getPos()) <= 256.0 && ((RitualRecipe)this.getCurrentRitualRecipe().value()).getRitual().isValidItemUse(event)) {
            this.notifyItemUse(event);
        }
    }

    public void onLivingDeath(LivingDeathEvent event) {
        LivingEntity entityLivingBase = event.getEntity();
        if (!entityLivingBase.level().isClientSide && this.getCurrentRitualRecipe() != null && event.getSource().getEntity() instanceof Player && this.getBlockPos().distSqr((Vec3i)entityLivingBase.blockPosition()) <= 64.0 && ((RitualRecipe)this.getCurrentRitualRecipe().value()).getRitual().isValidSacrifice(entityLivingBase)) {
            this.notifySacrifice(entityLivingBase);
        }
    }

    protected void restoreRemainingAdditionalIngredients() {
        this.remainingAdditionalIngredients = this.level == null ? null : (this.consumedIngredients.size() > 0 ? Ritual.getRemainingAdditionalIngredients(((RitualRecipe)this.getCurrentRitualRecipe().value()).getIngredients(), this.consumedIngredients) : new ArrayList<Ingredient>((Collection<Ingredient>)((RitualRecipe)this.getCurrentRitualRecipe().value()).getIngredients()));
    }

    @Override
    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.consumedIngredients.clear();
        if (this.currentRitualRecipeId != null || this.getCurrentRitualRecipe() != null) {
            if (compound.contains("consumedIngredients")) {
                ListTag list = compound.getList("consumedIngredients", 10);
                for (int i = 0; i < list.size(); ++i) {
                    ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)list.getCompound(i));
                    this.consumedIngredients.add(stack);
                }
            }
            this.restoreRemainingAdditionalIngredients();
        }
        if (compound.contains("sacrificeProvided")) {
            this.sacrificeProvided = compound.getBoolean("sacrificeProvided");
        }
        if (compound.contains("requiredItemUsed")) {
            this.itemUseProvided = compound.getBoolean("requiredItemUsed");
        }
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        if (this.getCurrentRitualRecipe() != null) {
            if (!this.consumedIngredients.isEmpty()) {
                ListTag list = new ListTag();
                for (ItemStack stack : this.consumedIngredients) {
                    list.add((Object)stack.saveOptional(provider));
                }
                compound.put("consumedIngredients", (Tag)list);
            }
            compound.putBoolean("sacrificeProvided", this.sacrificeProvided);
            compound.putBoolean("requiredItemUsed", this.itemUseProvided);
        }
        super.saveAdditional(compound, provider);
    }

    @Override
    public void loadNetwork(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadNetwork(compound, provider);
        if (compound.contains("currentRitual")) {
            this.currentRitualRecipeId = ResourceLocation.parse((String)compound.getString("currentRitual"));
        }
        if (compound.contains("castingPlayerId")) {
            this.castingPlayerId = compound.getUUID("castingPlayerId");
        }
        this.currentTime = compound.getInt("currentTime");
    }

    @Override
    public CompoundTag saveNetwork(CompoundTag compound, HolderLookup.Provider provider) {
        RecipeHolder<RitualRecipe> recipe = this.getCurrentRitualRecipe();
        if (recipe != null) {
            compound.putString("currentRitual", recipe.id().toString());
        }
        if (this.castingPlayerId != null) {
            compound.putUUID("castingPlayerId", this.castingPlayerId);
        }
        compound.putInt("currentTime", this.currentTime);
        return super.saveNetwork(compound, provider);
    }
}

