/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.blockentity;

import com.klikli_dev.occultism.common.blockentity.NetworkedBlockEntity;
import com.klikli_dev.occultism.common.container.DimensionalMineshaftContainer;
import com.klikli_dev.occultism.crafting.recipe.MinerRecipe;
import com.klikli_dev.occultism.crafting.recipe.input.ItemHandlerRecipeInput;
import com.klikli_dev.occultism.crafting.recipe.result.WeightedRecipeResult;
import com.klikli_dev.occultism.registry.OccultismBlockEntities;
import com.klikli_dev.occultism.registry.OccultismDataComponents;
import com.klikli_dev.occultism.registry.OccultismRecipes;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;

public class DimensionalMineshaftBlockEntity
extends NetworkedBlockEntity
implements MenuProvider {
    public static final ResourceKey<Enchantment> EVILCRAFT_UNUSING_ENCHANTEMENT = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.parse((String)"evilcraft:unusing"));
    public static final String MAX_MINING_TIME_TAG = "maxMiningTime";
    public static final int DEFAULT_MAX_MINING_TIME = 400;
    public static int DEFAULT_ROLLS_PER_OPERATION = 1;
    public static String ROLLS_PER_OPERATION_TAG = "rollsPerOperation";
    public ItemStackHandler inputHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            DimensionalMineshaftBlockEntity.this.setChanged();
        }
    };
    public ItemStackHandler outputHandler = new ItemStackHandler(9){

        protected void onContentsChanged(int slot) {
            DimensionalMineshaftBlockEntity.this.setChanged();
        }
    };
    public CombinedInvWrapper combinedHandler = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputHandler, this.outputHandler});
    public int miningTime;
    public int maxMiningTime = 0;
    public int rollsPerOperation = 0;
    protected Item currentInputType;
    protected List<WeightedRecipeResult> possibleResults;

    public DimensionalMineshaftBlockEntity(BlockPos worldPos, BlockState state) {
        super(OccultismBlockEntities.DIMENSIONAL_MINESHAFT.get(), worldPos, state);
    }

    public static void forceInitStackNBT(ItemStack stack, ServerLevel level) {
        stack.getItem().onCraftedBy(stack, (Level)level, (Player)FakePlayerFactory.getMinecraft((ServerLevel)level));
    }

    public static int getMaxMiningTime(ItemStack stack) {
        return (Integer)stack.getOrDefault(OccultismDataComponents.MAX_MINING_TIME, (Object)400);
    }

    public static int getRollsPerOperation(ItemStack stack) {
        return (Integer)stack.getOrDefault(OccultismDataComponents.ROLLS_PER_OPERATION, (Object)DEFAULT_ROLLS_PER_OPERATION);
    }

    public Component getDisplayName() {
        return Component.literal((String)BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)this.getType()).getPath());
    }

    @Override
    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.inputHandler.deserializeNBT(provider, compound.getCompound("inputHandler"));
        this.outputHandler.deserializeNBT(provider, compound.getCompound("outputHandler"));
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        compound.put("inputHandler", (Tag)this.inputHandler.serializeNBT(provider));
        compound.put("outputHandler", (Tag)this.outputHandler.serializeNBT(provider));
        super.saveAdditional(compound, provider);
    }

    @Override
    public void loadNetwork(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadNetwork(compound, provider);
        this.miningTime = compound.getInt("miningTime");
        this.maxMiningTime = compound.getInt(MAX_MINING_TIME_TAG);
    }

    @Override
    public CompoundTag saveNetwork(CompoundTag compound, HolderLookup.Provider provider) {
        compound.putInt("miningTime", this.miningTime);
        compound.putInt(MAX_MINING_TIME_TAG, this.maxMiningTime);
        return super.saveNetwork(compound, provider);
    }

    public void tick() {
        if (!this.level.isClientSide) {
            ItemStack input = this.inputHandler.getStackInSlot(0);
            if (input.getMaxDamage() - input.getDamageValue() < 6 && input.isEnchanted() && this.level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).get(EVILCRAFT_UNUSING_ENCHANTEMENT).isPresent() && input.getEnchantmentLevel((Holder)this.level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).get(EVILCRAFT_UNUSING_ENCHANTEMENT).get()) > 0) {
                this.miningTime = 0;
                return;
            }
            boolean dirty = false;
            if (this.miningTime > 0) {
                --this.miningTime;
                if (this.miningTime == 0 && !this.level.isClientSide) {
                    this.mine();
                }
                if (input.getItem() != this.currentInputType) {
                    this.miningTime = 0;
                    this.possibleResults = null;
                }
                if (this.miningTime % 10 == 0) {
                    dirty = true;
                }
            } else if (!input.isEmpty()) {
                this.currentInputType = input.getItem();
                DimensionalMineshaftBlockEntity.forceInitStackNBT(input, (ServerLevel)this.level);
                this.maxMiningTime = DimensionalMineshaftBlockEntity.getMaxMiningTime(input);
                this.rollsPerOperation = DimensionalMineshaftBlockEntity.getRollsPerOperation(input);
                this.miningTime = this.maxMiningTime;
                dirty = true;
            }
            if (dirty) {
                this.markNetworkDirty();
            }
        } else if (this.miningTime > 0 && this.level.getGameTime() % 10L == 0L) {
            this.level.addParticle((ParticleOptions)ParticleTypes.PORTAL, (double)((float)this.worldPosition.getX() + 0.5f), (double)this.worldPosition.getY() + 0.5, (double)((float)this.worldPosition.getZ() + 0.5f), 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player player) {
        return new DimensionalMineshaftContainer(id, playerInventory, this);
    }

    public void mine() {
        if (this.possibleResults == null) {
            List recipes = this.level.getRecipeManager().getRecipesFor((RecipeType)OccultismRecipes.MINER_TYPE.get(), (RecipeInput)new ItemHandlerRecipeInput((IItemHandlerModifiable)this.inputHandler), this.level);
            this.possibleResults = recipes == null || recipes.size() == 0 ? new ArrayList<WeightedRecipeResult>() : recipes.stream().map(r -> ((MinerRecipe)r.value()).getWeightedResult()).collect(Collectors.toList());
        }
        if (this.possibleResults.size() == 0) {
            return;
        }
        for (int i = 0; i < this.rollsPerOperation; ++i) {
            Optional result = WeightedRandom.getRandomItem((RandomSource)this.level.random, this.possibleResults);
            result.ifPresent(r -> ItemHandlerHelper.insertItemStacked((IItemHandler)this.outputHandler, (ItemStack)r.getStack().copy(), (boolean)false));
        }
        ItemStack input = this.inputHandler.getStackInSlot(0);
        input.hurtAndBreak(1, (ServerLevel)this.level, (LivingEntity)null, item -> {});
    }
}

