/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.block;

import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class CandleBlock
extends Block {
    private static final VoxelShape SHAPE = Stream.of(Block.box((double)7.0, (double)0.0, (double)10.0, (double)9.0, (double)4.0, (double)11.0), Block.box((double)10.0, (double)0.0, (double)8.0, (double)11.0, (double)3.0, (double)9.0), Block.box((double)10.0, (double)0.0, (double)6.0, (double)11.0, (double)1.0, (double)7.0), Block.box((double)11.0, (double)0.0, (double)7.0, (double)12.0, (double)1.0, (double)8.0), Block.box((double)7.0, (double)0.0, (double)11.0, (double)8.0, (double)1.0, (double)12.0), Block.box((double)6.0, (double)0.0, (double)10.0, (double)7.0, (double)1.0, (double)11.0), Block.box((double)4.0, (double)0.0, (double)7.0, (double)5.0, (double)1.0, (double)8.0), Block.box((double)5.0, (double)0.0, (double)6.0, (double)6.0, (double)1.0, (double)7.0), Block.box((double)7.0, (double)0.0, (double)5.0, (double)8.0, (double)2.0, (double)6.0), Block.box((double)10.0, (double)0.0, (double)7.0, (double)11.0, (double)5.0, (double)8.0), Block.box((double)8.0, (double)0.0, (double)5.0, (double)9.0, (double)6.0, (double)6.0), Block.box((double)5.0, (double)0.0, (double)7.0, (double)6.0, (double)3.0, (double)9.0), Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0), Block.box((double)7.75, (double)8.0, (double)7.75, (double)8.25, (double)10.0, (double)8.25)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    public CandleBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level level, BlockPos blockPos, Random rand) {
        double d0 = (double)blockPos.getX() + 0.5;
        double d1 = (double)blockPos.getY() + 0.7;
        double d2 = (double)blockPos.getZ() + 0.5;
        level.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
        level.addParticle((ParticleOptions)ParticleTypes.FLAME, d0, d1, d2, 0.0, 0.0, 0.0);
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!this.canSurvive(state, (LevelReader)worldIn, pos)) {
            CandleBlock.dropResources((BlockState)state, (Level)worldIn, (BlockPos)pos);
            worldIn.removeBlock(pos, false);
        }
    }

    public float getEnchantPowerBonus(BlockState state, LevelReader level, BlockPos pos) {
        return 1.0f;
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos down = pos.below();
        BlockState downState = worldIn.getBlockState(down);
        return downState.isFaceSturdy((BlockGetter)worldIn, down, Direction.UP);
    }
}

