/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.advancement;

import com.klikli_dev.occultism.common.ritual.Ritual;
import com.klikli_dev.occultism.registry.OccultismAdvancements;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class RitualTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public void trigger(ServerPlayer player, Ritual ritual) {
        this.trigger(player, instance -> instance.matches(player, ritual));
    }

    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<ResourceLocation> ritualId, Optional<ResourceLocation> ritualFactoryId) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)ResourceLocation.CODEC.optionalFieldOf("ritual_id").forGetter(TriggerInstance::ritualId), (App)ResourceLocation.CODEC.optionalFieldOf("ritual_factory_id").forGetter(TriggerInstance::ritualFactoryId)).apply((Applicative)instance, TriggerInstance::new));

        public static Criterion<TriggerInstance> ritualFactory(ResourceLocation ritualFactoryId) {
            return ((RitualTrigger)((Object)OccultismAdvancements.RITUAL.get())).createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), Optional.empty(), Optional.of(ritualFactoryId)));
        }

        public boolean matches(ServerPlayer player, Ritual ritual) {
            if (this.ritualId.isPresent() && !this.ritualId.get().equals((Object)ritual.getRecipeHolder(player).id())) {
                return false;
            }
            return this.ritualFactoryId.isEmpty() || this.ritualFactoryId.get().equals((Object)ritual.getFactoryID());
        }
    }
}

