/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.render;

import com.klikli_dev.occultism.common.blockentity.GoldenSacrificialBowlBlockEntity;
import com.klikli_dev.occultism.crafting.recipe.RitualRecipe;
import com.klikli_dev.occultism.registry.OccultismRecipes;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class GoldenSacrificialBowlHUD
implements LayeredDraw.Layer {
    private static final GoldenSacrificialBowlHUD instance = new GoldenSacrificialBowlHUD();
    public static BlockPos lastHovered = null;
    public static List<MutableComponent> lastPentacles = List.of();
    public static long lastPentacleQueryTime = 0L;
    private static MutableComponent noPentacleFound = Component.translatable((String)"hud.occultism.no_pentacle_found");

    public static GoldenSacrificialBowlHUD get() {
        return instance;
    }

    public void render(GuiGraphics pGuiGraphics, DeltaTracker pDeltaTracker) {
        Minecraft mc = Minecraft.getInstance();
        HitResult hitResult = mc.hitResult;
        if (!(hitResult instanceof BlockHitResult)) {
            lastHovered = null;
            lastPentacles = List.of();
            lastPentacleQueryTime = 0L;
            return;
        }
        BlockHitResult blockHitResult = (BlockHitResult)hitResult;
        BlockPos pos = blockHitResult.getBlockPos();
        BlockEntity blockEntity = mc.level.getBlockEntity(pos);
        if (!(blockEntity instanceof GoldenSacrificialBowlBlockEntity)) {
            lastHovered = null;
            lastPentacles = List.of();
            lastPentacleQueryTime = 0L;
            return;
        }
        GoldenSacrificialBowlBlockEntity goldenBowl = (GoldenSacrificialBowlBlockEntity)blockEntity;
        if (!(pos.equals((Object)lastHovered) && !lastPentacles.isEmpty() || lastPentacles.isEmpty() && mc.level.getGameTime() - lastPentacleQueryTime < 20L)) {
            lastPentacleQueryTime = mc.level.getGameTime();
            lastHovered = pos;
            List pentacles = mc.level.getRecipeManager().getAllRecipesFor((RecipeType)OccultismRecipes.RITUAL_TYPE.get()).stream().filter(r -> ((RitualRecipe)r.value()).getPentacle().validate((Level)mc.level, pos) != null).collect(Collectors.toMap(r -> ((RitualRecipe)r.value()).getPentacle().getId(), Function.identity(), (existing, replacement) -> existing)).values().stream().map(r -> Component.translatable((String)Util.makeDescriptionId((String)"multiblock", (ResourceLocation)((RitualRecipe)r.value()).getPentacle().getId()))).collect(Collectors.toList());
            lastPentacles = pentacles;
        }
        Font font = mc.font;
        int x = pGuiGraphics.guiWidth() / 2;
        int y = pGuiGraphics.guiHeight() / 2 + 18;
        PoseStack pose = pGuiGraphics.pose();
        pose.pushPose();
        if (!lastPentacles.isEmpty()) {
            for (MutableComponent text : lastPentacles) {
                pGuiGraphics.drawCenteredString(font, (Component)Component.translatable((String)"hud.occultism.pentacle_found", (Object[])new Object[]{text.withStyle(ChatFormatting.GREEN)}).withStyle(ChatFormatting.WHITE), x, y, -1);
                y += 9;
            }
        } else {
            pGuiGraphics.drawCenteredString(font, (Component)noPentacleFound.withStyle(ChatFormatting.YELLOW), x, y, -1);
        }
        pose.popPose();
    }
}

