/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.api.common.data;

import com.klikli_dev.occultism.api.common.data.GlobalBlockPos;
import com.klikli_dev.occultism.util.BlockEntityUtil;
import com.klikli_dev.occultism.util.OccultismExtraStreamCodecs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.INBTSerializable;

public class MachineReference
implements INBTSerializable<CompoundTag> {
    public static final Codec<MachineReference> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)GlobalBlockPos.CODEC.optionalFieldOf("extractGlobalPos").forGetter(m -> Optional.ofNullable(m.extractGlobalPos)), (App)ResourceLocation.CODEC.optionalFieldOf("extractRegistryName").forGetter(m -> Optional.ofNullable(m.extractRegistryName)), (App)Codec.BOOL.fieldOf("extractChunkLoaded").forGetter(m -> m.extractChunkLoaded), (App)Direction.CODEC.fieldOf("extractFacing").forGetter(m -> m.extractFacing), (App)GlobalBlockPos.CODEC.optionalFieldOf("insertGlobalPos").forGetter(m -> Optional.ofNullable(m.insertGlobalPos)), (App)ResourceLocation.CODEC.optionalFieldOf("insertRegistryName").forGetter(m -> Optional.ofNullable(m.insertRegistryName)), (App)Codec.BOOL.fieldOf("insertChunkLoaded").forGetter(m -> m.insertChunkLoaded), (App)Direction.CODEC.fieldOf("insertFacing").forGetter(m -> m.insertFacing), (App)Codec.STRING.fieldOf("customName").forGetter(m -> m.customName)).apply((Applicative)instance, MachineReference::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, MachineReference> STREAM_CODEC = OccultismExtraStreamCodecs.composite(GlobalBlockPos.STREAM_CODEC, m -> m.extractGlobalPos, ResourceLocation.STREAM_CODEC, m -> m.extractRegistryName, ByteBufCodecs.BOOL, m -> m.extractChunkLoaded, Direction.STREAM_CODEC, m -> m.extractFacing, GlobalBlockPos.STREAM_CODEC, m -> m.insertGlobalPos, ResourceLocation.STREAM_CODEC, m -> m.insertRegistryName, ByteBufCodecs.BOOL, m -> m.insertChunkLoaded, Direction.STREAM_CODEC, m -> m.insertFacing, ByteBufCodecs.STRING_UTF8, m -> m.customName, MachineReference::new);
    public GlobalBlockPos extractGlobalPos;
    public ResourceLocation extractRegistryName;
    public boolean extractChunkLoaded;
    public Direction extractFacing = Direction.DOWN;
    public GlobalBlockPos insertGlobalPos;
    public ResourceLocation insertRegistryName;
    public boolean insertChunkLoaded;
    public Direction insertFacing = Direction.UP;
    public String customName = "";
    protected ItemStack cachedExtractItemStack = ItemStack.EMPTY;
    protected Item cachedExtractItem = null;
    protected ItemStack cachedInsertItemStack = ItemStack.EMPTY;
    protected Item cachedInsertItem = null;

    public MachineReference() {
    }

    public MachineReference(GlobalBlockPos extractGlobalPos, ResourceLocation extractRegistryName, boolean extractChunkLoaded, Direction extractFacing, GlobalBlockPos insertGlobalPos, ResourceLocation insertRegistryName, boolean insertChunkLoaded, Direction insertFacing) {
        this(extractGlobalPos, extractRegistryName, extractChunkLoaded, extractFacing, insertGlobalPos, insertRegistryName, insertChunkLoaded, insertFacing, "");
    }

    public MachineReference(Optional<GlobalBlockPos> extractGlobalPos, Optional<ResourceLocation> extractRegistryName, boolean extractChunkLoaded, Direction extractFacing, Optional<GlobalBlockPos> insertGlobalPos, Optional<ResourceLocation> insertRegistryName, boolean insertChunkLoaded, Direction insertFacing, String customName) {
        this((GlobalBlockPos)extractGlobalPos.orElse(null), (ResourceLocation)extractRegistryName.orElse(null), extractChunkLoaded, extractFacing, (GlobalBlockPos)insertGlobalPos.orElse(null), (ResourceLocation)insertRegistryName.orElse(null), insertChunkLoaded, insertFacing, customName);
    }

    public MachineReference(GlobalBlockPos extractGlobalPos, ResourceLocation extractRegistryName, boolean extractChunkLoaded, Direction extractFacing, GlobalBlockPos insertGlobalPos, ResourceLocation insertRegistryName, boolean insertChunkLoaded, Direction insertFacing, String customName) {
        this.extractGlobalPos = extractGlobalPos;
        this.extractRegistryName = extractRegistryName;
        this.extractChunkLoaded = extractChunkLoaded;
        this.extractFacing = extractFacing;
        this.insertGlobalPos = insertGlobalPos;
        this.insertRegistryName = insertRegistryName;
        this.insertChunkLoaded = insertChunkLoaded;
        this.insertFacing = insertFacing;
        this.customName = customName;
    }

    public static MachineReference from(BlockEntity extractBlockEntity, BlockEntity insertBlockEntity) {
        GlobalBlockPos extractPos = GlobalBlockPos.from(extractBlockEntity);
        BlockState extractState = extractBlockEntity.getLevel().getBlockState(extractPos.getPos());
        ItemStack extractItem = extractState.getBlock().getCloneItemStack((LevelReader)extractBlockEntity.getLevel(), extractPos.getPos(), extractState);
        boolean extractIsLoaded = extractBlockEntity.getLevel().isLoaded(extractPos.getPos());
        GlobalBlockPos insertPos = GlobalBlockPos.from(insertBlockEntity);
        BlockState insertState = extractBlockEntity.getLevel().getBlockState(insertPos.getPos());
        ItemStack insertItem = insertState.getBlock().getCloneItemStack((LevelReader)extractBlockEntity.getLevel(), insertPos.getPos(), insertState);
        boolean insertIsLoaded = insertBlockEntity.getLevel().isLoaded(insertPos.getPos());
        return new MachineReference(extractPos, BuiltInRegistries.ITEM.getKey((Object)extractItem.getItem()), extractIsLoaded, Direction.DOWN, insertPos, BuiltInRegistries.ITEM.getKey((Object)insertItem.getItem()), insertIsLoaded, Direction.UP);
    }

    public Item getExtractItem() {
        if (this.cachedExtractItem == null) {
            this.cachedExtractItem = (Item)BuiltInRegistries.ITEM.get(this.extractRegistryName);
        }
        return this.cachedExtractItem;
    }

    public ItemStack getExtractItemStack() {
        if (this.cachedExtractItemStack.isEmpty()) {
            this.cachedExtractItemStack = new ItemStack((ItemLike)this.getExtractItem());
        }
        return this.cachedExtractItemStack;
    }

    public Item getInsertItem() {
        if (this.cachedInsertItem == null) {
            this.cachedInsertItem = (Item)BuiltInRegistries.ITEM.get(this.insertRegistryName);
        }
        return this.cachedInsertItem;
    }

    public ItemStack getInsertItemStack() {
        if (this.cachedInsertItemStack.isEmpty()) {
            this.cachedInsertItemStack = new ItemStack((ItemLike)this.getInsertItem());
        }
        return this.cachedInsertItemStack;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        return (CompoundTag)CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this).getOrThrow();
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        MachineReference ref = (MachineReference)CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt).getOrThrow();
        this.extractGlobalPos = ref.extractGlobalPos;
        this.extractRegistryName = ref.extractRegistryName;
        this.extractChunkLoaded = ref.extractChunkLoaded;
        this.extractFacing = ref.extractFacing;
        this.insertGlobalPos = ref.insertGlobalPos;
        this.insertRegistryName = ref.insertRegistryName;
        this.insertChunkLoaded = ref.insertChunkLoaded;
        this.insertFacing = ref.insertFacing;
        this.customName = ref.customName;
    }

    public BlockEntity getExtractBlockEntity(Level level) {
        return BlockEntityUtil.get(level, this.extractGlobalPos);
    }

    public BlockEntity getInsertBlockEntity(Level level) {
        return BlockEntityUtil.get(level, this.insertGlobalPos);
    }

    public boolean isValidFor(Level level) {
        return this.getExtractBlockEntity(level) != null && this.getInsertBlockEntity(level) != null;
    }
}

